---
search:
  exclude: true
---
# 複数エージェントのオーケストレーション

オーケストレーションとは、アプリ内でのエージェントの流れを指します。どのエージェントをどの順番で実行し、次に何を行うかをどのように決定するか、ということです。エージェントをオーケストレーションする主な方法は 2 つあります。

1.  LLM に意思決定を委ねる: LLM の知能を活用して計画・推論し、それに基づいて次のステップを決定します。  
2.  コードによるオーケストレーション: コードでエージェントの流れを制御します。

これらのパターンは組み合わせて使うことも可能です。それぞれに一長一短があります。

## LLM によるオーケストレーション

エージェントとは、instructions、tools、handoffs を備えた LLM です。これにより、オープンエンドなタスクに対して、LLM が自律的に計画を立て、tools を用いてアクションを実行しデータを取得し、handoffs によってサブエージェントへタスクを委任できます。たとえば、リサーチ エージェントには以下のような tools を用意できます。

-   Web 検索でオンライン情報を取得する  
-   ファイル検索と取得で専有データや接続を検索する  
-   コンピュータ操作でコンピュータ上のアクションを実行する  
-   コード実行でデータ分析を行う  
-   計画立案やレポート作成などに特化したエージェントへのハンドオフ  

このパターンはタスクがオープンエンドで、LLM の知能に頼りたい場合に最適です。ここで重要な戦略は次のとおりです。

1.  良いプロンプトに投資する。利用可能な tools、使用方法、および運用パラメーターを明確にします。  
2.  アプリをモニタリングしてイテレーションを重ねる。問題が発生した箇所を確認し、プロンプトを改善します。  
3.  エージェントに内省させて改善させる。たとえばループで実行し自己批評させる、あるいはエラーメッセージを渡して改善させるなどです。  
4.  一つのタスクに特化したエージェントを用意し、何でもこなす汎用エージェントに過度な期待をしないようにします。  
5.  [evals](https://platform.openai.com/docs/guides/evals) に投資する。これによりエージェントを訓練し、タスク遂行能力を向上させられます。  

## コードによるオーケストレーション

LLM によるオーケストレーションは強力ですが、コードによるオーケストレーションは速度・コスト・パフォーマンスの面でより決定論的かつ予測可能にできます。一般的なパターンは以下のとおりです。

-   [structured outputs](https://platform.openai.com/docs/guides/structured-outputs) を使って、コードで検査できる適切な形式のデータを生成する。たとえば、エージェントにタスクをいくつかのカテゴリーに分類させ、そのカテゴリーに基づいて次のエージェントを選ぶ方法があります。  
-   あるエージェントの出力を次のエージェントの入力に変換して複数エージェントをチェーンする。ブログ記事執筆タスクを、リサーチ → アウトライン作成 → 記事作成 → 批評 → 改善、といった一連のステップに分解できます。  
-   タスクを実行するエージェントを `while` ループで回し、別のエージェントが評価とフィードバックを行い、評価者が基準を満たしたと判断するまで繰り返します。  
-   Python の基本コンポーネントである `asyncio.gather` などを用いて複数エージェントを並列実行する。相互に依存しない複数タスクを高速に処理したい場合に有用です。  

[`examples/agent_patterns`](https://github.com/openai/openai-agents-python/tree/main/examples/agent_patterns) には多数の code examples があります。