---
search:
  exclude: true
---
# リリースプロセス／変更履歴

このプロジェクトは、`0.Y.Z` という形式を使用したセマンティック バージョニングのわずかに改変されたバージョンに従っています。先頭の `0` は、 SDK がまだ急速に進化していることを示しています。各コンポーネントの増分ルールは次のとおりです。

## マイナー (`Y`) バージョン

ベータでない公開インターフェースに **破壊的変更** が入った場合は、マイナー バージョン `Y` を上げます。たとえば、`0.0.x` から `0.1.x` への更新には破壊的変更が含まれる可能性があります。

破壊的変更を避けたい場合は、プロジェクトで `0.0.x` バージョンを固定して使用することを推奨します。

## パッチ (`Z`) バージョン

互換性を壊さない変更については `Z` を増分します。

-   バグ修正
-   新機能
-   非公開インターフェースの変更
-   ベータ機能の更新

## 破壊的変更の変更履歴

### 0.2.0

このバージョンでは、以前は `Agent` を引数として受け取っていた数か所が、代わりに `AgentBase` を引数として受け取るようになりました。例としては MCP サーバーの `list_tools()` 呼び出しなどです。これは型に関する変更のみであり、実際には引き続き `Agent` オブジェクトを受け取ります。更新するには、型エラーを修正し `Agent` を `AgentBase` に置き換えてください。

### 0.1.0

このバージョンでは、[`MCPServer.list_tools()`][agents.mcp.server.MCPServer] に `run_context` と `agent` の 2 つの新しいパラメーターが追加されました。`MCPServer` をサブクラス化しているクラスには、これらのパラメーターを追加する必要があります。