# 
# SPDX-FileCopyrightText: Copyright (c) 2025 provide.io llc. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#

"""Client and server classes corresponding to protobuf-defined services."""

import grpc
import warnings

from pyvider.protocols.tfprotov6.protobuf import tfplugin6_pb2 as tfplugin6__pb2

GRPC_GENERATED_VERSION = '1.73.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in tfplugin6_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class ProviderStub(object):
    """////// Information about what a provider supports/expects
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetMetadata = channel.unary_unary(
                '/tfplugin6.Provider/GetMetadata',
                request_serializer=tfplugin6__pb2.GetMetadata.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.GetMetadata.Response.FromString,
                _registered_method=True)
        self.GetProviderSchema = channel.unary_unary(
                '/tfplugin6.Provider/GetProviderSchema',
                request_serializer=tfplugin6__pb2.GetProviderSchema.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.GetProviderSchema.Response.FromString,
                _registered_method=True)
        self.ValidateProviderConfig = channel.unary_unary(
                '/tfplugin6.Provider/ValidateProviderConfig',
                request_serializer=tfplugin6__pb2.ValidateProviderConfig.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ValidateProviderConfig.Response.FromString,
                _registered_method=True)
        self.ValidateResourceConfig = channel.unary_unary(
                '/tfplugin6.Provider/ValidateResourceConfig',
                request_serializer=tfplugin6__pb2.ValidateResourceConfig.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ValidateResourceConfig.Response.FromString,
                _registered_method=True)
        self.ValidateDataResourceConfig = channel.unary_unary(
                '/tfplugin6.Provider/ValidateDataResourceConfig',
                request_serializer=tfplugin6__pb2.ValidateDataResourceConfig.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ValidateDataResourceConfig.Response.FromString,
                _registered_method=True)
        self.UpgradeResourceState = channel.unary_unary(
                '/tfplugin6.Provider/UpgradeResourceState',
                request_serializer=tfplugin6__pb2.UpgradeResourceState.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.UpgradeResourceState.Response.FromString,
                _registered_method=True)
        self.GetResourceIdentitySchemas = channel.unary_unary(
                '/tfplugin6.Provider/GetResourceIdentitySchemas',
                request_serializer=tfplugin6__pb2.GetResourceIdentitySchemas.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.GetResourceIdentitySchemas.Response.FromString,
                _registered_method=True)
        self.UpgradeResourceIdentity = channel.unary_unary(
                '/tfplugin6.Provider/UpgradeResourceIdentity',
                request_serializer=tfplugin6__pb2.UpgradeResourceIdentity.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.UpgradeResourceIdentity.Response.FromString,
                _registered_method=True)
        self.ConfigureProvider = channel.unary_unary(
                '/tfplugin6.Provider/ConfigureProvider',
                request_serializer=tfplugin6__pb2.ConfigureProvider.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ConfigureProvider.Response.FromString,
                _registered_method=True)
        self.ReadResource = channel.unary_unary(
                '/tfplugin6.Provider/ReadResource',
                request_serializer=tfplugin6__pb2.ReadResource.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ReadResource.Response.FromString,
                _registered_method=True)
        self.PlanResourceChange = channel.unary_unary(
                '/tfplugin6.Provider/PlanResourceChange',
                request_serializer=tfplugin6__pb2.PlanResourceChange.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.PlanResourceChange.Response.FromString,
                _registered_method=True)
        self.ApplyResourceChange = channel.unary_unary(
                '/tfplugin6.Provider/ApplyResourceChange',
                request_serializer=tfplugin6__pb2.ApplyResourceChange.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ApplyResourceChange.Response.FromString,
                _registered_method=True)
        self.ImportResourceState = channel.unary_unary(
                '/tfplugin6.Provider/ImportResourceState',
                request_serializer=tfplugin6__pb2.ImportResourceState.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ImportResourceState.Response.FromString,
                _registered_method=True)
        self.MoveResourceState = channel.unary_unary(
                '/tfplugin6.Provider/MoveResourceState',
                request_serializer=tfplugin6__pb2.MoveResourceState.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.MoveResourceState.Response.FromString,
                _registered_method=True)
        self.ReadDataSource = channel.unary_unary(
                '/tfplugin6.Provider/ReadDataSource',
                request_serializer=tfplugin6__pb2.ReadDataSource.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ReadDataSource.Response.FromString,
                _registered_method=True)
        self.ValidateEphemeralResourceConfig = channel.unary_unary(
                '/tfplugin6.Provider/ValidateEphemeralResourceConfig',
                request_serializer=tfplugin6__pb2.ValidateEphemeralResourceConfig.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.ValidateEphemeralResourceConfig.Response.FromString,
                _registered_method=True)
        self.OpenEphemeralResource = channel.unary_unary(
                '/tfplugin6.Provider/OpenEphemeralResource',
                request_serializer=tfplugin6__pb2.OpenEphemeralResource.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.OpenEphemeralResource.Response.FromString,
                _registered_method=True)
        self.RenewEphemeralResource = channel.unary_unary(
                '/tfplugin6.Provider/RenewEphemeralResource',
                request_serializer=tfplugin6__pb2.RenewEphemeralResource.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.RenewEphemeralResource.Response.FromString,
                _registered_method=True)
        self.CloseEphemeralResource = channel.unary_unary(
                '/tfplugin6.Provider/CloseEphemeralResource',
                request_serializer=tfplugin6__pb2.CloseEphemeralResource.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.CloseEphemeralResource.Response.FromString,
                _registered_method=True)
        self.GetFunctions = channel.unary_unary(
                '/tfplugin6.Provider/GetFunctions',
                request_serializer=tfplugin6__pb2.GetFunctions.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.GetFunctions.Response.FromString,
                _registered_method=True)
        self.CallFunction = channel.unary_unary(
                '/tfplugin6.Provider/CallFunction',
                request_serializer=tfplugin6__pb2.CallFunction.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.CallFunction.Response.FromString,
                _registered_method=True)
        self.StopProvider = channel.unary_unary(
                '/tfplugin6.Provider/StopProvider',
                request_serializer=tfplugin6__pb2.StopProvider.Request.SerializeToString,
                response_deserializer=tfplugin6__pb2.StopProvider.Response.FromString,
                _registered_method=True)


class ProviderServicer(object):
    """////// Information about what a provider supports/expects
    """

    def GetMetadata(self, request, context):
        """GetMetadata returns upfront information about server capabilities and
        supported resource types without requiring the server to instantiate all
        schema information, which may be memory intensive. This RPC is optional,
        where clients may receive an unimplemented RPC error. Clients should
        ignore the error and call the GetProviderSchema RPC as a fallback.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetProviderSchema(self, request, context):
        """GetSchema returns schema information for the provider, data resources,
        and managed resources.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidateProviderConfig(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidateResourceConfig(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidateDataResourceConfig(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpgradeResourceState(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetResourceIdentitySchemas(self, request, context):
        """GetResourceIdentitySchemas returns the identity schemas for all managed
        resources.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpgradeResourceIdentity(self, request, context):
        """UpgradeResourceIdentityData should return the upgraded resource identity
        data for a managed resource type.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ConfigureProvider(self, request, context):
        """////// One-time initialization, called before other functions below
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReadResource(self, request, context):
        """////// Managed Resource Lifecycle
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PlanResourceChange(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ApplyResourceChange(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportResourceState(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MoveResourceState(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReadDataSource(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ValidateEphemeralResourceConfig(self, request, context):
        """////// Ephemeral Resource Lifecycle
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def OpenEphemeralResource(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RenewEphemeralResource(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CloseEphemeralResource(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFunctions(self, request, context):
        """GetFunctions returns the definitions of all functions.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CallFunction(self, request, context):
        """////// Provider-contributed Functions
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StopProvider(self, request, context):
        """////// Graceful Shutdown
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ProviderServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetMetadata': grpc.unary_unary_rpc_method_handler(
                    servicer.GetMetadata,
                    request_deserializer=tfplugin6__pb2.GetMetadata.Request.FromString,
                    response_serializer=tfplugin6__pb2.GetMetadata.Response.SerializeToString,
            ),
            'GetProviderSchema': grpc.unary_unary_rpc_method_handler(
                    servicer.GetProviderSchema,
                    request_deserializer=tfplugin6__pb2.GetProviderSchema.Request.FromString,
                    response_serializer=tfplugin6__pb2.GetProviderSchema.Response.SerializeToString,
            ),
            'ValidateProviderConfig': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidateProviderConfig,
                    request_deserializer=tfplugin6__pb2.ValidateProviderConfig.Request.FromString,
                    response_serializer=tfplugin6__pb2.ValidateProviderConfig.Response.SerializeToString,
            ),
            'ValidateResourceConfig': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidateResourceConfig,
                    request_deserializer=tfplugin6__pb2.ValidateResourceConfig.Request.FromString,
                    response_serializer=tfplugin6__pb2.ValidateResourceConfig.Response.SerializeToString,
            ),
            'ValidateDataResourceConfig': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidateDataResourceConfig,
                    request_deserializer=tfplugin6__pb2.ValidateDataResourceConfig.Request.FromString,
                    response_serializer=tfplugin6__pb2.ValidateDataResourceConfig.Response.SerializeToString,
            ),
            'UpgradeResourceState': grpc.unary_unary_rpc_method_handler(
                    servicer.UpgradeResourceState,
                    request_deserializer=tfplugin6__pb2.UpgradeResourceState.Request.FromString,
                    response_serializer=tfplugin6__pb2.UpgradeResourceState.Response.SerializeToString,
            ),
            'GetResourceIdentitySchemas': grpc.unary_unary_rpc_method_handler(
                    servicer.GetResourceIdentitySchemas,
                    request_deserializer=tfplugin6__pb2.GetResourceIdentitySchemas.Request.FromString,
                    response_serializer=tfplugin6__pb2.GetResourceIdentitySchemas.Response.SerializeToString,
            ),
            'UpgradeResourceIdentity': grpc.unary_unary_rpc_method_handler(
                    servicer.UpgradeResourceIdentity,
                    request_deserializer=tfplugin6__pb2.UpgradeResourceIdentity.Request.FromString,
                    response_serializer=tfplugin6__pb2.UpgradeResourceIdentity.Response.SerializeToString,
            ),
            'ConfigureProvider': grpc.unary_unary_rpc_method_handler(
                    servicer.ConfigureProvider,
                    request_deserializer=tfplugin6__pb2.ConfigureProvider.Request.FromString,
                    response_serializer=tfplugin6__pb2.ConfigureProvider.Response.SerializeToString,
            ),
            'ReadResource': grpc.unary_unary_rpc_method_handler(
                    servicer.ReadResource,
                    request_deserializer=tfplugin6__pb2.ReadResource.Request.FromString,
                    response_serializer=tfplugin6__pb2.ReadResource.Response.SerializeToString,
            ),
            'PlanResourceChange': grpc.unary_unary_rpc_method_handler(
                    servicer.PlanResourceChange,
                    request_deserializer=tfplugin6__pb2.PlanResourceChange.Request.FromString,
                    response_serializer=tfplugin6__pb2.PlanResourceChange.Response.SerializeToString,
            ),
            'ApplyResourceChange': grpc.unary_unary_rpc_method_handler(
                    servicer.ApplyResourceChange,
                    request_deserializer=tfplugin6__pb2.ApplyResourceChange.Request.FromString,
                    response_serializer=tfplugin6__pb2.ApplyResourceChange.Response.SerializeToString,
            ),
            'ImportResourceState': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportResourceState,
                    request_deserializer=tfplugin6__pb2.ImportResourceState.Request.FromString,
                    response_serializer=tfplugin6__pb2.ImportResourceState.Response.SerializeToString,
            ),
            'MoveResourceState': grpc.unary_unary_rpc_method_handler(
                    servicer.MoveResourceState,
                    request_deserializer=tfplugin6__pb2.MoveResourceState.Request.FromString,
                    response_serializer=tfplugin6__pb2.MoveResourceState.Response.SerializeToString,
            ),
            'ReadDataSource': grpc.unary_unary_rpc_method_handler(
                    servicer.ReadDataSource,
                    request_deserializer=tfplugin6__pb2.ReadDataSource.Request.FromString,
                    response_serializer=tfplugin6__pb2.ReadDataSource.Response.SerializeToString,
            ),
            'ValidateEphemeralResourceConfig': grpc.unary_unary_rpc_method_handler(
                    servicer.ValidateEphemeralResourceConfig,
                    request_deserializer=tfplugin6__pb2.ValidateEphemeralResourceConfig.Request.FromString,
                    response_serializer=tfplugin6__pb2.ValidateEphemeralResourceConfig.Response.SerializeToString,
            ),
            'OpenEphemeralResource': grpc.unary_unary_rpc_method_handler(
                    servicer.OpenEphemeralResource,
                    request_deserializer=tfplugin6__pb2.OpenEphemeralResource.Request.FromString,
                    response_serializer=tfplugin6__pb2.OpenEphemeralResource.Response.SerializeToString,
            ),
            'RenewEphemeralResource': grpc.unary_unary_rpc_method_handler(
                    servicer.RenewEphemeralResource,
                    request_deserializer=tfplugin6__pb2.RenewEphemeralResource.Request.FromString,
                    response_serializer=tfplugin6__pb2.RenewEphemeralResource.Response.SerializeToString,
            ),
            'CloseEphemeralResource': grpc.unary_unary_rpc_method_handler(
                    servicer.CloseEphemeralResource,
                    request_deserializer=tfplugin6__pb2.CloseEphemeralResource.Request.FromString,
                    response_serializer=tfplugin6__pb2.CloseEphemeralResource.Response.SerializeToString,
            ),
            'GetFunctions': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFunctions,
                    request_deserializer=tfplugin6__pb2.GetFunctions.Request.FromString,
                    response_serializer=tfplugin6__pb2.GetFunctions.Response.SerializeToString,
            ),
            'CallFunction': grpc.unary_unary_rpc_method_handler(
                    servicer.CallFunction,
                    request_deserializer=tfplugin6__pb2.CallFunction.Request.FromString,
                    response_serializer=tfplugin6__pb2.CallFunction.Response.SerializeToString,
            ),
            'StopProvider': grpc.unary_unary_rpc_method_handler(
                    servicer.StopProvider,
                    request_deserializer=tfplugin6__pb2.StopProvider.Request.FromString,
                    response_serializer=tfplugin6__pb2.StopProvider.Response.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'tfplugin6.Provider', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('tfplugin6.Provider', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Provider(object):
    """////// Information about what a provider supports/expects
    """

    @staticmethod
    def GetMetadata(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/GetMetadata',
            tfplugin6__pb2.GetMetadata.Request.SerializeToString,
            tfplugin6__pb2.GetMetadata.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetProviderSchema(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/GetProviderSchema',
            tfplugin6__pb2.GetProviderSchema.Request.SerializeToString,
            tfplugin6__pb2.GetProviderSchema.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ValidateProviderConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ValidateProviderConfig',
            tfplugin6__pb2.ValidateProviderConfig.Request.SerializeToString,
            tfplugin6__pb2.ValidateProviderConfig.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ValidateResourceConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ValidateResourceConfig',
            tfplugin6__pb2.ValidateResourceConfig.Request.SerializeToString,
            tfplugin6__pb2.ValidateResourceConfig.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ValidateDataResourceConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ValidateDataResourceConfig',
            tfplugin6__pb2.ValidateDataResourceConfig.Request.SerializeToString,
            tfplugin6__pb2.ValidateDataResourceConfig.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UpgradeResourceState(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/UpgradeResourceState',
            tfplugin6__pb2.UpgradeResourceState.Request.SerializeToString,
            tfplugin6__pb2.UpgradeResourceState.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetResourceIdentitySchemas(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/GetResourceIdentitySchemas',
            tfplugin6__pb2.GetResourceIdentitySchemas.Request.SerializeToString,
            tfplugin6__pb2.GetResourceIdentitySchemas.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UpgradeResourceIdentity(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/UpgradeResourceIdentity',
            tfplugin6__pb2.UpgradeResourceIdentity.Request.SerializeToString,
            tfplugin6__pb2.UpgradeResourceIdentity.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ConfigureProvider(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ConfigureProvider',
            tfplugin6__pb2.ConfigureProvider.Request.SerializeToString,
            tfplugin6__pb2.ConfigureProvider.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ReadResource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ReadResource',
            tfplugin6__pb2.ReadResource.Request.SerializeToString,
            tfplugin6__pb2.ReadResource.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PlanResourceChange(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/PlanResourceChange',
            tfplugin6__pb2.PlanResourceChange.Request.SerializeToString,
            tfplugin6__pb2.PlanResourceChange.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ApplyResourceChange(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ApplyResourceChange',
            tfplugin6__pb2.ApplyResourceChange.Request.SerializeToString,
            tfplugin6__pb2.ApplyResourceChange.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ImportResourceState(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ImportResourceState',
            tfplugin6__pb2.ImportResourceState.Request.SerializeToString,
            tfplugin6__pb2.ImportResourceState.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MoveResourceState(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/MoveResourceState',
            tfplugin6__pb2.MoveResourceState.Request.SerializeToString,
            tfplugin6__pb2.MoveResourceState.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ReadDataSource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ReadDataSource',
            tfplugin6__pb2.ReadDataSource.Request.SerializeToString,
            tfplugin6__pb2.ReadDataSource.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ValidateEphemeralResourceConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/ValidateEphemeralResourceConfig',
            tfplugin6__pb2.ValidateEphemeralResourceConfig.Request.SerializeToString,
            tfplugin6__pb2.ValidateEphemeralResourceConfig.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def OpenEphemeralResource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/OpenEphemeralResource',
            tfplugin6__pb2.OpenEphemeralResource.Request.SerializeToString,
            tfplugin6__pb2.OpenEphemeralResource.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RenewEphemeralResource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/RenewEphemeralResource',
            tfplugin6__pb2.RenewEphemeralResource.Request.SerializeToString,
            tfplugin6__pb2.RenewEphemeralResource.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CloseEphemeralResource(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/CloseEphemeralResource',
            tfplugin6__pb2.CloseEphemeralResource.Request.SerializeToString,
            tfplugin6__pb2.CloseEphemeralResource.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetFunctions(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/GetFunctions',
            tfplugin6__pb2.GetFunctions.Request.SerializeToString,
            tfplugin6__pb2.GetFunctions.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CallFunction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/CallFunction',
            tfplugin6__pb2.CallFunction.Request.SerializeToString,
            tfplugin6__pb2.CallFunction.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StopProvider(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/tfplugin6.Provider/StopProvider',
            tfplugin6__pb2.StopProvider.Request.SerializeToString,
            tfplugin6__pb2.StopProvider.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

# 🐍🏗️🔚
