"""Stub file for reflex/components/lucide/icon.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any

from reflex.components.component import Component
from reflex.components.core.breakpoints import Breakpoints
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

LUCIDE_LIBRARY = "lucide-react@0.541.0"

class LucideIconComponent(Component):
    @classmethod
    def create(
        cls,
        *children,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> LucideIconComponent:
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

class Icon(LucideIconComponent):
    @classmethod
    def create(
        cls,
        *children,
        size: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Icon:
        """Initialize the Icon component.

        Run some additional checks on Icon component.

        Args:
            *children: The positional arguments
            size: The size of the icon in pixels.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The keyword arguments

        Raises:
            AttributeError: The errors tied to bad usage of the Icon component.
            TypeError: If the icon name is not a string.

        Returns:
            The created component.
        """

class DynamicIcon(LucideIconComponent):
    @classmethod
    def create(
        cls,
        *children,
        name: Var[str] | str | None = None,
        size: Var[int] | int | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> DynamicIcon:
        """Create the component.

        Args:
            *children: The children of the component.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props of the component.

        Returns:
            The component.
        """

LUCIDE_ICON_LIST = [
    "a_arrow_down",
    "a_arrow_up",
    "a_large_small",
    "accessibility",
    "activity",
    "air_vent",
    "airplay",
    "alarm_clock_check",
    "alarm_clock_minus",
    "alarm_clock_off",
    "alarm_clock_plus",
    "alarm_clock",
    "alarm_smoke",
    "album",
    "align_center_horizontal",
    "align_center_vertical",
    "align_center",
    "align_end_horizontal",
    "align_end_vertical",
    "align_horizontal_distribute_center",
    "align_horizontal_distribute_end",
    "align_horizontal_distribute_start",
    "align_horizontal_justify_center",
    "align_horizontal_justify_end",
    "align_horizontal_justify_start",
    "align_horizontal_space_around",
    "align_horizontal_space_between",
    "align_justify",
    "align_left",
    "align_right",
    "align_start_horizontal",
    "align_start_vertical",
    "align_vertical_distribute_center",
    "align_vertical_distribute_end",
    "align_vertical_distribute_start",
    "align_vertical_justify_center",
    "align_vertical_justify_end",
    "align_vertical_justify_start",
    "align_vertical_space_around",
    "align_vertical_space_between",
    "ambulance",
    "ampersand",
    "ampersands",
    "amphora",
    "anchor",
    "angry",
    "annoyed",
    "antenna",
    "anvil",
    "aperture",
    "app_window_mac",
    "app_window",
    "apple",
    "archive_restore",
    "archive_x",
    "archive",
    "area_chart",
    "armchair",
    "arrow_big_down_dash",
    "arrow_big_down",
    "arrow_big_left_dash",
    "arrow_big_left",
    "arrow_big_right_dash",
    "arrow_big_right",
    "arrow_big_up_dash",
    "arrow_big_up",
    "arrow_down_0_1",
    "arrow_down_1_0",
    "arrow_down_a_z",
    "arrow_down_from_line",
    "arrow_down_left",
    "arrow_down_narrow_wide",
    "arrow_down_right",
    "arrow_down_to_dot",
    "arrow_down_to_line",
    "arrow_down_up",
    "arrow_down_wide_narrow",
    "arrow_down_z_a",
    "arrow_down",
    "arrow_left_from_line",
    "arrow_left_right",
    "arrow_left_to_line",
    "arrow_left",
    "arrow_right_from_line",
    "arrow_right_left",
    "arrow_right_to_line",
    "arrow_right",
    "arrow_up_0_1",
    "arrow_up_1_0",
    "arrow_up_a_z",
    "arrow_up_down",
    "arrow_up_from_dot",
    "arrow_up_from_line",
    "arrow_up_left",
    "arrow_up_narrow_wide",
    "arrow_up_right",
    "arrow_up_to_line",
    "arrow_up_wide_narrow",
    "arrow_up_z_a",
    "arrow_up",
    "arrows_up_from_line",
    "asterisk",
    "at_sign",
    "atom",
    "audio_lines",
    "audio_waveform",
    "award",
    "axe",
    "axis_3d",
    "baby",
    "backpack",
    "badge_alert",
    "badge_cent",
    "badge_check",
    "badge_dollar_sign",
    "badge_euro",
    "badge_help",
    "badge_indian_rupee",
    "badge_info",
    "badge_japanese_yen",
    "badge_minus",
    "badge_percent",
    "badge_plus",
    "badge_pound_sterling",
    "badge_russian_ruble",
    "badge_swiss_franc",
    "badge_turkish_lira",
    "badge_x",
    "badge",
    "baggage_claim",
    "ban",
    "banana",
    "bandage",
    "banknote_arrow_down",
    "banknote_x",
    "banknote",
    "bar_chart_2",
    "bar_chart_3",
    "bar_chart_4",
    "bar_chart_big",
    "bar_chart_horizontal_big",
    "bar_chart_horizontal",
    "bar_chart",
    "barcode",
    "barrel",
    "baseline",
    "bath",
    "battery_charging",
    "battery_full",
    "battery_low",
    "battery_medium",
    "battery_plus",
    "battery_warning",
    "battery",
    "beaker",
    "bean_off",
    "bean",
    "bed_double",
    "bed_single",
    "bed",
    "beef",
    "beer_off",
    "beer",
    "bell_dot",
    "bell_electric",
    "bell_minus",
    "bell_off",
    "bell_plus",
    "bell_ring",
    "bell",
    "between_horizontal_end",
    "between_horizontal_start",
    "between_vertical_end",
    "between_vertical_start",
    "biceps_flexed",
    "bike",
    "binary",
    "binoculars",
    "biohazard",
    "bird",
    "bitcoin",
    "blend",
    "blinds",
    "blocks",
    "bluetooth_connected",
    "bluetooth_off",
    "bluetooth_searching",
    "bluetooth",
    "bold",
    "bolt",
    "bomb",
    "bone",
    "book_a",
    "book_alert",
    "book_audio",
    "book_check",
    "book_copy",
    "book_dashed",
    "book_down",
    "book_headphones",
    "book_heart",
    "book_image",
    "book_key",
    "book_lock",
    "book_marked",
    "book_minus",
    "book_open_check",
    "book_open_text",
    "book_open",
    "book_plus",
    "book_text",
    "book_type",
    "book_up_2",
    "book_up",
    "book_user",
    "book_x",
    "book",
    "bookmark_check",
    "bookmark_minus",
    "bookmark_plus",
    "bookmark_x",
    "bookmark",
    "boom_box",
    "bot_message_square",
    "bot_off",
    "bot",
    "bottle_wine",
    "bow_arrow",
    "box_select",
    "box",
    "boxes",
    "braces",
    "brackets",
    "brain_circuit",
    "brain_cog",
    "brain",
    "brick_wall_fire",
    "brick_wall_shield",
    "brick_wall",
    "briefcase_business",
    "briefcase_conveyor_belt",
    "briefcase_medical",
    "briefcase",
    "bring_to_front",
    "brush_cleaning",
    "brush",
    "bubbles",
    "bug_off",
    "bug_play",
    "bug",
    "building_2",
    "building",
    "bus_front",
    "bus",
    "cable_car",
    "cable",
    "cake_slice",
    "cake",
    "calculator",
    "calendar_1",
    "calendar_arrow_down",
    "calendar_arrow_up",
    "calendar_check_2",
    "calendar_check",
    "calendar_clock",
    "calendar_cog",
    "calendar_days",
    "calendar_fold",
    "calendar_heart",
    "calendar_minus_2",
    "calendar_minus",
    "calendar_off",
    "calendar_plus_2",
    "calendar_plus",
    "calendar_range",
    "calendar_search",
    "calendar_sync",
    "calendar_x_2",
    "calendar_x",
    "calendar",
    "camera_off",
    "camera",
    "candlestick_chart",
    "candy_cane",
    "candy_off",
    "candy",
    "cannabis",
    "captions_off",
    "captions",
    "car_front",
    "car_taxi_front",
    "car",
    "caravan",
    "card_sim",
    "carrot",
    "case_lower",
    "case_sensitive",
    "case_upper",
    "cassette_tape",
    "cast",
    "castle",
    "cat",
    "cctv",
    "chart_area",
    "chart_bar_big",
    "chart_bar_decreasing",
    "chart_bar_increasing",
    "chart_bar_stacked",
    "chart_bar",
    "chart_candlestick",
    "chart_column_big",
    "chart_column_decreasing",
    "chart_column_increasing",
    "chart_column_stacked",
    "chart_column",
    "chart_gantt",
    "chart_line",
    "chart_network",
    "chart_no_axes_column_decreasing",
    "chart_no_axes_column_increasing",
    "chart_no_axes_column",
    "chart_no_axes_combined",
    "chart_no_axes_gantt",
    "chart_pie",
    "chart_scatter",
    "chart_spline",
    "check_check",
    "check_line",
    "check",
    "chef_hat",
    "cherry",
    "chevron_down",
    "chevron_first",
    "chevron_last",
    "chevron_left",
    "chevron_right",
    "chevron_up",
    "chevrons_down_up",
    "chevrons_down",
    "chevrons_left_right_ellipsis",
    "chevrons_left_right",
    "chevrons_left",
    "chevrons_right_left",
    "chevrons_right",
    "chevrons_up_down",
    "chevrons_up",
    "chrome",
    "chromium",
    "church",
    "cigarette_off",
    "cigarette",
    "circle_alert",
    "circle_arrow_down",
    "circle_arrow_left",
    "circle_arrow_out_down_left",
    "circle_arrow_out_down_right",
    "circle_arrow_out_up_left",
    "circle_arrow_out_up_right",
    "circle_arrow_right",
    "circle_arrow_up",
    "circle_check_big",
    "circle_check",
    "circle_chevron_down",
    "circle_chevron_left",
    "circle_chevron_right",
    "circle_chevron_up",
    "circle_dashed",
    "circle_divide",
    "circle_dollar_sign",
    "circle_dot_dashed",
    "circle_dot",
    "circle_ellipsis",
    "circle_equal",
    "circle_fading_arrow_up",
    "circle_fading_plus",
    "circle_gauge",
    "circle_help",
    "circle_minus",
    "circle_off",
    "circle_parking_off",
    "circle_parking",
    "circle_pause",
    "circle_percent",
    "circle_play",
    "circle_plus",
    "circle_pound_sterling",
    "circle_power",
    "circle_slash_2",
    "circle_slash",
    "circle_small",
    "circle_star",
    "circle_stop",
    "circle_user_round",
    "circle_user",
    "circle_x",
    "circle",
    "circuit_board",
    "citrus",
    "clapperboard",
    "clipboard_check",
    "clipboard_clock",
    "clipboard_copy",
    "clipboard_list",
    "clipboard_minus",
    "clipboard_paste",
    "clipboard_pen_line",
    "clipboard_pen",
    "clipboard_plus",
    "clipboard_type",
    "clipboard_x",
    "clipboard",
    "clock_1",
    "clock_10",
    "clock_11",
    "clock_12",
    "clock_2",
    "clock_3",
    "clock_4",
    "clock_5",
    "clock_6",
    "clock_7",
    "clock_8",
    "clock_9",
    "clock_alert",
    "clock_arrow_down",
    "clock_arrow_up",
    "clock_fading",
    "clock_plus",
    "clock",
    "closed_caption",
    "cloud_alert",
    "cloud_check",
    "cloud_cog",
    "cloud_download",
    "cloud_drizzle",
    "cloud_fog",
    "cloud_hail",
    "cloud_lightning",
    "cloud_moon_rain",
    "cloud_moon",
    "cloud_off",
    "cloud_rain_wind",
    "cloud_rain",
    "cloud_snow",
    "cloud_sun_rain",
    "cloud_sun",
    "cloud_upload",
    "cloud",
    "cloudy",
    "clover",
    "club",
    "code_xml",
    "code",
    "codepen",
    "codesandbox",
    "coffee",
    "cog",
    "coins",
    "columns_2",
    "columns_3_cog",
    "columns_3",
    "columns_4",
    "combine",
    "command",
    "compass",
    "component",
    "computer",
    "concierge_bell",
    "cone",
    "construction",
    "contact_round",
    "contact",
    "container",
    "contrast",
    "cookie",
    "cooking_pot",
    "copy_check",
    "copy_minus",
    "copy_plus",
    "copy_slash",
    "copy_x",
    "copy",
    "copyleft",
    "copyright",
    "corner_down_left",
    "corner_down_right",
    "corner_left_down",
    "corner_left_up",
    "corner_right_down",
    "corner_right_up",
    "corner_up_left",
    "corner_up_right",
    "cpu",
    "creative_commons",
    "credit_card",
    "croissant",
    "crop",
    "cross",
    "crosshair",
    "crown",
    "cuboid",
    "cup_soda",
    "currency",
    "cylinder",
    "dam",
    "database_backup",
    "database_zap",
    "database",
    "decimals_arrow_left",
    "decimals_arrow_right",
    "delete",
    "dessert",
    "diameter",
    "diamond_minus",
    "diamond_percent",
    "diamond_plus",
    "diamond",
    "dice_1",
    "dice_2",
    "dice_3",
    "dice_4",
    "dice_5",
    "dice_6",
    "dices",
    "diff",
    "disc_2",
    "disc_3",
    "disc_album",
    "disc",
    "divide",
    "dna_off",
    "dna",
    "dock",
    "dog",
    "dollar_sign",
    "donut",
    "door_closed_locked",
    "door_closed",
    "door_open",
    "dot",
    "download",
    "drafting_compass",
    "drama",
    "dribbble",
    "drill",
    "drone",
    "droplet_off",
    "droplet",
    "droplets",
    "drum",
    "drumstick",
    "dumbbell",
    "ear_off",
    "ear",
    "earth_lock",
    "earth",
    "eclipse",
    "egg_fried",
    "egg_off",
    "egg",
    "ellipsis_vertical",
    "ellipsis",
    "equal_approximately",
    "equal_not",
    "equal",
    "eraser",
    "ethernet_port",
    "euro",
    "expand",
    "external_link",
    "eye_closed",
    "eye_off",
    "eye",
    "facebook",
    "factory",
    "fan",
    "fast_forward",
    "feather",
    "fence",
    "ferris_wheel",
    "figma",
    "file_archive",
    "file_audio_2",
    "file_audio",
    "file_axis_3d",
    "file_badge_2",
    "file_badge",
    "file_bar_chart_2",
    "file_bar_chart",
    "file_box",
    "file_chart_column_increasing",
    "file_chart_column",
    "file_chart_line",
    "file_chart_pie",
    "file_check_2",
    "file_check",
    "file_clock",
    "file_code_2",
    "file_code",
    "file_cog",
    "file_diff",
    "file_digit",
    "file_down",
    "file_heart",
    "file_image",
    "file_input",
    "file_json_2",
    "file_json",
    "file_key_2",
    "file_key",
    "file_line_chart",
    "file_lock_2",
    "file_lock",
    "file_minus_2",
    "file_minus",
    "file_music",
    "file_output",
    "file_pen_line",
    "file_pen",
    "file_pie_chart",
    "file_plus_2",
    "file_plus",
    "file_question",
    "file_scan",
    "file_search_2",
    "file_search",
    "file_sliders",
    "file_spreadsheet",
    "file_stack",
    "file_symlink",
    "file_terminal",
    "file_text",
    "file_type_2",
    "file_type",
    "file_up",
    "file_user",
    "file_video_2",
    "file_video",
    "file_volume_2",
    "file_volume",
    "file_warning",
    "file_x_2",
    "file_x",
    "file",
    "files",
    "film",
    "filter_x",
    "filter",
    "fingerprint",
    "fire_extinguisher",
    "fish_off",
    "fish_symbol",
    "fish",
    "flag_off",
    "flag_triangle_left",
    "flag_triangle_right",
    "flag",
    "flame_kindling",
    "flame",
    "flashlight_off",
    "flashlight",
    "flask_conical_off",
    "flask_conical",
    "flask_round",
    "flip_horizontal_2",
    "flip_horizontal",
    "flip_vertical_2",
    "flip_vertical",
    "flower_2",
    "flower",
    "focus",
    "fold_horizontal",
    "fold_vertical",
    "folder_archive",
    "folder_check",
    "folder_clock",
    "folder_closed",
    "folder_code",
    "folder_cog",
    "folder_dot",
    "folder_down",
    "folder_git_2",
    "folder_git",
    "folder_heart",
    "folder_input",
    "folder_kanban",
    "folder_key",
    "folder_lock",
    "folder_minus",
    "folder_open_dot",
    "folder_open",
    "folder_output",
    "folder_pen",
    "folder_plus",
    "folder_root",
    "folder_search_2",
    "folder_search",
    "folder_symlink",
    "folder_sync",
    "folder_tree",
    "folder_up",
    "folder_x",
    "folder",
    "folders",
    "footprints",
    "forklift",
    "forward",
    "frame",
    "framer",
    "frown",
    "fuel",
    "fullscreen",
    "funnel_plus",
    "funnel_x",
    "funnel",
    "gallery_horizontal_end",
    "gallery_horizontal",
    "gallery_thumbnails",
    "gallery_vertical_end",
    "gallery_vertical",
    "gamepad_2",
    "gamepad",
    "gantt_chart",
    "gauge",
    "gavel",
    "gem",
    "georgian_lari",
    "ghost",
    "gift",
    "git_branch_plus",
    "git_branch",
    "git_commit_horizontal",
    "git_commit_vertical",
    "git_compare_arrows",
    "git_compare",
    "git_fork",
    "git_graph",
    "git_merge",
    "git_pull_request_arrow",
    "git_pull_request_closed",
    "git_pull_request_create_arrow",
    "git_pull_request_create",
    "git_pull_request_draft",
    "git_pull_request",
    "github",
    "gitlab",
    "glass_water",
    "glasses",
    "globe_lock",
    "globe",
    "goal",
    "gpu",
    "grab",
    "graduation_cap",
    "grape",
    "grid_2x_2_check",
    "grid_2x_2_plus",
    "grid_2x_2_x",
    "grid_2x_2",
    "grid_2x2",
    "grid_3x_3",
    "grid_3x2",
    "grid_3x3",
    "grip_horizontal",
    "grip_vertical",
    "grip",
    "group",
    "guitar",
    "ham",
    "hamburger",
    "hammer",
    "hand_coins",
    "hand_fist",
    "hand_heart",
    "hand_helping",
    "hand_metal",
    "hand_platter",
    "hand",
    "handbag",
    "handshake",
    "hard_drive_download",
    "hard_drive_upload",
    "hard_drive",
    "hard_hat",
    "hash",
    "hat_glasses",
    "haze",
    "hdmi_port",
    "heading_1",
    "heading_2",
    "heading_3",
    "heading_4",
    "heading_5",
    "heading_6",
    "heading",
    "headphone_off",
    "headphones",
    "headset",
    "heart_crack",
    "heart_handshake",
    "heart_minus",
    "heart_off",
    "heart_plus",
    "heart_pulse",
    "heart",
    "heater",
    "hexagon",
    "highlighter",
    "history",
    "home",
    "hop_off",
    "hop",
    "hospital",
    "hotel",
    "hourglass",
    "house_plug",
    "house_plus",
    "house_wifi",
    "house",
    "ice_cream_bowl",
    "ice_cream_cone",
    "id_card_lanyard",
    "id_card",
    "image_down",
    "image_minus",
    "image_off",
    "image_play",
    "image_plus",
    "image_up",
    "image_upscale",
    "image",
    "images",
    "import",
    "inbox",
    "indent_decrease",
    "indent_increase",
    "indian_rupee",
    "infinity",
    "info",
    "inspection_panel",
    "instagram",
    "italic",
    "iteration_ccw",
    "iteration_cw",
    "japanese_yen",
    "joystick",
    "kanban",
    "kayak",
    "key_round",
    "key_square",
    "key",
    "keyboard_music",
    "keyboard_off",
    "keyboard",
    "lamp_ceiling",
    "lamp_desk",
    "lamp_floor",
    "lamp_wall_down",
    "lamp_wall_up",
    "lamp",
    "land_plot",
    "landmark",
    "languages",
    "laptop_minimal_check",
    "laptop_minimal",
    "laptop",
    "lasso_select",
    "lasso",
    "laugh",
    "layers_2",
    "layers_3",
    "layers",
    "layout_dashboard",
    "layout_grid",
    "layout_list",
    "layout_panel_left",
    "layout_panel_top",
    "layout_template",
    "leaf",
    "leafy_green",
    "lectern",
    "letter_text",
    "library_big",
    "library",
    "life_buoy",
    "ligature",
    "lightbulb_off",
    "lightbulb",
    "line_chart",
    "line_squiggle",
    "link_2_off",
    "link_2",
    "link",
    "linkedin",
    "list_check",
    "list_checks",
    "list_collapse",
    "list_end",
    "list_filter_plus",
    "list_filter",
    "list_minus",
    "list_music",
    "list_ordered",
    "list_plus",
    "list_restart",
    "list_start",
    "list_todo",
    "list_tree",
    "list_video",
    "list_x",
    "list",
    "loader_circle",
    "loader_pinwheel",
    "loader",
    "locate_fixed",
    "locate_off",
    "locate",
    "location_edit",
    "lock_keyhole_open",
    "lock_keyhole",
    "lock_open",
    "lock",
    "log_in",
    "log_out",
    "logs",
    "lollipop",
    "luggage",
    "magnet",
    "mail_check",
    "mail_minus",
    "mail_open",
    "mail_plus",
    "mail_question",
    "mail_search",
    "mail_warning",
    "mail_x",
    "mail",
    "mailbox",
    "mails",
    "map_minus",
    "map_pin_check_inside",
    "map_pin_check",
    "map_pin_house",
    "map_pin_minus_inside",
    "map_pin_minus",
    "map_pin_off",
    "map_pin_plus_inside",
    "map_pin_plus",
    "map_pin_x_inside",
    "map_pin_x",
    "map_pin",
    "map_pinned",
    "map_plus",
    "map",
    "mars_stroke",
    "martini",
    "maximize_2",
    "maximize",
    "medal",
    "megaphone_off",
    "megaphone",
    "meh",
    "memory_stick",
    "menu",
    "merge",
    "message_circle_code",
    "message_circle_dashed",
    "message_circle_heart",
    "message_circle_more",
    "message_circle_off",
    "message_circle_plus",
    "message_circle_question",
    "message_circle_reply",
    "message_circle_warning",
    "message_circle_x",
    "message_circle",
    "message_square_code",
    "message_square_dashed",
    "message_square_diff",
    "message_square_dot",
    "message_square_heart",
    "message_square_lock",
    "message_square_more",
    "message_square_off",
    "message_square_plus",
    "message_square_quote",
    "message_square_reply",
    "message_square_share",
    "message_square_text",
    "message_square_warning",
    "message_square_x",
    "message_square",
    "messages_square",
    "mic_off",
    "mic_vocal",
    "mic",
    "microchip",
    "microscope",
    "microwave",
    "milestone",
    "milk_off",
    "milk",
    "minimize_2",
    "minimize",
    "minus",
    "monitor_check",
    "monitor_cog",
    "monitor_dot",
    "monitor_down",
    "monitor_off",
    "monitor_pause",
    "monitor_play",
    "monitor_smartphone",
    "monitor_speaker",
    "monitor_stop",
    "monitor_up",
    "monitor_x",
    "monitor",
    "moon_star",
    "moon",
    "mountain_snow",
    "mountain",
    "mouse_off",
    "mouse_pointer_2",
    "mouse_pointer_ban",
    "mouse_pointer_click",
    "mouse_pointer",
    "mouse",
    "move_3d",
    "move_diagonal_2",
    "move_diagonal",
    "move_down_left",
    "move_down_right",
    "move_down",
    "move_horizontal",
    "move_left",
    "move_right",
    "move_up_left",
    "move_up_right",
    "move_up",
    "move_vertical",
    "move",
    "music_2",
    "music_3",
    "music_4",
    "music",
    "navigation_2_off",
    "navigation_2",
    "navigation_off",
    "navigation",
    "network",
    "newspaper",
    "nfc",
    "non_binary",
    "notebook_pen",
    "notebook_tabs",
    "notebook_text",
    "notebook",
    "notepad_text_dashed",
    "notepad_text",
    "nut_off",
    "nut",
    "octagon_alert",
    "octagon_minus",
    "octagon_pause",
    "octagon_x",
    "octagon",
    "omega",
    "option",
    "orbit",
    "origami",
    "package_2",
    "package_check",
    "package_minus",
    "package_open",
    "package_plus",
    "package_search",
    "package_x",
    "package",
    "paint_bucket",
    "paint_roller",
    "paintbrush_2",
    "paintbrush_vertical",
    "paintbrush",
    "palette",
    "panda",
    "panel_bottom_close",
    "panel_bottom_dashed",
    "panel_bottom_open",
    "panel_bottom",
    "panel_left_close",
    "panel_left_dashed",
    "panel_left_open",
    "panel_left_right_dashed",
    "panel_left",
    "panel_right_close",
    "panel_right_dashed",
    "panel_right_open",
    "panel_right",
    "panel_top_bottom_dashed",
    "panel_top_close",
    "panel_top_dashed",
    "panel_top_open",
    "panel_top",
    "panels_left_bottom",
    "panels_right_bottom",
    "panels_top_left",
    "paperclip",
    "parentheses",
    "parking_meter",
    "party_popper",
    "pause",
    "paw_print",
    "pc_case",
    "pen_line",
    "pen_off",
    "pen_tool",
    "pen",
    "pencil_line",
    "pencil_off",
    "pencil_ruler",
    "pencil",
    "pentagon",
    "percent",
    "person_standing",
    "philippine_peso",
    "phone_call",
    "phone_forwarded",
    "phone_incoming",
    "phone_missed",
    "phone_off",
    "phone_outgoing",
    "phone",
    "pi",
    "piano",
    "pickaxe",
    "picture_in_picture_2",
    "picture_in_picture",
    "pie_chart",
    "piggy_bank",
    "pilcrow_left",
    "pilcrow_right",
    "pilcrow",
    "pill_bottle",
    "pill",
    "pin_off",
    "pin",
    "pipette",
    "pizza",
    "plane_landing",
    "plane_takeoff",
    "plane",
    "play",
    "plug_2",
    "plug_zap_2",
    "plug_zap",
    "plug",
    "plus",
    "pocket_knife",
    "pocket",
    "podcast",
    "pointer_off",
    "pointer",
    "popcorn",
    "popsicle",
    "pound_sterling",
    "power_off",
    "power",
    "presentation",
    "printer_check",
    "printer",
    "projector",
    "proportions",
    "puzzle",
    "pyramid",
    "qr_code",
    "quote",
    "rabbit",
    "radar",
    "radiation",
    "radical",
    "radio_receiver",
    "radio_tower",
    "radio",
    "radius",
    "rail_symbol",
    "rainbow",
    "rat",
    "ratio",
    "receipt_cent",
    "receipt_euro",
    "receipt_indian_rupee",
    "receipt_japanese_yen",
    "receipt_pound_sterling",
    "receipt_russian_ruble",
    "receipt_swiss_franc",
    "receipt_text",
    "receipt_turkish_lira",
    "receipt",
    "rectangle_circle",
    "rectangle_ellipsis",
    "rectangle_goggles",
    "rectangle_horizontal",
    "rectangle_vertical",
    "recycle",
    "redo_2",
    "redo_dot",
    "redo",
    "refresh_ccw_dot",
    "refresh_ccw",
    "refresh_cw_off",
    "refresh_cw",
    "refrigerator",
    "regex",
    "remove_formatting",
    "repeat_1",
    "repeat_2",
    "repeat",
    "replace_all",
    "replace",
    "reply_all",
    "reply",
    "rewind",
    "ribbon",
    "rocket",
    "rocking_chair",
    "roller_coaster",
    "rose",
    "rotate_3d",
    "rotate_ccw_key",
    "rotate_ccw_square",
    "rotate_ccw",
    "rotate_cw_square",
    "rotate_cw",
    "route_off",
    "route",
    "router",
    "rows_2",
    "rows_3",
    "rows_4",
    "rss",
    "ruler_dimension_line",
    "ruler",
    "russian_ruble",
    "sailboat",
    "salad",
    "sandwich",
    "satellite_dish",
    "satellite",
    "saudi_riyal",
    "save_all",
    "save_off",
    "save",
    "scale_3d",
    "scale",
    "scaling",
    "scan_barcode",
    "scan_eye",
    "scan_face",
    "scan_heart",
    "scan_line",
    "scan_qr_code",
    "scan_search",
    "scan_text",
    "scan",
    "scatter_chart",
    "school",
    "scissors_line_dashed",
    "scissors",
    "screen_share_off",
    "screen_share",
    "scroll_text",
    "scroll",
    "search_check",
    "search_code",
    "search_slash",
    "search_x",
    "search",
    "section",
    "send_horizontal",
    "send_to_back",
    "send",
    "separator_horizontal",
    "separator_vertical",
    "server_cog",
    "server_crash",
    "server_off",
    "server",
    "settings_2",
    "settings",
    "shapes",
    "share_2",
    "share",
    "sheet",
    "shell",
    "shield_alert",
    "shield_ban",
    "shield_check",
    "shield_ellipsis",
    "shield_half",
    "shield_minus",
    "shield_off",
    "shield_plus",
    "shield_question",
    "shield_user",
    "shield_x",
    "shield",
    "ship_wheel",
    "ship",
    "shirt",
    "shopping_bag",
    "shopping_basket",
    "shopping_cart",
    "shovel",
    "shower_head",
    "shredder",
    "shrimp",
    "shrink",
    "shrub",
    "shuffle",
    "sigma",
    "signal_high",
    "signal_low",
    "signal_medium",
    "signal_zero",
    "signal",
    "signature",
    "signpost_big",
    "signpost",
    "siren",
    "skip_back",
    "skip_forward",
    "skull",
    "slack",
    "slash",
    "slice",
    "sliders_horizontal",
    "sliders_vertical",
    "smartphone_charging",
    "smartphone_nfc",
    "smartphone",
    "smile_plus",
    "smile",
    "snail",
    "snowflake",
    "soap_dispenser_droplet",
    "sofa",
    "soup",
    "space",
    "spade",
    "sparkle",
    "sparkles",
    "speaker",
    "speech",
    "spell_check_2",
    "spell_check",
    "spline_pointer",
    "spline",
    "split",
    "spool",
    "spotlight",
    "spray_can",
    "sprout",
    "square_activity",
    "square_arrow_down_left",
    "square_arrow_down_right",
    "square_arrow_down",
    "square_arrow_left",
    "square_arrow_out_down_left",
    "square_arrow_out_down_right",
    "square_arrow_out_up_left",
    "square_arrow_out_up_right",
    "square_arrow_right",
    "square_arrow_up_left",
    "square_arrow_up_right",
    "square_arrow_up",
    "square_asterisk",
    "square_bottom_dashed_scissors",
    "square_chart_gantt",
    "square_check_big",
    "square_check",
    "square_chevron_down",
    "square_chevron_left",
    "square_chevron_right",
    "square_chevron_up",
    "square_code",
    "square_dashed_bottom_code",
    "square_dashed_bottom",
    "square_dashed_kanban",
    "square_dashed_mouse_pointer",
    "square_dashed_top_solid",
    "square_dashed",
    "square_divide",
    "square_dot",
    "square_equal",
    "square_function",
    "square_gantt_chart",
    "square_kanban",
    "square_library",
    "square_m",
    "square_menu",
    "square_minus",
    "square_mouse_pointer",
    "square_parking_off",
    "square_parking",
    "square_pen",
    "square_percent",
    "square_pi",
    "square_pilcrow",
    "square_play",
    "square_plus",
    "square_power",
    "square_radical",
    "square_round_corner",
    "square_scissors",
    "square_sigma",
    "square_slash",
    "square_split_horizontal",
    "square_split_vertical",
    "square_square",
    "square_stack",
    "square_terminal",
    "square_user_round",
    "square_user",
    "square_x",
    "square",
    "squares_exclude",
    "squares_intersect",
    "squares_subtract",
    "squares_unite",
    "squircle_dashed",
    "squircle",
    "squirrel",
    "stamp",
    "star_half",
    "star_off",
    "star",
    "step_back",
    "step_forward",
    "stethoscope",
    "sticker",
    "sticky_note",
    "store",
    "stretch_horizontal",
    "stretch_vertical",
    "strikethrough",
    "subscript",
    "sun_dim",
    "sun_medium",
    "sun_moon",
    "sun_snow",
    "sun",
    "sunrise",
    "sunset",
    "superscript",
    "swatch_book",
    "swiss_franc",
    "switch_camera",
    "sword",
    "swords",
    "syringe",
    "table_2",
    "table_cells_merge",
    "table_cells_split",
    "table_columns_split",
    "table_of_contents",
    "table_properties",
    "table_rows_split",
    "table",
    "tablet_smartphone",
    "tablet",
    "tablets",
    "tag",
    "tags",
    "tally_1",
    "tally_2",
    "tally_3",
    "tally_4",
    "tally_5",
    "tangent",
    "target",
    "telescope",
    "tent_tree",
    "tent",
    "terminal",
    "test_tube_diagonal",
    "test_tube",
    "test_tubes",
    "text_cursor_input",
    "text_cursor",
    "text_quote",
    "text_search",
    "text_select",
    "text",
    "theater",
    "thermometer_snowflake",
    "thermometer_sun",
    "thermometer",
    "thumbs_down",
    "thumbs_up",
    "ticket_check",
    "ticket_minus",
    "ticket_percent",
    "ticket_plus",
    "ticket_slash",
    "ticket_x",
    "ticket",
    "tickets_plane",
    "tickets",
    "timer_off",
    "timer_reset",
    "timer",
    "toggle_left",
    "toggle_right",
    "toilet",
    "tool_case",
    "tornado",
    "torus",
    "touchpad_off",
    "touchpad",
    "tower_control",
    "toy_brick",
    "tractor",
    "traffic_cone",
    "train_front_tunnel",
    "train_front",
    "train_track",
    "tram_front",
    "transgender",
    "trash_2",
    "trash",
    "tree_deciduous",
    "tree_palm",
    "tree_pine",
    "trees",
    "trello",
    "trending_down",
    "trending_up_down",
    "trending_up",
    "triangle_alert",
    "triangle_dashed",
    "triangle_right",
    "triangle",
    "trophy",
    "truck_electric",
    "truck",
    "turkish_lira",
    "turntable",
    "turtle",
    "tv_2",
    "tv_minimal_play",
    "tv_minimal",
    "tv",
    "twitch",
    "twitter",
    "type_outline",
    "type",
    "umbrella_off",
    "umbrella",
    "underline",
    "undo_2",
    "undo_dot",
    "undo",
    "unfold_horizontal",
    "unfold_vertical",
    "ungroup",
    "university",
    "unlink_2",
    "unlink",
    "unplug",
    "upload",
    "usb",
    "user_check",
    "user_cog",
    "user_lock",
    "user_minus",
    "user_pen",
    "user_plus",
    "user_round_check",
    "user_round_cog",
    "user_round_minus",
    "user_round_pen",
    "user_round_plus",
    "user_round_search",
    "user_round_x",
    "user_round",
    "user_search",
    "user_star",
    "user_x",
    "user",
    "users_round",
    "users",
    "utensils_crossed",
    "utensils",
    "utility_pole",
    "variable",
    "vault",
    "vector_square",
    "vegan",
    "venetian_mask",
    "venus_and_mars",
    "venus",
    "vibrate_off",
    "vibrate",
    "video_off",
    "video",
    "videotape",
    "view",
    "voicemail",
    "volleyball",
    "volume_1",
    "volume_2",
    "volume_off",
    "volume_x",
    "volume",
    "vote",
    "wallet_cards",
    "wallet_minimal",
    "wallet",
    "wallpaper",
    "wand_sparkles",
    "wand",
    "warehouse",
    "washing_machine",
    "watch",
    "waves_ladder",
    "waves",
    "waypoints",
    "webcam",
    "webhook_off",
    "webhook",
    "weight",
    "wheat_off",
    "wheat",
    "whole_word",
    "wifi_cog",
    "wifi_high",
    "wifi_low",
    "wifi_off",
    "wifi_pen",
    "wifi_sync",
    "wifi_zero",
    "wifi",
    "wind_arrow_down",
    "wind",
    "wine_off",
    "wine",
    "workflow",
    "worm",
    "wrap_text",
    "wrench",
    "x",
    "youtube",
    "zap_off",
    "zap",
    "zoom_in",
    "zoom_out",
]
LUCIDE_ICON_MAPPING_OVERRIDE = {"grid_3x2": "Grid3x2Icon"}
