"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jenkins = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const jenkins = require("./imports/jenkins.io");
/**
 * A jenkins instance.
 */
class Jenkins extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this._plugins = props.plugins ?? [];
        this._seedJobs = props.seedJobs ?? [];
        this._basePlugins = new Map([
            ['kubernetes', '1.31.3'],
            ['workflow-job', '1145.v7f2433caa07f'],
            ['workflow-aggregator', '2.6'],
            ['git', '4.10.3'],
            ['job-dsl', '1.78.1'],
            ['configuration-as-code', '1414.v878271fc496f'],
            ['kubernetes-credentials-provider', '0.20'],
        ]);
        this.addBasePlugins(...(props.basePlugins ?? []));
        const metadata = {
            ...props.metadata,
            namespace: props.metadata?.namespace ?? 'default',
            labels: props.metadata?.labels ?? { app: 'jenkins' },
        };
        const authorizationStrategy = 'createUser';
        const disableCSRFProtection = props.disableCsrfProtection ?? false;
        // Keeping container resources defaults similar to Jenkins defaults here: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/installing-the-operator/
        const containers = [
            {
                name: 'jenkins-master',
                image: 'jenkins/jenkins:lts',
                imagePullPolicy: 'Always',
                resources: {
                    limits: {
                        cpu: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('1500m'),
                        memory: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('3Gi'),
                    },
                    requests: {
                        cpu: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('1'),
                        memory: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('500M'),
                    },
                },
            },
        ];
        ;
        const jenkinsCustomResource = new jenkins.Jenkins(this, 'Default', {
            metadata: metadata,
            spec: {
                groovyScripts: {
                    configurations: [],
                    secret: {
                        name: '',
                    },
                },
                configurationAsCode: {
                    configurations: [],
                    secret: {
                        name: '',
                    },
                },
                jenkinsApiSettings: {
                    authorizationStrategy: authorizationStrategy,
                },
                master: {
                    disableCsrfProtection: disableCSRFProtection,
                    containers: containers,
                    basePlugins: cdk8s.Lazy.any({
                        produce: () => {
                            return Array.from(this._basePlugins, ([key, value]) => {
                                return {
                                    name: key,
                                    version: value,
                                };
                            });
                        },
                    }),
                    plugins: cdk8s.Lazy.any({
                        produce: () => {
                            return this._plugins;
                        },
                    }),
                },
                seedJobs: cdk8s.Lazy.any({
                    produce: () => {
                        return this._seedJobs;
                    },
                }),
            },
        });
        this.node.defaultChild = jenkinsCustomResource;
    }
    /**
     * Add base plugins to jenkins instance.
     * @param basePlugins List of base plugins.
     */
    addBasePlugins(...basePlugins) {
        for (const basePlugin of basePlugins) {
            this._basePlugins.set(basePlugin.name, basePlugin.version);
        }
    }
    /**
     * Add custom plugins to jenkins instance.
     * @param plugins List of custom plugins.
     */
    addPlugins(...plugins) {
        this._plugins.push(...plugins);
    }
    /**
     * Add seed jobs to jenkins instance.
     * @param seedJobs List of seed jobs.
     */
    addSeedJobs(...seedJobs) {
        this._seedJobs.push(...seedJobs);
    }
}
exports.Jenkins = Jenkins;
_a = JSII_RTTI_SYMBOL_1;
Jenkins[_a] = { fqn: "cdk8s-jenkins.Jenkins", version: "0.0.516" };
//# sourceMappingURL=data:application/json;base64,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