# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertConditionArgs', 'AlertCondition']

@pulumi.input_type
class AlertConditionArgs:
    def __init__(__self__, *,
                 entities: pulumi.Input[Sequence[pulumi.Input[str]]],
                 metric: pulumi.Input[str],
                 policy_id: pulumi.Input[str],
                 terms: pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]],
                 type: pulumi.Input[str],
                 condition_scope: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 gc_metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 runbook_url: Optional[pulumi.Input[str]] = None,
                 user_defined_metric: Optional[pulumi.Input[str]] = None,
                 user_defined_value_function: Optional[pulumi.Input[str]] = None,
                 violation_close_timer: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AlertCondition resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: The instance IDs associated with this condition.
        :param pulumi.Input[str] metric: The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        :param pulumi.Input[str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]] terms: A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[str] type: The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        :param pulumi.Input[str] condition_scope: `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        :param pulumi.Input[bool] enabled: Whether the condition is enabled or not. Defaults to true.
        :param pulumi.Input[str] gc_metric: A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        :param pulumi.Input[str] name: The title of the condition. Must be between 1 and 64 characters, inclusive.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[str] user_defined_metric: A custom metric to be evaluated.
        :param pulumi.Input[str] user_defined_value_function: One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.
               
               > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[int] violation_close_timer: Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
               * when `type` = `apm_app_metric` and `condition_scope` = `instance`
               * when `type` = `apm_jvm_metric`
        """
        pulumi.set(__self__, "entities", entities)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "terms", terms)
        pulumi.set(__self__, "type", type)
        if condition_scope is not None:
            pulumi.set(__self__, "condition_scope", condition_scope)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if gc_metric is not None:
            pulumi.set(__self__, "gc_metric", gc_metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if user_defined_metric is not None:
            pulumi.set(__self__, "user_defined_metric", user_defined_metric)
        if user_defined_value_function is not None:
            pulumi.set(__self__, "user_defined_value_function", user_defined_value_function)
        if violation_close_timer is not None:
            pulumi.set(__self__, "violation_close_timer", violation_close_timer)

    @property
    @pulumi.getter
    def entities(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The instance IDs associated with this condition.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "entities", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[str]:
        """
        The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def terms(self) -> pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]]:
        """
        A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]]):
        pulumi.set(self, "terms", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="conditionScope")
    def condition_scope(self) -> Optional[pulumi.Input[str]]:
        """
        `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        """
        return pulumi.get(self, "condition_scope")

    @condition_scope.setter
    def condition_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_scope", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the condition is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="gcMetric")
    def gc_metric(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        """
        return pulumi.get(self, "gc_metric")

    @gc_metric.setter
    def gc_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gc_metric", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the condition. Must be between 1 and 64 characters, inclusive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runbook_url", value)

    @property
    @pulumi.getter(name="userDefinedMetric")
    def user_defined_metric(self) -> Optional[pulumi.Input[str]]:
        """
        A custom metric to be evaluated.
        """
        return pulumi.get(self, "user_defined_metric")

    @user_defined_metric.setter
    def user_defined_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_defined_metric", value)

    @property
    @pulumi.getter(name="userDefinedValueFunction")
    def user_defined_value_function(self) -> Optional[pulumi.Input[str]]:
        """
        One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.

        > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "user_defined_value_function")

    @user_defined_value_function.setter
    def user_defined_value_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_defined_value_function", value)

    @property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> Optional[pulumi.Input[int]]:
        """
        Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
        * when `type` = `apm_app_metric` and `condition_scope` = `instance`
        * when `type` = `apm_jvm_metric`
        """
        return pulumi.get(self, "violation_close_timer")

    @violation_close_timer.setter
    def violation_close_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "violation_close_timer", value)


@pulumi.input_type
class _AlertConditionState:
    def __init__(__self__, *,
                 condition_scope: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 entity_guid: Optional[pulumi.Input[str]] = None,
                 gc_metric: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 runbook_url: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_defined_metric: Optional[pulumi.Input[str]] = None,
                 user_defined_value_function: Optional[pulumi.Input[str]] = None,
                 violation_close_timer: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AlertCondition resources.
        :param pulumi.Input[str] condition_scope: `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        :param pulumi.Input[bool] enabled: Whether the condition is enabled or not. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: The instance IDs associated with this condition.
        :param pulumi.Input[str] entity_guid: The unique entity identifier of the condition in New Relic.
        :param pulumi.Input[str] gc_metric: A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        :param pulumi.Input[str] metric: The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        :param pulumi.Input[str] name: The title of the condition. Must be between 1 and 64 characters, inclusive.
        :param pulumi.Input[str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]] terms: A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[str] type: The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        :param pulumi.Input[str] user_defined_metric: A custom metric to be evaluated.
        :param pulumi.Input[str] user_defined_value_function: One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.
               
               > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[int] violation_close_timer: Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
               * when `type` = `apm_app_metric` and `condition_scope` = `instance`
               * when `type` = `apm_jvm_metric`
        """
        if condition_scope is not None:
            pulumi.set(__self__, "condition_scope", condition_scope)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entities is not None:
            pulumi.set(__self__, "entities", entities)
        if entity_guid is not None:
            pulumi.set(__self__, "entity_guid", entity_guid)
        if gc_metric is not None:
            pulumi.set(__self__, "gc_metric", gc_metric)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_defined_metric is not None:
            pulumi.set(__self__, "user_defined_metric", user_defined_metric)
        if user_defined_value_function is not None:
            pulumi.set(__self__, "user_defined_value_function", user_defined_value_function)
        if violation_close_timer is not None:
            pulumi.set(__self__, "violation_close_timer", violation_close_timer)

    @property
    @pulumi.getter(name="conditionScope")
    def condition_scope(self) -> Optional[pulumi.Input[str]]:
        """
        `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        """
        return pulumi.get(self, "condition_scope")

    @condition_scope.setter
    def condition_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition_scope", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the condition is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instance IDs associated with this condition.
        """
        return pulumi.get(self, "entities")

    @entities.setter
    def entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entities", value)

    @property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> Optional[pulumi.Input[str]]:
        """
        The unique entity identifier of the condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @entity_guid.setter
    def entity_guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_guid", value)

    @property
    @pulumi.getter(name="gcMetric")
    def gc_metric(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        """
        return pulumi.get(self, "gc_metric")

    @gc_metric.setter
    def gc_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gc_metric", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the condition. Must be between 1 and 64 characters, inclusive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runbook_url", value)

    @property
    @pulumi.getter
    def terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]]]:
        """
        A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertConditionTermArgs']]]]):
        pulumi.set(self, "terms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userDefinedMetric")
    def user_defined_metric(self) -> Optional[pulumi.Input[str]]:
        """
        A custom metric to be evaluated.
        """
        return pulumi.get(self, "user_defined_metric")

    @user_defined_metric.setter
    def user_defined_metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_defined_metric", value)

    @property
    @pulumi.getter(name="userDefinedValueFunction")
    def user_defined_value_function(self) -> Optional[pulumi.Input[str]]:
        """
        One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.

        > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "user_defined_value_function")

    @user_defined_value_function.setter
    def user_defined_value_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_defined_value_function", value)

    @property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> Optional[pulumi.Input[int]]:
        """
        Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
        * when `type` = `apm_app_metric` and `condition_scope` = `instance`
        * when `type` = `apm_jvm_metric`
        """
        return pulumi.get(self, "violation_close_timer")

    @violation_close_timer.setter
    def violation_close_timer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "violation_close_timer", value)


class AlertCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_scope: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gc_metric: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 runbook_url: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertConditionTermArgs', 'AlertConditionTermArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_defined_metric: Optional[pulumi.Input[str]] = None,
                 user_defined_value_function: Optional[pulumi.Input[str]] = None,
                 violation_close_timer: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Use this resource to create and manage alert conditions for APM, Browser, and Mobile in New Relic.

        > **WARNING:** The `AlertCondition` resource is deprecated and will be removed in the next major release. The resource NrqlAlertCondition would be a preferred alternative to configure alert conditions - in most cases, feature parity can be achieved with a NRQL query.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        app = newrelic.get_entity(name="my-app",
            type="APPLICATION",
            domain="APM")
        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_alert_condition = newrelic.AlertCondition("foo",
            policy_id=foo.id,
            name="foo",
            type="apm_app_metric",
            entities=[app.application_id],
            metric="apdex",
            runbook_url="https://www.example.com",
            condition_scope="application",
            terms=[{
                "duration": 5,
                "operator": "below",
                "priority": "critical",
                "threshold": 0.75,
                "time_function": "all",
            }])
        ```

        ## Terms

        The `term` mapping supports the following arguments:

          * `duration` - (Required) In minutes, must be in the range of `5` to `120`, inclusive.
          * `operator` - (Optional) `above`, `below`, or `equal`.  Defaults to `equal`.
          * `priority` - (Optional) `critical` or `warning`.  Defaults to `critical`. Terms must include at least one `critical` priority term
          * `threshold` - (Required) Must be 0 or greater.
          * `time_function` - (Required) `all` or `any`.

        ## Tags

        Manage alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check EntityTags

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.get_entity(name="foo entitiy")
        foo_alert_policy = newrelic.AlertPolicy("foo", name="foo policy")
        foo_alert_condition = newrelic.AlertCondition("foo",
            policy_id=foo_alert_policy.id,
            name="foo condition",
            type="apm_app_metric",
            entities=[foo.application_id],
            metric="apdex",
            runbook_url="https://www.example.com",
            condition_scope="application",
            terms=[{
                "duration": 5,
                "operator": "below",
                "priority": "critical",
                "threshold": 0.75,
                "time_function": "all",
            }])
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        ## Import

        Alert conditions can be imported using notation `alert_policy_id:alert_condition_id`, e.g.

        ```sh
        $ pulumi import newrelic:index/alertCondition:AlertCondition main 123456:6789012345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] condition_scope: `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        :param pulumi.Input[bool] enabled: Whether the condition is enabled or not. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: The instance IDs associated with this condition.
        :param pulumi.Input[str] gc_metric: A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        :param pulumi.Input[str] metric: The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        :param pulumi.Input[str] name: The title of the condition. Must be between 1 and 64 characters, inclusive.
        :param pulumi.Input[str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertConditionTermArgs', 'AlertConditionTermArgsDict']]]] terms: A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[str] type: The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        :param pulumi.Input[str] user_defined_metric: A custom metric to be evaluated.
        :param pulumi.Input[str] user_defined_value_function: One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.
               
               > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[int] violation_close_timer: Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
               * when `type` = `apm_app_metric` and `condition_scope` = `instance`
               * when `type` = `apm_jvm_metric`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create and manage alert conditions for APM, Browser, and Mobile in New Relic.

        > **WARNING:** The `AlertCondition` resource is deprecated and will be removed in the next major release. The resource NrqlAlertCondition would be a preferred alternative to configure alert conditions - in most cases, feature parity can be achieved with a NRQL query.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        app = newrelic.get_entity(name="my-app",
            type="APPLICATION",
            domain="APM")
        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_alert_condition = newrelic.AlertCondition("foo",
            policy_id=foo.id,
            name="foo",
            type="apm_app_metric",
            entities=[app.application_id],
            metric="apdex",
            runbook_url="https://www.example.com",
            condition_scope="application",
            terms=[{
                "duration": 5,
                "operator": "below",
                "priority": "critical",
                "threshold": 0.75,
                "time_function": "all",
            }])
        ```

        ## Terms

        The `term` mapping supports the following arguments:

          * `duration` - (Required) In minutes, must be in the range of `5` to `120`, inclusive.
          * `operator` - (Optional) `above`, `below`, or `equal`.  Defaults to `equal`.
          * `priority` - (Optional) `critical` or `warning`.  Defaults to `critical`. Terms must include at least one `critical` priority term
          * `threshold` - (Required) Must be 0 or greater.
          * `time_function` - (Required) `all` or `any`.

        ## Tags

        Manage alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check EntityTags

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.get_entity(name="foo entitiy")
        foo_alert_policy = newrelic.AlertPolicy("foo", name="foo policy")
        foo_alert_condition = newrelic.AlertCondition("foo",
            policy_id=foo_alert_policy.id,
            name="foo condition",
            type="apm_app_metric",
            entities=[foo.application_id],
            metric="apdex",
            runbook_url="https://www.example.com",
            condition_scope="application",
            terms=[{
                "duration": 5,
                "operator": "below",
                "priority": "critical",
                "threshold": 0.75,
                "time_function": "all",
            }])
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        ## Import

        Alert conditions can be imported using notation `alert_policy_id:alert_condition_id`, e.g.

        ```sh
        $ pulumi import newrelic:index/alertCondition:AlertCondition main 123456:6789012345
        ```

        :param str resource_name: The name of the resource.
        :param AlertConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition_scope: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gc_metric: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 runbook_url: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertConditionTermArgs', 'AlertConditionTermArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_defined_metric: Optional[pulumi.Input[str]] = None,
                 user_defined_value_function: Optional[pulumi.Input[str]] = None,
                 violation_close_timer: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertConditionArgs.__new__(AlertConditionArgs)

            __props__.__dict__["condition_scope"] = condition_scope
            __props__.__dict__["enabled"] = enabled
            if entities is None and not opts.urn:
                raise TypeError("Missing required property 'entities'")
            __props__.__dict__["entities"] = entities
            __props__.__dict__["gc_metric"] = gc_metric
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["name"] = name
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["runbook_url"] = runbook_url
            if terms is None and not opts.urn:
                raise TypeError("Missing required property 'terms'")
            __props__.__dict__["terms"] = terms
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_defined_metric"] = user_defined_metric
            __props__.__dict__["user_defined_value_function"] = user_defined_value_function
            __props__.__dict__["violation_close_timer"] = violation_close_timer
            __props__.__dict__["entity_guid"] = None
        super(AlertCondition, __self__).__init__(
            'newrelic:index/alertCondition:AlertCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition_scope: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            entity_guid: Optional[pulumi.Input[str]] = None,
            gc_metric: Optional[pulumi.Input[str]] = None,
            metric: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            runbook_url: Optional[pulumi.Input[str]] = None,
            terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertConditionTermArgs', 'AlertConditionTermArgsDict']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_defined_metric: Optional[pulumi.Input[str]] = None,
            user_defined_value_function: Optional[pulumi.Input[str]] = None,
            violation_close_timer: Optional[pulumi.Input[int]] = None) -> 'AlertCondition':
        """
        Get an existing AlertCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] condition_scope: `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        :param pulumi.Input[bool] enabled: Whether the condition is enabled or not. Defaults to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entities: The instance IDs associated with this condition.
        :param pulumi.Input[str] entity_guid: The unique entity identifier of the condition in New Relic.
        :param pulumi.Input[str] gc_metric: A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        :param pulumi.Input[str] metric: The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        :param pulumi.Input[str] name: The title of the condition. Must be between 1 and 64 characters, inclusive.
        :param pulumi.Input[str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertConditionTermArgs', 'AlertConditionTermArgsDict']]]] terms: A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[str] type: The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        :param pulumi.Input[str] user_defined_metric: A custom metric to be evaluated.
        :param pulumi.Input[str] user_defined_value_function: One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.
               
               > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.
               
               ```
               Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
               ```
        :param pulumi.Input[int] violation_close_timer: Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
               * when `type` = `apm_app_metric` and `condition_scope` = `instance`
               * when `type` = `apm_jvm_metric`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertConditionState.__new__(_AlertConditionState)

        __props__.__dict__["condition_scope"] = condition_scope
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entities"] = entities
        __props__.__dict__["entity_guid"] = entity_guid
        __props__.__dict__["gc_metric"] = gc_metric
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["runbook_url"] = runbook_url
        __props__.__dict__["terms"] = terms
        __props__.__dict__["type"] = type
        __props__.__dict__["user_defined_metric"] = user_defined_metric
        __props__.__dict__["user_defined_value_function"] = user_defined_value_function
        __props__.__dict__["violation_close_timer"] = violation_close_timer
        return AlertCondition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conditionScope")
    def condition_scope(self) -> pulumi.Output[Optional[str]]:
        """
        `application` or `instance`.  Choose `application` for most scenarios.  If you are using the JVM plugin in New Relic, the `instance` setting allows your condition to trigger [for specific app instances](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/scope-alert-thresholds-specific-instances).
        """
        return pulumi.get(self, "condition_scope")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the condition is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def entities(self) -> pulumi.Output[Sequence[str]]:
        """
        The instance IDs associated with this condition.
        """
        return pulumi.get(self, "entities")

    @property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> pulumi.Output[str]:
        """
        The unique entity identifier of the condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @property
    @pulumi.getter(name="gcMetric")
    def gc_metric(self) -> pulumi.Output[Optional[str]]:
        """
        A valid Garbage Collection metric e.g. `GC/G1 Young Generation`.
        """
        return pulumi.get(self, "gc_metric")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output[str]:
        """
        The metric field accepts parameters based on the `type` set. One of these metrics based on `type`:
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The title of the condition. Must be between 1 and 64 characters, inclusive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> pulumi.Output[Optional[str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @property
    @pulumi.getter
    def terms(self) -> pulumi.Output[Sequence['outputs.AlertConditionTerm']]:
        """
        A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of condition. One of: `apm_app_metric`, `apm_jvm_metric`, `apm_kt_metric`, `browser_metric`, `mobile_metric`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userDefinedMetric")
    def user_defined_metric(self) -> pulumi.Output[Optional[str]]:
        """
        A custom metric to be evaluated.
        """
        return pulumi.get(self, "user_defined_metric")

    @property
    @pulumi.getter(name="userDefinedValueFunction")
    def user_defined_value_function(self) -> pulumi.Output[Optional[str]]:
        """
        One of: `average`, `min`, `max`, `total`, `sample_size`, `rate` or `percent`.

        > **NOTE:** The `user_defined_value_function` can have `rate` or `percent` only when the `type` is `mobile_metric`.

        ```
        Warning: This resource will use the account ID linked to your API key. At the moment it is not possible to dynamically set the account ID.
        ```
        """
        return pulumi.get(self, "user_defined_value_function")

    @property
    @pulumi.getter(name="violationCloseTimer")
    def violation_close_timer(self) -> pulumi.Output[Optional[int]]:
        """
        Automatically close instance-based incidents, including JVM health metric incidents, after the number of hours specified. Must be between 1 and 720 hours. Must be specified in the following two cases, to prevent drift:
        * when `type` = `apm_app_metric` and `condition_scope` = `instance`
        * when `type` = `apm_jvm_metric`
        """
        return pulumi.get(self, "violation_close_timer")

