# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAuthenticationDomainResult',
    'AwaitableGetAuthenticationDomainResult',
    'get_authentication_domain',
    'get_authentication_domain_output',
]

@pulumi.output_type
class GetAuthenticationDomainResult:
    """
    A collection of values returned by getAuthenticationDomain.
    """
    def __init__(__self__, id=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the matching authentication domain fetched.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetAuthenticationDomainResult(GetAuthenticationDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticationDomainResult(
            id=self.id,
            name=self.name)


def get_authentication_domain(name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticationDomainResult:
    """
    Use this data source to fetch the ID of an authentication domain belonging to your account, matching the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.get_authentication_domain(name="Test Authentication Domain")
    pulumi.export("foo", foo.id)
    ```


    :param str name: The name of the authentication domain to be searched for. An error is thrown, if no authentication domain is found with the specified name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:index/getAuthenticationDomain:getAuthenticationDomain', __args__, opts=opts, typ=GetAuthenticationDomainResult).value

    return AwaitableGetAuthenticationDomainResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_authentication_domain)
def get_authentication_domain_output(name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthenticationDomainResult]:
    """
    Use this data source to fetch the ID of an authentication domain belonging to your account, matching the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.get_authentication_domain(name="Test Authentication Domain")
    pulumi.export("foo", foo.id)
    ```


    :param str name: The name of the authentication domain to be searched for. An error is thrown, if no authentication domain is found with the specified name.
    """
    ...
