# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetKeyTransactionResult',
    'AwaitableGetKeyTransactionResult',
    'get_key_transaction',
    'get_key_transaction_output',
]

@pulumi.output_type
class GetKeyTransactionResult:
    """
    A collection of values returned by getKeyTransaction.
    """
    def __init__(__self__, id=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetKeyTransactionResult(GetKeyTransactionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyTransactionResult(
            id=self.id,
            name=self.name)


def get_key_transaction(name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyTransactionResult:
    """
    Use this data source to get information about a specific key transaction in New Relic that already exists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    txn = newrelic.get_key_transaction(name="txn")
    foo = newrelic.AlertPolicy("foo", name="foo")
    foo_alert_condition = newrelic.AlertCondition("foo",
        policy_id=foo.id,
        name="foo",
        type="apm_kt_metric",
        entities=[txn.id],
        metric="error_percentage",
        runbook_url="https://www.example.com",
        terms=[{
            "duration": 5,
            "operator": "below",
            "priority": "critical",
            "threshold": 0.75,
            "time_function": "all",
        }])
    ```


    :param str name: The name of the key transaction in New Relic.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:index/getKeyTransaction:getKeyTransaction', __args__, opts=opts, typ=GetKeyTransactionResult).value

    return AwaitableGetKeyTransactionResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_key_transaction)
def get_key_transaction_output(name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyTransactionResult]:
    """
    Use this data source to get information about a specific key transaction in New Relic that already exists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    txn = newrelic.get_key_transaction(name="txn")
    foo = newrelic.AlertPolicy("foo", name="foo")
    foo_alert_condition = newrelic.AlertCondition("foo",
        policy_id=foo.id,
        name="foo",
        type="apm_kt_metric",
        entities=[txn.id],
        metric="error_percentage",
        runbook_url="https://www.example.com",
        terms=[{
            "duration": 5,
            "operator": "below",
            "priority": "critical",
            "threshold": 0.75,
            "time_function": "all",
        }])
    ```


    :param str name: The name of the key transaction in New Relic.
    """
    ...
