# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkflowArgs', 'Workflow']

@pulumi.input_type
class WorkflowArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]],
                 issues_filter: pulumi.Input['WorkflowIssuesFilterArgs'],
                 muting_rules_handling: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 destinations_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enrichments: Optional[pulumi.Input['WorkflowEnrichmentsArgs']] = None,
                 enrichments_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Workflow resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]] destinations: Notification configuration. See Nested destination blocks below for details.
        :param pulumi.Input['WorkflowIssuesFilterArgs'] issues_filter: A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        :param pulumi.Input[str] muting_rules_handling: How to handle muted issues. See Muting Rules below for details.
        :param pulumi.Input[str] account_id: Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        :param pulumi.Input[bool] destinations_enabled: **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
               these two are different flags, but they are functionally identical. Defaults to true.
        :param pulumi.Input[bool] enabled: Whether workflow is enabled. Defaults to true.
        :param pulumi.Input['WorkflowEnrichmentsArgs'] enrichments: Workflow's enrichments. See Nested enrichments blocks below for details.
        :param pulumi.Input[bool] enrichments_enabled: Whether enrichments are enabled. Defaults to true.
        :param pulumi.Input[str] name: The name of the workflow.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "issues_filter", issues_filter)
        pulumi.set(__self__, "muting_rules_handling", muting_rules_handling)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if destinations_enabled is not None:
            warnings.warn("""Please use 'enabled' instead""", DeprecationWarning)
            pulumi.log.warn("""destinations_enabled is deprecated: Please use 'enabled' instead""")
        if destinations_enabled is not None:
            pulumi.set(__self__, "destinations_enabled", destinations_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if enrichments_enabled is not None:
            pulumi.set(__self__, "enrichments_enabled", enrichments_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]]:
        """
        Notification configuration. See Nested destination blocks below for details.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="issuesFilter")
    def issues_filter(self) -> pulumi.Input['WorkflowIssuesFilterArgs']:
        """
        A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        """
        return pulumi.get(self, "issues_filter")

    @issues_filter.setter
    def issues_filter(self, value: pulumi.Input['WorkflowIssuesFilterArgs']):
        pulumi.set(self, "issues_filter", value)

    @property
    @pulumi.getter(name="mutingRulesHandling")
    def muting_rules_handling(self) -> pulumi.Input[str]:
        """
        How to handle muted issues. See Muting Rules below for details.
        """
        return pulumi.get(self, "muting_rules_handling")

    @muting_rules_handling.setter
    def muting_rules_handling(self, value: pulumi.Input[str]):
        pulumi.set(self, "muting_rules_handling", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="destinationsEnabled")
    @_utilities.deprecated("""Please use 'enabled' instead""")
    def destinations_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
        these two are different flags, but they are functionally identical. Defaults to true.
        """
        return pulumi.get(self, "destinations_enabled")

    @destinations_enabled.setter
    def destinations_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "destinations_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether workflow is enabled. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enrichments(self) -> Optional[pulumi.Input['WorkflowEnrichmentsArgs']]:
        """
        Workflow's enrichments. See Nested enrichments blocks below for details.
        """
        return pulumi.get(self, "enrichments")

    @enrichments.setter
    def enrichments(self, value: Optional[pulumi.Input['WorkflowEnrichmentsArgs']]):
        pulumi.set(self, "enrichments", value)

    @property
    @pulumi.getter(name="enrichmentsEnabled")
    def enrichments_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enrichments are enabled. Defaults to true.
        """
        return pulumi.get(self, "enrichments_enabled")

    @enrichments_enabled.setter
    def enrichments_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enrichments_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _WorkflowState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]]] = None,
                 destinations_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enrichments: Optional[pulumi.Input['WorkflowEnrichmentsArgs']] = None,
                 enrichments_enabled: Optional[pulumi.Input[bool]] = None,
                 guid: Optional[pulumi.Input[str]] = None,
                 issues_filter: Optional[pulumi.Input['WorkflowIssuesFilterArgs']] = None,
                 last_run: Optional[pulumi.Input[str]] = None,
                 muting_rules_handling: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 workflow_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Workflow resources.
        :param pulumi.Input[str] account_id: Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]] destinations: Notification configuration. See Nested destination blocks below for details.
        :param pulumi.Input[bool] destinations_enabled: **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
               these two are different flags, but they are functionally identical. Defaults to true.
        :param pulumi.Input[bool] enabled: Whether workflow is enabled. Defaults to true.
        :param pulumi.Input['WorkflowEnrichmentsArgs'] enrichments: Workflow's enrichments. See Nested enrichments blocks below for details.
        :param pulumi.Input[bool] enrichments_enabled: Whether enrichments are enabled. Defaults to true.
        :param pulumi.Input[str] guid: Workflow entity GUID
        :param pulumi.Input['WorkflowIssuesFilterArgs'] issues_filter: A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        :param pulumi.Input[str] last_run: The last time notification was sent for this workflow.
        :param pulumi.Input[str] muting_rules_handling: How to handle muted issues. See Muting Rules below for details.
        :param pulumi.Input[str] name: The name of the workflow.
        :param pulumi.Input[str] workflow_id: The id of the workflow.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if destinations_enabled is not None:
            warnings.warn("""Please use 'enabled' instead""", DeprecationWarning)
            pulumi.log.warn("""destinations_enabled is deprecated: Please use 'enabled' instead""")
        if destinations_enabled is not None:
            pulumi.set(__self__, "destinations_enabled", destinations_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if enrichments_enabled is not None:
            pulumi.set(__self__, "enrichments_enabled", enrichments_enabled)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if issues_filter is not None:
            pulumi.set(__self__, "issues_filter", issues_filter)
        if last_run is not None:
            pulumi.set(__self__, "last_run", last_run)
        if muting_rules_handling is not None:
            pulumi.set(__self__, "muting_rules_handling", muting_rules_handling)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workflow_id is not None:
            pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]]]:
        """
        Notification configuration. See Nested destination blocks below for details.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="destinationsEnabled")
    @_utilities.deprecated("""Please use 'enabled' instead""")
    def destinations_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
        these two are different flags, but they are functionally identical. Defaults to true.
        """
        return pulumi.get(self, "destinations_enabled")

    @destinations_enabled.setter
    def destinations_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "destinations_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether workflow is enabled. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def enrichments(self) -> Optional[pulumi.Input['WorkflowEnrichmentsArgs']]:
        """
        Workflow's enrichments. See Nested enrichments blocks below for details.
        """
        return pulumi.get(self, "enrichments")

    @enrichments.setter
    def enrichments(self, value: Optional[pulumi.Input['WorkflowEnrichmentsArgs']]):
        pulumi.set(self, "enrichments", value)

    @property
    @pulumi.getter(name="enrichmentsEnabled")
    def enrichments_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enrichments are enabled. Defaults to true.
        """
        return pulumi.get(self, "enrichments_enabled")

    @enrichments_enabled.setter
    def enrichments_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enrichments_enabled", value)

    @property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[str]]:
        """
        Workflow entity GUID
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guid", value)

    @property
    @pulumi.getter(name="issuesFilter")
    def issues_filter(self) -> Optional[pulumi.Input['WorkflowIssuesFilterArgs']]:
        """
        A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        """
        return pulumi.get(self, "issues_filter")

    @issues_filter.setter
    def issues_filter(self, value: Optional[pulumi.Input['WorkflowIssuesFilterArgs']]):
        pulumi.set(self, "issues_filter", value)

    @property
    @pulumi.getter(name="lastRun")
    def last_run(self) -> Optional[pulumi.Input[str]]:
        """
        The last time notification was sent for this workflow.
        """
        return pulumi.get(self, "last_run")

    @last_run.setter
    def last_run(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_run", value)

    @property
    @pulumi.getter(name="mutingRulesHandling")
    def muting_rules_handling(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle muted issues. See Muting Rules below for details.
        """
        return pulumi.get(self, "muting_rules_handling")

    @muting_rules_handling.setter
    def muting_rules_handling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "muting_rules_handling", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workflow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the workflow.
        """
        return pulumi.get(self, "workflow_id")

    @workflow_id.setter
    def workflow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_id", value)


class Workflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowDestinationArgs', 'WorkflowDestinationArgsDict']]]]] = None,
                 destinations_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enrichments: Optional[pulumi.Input[Union['WorkflowEnrichmentsArgs', 'WorkflowEnrichmentsArgsDict']]] = None,
                 enrichments_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_filter: Optional[pulumi.Input[Union['WorkflowIssuesFilterArgs', 'WorkflowIssuesFilterArgsDict']]] = None,
                 muting_rules_handling: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to create and manage New Relic workflows.

        ## Example Usage

        ##### Workflow
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.Workflow("foo",
            name="workflow-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["growth"],
                }],
            },
            destinations=[{
                "channel_id": some_channel["id"],
            }])
        ```

        ## Policy-Based Workflow Example

        This scenario describes one of most common ways of using workflows by defining a set of policies the workflow handles

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        # Create a policy to track
        my_policy = newrelic.AlertPolicy("my-policy", name="my_policy")
        # Create a reusable notification destination
        webhook_destination = newrelic.NotificationDestination("webhook-destination",
            name="destination-webhook",
            type="WEBHOOK",
            properties=[{
                "key": "url",
                "value": "https://example.com",
            }],
            auth_basic={
                "user": "username",
                "password": "password",
            })
        # Create a notification channel to use in the workflow
        webhook_channel = newrelic.NotificationChannel("webhook-channel",
            name="channel-webhook",
            type="WEBHOOK",
            destination_id=webhook_destination.id,
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "{}",
                "label": "Payload Template",
            }])
        # A workflow that matches issues that include incidents triggered by the policy
        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "labels.policyIds",
                    "operator": "EXACTLY_MATCHES",
                    "values": [my_policy.id],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel.id,
            }])
        ```

        ### An example of a workflow with enrichments

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-enrichment-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["my_team"],
                }],
            },
            enrichments={
                "nrqls": [{
                    "name": "Log Count",
                    "configurations": [{
                        "query": "SELECT count(*) FROM Log WHERE message like '%error%' since 10 minutes ago",
                    }],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel["id"],
            }])
        ```

        ### An example of a workflow with notification triggers

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-enrichment-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["my_team"],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel["id"],
                "notification_triggers": ["ACTIVATED"],
            }])
        ```

        ## Additional Information

        More details about the workflows can be found [here](https://docs.newrelic.com/docs/alerts-applied-intelligence/applied-intelligence/incident-workflows/incident-workflows/).

        ### Moving from Legacy Alert Policy Channels to Workflows
        As described in the documentation of this resource, mapping alert channels (created using `NotificationDestination` and `NotificationChannel`) to policies can be performed using the `Workflow` resource, which is an alternative to the legacy resource `AlertPolicyChannel` (which consumes alert channels created using the legacy resource `AlertChannel`).

        Both of the legacy resources mentioned above, `AlertChannel` and `AlertPolicyChannel` are **deprecated** and will be **removed in a future major release**, as stated in the documentation of both of these resources.

        If you're currently using `AlertChannel` and `AlertPolicyChannel` to manage alert channels linked to policies, we **strongly recommend** migrating to these workflows and notifications-based resources at the earliest.

        Please refer to the examples in this page, or this example for illustrations on setting up channels and workflows with these resources.

        ## v3.3 changes

        In version v3.3 we renamed the following arguments:

        - `workflow_enabled` changed to `enabled`.
        - `destination_configuration` changed to `destination`.
        - `predicates` changed to `predicate`.
        - Enrichment's `configurations` changed to `configuration`.

        ## Import

        Workflows can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:index/workflow:Workflow foo <id>
        ```

        You can find the workflow ID from the workflow table by clicking on ... at the end of the row and choosing `Copy workflow id to clipboard`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowDestinationArgs', 'WorkflowDestinationArgsDict']]]] destinations: Notification configuration. See Nested destination blocks below for details.
        :param pulumi.Input[bool] destinations_enabled: **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
               these two are different flags, but they are functionally identical. Defaults to true.
        :param pulumi.Input[bool] enabled: Whether workflow is enabled. Defaults to true.
        :param pulumi.Input[Union['WorkflowEnrichmentsArgs', 'WorkflowEnrichmentsArgsDict']] enrichments: Workflow's enrichments. See Nested enrichments blocks below for details.
        :param pulumi.Input[bool] enrichments_enabled: Whether enrichments are enabled. Defaults to true.
        :param pulumi.Input[Union['WorkflowIssuesFilterArgs', 'WorkflowIssuesFilterArgsDict']] issues_filter: A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        :param pulumi.Input[str] muting_rules_handling: How to handle muted issues. See Muting Rules below for details.
        :param pulumi.Input[str] name: The name of the workflow.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create and manage New Relic workflows.

        ## Example Usage

        ##### Workflow
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.Workflow("foo",
            name="workflow-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["growth"],
                }],
            },
            destinations=[{
                "channel_id": some_channel["id"],
            }])
        ```

        ## Policy-Based Workflow Example

        This scenario describes one of most common ways of using workflows by defining a set of policies the workflow handles

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        # Create a policy to track
        my_policy = newrelic.AlertPolicy("my-policy", name="my_policy")
        # Create a reusable notification destination
        webhook_destination = newrelic.NotificationDestination("webhook-destination",
            name="destination-webhook",
            type="WEBHOOK",
            properties=[{
                "key": "url",
                "value": "https://example.com",
            }],
            auth_basic={
                "user": "username",
                "password": "password",
            })
        # Create a notification channel to use in the workflow
        webhook_channel = newrelic.NotificationChannel("webhook-channel",
            name="channel-webhook",
            type="WEBHOOK",
            destination_id=webhook_destination.id,
            product="IINT",
            properties=[{
                "key": "payload",
                "value": "{}",
                "label": "Payload Template",
            }])
        # A workflow that matches issues that include incidents triggered by the policy
        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "labels.policyIds",
                    "operator": "EXACTLY_MATCHES",
                    "values": [my_policy.id],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel.id,
            }])
        ```

        ### An example of a workflow with enrichments

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-enrichment-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["my_team"],
                }],
            },
            enrichments={
                "nrqls": [{
                    "name": "Log Count",
                    "configurations": [{
                        "query": "SELECT count(*) FROM Log WHERE message like '%error%' since 10 minutes ago",
                    }],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel["id"],
            }])
        ```

        ### An example of a workflow with notification triggers

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        workflow_example = newrelic.Workflow("workflow-example",
            name="workflow-enrichment-example",
            muting_rules_handling="NOTIFY_ALL_ISSUES",
            issues_filter={
                "name": "Filter-name",
                "type": "FILTER",
                "predicates": [{
                    "attribute": "accumulations.tag.team",
                    "operator": "EXACTLY_MATCHES",
                    "values": ["my_team"],
                }],
            },
            destinations=[{
                "channel_id": webhook_channel["id"],
                "notification_triggers": ["ACTIVATED"],
            }])
        ```

        ## Additional Information

        More details about the workflows can be found [here](https://docs.newrelic.com/docs/alerts-applied-intelligence/applied-intelligence/incident-workflows/incident-workflows/).

        ### Moving from Legacy Alert Policy Channels to Workflows
        As described in the documentation of this resource, mapping alert channels (created using `NotificationDestination` and `NotificationChannel`) to policies can be performed using the `Workflow` resource, which is an alternative to the legacy resource `AlertPolicyChannel` (which consumes alert channels created using the legacy resource `AlertChannel`).

        Both of the legacy resources mentioned above, `AlertChannel` and `AlertPolicyChannel` are **deprecated** and will be **removed in a future major release**, as stated in the documentation of both of these resources.

        If you're currently using `AlertChannel` and `AlertPolicyChannel` to manage alert channels linked to policies, we **strongly recommend** migrating to these workflows and notifications-based resources at the earliest.

        Please refer to the examples in this page, or this example for illustrations on setting up channels and workflows with these resources.

        ## v3.3 changes

        In version v3.3 we renamed the following arguments:

        - `workflow_enabled` changed to `enabled`.
        - `destination_configuration` changed to `destination`.
        - `predicates` changed to `predicate`.
        - Enrichment's `configurations` changed to `configuration`.

        ## Import

        Workflows can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:index/workflow:Workflow foo <id>
        ```

        You can find the workflow ID from the workflow table by clicking on ... at the end of the row and choosing `Copy workflow id to clipboard`.

        :param str resource_name: The name of the resource.
        :param WorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowDestinationArgs', 'WorkflowDestinationArgsDict']]]]] = None,
                 destinations_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 enrichments: Optional[pulumi.Input[Union['WorkflowEnrichmentsArgs', 'WorkflowEnrichmentsArgsDict']]] = None,
                 enrichments_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_filter: Optional[pulumi.Input[Union['WorkflowIssuesFilterArgs', 'WorkflowIssuesFilterArgsDict']]] = None,
                 muting_rules_handling: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowArgs.__new__(WorkflowArgs)

            __props__.__dict__["account_id"] = account_id
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["destinations_enabled"] = destinations_enabled
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["enrichments"] = enrichments
            __props__.__dict__["enrichments_enabled"] = enrichments_enabled
            if issues_filter is None and not opts.urn:
                raise TypeError("Missing required property 'issues_filter'")
            __props__.__dict__["issues_filter"] = issues_filter
            if muting_rules_handling is None and not opts.urn:
                raise TypeError("Missing required property 'muting_rules_handling'")
            __props__.__dict__["muting_rules_handling"] = muting_rules_handling
            __props__.__dict__["name"] = name
            __props__.__dict__["guid"] = None
            __props__.__dict__["last_run"] = None
            __props__.__dict__["workflow_id"] = None
        super(Workflow, __self__).__init__(
            'newrelic:index/workflow:Workflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkflowDestinationArgs', 'WorkflowDestinationArgsDict']]]]] = None,
            destinations_enabled: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            enrichments: Optional[pulumi.Input[Union['WorkflowEnrichmentsArgs', 'WorkflowEnrichmentsArgsDict']]] = None,
            enrichments_enabled: Optional[pulumi.Input[bool]] = None,
            guid: Optional[pulumi.Input[str]] = None,
            issues_filter: Optional[pulumi.Input[Union['WorkflowIssuesFilterArgs', 'WorkflowIssuesFilterArgsDict']]] = None,
            last_run: Optional[pulumi.Input[str]] = None,
            muting_rules_handling: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            workflow_id: Optional[pulumi.Input[str]] = None) -> 'Workflow':
        """
        Get an existing Workflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkflowDestinationArgs', 'WorkflowDestinationArgsDict']]]] destinations: Notification configuration. See Nested destination blocks below for details.
        :param pulumi.Input[bool] destinations_enabled: **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
               these two are different flags, but they are functionally identical. Defaults to true.
        :param pulumi.Input[bool] enabled: Whether workflow is enabled. Defaults to true.
        :param pulumi.Input[Union['WorkflowEnrichmentsArgs', 'WorkflowEnrichmentsArgsDict']] enrichments: Workflow's enrichments. See Nested enrichments blocks below for details.
        :param pulumi.Input[bool] enrichments_enabled: Whether enrichments are enabled. Defaults to true.
        :param pulumi.Input[str] guid: Workflow entity GUID
        :param pulumi.Input[Union['WorkflowIssuesFilterArgs', 'WorkflowIssuesFilterArgsDict']] issues_filter: A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        :param pulumi.Input[str] last_run: The last time notification was sent for this workflow.
        :param pulumi.Input[str] muting_rules_handling: How to handle muted issues. See Muting Rules below for details.
        :param pulumi.Input[str] name: The name of the workflow.
        :param pulumi.Input[str] workflow_id: The id of the workflow.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkflowState.__new__(_WorkflowState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["destinations_enabled"] = destinations_enabled
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["enrichments"] = enrichments
        __props__.__dict__["enrichments_enabled"] = enrichments_enabled
        __props__.__dict__["guid"] = guid
        __props__.__dict__["issues_filter"] = issues_filter
        __props__.__dict__["last_run"] = last_run
        __props__.__dict__["muting_rules_handling"] = muting_rules_handling
        __props__.__dict__["name"] = name
        __props__.__dict__["workflow_id"] = workflow_id
        return Workflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Determines the New Relic account in which the workflow is created. Defaults to the account defined in the provider section.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence['outputs.WorkflowDestination']]:
        """
        Notification configuration. See Nested destination blocks below for details.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="destinationsEnabled")
    @_utilities.deprecated("""Please use 'enabled' instead""")
    def destinations_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        **DEPRECATED** Whether destinations are enabled. Please use `enabled` instead:
        these two are different flags, but they are functionally identical. Defaults to true.
        """
        return pulumi.get(self, "destinations_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether workflow is enabled. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def enrichments(self) -> pulumi.Output[Optional['outputs.WorkflowEnrichments']]:
        """
        Workflow's enrichments. See Nested enrichments blocks below for details.
        """
        return pulumi.get(self, "enrichments")

    @property
    @pulumi.getter(name="enrichmentsEnabled")
    def enrichments_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enrichments are enabled. Defaults to true.
        """
        return pulumi.get(self, "enrichments_enabled")

    @property
    @pulumi.getter
    def guid(self) -> pulumi.Output[str]:
        """
        Workflow entity GUID
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter(name="issuesFilter")
    def issues_filter(self) -> pulumi.Output['outputs.WorkflowIssuesFilter']:
        """
        A filter used to identify issues handled by this workflow. See Nested issues_filter blocks below for details.
        """
        return pulumi.get(self, "issues_filter")

    @property
    @pulumi.getter(name="lastRun")
    def last_run(self) -> pulumi.Output[str]:
        """
        The last time notification was sent for this workflow.
        """
        return pulumi.get(self, "last_run")

    @property
    @pulumi.getter(name="mutingRulesHandling")
    def muting_rules_handling(self) -> pulumi.Output[str]:
        """
        How to handle muted issues. See Muting Rules below for details.
        """
        return pulumi.get(self, "muting_rules_handling")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the workflow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Output[str]:
        """
        The id of the workflow.
        """
        return pulumi.get(self, "workflow_id")

