# .agent - Agent-Optimized Documentation

**⚠️ These files are maintained for AI coding assistants and may be regenerated from source code.**

This directory contains comprehensive, agent-friendly documentation for the workstack codebase. While these files are currently version-controlled, they may be regenerated in the future to stay in sync with the codebase.

## Contents

This directory contains comprehensive documentation for the workstack codebase:

- **ARCHITECTURE.md** - System architecture, design patterns, and component relationships
- **FEATURE_INDEX.md** - Complete index of all features with implementation locations
- **GLOSSARY.md** - Terminology and concept definitions used throughout the codebase
- **MODULE_MAP.md** - Map of all modules with their purposes and key exports (located in docs/)
- **docs/** - Detailed documentation on coding patterns, exception handling, and more

## Purpose

These documents are specifically structured for AI coding assistants to:

- Quickly understand the codebase architecture
- Find specific features and their implementations
- Learn project-specific patterns and conventions
- Navigate the module structure efficiently

## For Agents

These files provide comprehensive context about the codebase structure, patterns, and conventions. Use them to:

- Understand system architecture and design decisions
- Find where specific features are implemented
- Learn coding patterns and best practices
- Navigate the module structure

Always cross-reference with the actual source code, as implementations may evolve.
