#  Copyright Contributors to the OpenCue Project
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.


"""Test suite for all cueman unit tests."""

from __future__ import absolute_import, division, print_function

import unittest
import warnings

from tests.test_main import TestCuemanHandleArgs, TestCuemanMain

# Suppress protobuf version warnings
warnings.filterwarnings(
    "ignore", category=UserWarning, module="google.protobuf.runtime_version"
)


def create_test_suite():
    """Creates and returns the full test suite for cueman."""
    suite = unittest.TestSuite()

    # Add test cases from test_main
    suite.addTests(unittest.TestLoader().loadTestsFromTestCase(TestCuemanMain))
    suite.addTests(unittest.TestLoader().loadTestsFromTestCase(TestCuemanHandleArgs))

    return suite


if __name__ == "__main__":
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(create_test_suite())
