"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HyperledgerFabricUser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
const constructs = require("constructs");
const identity = require("./identity");
/**
 * Creates custom resources to register and enroll users identities
 * with the CA using the fabric-ca-client SDK
 */
class HyperledgerFabricUser extends constructs.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Populate instance variables from input properties
        this.userId = props.userId;
        this.affiliation = props.affilitation;
        // Get the custom resources from Identity Resources class
        const customResourceRole = identity.HyperledgerFabricIdentity.customRole;
        const registerProvider = identity.HyperledgerFabricIdentity.userProvider;
        // Ensure the user affiliation includes the member name
        if (!this.affiliation.startsWith(scope.memberName))
            throw new Error('User affiliation is invalid. Affiliation should start with Member name');
        // The user credentials will be stored in these secrets
        const userPasswordSecret = new secretsmanager.Secret(this, `${this.userId}-Password`);
        this.userPrivateKeySecret = new secretsmanager.Secret(this, `${this.userId}-PrivateKey`);
        this.userSignedCertSecret = new secretsmanager.Secret(this, `${this.userId}-SignedCert`);
        // Add secrets arn to the custom role
        customResourceRole.addToPolicy(new iam.PolicyStatement({
            actions: ['secretsmanager:PutSecretValue'],
            resources: [
                userPasswordSecret.secretArn,
                this.userPrivateKeySecret.secretArn,
                this.userSignedCertSecret.secretArn,
            ],
        }));
        const userProp = {
            userId: this.userId,
            affiliation: this.affiliation,
            passwordArn: userPasswordSecret.secretArn,
            privateKeyArn: this.userPrivateKeySecret.secretArn,
            signedCertArn: this.userSignedCertSecret.secretArn,
        };
        // Custom resource to enroll the admin identity using fabric client SDK
        new cdk.CustomResource(this, `${this.userId}Resource`, { serviceToken: registerProvider.serviceToken, properties: userProp });
    }
}
exports.HyperledgerFabricUser = HyperledgerFabricUser;
_a = JSII_RTTI_SYMBOL_1;
HyperledgerFabricUser[_a] = { fqn: "@cdklabs/cdk-hyperledger-fabric-network.HyperledgerFabricUser", version: "0.8.339" };
//# sourceMappingURL=data:application/json;base64,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