# coding: utf-8

"""
    Workspace Data Service

    This page lists current APIs.  All v0.2 APIs are subject to change without notice.  Changelog at [https://github.com/DataBiosphere/terra-workspace-data-service/releases](https://github.com/DataBiosphere/terra-workspace-data-service/releases) 

    The version of the OpenAPI document: v0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeleteRecordsRequest(BaseModel):
    """
    A request body to delete records in bulk. The caller must either:  (1) specify which records should be deleted using the `record_ids` field  *OR*  (2) set `delete_all=true`.  If `delete_all=true`, the caller may optionally specify a list of records  to be spared from deletion using the `excluded_record_ids` field. 
    """ # noqa: E501
    record_ids: Optional[List[StrictStr]] = Field(default=None, description="an array of record IDs that should be deleted")
    excluded_record_ids: Optional[List[StrictStr]] = Field(default=None, description="an array of record IDs that should NOT be deleted.")
    delete_all: Optional[StrictBool] = Field(default=False, description="if true, deletes all records")
    __properties: ClassVar[List[str]] = ["record_ids", "excluded_record_ids", "delete_all"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeleteRecordsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeleteRecordsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "record_ids": obj.get("record_ids"),
            "excluded_record_ids": obj.get("excluded_record_ids"),
            "delete_all": obj.get("delete_all") if obj.get("delete_all") is not None else False
        })
        return _obj


