# pyGroupedTransforms

Fast Grouped Transformations as introduced in [Bartel, Potts, Schmischke, 2021](https://arxiv.org/abs/2010.10199) .

[![](https://github.com/NFFT/pyGroupedTransforms/actions/workflows/ci.yml/badge.svg)](https://github.com/NFFT/pyGroupedTransforms/actions/workflows/ci.yml)

`pyGroupedTransforms` provides the following fast algorithms:
nonequispaced fast transformation with exponential functions for grouped index sets based on the NFFT (non-equispaced fast Fourier transform)
nonequispaced fast transformation with cosine functions for grouped index sets based on the NFCT (non-equispaced fast cosine transform)

## Getting started

The [pyGroupedTransforms package](https://pypi.org/project/pyGroupedTransforms/) can be installed via pip:

```
pip install pyGroupedTransforms
```

Read the [documentation](https://nfft.github.io/pyGroupedTransforms/) for specific usage information.

Requirements
------------

- Python 3.8 or greater
- pyNFFT3 0.2.2 or greater
- NumPy 2.0.0 or greater
- SciPy 1.16.0 or greater
