import numpy as np


# Cardinal B-Spline :
def cardinal_bspline(
    v, order
):  # function cardinal_bspline(v::Array{Float64}, order::Int)::Array{Float64}
    """
    % evaluates the centered cardinal B-spline of the given order at v
    INPUT :
    v     ... x-values
    order ... order of B-Spline
    y     ... function values
    """

    f = np.zeros_like(v, dtype=float)

    for i in range(len(v)):
        x = v[i]

        if x < -order / 2 or x >= order / 2:
            j = 0
        else:
            j = int(np.ceil(x + order / 2))

        if order == 1:
            if j == 1:
                y = 1.0000000000000000e00
            else:
                y = 0
        elif order == 2:
            if j == 1:
                y = 1.0000000000000000e00 + x * (1.0000000000000000e00)
            elif j == 2:
                y = 1.0000000000000000e00 + x * (-1.0000000000000000e00)
            else:
                y = 0
        elif order == 3:
            if j == 1:
                y = 1.1250000000000000e00 + x * (
                    1.5000000000000000e00 + x * (5.0000000000000000e-01)
                )
            elif j == 2:
                y = 7.5000000000000000e-01 + x * (
                    0.0000000000000000e00 + x * (-1.0000000000000000e00)
                )
            elif j == 3:
                y = 1.1250000000000000e00 + x * (
                    -1.5000000000000000e00 + x * (5.0000000000000000e-01)
                )
            else:
                y = 0
        elif order == 4:
            if j == 1:
                y = 1.3333333333333333e00 + x * (
                    2.0000000000000000e00
                    + x * (1.0000000000000000e00 + x * (1.6666666666666666e-01))
                )
            elif j == 2:
                y = 6.6666666666666663e-01 + x * (
                    0.0000000000000000e00
                    + x * (-1.0000000000000000e00 + x * (-5.0000000000000000e-01))
                )
            elif j == 3:
                y = 6.6666666666666663e-01 + x * (
                    0.0000000000000000e00
                    + x * (-1.0000000000000000e00 + x * (5.0000000000000000e-01))
                )
            elif j == 4:
                y = 1.3333333333333333e00 + x * (
                    -2.0000000000000000e00
                    + x * (1.0000000000000000e00 + x * (-1.6666666666666666e-01))
                )
            else:
                y = 0
        elif order == 5:
            if j == 1:
                y = 1.6276041666666665e00 + x * (
                    2.6041666666666665e00
                    + x
                    * (
                        1.5625000000000000e00
                        + x * (4.1666666666666663e-01 + x * (4.1666666666666664e-02))
                    )
                )
            elif j == 2:
                y = 5.7291666666666663e-01 + x * (
                    -2.0833333333333343e-01
                    + x
                    * (
                        -1.2500000000000000e00
                        + x * (-8.3333333333333337e-01 + x * (-1.6666666666666666e-01))
                    )
                )
            elif j == 3:
                y = 5.9895833333333326e-01 + x * (
                    0.0000000000000000e00
                    + x
                    * (
                        -6.2500000000000000e-01
                        + x * (0.0000000000000000e00 + x * (2.5000000000000000e-01))
                    )
                )
            elif j == 4:
                y = 5.7291666666666663e-01 + x * (
                    2.0833333333333343e-01
                    + x
                    * (
                        -1.2500000000000000e00
                        + x * (8.3333333333333337e-01 + x * (-1.6666666666666666e-01))
                    )
                )
            elif j == 5:
                y = 1.6276041666666665e00 + x * (
                    -2.6041666666666665e00
                    + x
                    * (
                        1.5625000000000000e00
                        + x * (-4.1666666666666663e-01 + x * (4.1666666666666664e-02))
                    )
                )
            else:
                y = 0
        elif order == 6:
            if j == 1:
                y = 2.0249999999999999e00 + x * (
                    3.3750000000000000e00
                    + x
                    * (
                        2.2500000000000000e00
                        + x
                        * (
                            7.5000000000000000e-01
                            + x
                            * (1.2500000000000000e-01 + x * (8.3333333333333332e-03))
                        )
                    )
                )
            elif j == 2:
                y = 4.2499999999999999e-01 + x * (
                    -6.2500000000000033e-01
                    + x
                    * (
                        -1.7500000000000000e00
                        + x
                        * (
                            -1.2500000000000000e00
                            + x
                            * (-3.7499999999999994e-01 + x * (-4.1666666666666664e-02))
                        )
                    )
                )
            elif j == 3:
                y = 5.5000000000000004e-01 + x * (
                    -1.1102230246251565e-16
                    + x
                    * (
                        -4.9999999999999983e-01
                        + x
                        * (
                            0.0000000000000000e00
                            + x
                            * (2.5000000000000006e-01 + x * (8.3333333333333329e-02))
                        )
                    )
                )
            elif j == 4:
                y = 5.5000000000000004e-01 + x * (
                    1.1102230246251565e-16
                    + x
                    * (
                        -5.0000000000000000e-01
                        + x
                        * (
                            0.0000000000000000e00
                            + x
                            * (2.5000000000000000e-01 + x * (-8.3333333333333329e-02))
                        )
                    )
                )
            elif j == 5:
                y = 4.2499999999999999e-01 + x * (
                    6.2500000000000022e-01
                    + x
                    * (
                        -1.7500000000000000e00
                        + x
                        * (
                            1.2500000000000000e00
                            + x
                            * (-3.7500000000000000e-01 + x * (4.1666666666666664e-02))
                        )
                    )
                )
            elif j == 6:
                y = 2.0249999999999999e00 + x * (
                    -3.3750000000000000e00
                    + x
                    * (
                        2.2500000000000000e00
                        + x
                        * (
                            -7.5000000000000000e-01
                            + x
                            * (1.2500000000000000e-01 + x * (-8.3333333333333332e-03))
                        )
                    )
                )
            else:
                y = 0
        elif order == 7:
            if j == 1:
                y = 2.5531467013888887e00 + x * (
                    4.3768229166666659e00
                    + x
                    * (
                        3.1263020833333335e00
                        + x
                        * (
                            1.1909722222222221e00
                            + x
                            * (
                                2.5520833333333331e-01
                                + x
                                * (
                                    2.9166666666666664e-02
                                    + x * (1.3888888888888889e-03)
                                )
                            )
                        )
                    )
                )
            elif j == 2:
                y = 1.7955729166666637e-01 + x * (
                    -1.3197916666666669e00
                    + x
                    * (
                        -2.5703125000000000e00
                        + x
                        * (
                            -1.8472222222222221e00
                            + x
                            * (
                                -6.5625000000000000e-01
                                + x
                                * (
                                    -1.1666666666666665e-01
                                    + x * (-8.3333333333333332e-03)
                                )
                            )
                        )
                    )
                )
            elif j == 3:
                y = 5.1178385416666694e-01 + x * (
                    9.1145833333331847e-03
                    + x
                    * (
                        -3.5546874999999956e-01
                        + x
                        * (
                            1.2152777777777778e-01
                            + x
                            * (
                                3.2812500000000006e-01
                                + x
                                * (
                                    1.4583333333333334e-01
                                    + x * (2.0833333333333332e-02)
                                )
                            )
                        )
                    )
                )
            elif j == 4:
                y = 5.1102430555555556e-01 + x * (
                    -1.2952601953960160e-16
                    + x
                    * (
                        -4.0104166666666652e-01
                        + x
                        * (
                            -7.4014868308343765e-17
                            + x
                            * (
                                1.4583333333333334e-01
                                + x
                                * (
                                    0.0000000000000000e00
                                    + x * (-2.7777777777777776e-02)
                                )
                            )
                        )
                    )
                )
            elif j == 5:
                y = 5.1178385416666694e-01 + x * (
                    -9.1145833333330373e-03
                    + x
                    * (
                        -3.5546875000000000e-01
                        + x
                        * (
                            -1.2152777777777778e-01
                            + x
                            * (
                                3.2812500000000000e-01
                                + x
                                * (
                                    -1.4583333333333334e-01
                                    + x * (2.0833333333333332e-02)
                                )
                            )
                        )
                    )
                )
            elif j == 6:
                y = 1.7955729166666645e-01 + x * (
                    1.3197916666666669e00
                    + x
                    * (
                        -2.5703125000000000e00
                        + x
                        * (
                            1.8472222222222221e00
                            + x
                            * (
                                -6.5625000000000000e-01
                                + x
                                * (
                                    1.1666666666666665e-01
                                    + x * (-8.3333333333333332e-03)
                                )
                            )
                        )
                    )
                )
            elif j == 7:
                y = 2.5531467013888887e00 + x * (
                    -4.3768229166666659e00
                    + x
                    * (
                        3.1263020833333335e00
                        + x
                        * (
                            -1.1909722222222221e00
                            + x
                            * (
                                2.5520833333333331e-01
                                + x
                                * (
                                    -2.9166666666666664e-02
                                    + x * (1.3888888888888889e-03)
                                )
                            )
                        )
                    )
                )
            else:
                y = 0
        elif order == 8:
            if j == 1:
                y = 3.2507936507936499e00 + x * (
                    5.6888888888888891e00
                    + x
                    * (
                        4.2666666666666666e00
                        + x
                        * (
                            1.7777777777777775e00
                            + x
                            * (
                                4.4444444444444448e-01
                                + x
                                * (
                                    6.6666666666666666e-02
                                    + x
                                    * (
                                        5.5555555555555558e-03
                                        + x * (1.9841269841269841e-04)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 2:
                y = -2.2063492063492082e-01 + x * (
                    -2.4111111111111110e00
                    + x
                    * (
                        -3.8333333333333330e00
                        + x
                        * (
                            -2.7222222222222219e00
                            + x
                            * (
                                -1.0555555555555556e00
                                + x
                                * (
                                    -2.3333333333333334e-01
                                    + x
                                    * (
                                        -2.7777777777777780e-02
                                        + x * (-1.3888888888888889e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 3:
                y = 4.9047619047619057e-01 + x * (
                    7.7777777777777932e-02
                    + x
                    * (
                        -9.9999999999999520e-02
                        + x
                        * (
                            3.8888888888888917e-01
                            + x
                            * (
                                5.0000000000000000e-01
                                + x
                                * (
                                    2.3333333333333336e-01
                                    + x
                                    * (
                                        4.9999999999999996e-02
                                        + x * (4.1666666666666666e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 4:
                y = 4.7936507936507977e-01 + x * (
                    -4.1930744590753681e-16
                    + x
                    * (
                        -3.3333333333333293e-01
                        + x
                        * (
                            -1.3481279584734043e-16
                            + x
                            * (
                                1.1111111111111112e-01
                                + x
                                * (
                                    0.0000000000000000e00
                                    + x
                                    * (
                                        -2.7777777777777783e-02
                                        + x * (-6.9444444444444432e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 5:
                y = 4.7936507936507972e-01 + x * (
                    -9.9127055770103257e-19
                    + x
                    * (
                        -3.3333333333333298e-01
                        + x
                        * (
                            -8.7231809077690869e-17
                            + x
                            * (
                                1.1111111111111109e-01
                                + x
                                * (
                                    -1.5860328923216521e-17
                                    + x
                                    * (
                                        -2.7777777777777780e-02
                                        + x * (6.9444444444444432e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 6:
                y = 4.9047619047619057e-01 + x * (
                    -7.7777777777777682e-02
                    + x
                    * (
                        -1.0000000000000012e-01
                        + x
                        * (
                            -3.8888888888888901e-01
                            + x
                            * (
                                5.0000000000000000e-01
                                + x
                                * (
                                    -2.3333333333333336e-01
                                    + x
                                    * (
                                        4.9999999999999996e-02
                                        + x * (-4.1666666666666666e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 7:
                y = -2.2063492063492077e-01 + x * (
                    2.4111111111111114e00
                    + x
                    * (
                        -3.8333333333333330e00
                        + x
                        * (
                            2.7222222222222219e00
                            + x
                            * (
                                -1.0555555555555556e00
                                + x
                                * (
                                    2.3333333333333334e-01
                                    + x
                                    * (
                                        -2.7777777777777773e-02
                                        + x * (1.3888888888888889e-03)
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 8:
                y = 3.2507936507936499e00 + x * (
                    -5.6888888888888891e00
                    + x
                    * (
                        4.2666666666666666e00
                        + x
                        * (
                            -1.7777777777777775e00
                            + x
                            * (
                                4.4444444444444448e-01
                                + x
                                * (
                                    -6.6666666666666666e-02
                                    + x
                                    * (
                                        5.5555555555555558e-03
                                        + x * (-1.9841269841269841e-04)
                                    )
                                )
                            )
                        )
                    )
                )
            else:
                y = 0
        elif order == 9:
            if j == 1:
                y = 4.1704180036272316e00 + x * (
                    7.4140764508928569e00
                    + x
                    * (
                        5.7665039062499996e00
                        + x
                        * (
                            2.5628906249999996e00
                            + x
                            * (
                                7.1191406250000011e-01
                                + x
                                * (
                                    1.2656250000000002e-01
                                    + x
                                    * (
                                        1.4062500000000000e-02
                                        + x
                                        * (
                                            8.9285714285714294e-04
                                            + x * (2.4801587301587302e-05)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 2:
                y = -8.5608956473214359e-01 + x * (
                    -4.0750837053571427e00
                    + x
                    * (
                        -5.7226562500000000e00
                        + x
                        * (
                            -4.0023437500000014e00
                            + x
                            * (
                                -1.6328125000000000e00
                                + x
                                * (
                                    -4.0937499999999993e-01
                                    + x
                                    * (
                                        -6.2499999999999993e-02
                                        + x
                                        * (
                                            -5.3571428571428572e-03
                                            + x * (-1.9841269841269841e-04)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 3:
                y = 5.0630231584821439e-01 + x * (
                    2.8457031250000059e-01
                    + x
                    * (
                        3.8085937500000017e-01
                        + x
                        * (
                            8.8046875000000069e-01
                            + x
                            * (
                                8.0859374999999989e-01
                                + x
                                * (
                                    3.7187500000000001e-01
                                    + x
                                    * (
                                        9.3749999999999986e-02
                                        + x
                                        * (
                                            1.2499999999999999e-02
                                            + x * (6.9444444444444447e-04)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 4:
                y = 4.5290876116071449e-01 + x * (
                    -1.9531250000014036e-04
                    + x
                    * (
                        -2.8359374999999992e-01
                        + x
                        * (
                            -5.4687499999998678e-03
                            + x
                            * (
                                7.0312499999999861e-02
                                + x
                                * (
                                    -2.1874999999999967e-02
                                    + x
                                    * (
                                        -3.7500000000000019e-02
                                        + x
                                        * (
                                            -1.2500000000000001e-02
                                            + x * (-1.3888888888888887e-03)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 5:
                y = 4.5292096819196492e-01 + x * (
                    -4.1199682554449168e-16
                    + x
                    * (
                        -2.8222656249999944e-01
                        + x
                        * (
                            -2.1510571102112408e-16
                            + x
                            * (
                                8.3984374999999944e-02
                                + x
                                * (
                                    -1.3877787807814457e-17
                                    + x
                                    * (
                                        -1.5625000000000014e-02
                                        + x
                                        * (
                                            8.6736173798840355e-19
                                            + x * (1.7361111111111108e-03)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 6:
                y = 4.5290876116071466e-01 + x * (
                    1.9531249999965074e-04
                    + x
                    * (
                        -2.8359374999999992e-01
                        + x
                        * (
                            5.4687499999997776e-03
                            + x
                            * (
                                7.0312499999999875e-02
                                + x
                                * (
                                    2.1874999999999933e-02
                                    + x
                                    * (
                                        -3.7500000000000006e-02
                                        + x
                                        * (
                                            1.2499999999999999e-02
                                            + x * (-1.3888888888888887e-03)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 7:
                y = 5.0630231584821439e-01 + x * (
                    -2.8457031249999992e-01
                    + x
                    * (
                        3.8085937500000017e-01
                        + x
                        * (
                            -8.8046875000000024e-01
                            + x
                            * (
                                8.0859374999999989e-01
                                + x
                                * (
                                    -3.7187500000000001e-01
                                    + x
                                    * (
                                        9.3750000000000000e-02
                                        + x
                                        * (
                                            -1.2499999999999997e-02
                                            + x * (6.9444444444444447e-04)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 8:
                y = -8.5608956473214382e-01 + x * (
                    4.0750837053571427e00
                    + x
                    * (
                        -5.7226562500000000e00
                        + x
                        * (
                            4.0023437500000005e00
                            + x
                            * (
                                -1.6328125000000000e00
                                + x
                                * (
                                    4.0937499999999993e-01
                                    + x
                                    * (
                                        -6.2499999999999986e-02
                                        + x
                                        * (
                                            5.3571428571428563e-03
                                            + x * (-1.9841269841269841e-04)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 9:
                y = 4.1704180036272316e00 + x * (
                    -7.4140764508928569e00
                    + x
                    * (
                        5.7665039062499996e00
                        + x
                        * (
                            -2.5628906249999996e00
                            + x
                            * (
                                7.1191406250000011e-01
                                + x
                                * (
                                    -1.2656250000000002e-01
                                    + x
                                    * (
                                        1.4062500000000000e-02
                                        + x
                                        * (
                                            -8.9285714285714294e-04
                                            + x * (2.4801587301587302e-05)
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            else:
                y = 0
        elif order == 10:
            if j == 1:
                y = 5.3822889109347445e00 + x * (
                    9.6881200396825395e00
                    + x
                    * (
                        7.7504960317460307e00
                        + x
                        * (
                            3.6168981481481475e00
                            + x
                            * (
                                1.0850694444444446e00
                                + x
                                * (
                                    2.1701388888888895e-01
                                    + x
                                    * (
                                        2.8935185185185189e-02
                                        + x
                                        * (
                                            2.4801587301587300e-03
                                            + x
                                            * (
                                                1.2400793650793653e-04
                                                + x * (2.7557319223985893e-06)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 2:
                y = -1.8416969797178138e00 + x * (
                    -6.5658482142857135e00
                    + x
                    * (
                        -8.5034722222222232e00
                        + x
                        * (
                            -5.8645833333333339e00
                            + x
                            * (
                                -2.4704861111111116e00
                                + x
                                * (
                                    -6.7187500000000000e-01
                                    + x
                                    * (
                                        -1.1921296296296295e-01
                                        + x
                                        * (
                                            -1.3392857142857140e-02
                                            + x
                                            * (
                                                -8.6805555555555572e-04
                                                + x * (-2.4801587301587302e-05)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 3:
                y = 5.9915123456790131e-01 + x * (
                    7.5669642857142883e-01
                    + x
                    * (
                        1.2599206349206369e00
                        + x
                        * (
                            1.7291666666666661e00
                            + x
                            * (
                                1.3263888888888888e00
                                + x
                                * (
                                    5.9375000000000000e-01
                                    + x
                                    * (
                                        1.6203703703703703e-01
                                        + x
                                        * (
                                            2.6785714285714281e-02
                                            + x
                                            * (
                                                2.4801587301587300e-03
                                                + x * (9.9206349206349220e-05)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 4:
                y = 4.2983906525573179e-01 + x * (
                    -5.2083333333328057e-03
                    + x
                    * (
                        -2.6388888888888967e-01
                        + x
                        * (
                            -4.8611111111110529e-02
                            + x
                            * (
                                -6.9444444444446956e-03
                                + x
                                * (
                                    -7.2916666666666644e-02
                                    + x
                                    * (
                                        -6.0185185185185203e-02
                                        + x
                                        * (
                                            -2.0833333333333336e-02
                                            + x
                                            * (
                                                -3.4722222222222220e-03
                                                + x * (-2.3148148148148149e-04)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 5:
                y = 4.3041776895943618e-01 + x * (
                    -2.4454782334950824e-18
                    + x
                    * (
                        -2.4305555555555569e-01
                        + x
                        * (
                            1.3010426069826053e-16
                            + x
                            * (
                                6.5972222222221863e-02
                                + x
                                * (
                                    2.8526563827174158e-17
                                    + x
                                    * (
                                        -1.1574074074074106e-02
                                        + x
                                        * (
                                            -1.5419764230904951e-18
                                            + x
                                            * (
                                                1.7361111111111110e-03
                                                + x * (3.4722222222222213e-04)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 6:
                y = 4.3041776895943623e-01 + x * (
                    -9.9439409253128842e-16
                    + x
                    * (
                        -2.4305555555555530e-01
                        + x
                        * (
                            -5.7168775886080107e-16
                            + x
                            * (
                                6.5972222222221932e-02
                                + x
                                * (
                                    -5.7053127654348317e-17
                                    + x
                                    * (
                                        -1.1574074074074105e-02
                                        + x
                                        * (
                                            3.0839528461809902e-18
                                            + x
                                            * (
                                                1.7361111111111106e-03
                                                + x * (-3.4722222222222213e-04)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 7:
                y = 4.2983906525573234e-01 + x * (
                    5.2083333333329627e-03
                    + x
                    * (
                        -2.6388888888888878e-01
                        + x
                        * (
                            4.8611111111110640e-02
                            + x
                            * (
                                -6.9444444444445291e-03
                                + x
                                * (
                                    7.2916666666666644e-02
                                    + x
                                    * (
                                        -6.0185185185185182e-02
                                        + x
                                        * (
                                            2.0833333333333336e-02
                                            + x
                                            * (
                                                -3.4722222222222216e-03
                                                + x * (2.3148148148148149e-04)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 8:
                y = 5.9915123456790087e-01 + x * (
                    -7.5669642857142860e-01
                    + x
                    * (
                        1.2599206349206351e00
                        + x
                        * (
                            -1.7291666666666665e00
                            + x
                            * (
                                1.3263888888888888e00
                                + x
                                * (
                                    -5.9375000000000000e-01
                                    + x
                                    * (
                                        1.6203703703703703e-01
                                        + x
                                        * (
                                            -2.6785714285714288e-02
                                            + x
                                            * (
                                                2.4801587301587300e-03
                                                + x * (-9.9206349206349220e-05)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 9:
                y = -1.8416969797178138e00 + x * (
                    6.5658482142857135e00
                    + x
                    * (
                        -8.5034722222222232e00
                        + x
                        * (
                            5.8645833333333330e00
                            + x
                            * (
                                -2.4704861111111112e00
                                + x
                                * (
                                    6.7187499999999989e-01
                                    + x
                                    * (
                                        -1.1921296296296295e-01
                                        + x
                                        * (
                                            1.3392857142857140e-02
                                            + x
                                            * (
                                                -8.6805555555555551e-04
                                                + x * (2.4801587301587302e-05)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            elif j == 10:
                y = 5.3822889109347445e00 + x * (
                    -9.6881200396825395e00
                    + x
                    * (
                        7.7504960317460307e00
                        + x
                        * (
                            -3.6168981481481475e00
                            + x
                            * (
                                1.0850694444444446e00
                                + x
                                * (
                                    -2.1701388888888895e-01
                                    + x
                                    * (
                                        2.8935185185185189e-02
                                        + x
                                        * (
                                            -2.4801587301587300e-03
                                            + x
                                            * (
                                                1.2400793650793653e-04
                                                + x * (-2.7557319223985893e-06)
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                )
            else:
                y = 0

        f[i] = y
    return f
