from typing import overload
from enum import Enum
import typing
import warnings

import QuantConnect.Algorithm.Framework.Alphas
import QuantConnect.Algorithm.Framework.Alphas.Serialization
import QuantConnect.Util
import System


class SerializedInsight(System.Object):
    """
    DTO used for serializing an insight that was just generated by an algorithm.
    This type does not contain any of the analysis dependent fields, such as scores
    and estimated value
    """

    @property
    def id(self) -> str:
        """See Insight.Id"""
        ...

    @property.setter
    def id(self, value: str) -> None:
        ...

    @property
    def group_id(self) -> str:
        """See Insight.GroupId"""
        ...

    @property.setter
    def group_id(self, value: str) -> None:
        ...

    @property
    def source_model(self) -> str:
        """See Insight.SourceModel"""
        ...

    @property.setter
    def source_model(self, value: str) -> None:
        ...

    @property
    def generated_time(self) -> float:
        """
        Pass-through for CreatedTime
        
        Deprecated as of 2020-01-23. Please use the `CreatedTime` property instead.
        """
        warnings.warn("Deprecated as of 2020-01-23. Please use the `CreatedTime` property instead.", DeprecationWarning)

    @property.setter
    def generated_time(self, value: float) -> None:
        warnings.warn("Deprecated as of 2020-01-23. Please use the `CreatedTime` property instead.", DeprecationWarning)

    @property
    def created_time(self) -> float:
        """See Insight.GeneratedTimeUtc"""
        ...

    @property.setter
    def created_time(self, value: float) -> None:
        ...

    @property
    def close_time(self) -> float:
        """See Insight.CloseTimeUtc"""
        ...

    @property.setter
    def close_time(self, value: float) -> None:
        ...

    @property
    def symbol(self) -> str:
        """
        See Insight.Symbol
        The symbol's security identifier string
        """
        ...

    @property.setter
    def symbol(self, value: str) -> None:
        ...

    @property
    def ticker(self) -> str:
        """
        See Insight.Symbol
        The symbol's ticker at the generated time
        """
        ...

    @property.setter
    def ticker(self, value: str) -> None:
        ...

    @property
    def type(self) -> QuantConnect.Algorithm.Framework.Alphas.InsightType:
        """See Insight.Type"""
        ...

    @property.setter
    def type(self, value: QuantConnect.Algorithm.Framework.Alphas.InsightType) -> None:
        ...

    @property
    def reference_value(self) -> float:
        """See Insight.ReferenceValue"""
        ...

    @property.setter
    def reference_value(self, value: float) -> None:
        ...

    @property
    def reference_value_final(self) -> float:
        """See Insight.ReferenceValueFinal"""
        ...

    @property.setter
    def reference_value_final(self, value: float) -> None:
        ...

    @property
    def direction(self) -> QuantConnect.Algorithm.Framework.Alphas.InsightDirection:
        """See Insight.Direction"""
        ...

    @property.setter
    def direction(self, value: QuantConnect.Algorithm.Framework.Alphas.InsightDirection) -> None:
        ...

    @property
    def period(self) -> float:
        """See Insight.Period"""
        ...

    @property.setter
    def period(self, value: float) -> None:
        ...

    @property
    def magnitude(self) -> typing.Optional[float]:
        """See Insight.Magnitude"""
        ...

    @property.setter
    def magnitude(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def confidence(self) -> typing.Optional[float]:
        """See Insight.Confidence"""
        ...

    @property.setter
    def confidence(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def weight(self) -> typing.Optional[float]:
        """See Insight.Weight"""
        ...

    @property.setter
    def weight(self, value: typing.Optional[float]) -> None:
        ...

    @property
    def score_is_final(self) -> bool:
        """See InsightScore.IsFinalScore"""
        ...

    @property.setter
    def score_is_final(self, value: bool) -> None:
        ...

    @property
    def score_magnitude(self) -> float:
        """See InsightScore.Magnitude"""
        ...

    @property.setter
    def score_magnitude(self, value: float) -> None:
        ...

    @property
    def score_direction(self) -> float:
        """See InsightScore.Direction"""
        ...

    @property.setter
    def score_direction(self, value: float) -> None:
        ...

    @property
    def estimated_value(self) -> float:
        """See Insight.EstimatedValue"""
        ...

    @property.setter
    def estimated_value(self, value: float) -> None:
        ...

    @property
    def tag(self) -> str:
        """See Insight.Tag"""
        ...

    @property.setter
    def tag(self, value: str) -> None:
        ...

    @property
    def old_created_time(self) -> float:
        """See Insight.GeneratedTimeUtc"""
        ...

    @property.setter
    def old_created_time(self, value: float) -> None:
        ...

    @property
    def old_close_time(self) -> float:
        """See Insight.CloseTimeUtc"""
        ...

    @property.setter
    def old_close_time(self, value: float) -> None:
        ...

    @overload
    def __init__(self) -> None:
        """Initializes a new default instance of the SerializedInsight class"""
        ...

    @overload
    def __init__(self, insight: QuantConnect.Algorithm.Framework.Alphas.Insight) -> None:
        """
        Initializes a new instance of the SerializedInsight  class by copying the specified insight
        
        :param insight: The insight to copy
        """
        ...


class InsightJsonConverter(QuantConnect.Util.TypeChangeJsonConverter[QuantConnect.Algorithm.Framework.Alphas.Insight, QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight]):
    """Defines how insights should be serialized to json"""

    @overload
    def convert(self, value: QuantConnect.Algorithm.Framework.Alphas.Insight) -> QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight:
        """
        Convert the input value to a value to be serialized
        
        This method is protected.
        
        :param value: The input value to be converted before serialization
        :returns: A new instance of TResult that is to be serialized.
        """
        ...

    @overload
    def convert(self, value: QuantConnect.Algorithm.Framework.Alphas.Serialization.SerializedInsight) -> QuantConnect.Algorithm.Framework.Alphas.Insight:
        """
        Converts the input value to be deserialized
        
        This method is protected.
        
        :param value: The deserialized value that needs to be converted to T
        :returns: The converted value.
        """
        ...


