from typing import overload
from enum import Enum
import abc
import typing

import System
import System.Runtime.Intrinsics
import System.Runtime.Intrinsics.X86


class X86Base(System.Object, metaclass=abc.ABCMeta):
    """Provides access to the x86 base hardware instructions via intrinsics."""

    class X64(System.Object, metaclass=abc.ABCMeta):
        """Provides access to the x86 base hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)  DIV reg/m64"""
            ...

        @staticmethod
        @overload
        def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """__int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)  DIV reg/m64"""
            ...

        @staticmethod
        @overload
        def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)  DIV reg/m64"""
            ...

        @staticmethod
        @overload
        def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """__int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)  DIV reg/m64"""
            ...

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def cpu_id(function_id: int, sub_function_id: int) -> System.ValueTuple[int, int, int, int]:
        """void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);  CPUID"""
        ...

    @staticmethod
    @overload
    def cpu_id(function_id: int, sub_function_id: int) -> System.ValueTuple[int, int, int, int]:
        """void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);  CPUID"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """DIV reg/m32"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """IDIV reg/m32"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """unsigned _udiv64(unsigned __int64 dividend, unsigned divisor, unsigned* remainder)  DIV reg/m32"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """int _div64(__int64 dividend, int divisor, int* remainder)  IDIV reg/m32"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def div_rem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def pause() -> None:
        """void _mm_pause (void);  PAUSE"""
        ...

    @staticmethod
    @overload
    def pause() -> None:
        """void _mm_pause (void);  PAUSE"""
        ...


class Sse(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """Provides access to X86 SSE hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSE hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_cvtsi64_ss (__m128 a, __int64 b)   CVTSI2SS xmm1,       r/m64  VCVTSI2SS xmm1, xmm2, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_cvtsi64_ss (__m128 a, __int64 b)   CVTSI2SS xmm1,       r/m64  VCVTSI2SS xmm1, xmm2, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvtss_si64 (__m128 a)   CVTSS2SI r64, xmm1/m32  VCVTSS2SI r64, xmm1/m32This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvtss_si64 (__m128 a)   CVTSS2SI r64, xmm1/m32  VCVTSS2SI r64, xmm1/m32This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvttss_si64 (__m128 a)   CVTTSS2SI r64, xmm1/m32  VCVTTSS2SI r64, xmm1/m32This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvttss_si64 (__m128 a)   CVTTSS2SI r64, xmm1/m32  VCVTTSS2SI r64, xmm1/m32This intrinsic is only available on 64-bit processes"""
            ...

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_add_ps (__m128 a,  __m128 b)   ADDPS xmm1,               xmm2/m128  VADDPS xmm1,         xmm2, xmm3/m128  VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_add_ps (__m128 a,  __m128 b)   ADDPS xmm1,               xmm2/m128  VADDPS xmm1,         xmm2, xmm3/m128  VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_add_ss (__m128 a,  __m128 b)   ADDSS xmm1,               xmm2/m32  VADDSS xmm1,         xmm2, xmm3/m32  VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def add_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_add_ss (__m128 a,  __m128 b)   ADDSS xmm1,               xmm2/m32  VADDSS xmm1,         xmm2, xmm3/m32  VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_and_ps (__m128 a, __m128 b)   ANDPS xmm1,               xmm2/m128  VANDPS xmm1,         xmm2, xmm3/m128  VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_and_ps (__m128 a, __m128 b)   ANDPS xmm1,               xmm2/m128  VANDPS xmm1,         xmm2, xmm3/m128  VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_andnot_ps (__m128 a, __m128 b)   ANDNPS xmm1,               xmm2/m128  VANDNPS xmm1,         xmm2, xmm3/m128  VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_andnot_ps (__m128 a, __m128 b)   ANDNPS xmm1,               xmm2/m128  VANDNPS xmm1,         xmm2, xmm3/m128  VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpeq_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(0)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpeq_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(0)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpgt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(1)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpgt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(1)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpge_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(2)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpge_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(2)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmplt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(1)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmplt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(1)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmple_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(2)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmple_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(2)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpneq_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(4)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpneq_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(4)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpngt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(5)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpngt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(5)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnge_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(6)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnge_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(6)   ; with swapped operands  VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(5)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(5)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnle_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(6)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnle_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(6)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpord_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(7)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpord_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(7)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpeq_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(0)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpeq_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(0)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpgt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(1)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpgt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(1)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpge_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(2)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpge_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(2)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmplt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(1)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmplt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(1)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmple_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(2)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmple_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(2)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpneq_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(4)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpneq_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(4)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpngt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(5)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpngt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(5)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnge_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(6)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnge_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(6)   ; with swapped operands  VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(5)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(5)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnle_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(6)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpnle_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(6)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpord_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(7)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpord_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(7)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comieq_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=1 && PF=0  VCOMISS xmm1, xmm2/m32        ; ZF=1 && PF=0  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comieq_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=1 && PF=0  VCOMISS xmm1, xmm2/m32        ; ZF=1 && PF=0  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comigt_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=0 && CF=0  VCOMISS xmm1, xmm2/m32        ; ZF=0 && CF=0  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comigt_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=0 && CF=0  VCOMISS xmm1, xmm2/m32        ; ZF=0 && CF=0  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comige_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; CF=0  VCOMISS xmm1, xmm2/m32        ; CF=0  VCOMISS xmm1, xmm2/m32{sae}   ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comige_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; CF=0  VCOMISS xmm1, xmm2/m32        ; CF=0  VCOMISS xmm1, xmm2/m32{sae}   ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comilt_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; PF=0 && CF=1  VCOMISS xmm1, xmm2/m32        ; PF=0 && CF=1  VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comilt_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; PF=0 && CF=1  VCOMISS xmm1, xmm2/m32        ; PF=0 && CF=1  VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comile_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)  VCOMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)  VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comile_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)  VCOMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)  VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comineq_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=0 || PF=1  VCOMISS xmm1, xmm2/m32        ; ZF=0 || PF=1  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comineq_ss (__m128 a, __m128 b)   COMISS xmm1, xmm2/m32        ; ZF=0 || PF=1  VCOMISS xmm1, xmm2/m32        ; ZF=0 || PF=1  VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpunord_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(3)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpunord_ss (__m128 a,  __m128 b)   CMPSS xmm1,       xmm2/m32, imm8(3)  VCMPSS xmm1, xmm2, xmm3/m32, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomieq_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0  VUCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomieq_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0  VUCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomigt_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0  VUCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomigt_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0  VUCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomige_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; CF=0  VUCOMISS xmm1, xmm2/m32       ; CF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomige_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; CF=0  VUCOMISS xmm1, xmm2/m32       ; CF=0  VUCOMISS xmm1, xmm2/m32{sae}  ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomilt_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1  VUCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1  VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomilt_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1  VUCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1  VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomile_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)  VUCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)  VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomile_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)  VUCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)  VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomineq_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1  VUCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomineq_ss (__m128 a, __m128 b)   UCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1  VUCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1  VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpunord_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(3)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmpunord_ps (__m128 a,  __m128 b)   CMPPS xmm1,       xmm2/m128, imm8(3)  VCMPPS xmm1, xmm2, xmm3/m128, imm8(3)"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtsi32_ss (__m128 a, int b)   CVTSI2SS xmm1,       r/m32  VCVTSI2SS xmm1, xmm2, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtsi32_ss (__m128 a, int b)   CVTSI2SS xmm1,       r/m32  VCVTSI2SS xmm1, xmm2, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvtss_si32 (__m128 a)   CVTSS2SI r32, xmm1/m32  VCVTSS2SI r32, xmm1/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvtss_si32 (__m128 a)   CVTSS2SI r32, xmm1/m32  VCVTSS2SI r32, xmm1/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvttss_si32 (__m128 a)   CVTTSS2SI r32, xmm1/m32  VCVTTSS2SI r32, xmm1/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvttss_si32 (__m128 a)   CVTTSS2SI r32, xmm1/m32  VCVTTSS2SI r32, xmm1/m32"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_div_ps (__m128 a,  __m128 b)   DIVPS xmm,                xmm2/m128  VDIVPS xmm1,         xmm2, xmm3/m128  VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_div_ps (__m128 a,  __m128 b)   DIVPS xmm,                xmm2/m128  VDIVPS xmm1,         xmm2, xmm3/m128  VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def divide_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_div_ss (__m128 a,  __m128 b)   DIVSs xmm1,       xmm2/m32  VDIVSs xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def divide_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_div_ss (__m128 a,  __m128 b)   DIVSS xmm1,       xmm2/m32  VDIVSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_load_ps (float const* mem_address)   MOVAPS xmm1,         m128  VMOVAPS xmm1,         m128  VMOVAPS xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_load_ps (float const* mem_address)   MOVAPS xmm1,         m128  VMOVAPS xmm1,         m128  VMOVAPS xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_high(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)   MOVHPS xmm1,       m64  VMOVHPS xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_high(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)   MOVHPS xmm1,       m64  VMOVHPS xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_low(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)   MOVLPS xmm1,       m64  VMOVLPS xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_low(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)   MOVLPS xmm1,       m64  VMOVLPS xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_load_ss (float const* mem_address)   MOVSS xmm1,      m32  VMOVSS xmm1,      m32  VMOVSS xmm1 {k1}, m32"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_load_ss (float const* mem_address)   MOVSS xmm1,      m32  VMOVSS xmm1,      m32  VMOVSS xmm1 {k1}, m32"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadu_ps (float const* mem_address)   MOVUPS xmm1,         m128  VMOVUPS xmm1,         m128  VMOVUPS xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_loadu_ps (float const* mem_address)   MOVUPS xmm1,         m128  VMOVUPS xmm1,         m128  VMOVUPS xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_max_ps (__m128 a,  __m128 b)   MAXPS xmm1,               xmm2/m128  VMAXPS xmm1,         xmm2, xmm3/m128  VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_max_ps (__m128 a,  __m128 b)   MAXPS xmm1,               xmm2/m128  VMAXPS xmm1,         xmm2, xmm3/m128  VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def max_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_max_ss (__m128 a,  __m128 b)   MAXSS xmm1,       xmm2/m32  VMAXSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def max_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_max_ss (__m128 a,  __m128 b)   MAXSS xmm1,       xmm2/m32  VMAXSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_min_ps (__m128 a,  __m128 b)   MINPS xmm1,               xmm2/m128  VMINPS xmm1,         xmm2, xmm3/m128  VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_min_ps (__m128 a,  __m128 b)   MINPS xmm1,               xmm2/m128  VMINPS xmm1,         xmm2, xmm3/m128  VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_min_ss (__m128 a,  __m128 b)   MINSS xmm1,       xmm2/m32  VMINSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def min_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_min_ss (__m128 a,  __m128 b)   MINSS xmm1,       xmm2/m32  VMINSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def move_high_to_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movehl_ps (__m128 a,  __m128 b)   MOVHLPS xmm1,       xmm2  VMOVHLPS xmm1, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_high_to_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movehl_ps (__m128 a,  __m128 b)   MOVHLPS xmm1,       xmm2  VMOVHLPS xmm1, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_low_to_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movelh_ps (__m128 a,  __m128 b)   MOVLHPS xmm1,       xmm2  VMOVLHPS xmm1, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_low_to_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movelh_ps (__m128 a,  __m128 b)   MOVLHPS xmm1,       xmm2  VMOVLHPS xmm1, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_movemask_ps (__m128 a)   MOVMSKPS r32, xmm1  VMOVMSKPS r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_movemask_ps (__m128 a)   MOVMSKPS r32, xmm1  VMOVMSKPS r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_move_ss (__m128 a, __m128 b)   MOVSS xmm1,         xmm2  VMOVSS xmm1,         xmm2, xmm3  VMOVSS xmm1 {k1}{z}, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_move_ss (__m128 a, __m128 b)   MOVSS xmm1,         xmm2  VMOVSS xmm1,         xmm2, xmm3  VMOVSS xmm1 {k1}{z}, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mul_ps (__m128 a, __m128 b)   MULPS xmm1,               xmm2/m128  VMULPS xmm1,         xmm2, xmm3/m128  VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mul_ps (__m128 a, __m128 b)   MULPS xmm1,               xmm2/m128  VMULPS xmm1,         xmm2, xmm3/m128  VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mul_ss (__m128 a, __m128 b)   MULSS xmm1,       xmm2/m32  VMULSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def multiply_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mul_ss (__m128 a, __m128 b)   MULSS xmm1,       xmm2/m32  VMULSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_or_ps (__m128 a,  __m128 b)   ORPS xmm1,               xmm2/m128  VORPS xmm1,         xmm2, xmm3/m128  VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_or_ps (__m128 a,  __m128 b)   ORPS xmm1,               xmm2/m128  VORPS xmm1,         xmm2, xmm3/m128  VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def prefetch_0(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT0 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_0(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT0 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_1(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT1 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_1(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT1 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_2(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT2 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_2(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHT2 m8"""
        ...

    @staticmethod
    @overload
    def prefetch_non_temporal(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHNTA m8"""
        ...

    @staticmethod
    @overload
    def prefetch_non_temporal(address: typing.Any) -> None:
        """void _mm_prefetch(char* p, int i)  PREFETCHNTA m8"""
        ...

    @staticmethod
    @overload
    def reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ps (__m128 a)   RCPPS xmm1, xmm2/m128  VRCPPS xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ps (__m128 a)   RCPPS xmm1, xmm2/m128  VRCPPS xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def reciprocal_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ss (__m128 a)   RCPSS xmm1,       xmm2/m32  VRCPSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def reciprocal_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ss (__m128 a, __m128 b)   RCPSS xmm1,       xmm2/m32  VRCPSS xmm1, xmm2, xmm3/m32The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def reciprocal_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ss (__m128 a)   RCPSS xmm1,       xmm2/m32  VRCPSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def reciprocal_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rcp_ss (__m128 a, __m128 b)   RCPSS xmm1,       xmm2/m32  VRCPSS xmm1, xmm2, xmm3/m32The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ps (__m128 a)   RSQRTPS xmm1, xmm2/m128  VRSQRTPS xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ps (__m128 a)   RSQRTPS xmm1, xmm2/m128  VRSQRTPS xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ss (__m128 a)   RSQRTSS xmm1,       xmm2/m32  VRSQRTSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ss (__m128 a, __m128 b)   RSQRTSS xmm1,       xmm2/m32  VRSQRTSS xmm1, xmm2, xmm3/m32The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ss (__m128 a)   RSQRTSS xmm1,       xmm2/m32  VRSQRTSS xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_rsqrt_ss (__m128 a, __m128 b)   RSQRTSS xmm1,       xmm2/m32  VRSQRTSS xmm1, xmm2, xmm3/m32The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)   SHUFPS xmm1,               xmm2/m128,         imm8  VSHUFPS xmm1,         xmm2, xmm3/m128,         imm8  VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)   SHUFPS xmm1,               xmm2/m128,         imm8  VSHUFPS xmm1,         xmm2, xmm3/m128,         imm8  VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ps (__m128 a)   SQRTPS xmm1,         xmm2/m128  VSQRTPS xmm1,         xmm2/m128  VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ps (__m128 a)   SQRTPS xmm1,         xmm2/m128  VSQRTPS xmm1,         xmm2/m128  VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ss (__m128 a)   SQRTSS xmm1,               xmm2/m32  VSQRTSS xmm1,         xmm2, xmm3/m32  VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ss (__m128 a, __m128 b)   SQRTSS xmm1,               xmm2/m32  VSQRTSS xmm1,         xmm2, xmm3/m32  VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ss (__m128 a)   SQRTSS xmm1,               xmm2/m32  VSQRTSS xmm1,         xmm2, xmm3/m32  VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sqrt_ss (__m128 a, __m128 b)   SQRTSS xmm1,               xmm2/m32  VSQRTSS xmm1,         xmm2, xmm3/m32  VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs."""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeu_ps (float* mem_addr, __m128 a)   MOVAPS m128,         xmm1  VMOVAPS m128,         xmm1  VMOVAPS m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeu_ps (float* mem_addr, __m128 a)   MOVUPS m128,         xmm1  VMOVUPS m128,         xmm1  VMOVUPS m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_ps (float* mem_addr, __m128 a)   MOVAPS m128,         xmm1  VMOVAPS m128,         xmm1  VMOVAPS m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_ps (float* mem_addr, __m128 a)   MOVAPS m128,         xmm1  VMOVAPS m128,         xmm1  VMOVAPS m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_stream_ps (float* mem_addr, __m128 a)   MOVNTPS m128, xmm1  VMOVNTPS m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_stream_ps (float* mem_addr, __m128 a)   MOVNTPS m128, xmm1  VMOVNTPS m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_fence() -> None:
        """void _mm_sfence(void)  SFENCE"""
        ...

    @staticmethod
    @overload
    def store_fence() -> None:
        """void _mm_sfence(void)  SFENCE"""
        ...

    @staticmethod
    @overload
    def store_high(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeh_pi (__m64* mem_addr, __m128 a)   MOVHPS m64, xmm1  VMOVHPS m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_high(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeh_pi (__m64* mem_addr, __m128 a)   MOVHPS m64, xmm1  VMOVHPS m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_low(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storel_pi (__m64* mem_addr, __m128 a)   MOVLPS m64, xmm1  VMOVLPS m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_low(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storel_pi (__m64* mem_addr, __m128 a)   MOVLPS m64, xmm1  VMOVLPS m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_ss (float* mem_addr, __m128 a)   MOVSS m32,      xmm1  VMOVSS m32,      xmm1  VMOVSS m32 {k1}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_ss (float* mem_addr, __m128 a)   MOVSS m32,      xmm1  VMOVSS m32,      xmm1  VMOVSS m32 {k1}, xmm1"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_ps (__m128d a, __m128d b)   SUBPS xmm1,               xmm2/m128  VSUBPS xmm1,         xmm2, xmm3/m128  VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_ps (__m128d a, __m128d b)   SUBPS xmm1,               xmm2/m128  VSUBPS xmm1,         xmm2, xmm3/m128  VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def subtract_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sub_ss (__m128 a, __m128 b)   SUBSS xmm1,               xmm2/m32  VSUBSS xmm1,         xmm2, xmm3/m32  VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def subtract_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_sub_ss (__m128 a, __m128 b)   SUBSS xmm1,               xmm2/m32  VSUBSS xmm1,         xmm2, xmm3/m32  VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_unpackhi_ps (__m128 a,  __m128 b)   UNPCKHPS xmm1,               xmm2/m128  VUNPCKHPS xmm1,         xmm2, xmm3/m128  VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_unpackhi_ps (__m128 a,  __m128 b)   UNPCKHPS xmm1,               xmm2/m128  VUNPCKHPS xmm1,         xmm2, xmm3/m128  VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_unpacklo_ps (__m128 a,  __m128 b)   UNPCKLPS xmm1,               xmm2/m128  VUNPCKLPS xmm1,         xmm2, xmm3/m128  VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_unpacklo_ps (__m128 a,  __m128 b)   UNPCKLPS xmm1,               xmm2/m128  VUNPCKLPS xmm1,         xmm2, xmm3/m128  VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_xor_ps (__m128 a,  __m128 b)   XORPS xmm1,               xmm2/m128  VXORPS xmm1,         xmm2, xmm3/m128  VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_xor_ps (__m128 a,  __m128 b)   XORPS xmm1,               xmm2/m128  VXORPS xmm1,         xmm2, xmm3/m128  VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...


class Sse2(System.Runtime.Intrinsics.X86.Sse, metaclass=abc.ABCMeta):
    """Provides access to X86 SSE2 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Sse.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSE2 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_cvtsi64_sd (__m128d a, __int64 b)   CVTSI2SD xmm1,       r/m64  VCVTSI2SD xmm1, xmm2, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_cvtsi64_sd (__m128d a, __int64 b)   CVTSI2SD xmm1,       r/m64  VCVTSI2SD xmm1, xmm2, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_int_64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsi64_si128 (__int64 a)   MOVQ xmm1, r/m64  VMOVQ xmm1, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_int_64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsi64_si128 (__int64 a)   MOVQ xmm1, r/m64  VMOVQ xmm1, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_u_int_64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsi64_si128 (__int64 a)   MOVQ xmm1, r/m64  VMOVQ xmm1, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_scalar_to_vector_128_u_int_64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsi64_si128 (__int64 a)   MOVQ xmm1, r/m64  VMOVQ xmm1, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """__int64 _mm_cvtsi128_si64 (__m128i a)   MOVQ r/m64, xmm1  VMOVQ r/m64, xmm1This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvtsd_si64 (__m128d a)   CVTSD2SI r64, xmm1/m64  VCVTSD2SI r64, xmm1/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """__int64 _mm_cvtsi128_si64 (__m128i a)   MOVQ r/m64, xmm1  VMOVQ r/m64, xmm1This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvtsd_si64 (__m128d a)   CVTSD2SI r64, xmm1/m64  VCVTSD2SI r64, xmm1/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvttsd_si64 (__m128d a)   CVTTSD2SI r64, xmm1/m64  VCVTTSD2SI r64, xmm1/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_int_64_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """__int64 _mm_cvttsd_si64 (__m128d a)   CVTTSD2SI r64, xmm1/m64  VCVTTSD2SI r64, xmm1/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_u_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """__int64 _mm_cvtsi128_si64 (__m128i a)   MOVQ r/m64, xmm1  VMOVQ r/m64, xmm1This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def convert_to_u_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """__int64 _mm_cvtsi128_si64 (__m128i a)   MOVQ r/m64, xmm1  VMOVQ r/m64, xmm1This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def store_non_temporal(address: typing.Any, value: int) -> None:
            """void _mm_stream_si64(__int64 *p, __int64 a)  MOVNTI m64, r64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def store_non_temporal(address: typing.Any, value: int) -> None:
            """void _mm_stream_si64(__int64 *p, __int64 a)  MOVNTI m64, r64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def store_non_temporal(address: typing.Any, value: int) -> None:
            """void _mm_stream_si64(__int64 *p, __int64 a)  MOVNTI m64, r64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def store_non_temporal(address: typing.Any, value: int) -> None:
            """void _mm_stream_si64(__int64 *p, __int64 a)  MOVNTI m64, r64This intrinsic is only available on 64-bit processes"""
            ...

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi8 (__m128i a,  __m128i b)   PADDB xmm1,               xmm2/m128  VPADDB xmm1,         xmm2, xmm3/m128  VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi8 (__m128i a,  __m128i b)   PADDB xmm1,               xmm2/m128  VPADDB xmm1,         xmm2, xmm3/m128  VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi16 (__m128i a,  __m128i b)   PADDW xmm1,               xmm2/m128  VPADDW xmm1,         xmm2, xmm3/m128  VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi16 (__m128i a,  __m128i b)   PADDW xmm1,               xmm2/m128  VPADDW xmm1,         xmm2, xmm3/m128  VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi32 (__m128i a,  __m128i b)   PADDD xmm1,               xmm2/m128  VPADDD xmm1,         xmm2, xmm3/m128  VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi32 (__m128i a,  __m128i b)   PADDD xmm1,               xmm2/m128  VPADDD xmm1,         xmm2, xmm3/m128  VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi64 (__m128i a,  __m128i b)   PADDQ xmm1,               xmm2/m128  VPADDQ xmm1,         xmm2, xmm3/m128  VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi64 (__m128i a,  __m128i b)   PADDQ xmm1,               xmm2/m128  VPADDQ xmm1,         xmm2, xmm3/m128  VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_add_pd (__m128d a,  __m128d b)   ADDPD xmm1,               xmm2/m128  VADDPD xmm1,         xmm2, xmm3/m128  VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi8 (__m128i a,  __m128i b)   PADDB xmm1,               xmm2/m128  VPADDB xmm1,         xmm2, xmm3/m128  VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi8 (__m128i a,  __m128i b)   PADDB xmm1,               xmm2/m128  VPADDB xmm1,         xmm2, xmm3/m128  VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi16 (__m128i a,  __m128i b)   PADDW xmm1,               xmm2/m128  VPADDW xmm1,         xmm2, xmm3/m128  VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi16 (__m128i a,  __m128i b)   PADDW xmm1,               xmm2/m128  VPADDW xmm1,         xmm2, xmm3/m128  VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi32 (__m128i a,  __m128i b)   PADDD xmm1,               xmm2/m128  VPADDD xmm1,         xmm2, xmm3/m128  VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi32 (__m128i a,  __m128i b)   PADDD xmm1,               xmm2/m128  VPADDD xmm1,         xmm2, xmm3/m128  VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi64 (__m128i a,  __m128i b)   PADDQ xmm1,               xmm2/m128  VPADDQ xmm1,         xmm2, xmm3/m128  VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_add_epi64 (__m128i a,  __m128i b)   PADDQ xmm1,               xmm2/m128  VPADDQ xmm1,         xmm2, xmm3/m128  VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_add_pd (__m128d a,  __m128d b)   ADDPD xmm1,               xmm2/m128  VADDPD xmm1,         xmm2, xmm3/m128  VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epi8 (__m128i a,  __m128i b)   PADDSB xmm1,               xmm2/m128  VPADDSB xmm1,         xmm2, xmm3/m128  VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epu8 (__m128i a,  __m128i b)   PADDUSB xmm1,               xmm2/m128  VPADDUSB xmm1,         xmm2, xmm3/m128  VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epi16 (__m128i a,  __m128i b)   PADDSW xmm1,               xmm2/m128  VPADDSW xmm1,         xmm2, xmm3/m128  VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epu16 (__m128i a,  __m128i b)   PADDUSW xmm1,               xmm2/m128  VPADDUSW xmm1,         xmm2, xmm3/m128  VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epi8 (__m128i a,  __m128i b)   PADDSB xmm1,               xmm2/m128  VPADDSB xmm1,         xmm2, xmm3/m128  VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epu8 (__m128i a,  __m128i b)   PADDUSB xmm1,               xmm2/m128  VPADDUSB xmm1,         xmm2, xmm3/m128  VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epi16 (__m128i a,  __m128i b)   PADDSW xmm1,               xmm2/m128  VPADDSW xmm1,         xmm2, xmm3/m128  VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_adds_epu16 (__m128i a,  __m128i b)   PADDUSW xmm1,               xmm2/m128  VPADDUSW xmm1,         xmm2, xmm3/m128  VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_add_sd (__m128d a,  __m128d b)   ADDSD xmm1,               xmm2/m64  VADDSD xmm1,         xmm2, xmm3/m64  VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def add_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_add_sd (__m128d a,  __m128d b)   ADDSD xmm1,               xmm2/m64  VADDSD xmm1,         xmm2, xmm3/m64  VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_and_pd (__m128d a, __m128d b)   ANDPD xmm1,               xmm2/m128  VANDPD xmm1,         xmm2, xmm3/m128  VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND xmm1,       xmm2/m128  VPAND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_and_si128 (__m128i a,  __m128i b)   PAND  xmm1,               xmm2/m128  VPAND  xmm1,         xmm2, xmm3/m128  VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_and_pd (__m128d a, __m128d b)   ANDPD xmm1,               xmm2/m128  VANDPD xmm1,         xmm2, xmm3/m128  VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_andnot_pd (__m128d a, __m128d b)   ANDNPD xmm1,               xmm2/m128  VANDNPD xmm1,         xmm2, xmm3/m128  VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN xmm1,       xmm2/m128  VPANDN xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_andnot_si128 (__m128i a,  __m128i b)   PANDN  xmm1,               xmm2/m128  VPANDN  xmm1,         xmm2, xmm3/m128  VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_andnot_pd (__m128d a, __m128d b)   ANDNPD xmm1,               xmm2/m128  VANDNPD xmm1,         xmm2, xmm3/m128  VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_avg_epu8 (__m128i a,  __m128i b)   PAVGB xmm1,               xmm2/m128  VPAVGB xmm1,         xmm2, xmm3/m128  VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_avg_epu16 (__m128i a,  __m128i b)   PAVGW xmm1,               xmm2/m128  VPAVGW xmm1,         xmm2, xmm3/m128  VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_avg_epu8 (__m128i a,  __m128i b)   PAVGB xmm1,               xmm2/m128  VPAVGB xmm1,         xmm2, xmm3/m128  VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_avg_epu16 (__m128i a,  __m128i b)   PAVGW xmm1,               xmm2/m128  VPAVGW xmm1,         xmm2, xmm3/m128  VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)   PCMPEQB xmm1,       xmm2/m128  VPCMPEQB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)   PCMPEQB xmm1,       xmm2/m128  VPCMPEQB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)   PCMPEQW xmm1,       xmm2/m128  VPCMPEQW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)   PCMPEQW xmm1,       xmm2/m128  VPCMPEQW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)   PCMPEQD xmm1,       xmm2/m128  VPCMPEQD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)   PCMPEQD xmm1,       xmm2/m128  VPCMPEQD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpeq_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(0)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)   PCMPEQB xmm1,       xmm2/m128  VPCMPEQB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)   PCMPEQB xmm1,       xmm2/m128  VPCMPEQB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)   PCMPEQW xmm1,       xmm2/m128  VPCMPEQW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)   PCMPEQW xmm1,       xmm2/m128  VPCMPEQW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)   PCMPEQD xmm1,       xmm2/m128  VPCMPEQD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)   PCMPEQD xmm1,       xmm2/m128  VPCMPEQD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpeq_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(0)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)   PCMPGTB xmm1,       xmm2/m128  VPCMPGTB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)   PCMPGTW xmm1,       xmm2/m128  VPCMPGTW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)   PCMPGTD xmm1,       xmm2/m128  VPCMPGTD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpgt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(1)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)   PCMPGTB xmm1,       xmm2/m128  VPCMPGTB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)   PCMPGTW xmm1,       xmm2/m128  VPCMPGTW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)   PCMPGTD xmm1,       xmm2/m128  VPCMPGTD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpgt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(1)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpge_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(2)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpge_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(2)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)   PCMPGTB xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTB xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)   PCMPGTW xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTW xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)   PCMPGTD xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTD xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmplt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(1)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)   PCMPGTB xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTB xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)   PCMPGTW xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTW xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)   PCMPGTD xmm1,       xmm2/m128    ; with swapped operands  VPCMPGTD xmm1, xmm2, xmm3/m128    ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmplt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(1)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmple_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(2)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmple_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(2)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpneq_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(4)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpneq_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(4)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpngt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(5)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpngt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(5)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnge_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(6)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnge_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(6)   ; with swapped operands  VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(5)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(5)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnle_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(6)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnle_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(6)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpord_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(7)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpord_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(7)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpeq_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(0)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpeq_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(0)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(0)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpgt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(1)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpgt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(1)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpge_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(2)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpge_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(2)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmplt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(1)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmplt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(1)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmple_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(2)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmple_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(2)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpneq_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(4)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpneq_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(4)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(4)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpngt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(5)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpngt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(5)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnge_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(6)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnge_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(6)   ; with swapped operands  VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)   ; with swapped operands"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(5)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(5)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnle_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(6)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpnle_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(6)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpord_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(7)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpord_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(7)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(7)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comieq_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=1 && PF=0  VCOMISD xmm1, xmm2/m64        ; ZF=1 && PF=0  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comieq_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=1 && PF=0  VCOMISD xmm1, xmm2/m64        ; ZF=1 && PF=0  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comigt_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=0 && CF=0  VCOMISD xmm1, xmm2/m64        ; ZF=0 && CF=0  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comigt_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=0 && CF=0  VCOMISD xmm1, xmm2/m64        ; ZF=0 && CF=0  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comige_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; CF=0  VCOMISD xmm1, xmm2/m64        ; CF=0  VCOMISD xmm1, xmm2/m64{sae}   ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comige_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; CF=0  VCOMISD xmm1, xmm2/m64        ; CF=0  VCOMISD xmm1, xmm2/m64{sae}   ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comilt_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; PF=0 && CF=1  VCOMISD xmm1, xmm2/m64        ; PF=0 && CF=1  VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comilt_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; PF=0 && CF=1  VCOMISD xmm1, xmm2/m64        ; PF=0 && CF=1  VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comile_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)  VCOMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)  VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comile_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)  VCOMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)  VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comineq_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=0 || PF=1  VCOMISD xmm1, xmm2/m64        ; ZF=0 || PF=1  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_ordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_comineq_sd (__m128d a, __m128d b)   COMISD xmm1, xmm2/m64        ; ZF=0 || PF=1  VCOMISD xmm1, xmm2/m64        ; ZF=0 || PF=1  VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpunord_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(3)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpunord_sd (__m128d a,  __m128d b)   CMPDS xmm1,       xmm2/m64, imm8(3)  VCMPDS xmm1, xmm2, xmm3/m64, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomieq_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0  VUCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomieq_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0  VUCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=1 && PF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomigt_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0  VUCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomigt_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0  VUCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomige_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; CF=0  VUCOMISD xmm1, xmm2/m64       ; CF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomige_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; CF=0  VUCOMISD xmm1, xmm2/m64       ; CF=0  VUCOMISD xmm1, xmm2/m64{sae}  ; CF=0"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomilt_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1  VUCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1  VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomilt_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1  VUCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1  VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && CF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomile_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)  VUCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)  VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomile_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)  VUCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)  VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && (ZF=1 || CF=1)"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomineq_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1  VUCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_scalar_unordered_not_equal(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_ucomineq_sd (__m128d a, __m128d b)   UCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1  VUCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1  VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 || PF=1"""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpunord_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(3)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(3)"""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmpunord_pd (__m128d a,  __m128d b)   CMPPD xmm1,       xmm2/m128, imm8(3)  VCMPPD xmm1, xmm2, xmm3/m128, imm8(3)"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtsi32_sd (__m128d a, int b)   CVTSI2SD xmm1,       r/m32  VCVTSI2SD xmm1, xmm2, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtss_sd (__m128d a, __m128 b)   CVTSS2SD xmm1,       xmm2/m32  VCVTSS2SD xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtsi32_sd (__m128d a, int b)   CVTSI2SD xmm1,       r/m32  VCVTSI2SD xmm1, xmm2, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtss_sd (__m128d a, __m128 b)   CVTSS2SD xmm1,       xmm2/m32  VCVTSS2SD xmm1, xmm2, xmm3/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_int_32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtsi32_si128 (int a)   MOVD xmm1, r/m32  VMOVD xmm1, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_int_32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtsi32_si128 (int a)   MOVD xmm1, r/m32  VMOVD xmm1, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtsd_ss (__m128 a, __m128d b)   CVTSD2SS xmm1,       xmm2/m64  VCVTSD2SS xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtsd_ss (__m128 a, __m128d b)   CVTSD2SS xmm1,       xmm2/m64  VCVTSD2SS xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_u_int_32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtsi32_si128 (int a)   MOVD xmm1, r/m32  VMOVD xmm1, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_scalar_to_vector_128_u_int_32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtsi32_si128 (int a)   MOVD xmm1, r/m32  VMOVD xmm1, r/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_cvtsi128_si32 (__m128i a)   MOVD r/m32, xmm1  VMOVD r/m32, xmm1"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvtsd_si32 (__m128d a)   CVTSD2SI r32, xmm1/m64  VCVTSD2SI r32, xmm1/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_cvtsi128_si32 (__m128i a)   MOVD r/m32, xmm1  VMOVD r/m32, xmm1"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvtsd_si32 (__m128d a)   CVTSD2SI r32, xmm1/m64  VCVTSD2SI r32, xmm1/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvttsd_si32 (__m128d a)   CVTTSD2SI r32, xmm1/m64  VCVTTSD2SI r32, xmm1/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_cvttsd_si32 (__m128d a)   CVTTSD2SI r32, xmm1/m64  VCVTTSD2SI r32, xmm1/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_cvtsi128_si32 (__m128i a)   MOVD r/m32, xmm1  VMOVD r/m32, xmm1"""
        ...

    @staticmethod
    @overload
    def convert_to_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_cvtsi128_si32 (__m128i a)   MOVD r/m32, xmm1  VMOVD r/m32, xmm1"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtepi32_pd (__m128i a)   CVTDQ2PD xmm1,         xmm2/m64  VCVTDQ2PD xmm1,         xmm2/m64  VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtps_pd (__m128 a)   CVTPS2PD xmm1,         xmm2/m64  VCVTPS2PD xmm1,         xmm2/m64  VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtepi32_pd (__m128i a)   CVTDQ2PD xmm1,         xmm2/m64  VCVTDQ2PD xmm1,         xmm2/m64  VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cvtps_pd (__m128 a)   CVTPS2PD xmm1,         xmm2/m64  VCVTPS2PD xmm1,         xmm2/m64  VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtps_epi32 (__m128 a)   CVTPS2DQ xmm1,         xmm2/m128  VCVTPS2DQ xmm1,         xmm2/m128  VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtpd_epi32 (__m128d a)   CVTPD2DQ xmm1,         xmm2/m128  VCVTPD2DQ xmm1,         xmm2/m128  VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtps_epi32 (__m128 a)   CVTPS2DQ xmm1,         xmm2/m128  VCVTPS2DQ xmm1,         xmm2/m128  VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtpd_epi32 (__m128d a)   CVTPD2DQ xmm1,         xmm2/m128  VCVTPD2DQ xmm1,         xmm2/m128  VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvttps_epi32 (__m128 a)   CVTTPS2DQ xmm1,         xmm2/m128  VCVTTPS2DQ xmm1,         xmm2/m128  VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvttpd_epi32 (__m128d a)   CVTTPD2DQ xmm1,         xmm2/m128  VCVTTPD2DQ xmm1,         xmm2/m128  VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvttps_epi32 (__m128 a)   CVTTPS2DQ xmm1,         xmm2/m128  VCVTTPS2DQ xmm1,         xmm2/m128  VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvttpd_epi32 (__m128d a)   CVTTPD2DQ xmm1,         xmm2/m128  VCVTTPD2DQ xmm1,         xmm2/m128  VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtepi32_ps (__m128i a)   CVTDQ2PS xmm1,         xmm2/m128  VCVTDQ2PS xmm1,         xmm2/m128  VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtpd_ps (__m128d a)   CVTPD2PS xmm1,         xmm2/m128  VCVTPD2PS xmm1,         xmm2/m128  VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtepi32_ps (__m128i a)   CVTDQ2PS xmm1,         xmm2/m128  VCVTDQ2PS xmm1,         xmm2/m128  VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cvtpd_ps (__m128d a)   CVTPD2PS xmm1,         xmm2/m128  VCVTPD2PS xmm1,         xmm2/m128  VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_div_pd (__m128d a,  __m128d b)   DIVPD xmm1,               xmm2/m128  VDIVPD xmm1,         xmm2, xmm3/m128  VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_div_pd (__m128d a,  __m128d b)   DIVPD xmm1,               xmm2/m128  VDIVPD xmm1,         xmm2, xmm3/m128  VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def divide_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_div_sd (__m128d a,  __m128d b)   DIVSD xmm1,       xmm2/m64  VDIVSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def divide_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_div_sd (__m128d a,  __m128d b)   DIVSD xmm1,       xmm2/m64  VDIVSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi16 (__m128i a,  int immediate)   PEXTRW r/m16, xmm1, imm8  VPEXTRW r/m16, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi16 (__m128i a,  int immediate)   PEXTRW r/m16, xmm1, imm8  VPEXTRW r/m16, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)   PINSRW xmm1,       r/m16, imm8  VPINSRW xmm1, xmm2, r/m16, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)   PINSRW xmm1,       r/m16, imm8  VPINSRW xmm1, xmm2, r/m16, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)   PINSRW xmm1,       r/m16, imm8  VPINSRW xmm1, xmm2, r/m16, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)   PINSRW xmm1,       r/m16, imm8  VPINSRW xmm1, xmm2, r/m16, imm8"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_load_pd (double const* mem_address)   MOVAPD xmm1,         m128  VMOVAPD xmm1,         m128  VMOVAPD xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)  MOVDQA xmm, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_load_si128 (__m128i const* mem_address)   MOVDQA   xmm1,         m128  VMOVDQA   xmm1,         m128  VMOVDQA64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_load_pd (double const* mem_address)   MOVAPD xmm1,         m128  VMOVAPD xmm1,         m128  VMOVAPD xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_fence() -> None:
        """void _mm_lfence(void)  LFENCE"""
        ...

    @staticmethod
    @overload
    def load_fence() -> None:
        """void _mm_lfence(void)  LFENCE"""
        ...

    @staticmethod
    @overload
    def load_high(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadh_pd (__m128d a, double const* mem_addr)   MOVHPD xmm1,       m64  VMOVHPD xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_high(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadh_pd (__m128d a, double const* mem_addr)   MOVHPD xmm1,       m64  VMOVHPD xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_low(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadl_pd (__m128d a, double const* mem_addr)   MOVLPD xmm1,       m64  VMOVLPD xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_low(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadl_pd (__m128d a, double const* mem_addr)   MOVLPD xmm1,       m64  VMOVLPD xmm1, xmm2, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si32 (void const* mem_addr)   MOVD xmm1, m32  VMOVD xmm1, m32"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si32 (void const* mem_addr)   MOVD xmm1, m32  VMOVD xmm1, m32"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadl_epi64 (__m128i const* mem_addr)   MOVQ xmm1, m64  VMOVQ xmm1, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadl_epi64 (__m128i const* mem_addr)   MOVQ xmm1, m64  VMOVQ xmm1, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_load_sd (double const* mem_address)   MOVSD xmm1,      m64  VMOVSD xmm1,      m64  VMOVSD xmm1 {k1}, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si32 (void const* mem_addr)   MOVD xmm1, m32  VMOVD xmm1, m32"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si32 (void const* mem_addr)   MOVD xmm1, m32  VMOVD xmm1, m32"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadl_epi64 (__m128i const* mem_addr)   MOVQ xmm1, m64  VMOVQ xmm1, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadl_epi64 (__m128i const* mem_addr)   MOVQ xmm1, m64  VMOVQ xmm1, m64"""
        ...

    @staticmethod
    @overload
    def load_scalar_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_load_sd (double const* mem_address)   MOVSD xmm1,      m64  VMOVSD xmm1,      m64  VMOVSD xmm1 {k1}, m64"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU  xmm1,         m128  VMOVDQU  xmm1,         m128  VMOVDQU8 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU  xmm1,         m128  VMOVDQU  xmm1,         m128  VMOVDQU8 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU16 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU16 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadu_pd (double const* mem_address)   MOVUPD xmm1,         m128  VMOVUPD xmm1,         m128  VMOVUPD xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU  xmm1,         m128  VMOVDQU  xmm1,         m128  VMOVDQU8 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU  xmm1,         m128  VMOVDQU  xmm1,         m128  VMOVDQU8 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU16 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU16 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU32 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_loadu_si128 (__m128i const* mem_address)   MOVDQU   xmm1,         m128  VMOVDQU   xmm1,         m128  VMOVDQU64 xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def load_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loadu_pd (double const* mem_address)   MOVUPD xmm1,         m128  VMOVUPD xmm1,         m128  VMOVUPD xmm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def mask_move(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)   MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI  VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI"""
        ...

    @staticmethod
    @overload
    def mask_move(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)   MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI  VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI"""
        ...

    @staticmethod
    @overload
    def mask_move(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)   MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI  VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI"""
        ...

    @staticmethod
    @overload
    def mask_move(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)   MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI  VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu8 (__m128i a,  __m128i b)   PMAXUB xmm1,               xmm2/m128  VPMAXUB xmm1,         xmm2, xmm3/m128  VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi16 (__m128i a,  __m128i b)   PMAXSW xmm1,               xmm2/m128  VPMAXSW xmm1,         xmm2, xmm3/m128  VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_max_pd (__m128d a,  __m128d b)   MAXPD xmm1,               xmm2/m128  VMAXPD xmm1,         xmm2, xmm3/m128  VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu8 (__m128i a,  __m128i b)   PMAXUB xmm1,               xmm2/m128  VPMAXUB xmm1,         xmm2, xmm3/m128  VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi16 (__m128i a,  __m128i b)   PMAXSW xmm1,               xmm2/m128  VPMAXSW xmm1,         xmm2, xmm3/m128  VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_max_pd (__m128d a,  __m128d b)   MAXPD xmm1,               xmm2/m128  VMAXPD xmm1,         xmm2, xmm3/m128  VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def max_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_max_sd (__m128d a,  __m128d b)   MAXSD xmm1,       xmm2/m64  VMAXSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def max_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_max_sd (__m128d a,  __m128d b)   MAXSD xmm1,       xmm2/m64  VMAXSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def memory_fence() -> None:
        """void _mm_mfence(void)  MFENCE"""
        ...

    @staticmethod
    @overload
    def memory_fence() -> None:
        """void _mm_mfence(void)  MFENCE"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu8 (__m128i a,  __m128i b)   PMINUB xmm1,               xmm2/m128  VPMINUB xmm1,         xmm2, xmm3/m128  VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi16 (__m128i a,  __m128i b)   PMINSW xmm1,               xmm2/m128  VPMINSW xmm1,         xmm2, xmm3/m128  VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_min_pd (__m128d a,  __m128d b)   MINPD xmm1,               xmm2/m128  VMINPD xmm1,         xmm2, xmm3/m128  VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu8 (__m128i a,  __m128i b)   PMINUB xmm1,               xmm2/m128  VPMINUB xmm1,         xmm2, xmm3/m128  VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi16 (__m128i a,  __m128i b)   PMINSW xmm1,               xmm2/m128  VPMINSW xmm1,         xmm2, xmm3/m128  VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_min_pd (__m128d a,  __m128d b)   MINPD xmm1,               xmm2/m128  VMINPD xmm1,         xmm2, xmm3/m128  VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def min_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_min_sd (__m128d a,  __m128d b)   MINSD xmm1,       xmm2/m64  VMINSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def min_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_min_sd (__m128d a,  __m128d b)   MINSD xmm1,       xmm2/m64  VMINSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_movemask_epi8 (__m128i a)   PMOVMSKB r32, xmm1  VPMOVMSKB r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_movemask_epi8 (__m128i a)   PMOVMSKB r32, xmm1  VPMOVMSKB r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_movemask_pd (__m128d a)   MOVMSKPD r32, xmm1  VMOVMSKPD r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_movemask_epi8 (__m128i a)   PMOVMSKB r32, xmm1  VPMOVMSKB r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """int _mm_movemask_epi8 (__m128i a)   PMOVMSKB r32, xmm1  VPMOVMSKB r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """int _mm_movemask_pd (__m128d a)   MOVMSKPD r32, xmm1  VMOVMSKPD r32, xmm1"""
        ...

    @staticmethod
    @overload
    def move_scalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_move_epi64 (__m128i a)   MOVQ xmm1, xmm2  VMOVQ xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def move_scalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_move_epi64 (__m128i a)   MOVQ xmm1, xmm2  VMOVQ xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def move_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_move_sd (__m128d a, __m128d b)   MOVSD xmm1,               xmm2  VMOVSD xmm1,         xmm2, xmm3  VMOVSD xmm1 {k1}{z}, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def move_scalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_move_epi64 (__m128i a)   MOVQ xmm1, xmm2  VMOVQ xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def move_scalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_move_epi64 (__m128i a)   MOVQ xmm1, xmm2  VMOVQ xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def move_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_move_sd (__m128d a, __m128d b)   MOVSD xmm1,               xmm2  VMOVSD xmm1,         xmm2, xmm3  VMOVSD xmm1 {k1}{z}, xmm2, xmm3"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mul_epu32 (__m128i a,  __m128i b)   PMULUDQ xmm1,               xmm2/m128  VPMULUDQ xmm1,         xmm2, xmm3/m128  VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mul_pd (__m128d a,  __m128d b)   MULPD xmm1,               xmm2/m128  VMULPD xmm1,         xmm2, xmm3/m128  VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mul_epu32 (__m128i a,  __m128i b)   PMULUDQ xmm1,               xmm2/m128  VPMULUDQ xmm1,         xmm2, xmm3/m128  VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mul_pd (__m128d a,  __m128d b)   MULPD xmm1,               xmm2/m128  VMULPD xmm1,         xmm2, xmm3/m128  VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_madd_epi16 (__m128i a,  __m128i b)   PMADDWD xmm1,               xmm2/m128  VPMADDWD xmm1,         xmm2, xmm3/m128  VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_madd_epi16 (__m128i a,  __m128i b)   PMADDWD xmm1,               xmm2/m128  VPMADDWD xmm1,         xmm2, xmm3/m128  VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)   PMULHW xmm1,               xmm2/m128  VPMULHW xmm1,         xmm2, xmm3/m128  VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)   PMULHUW xmm1,               xmm2/m128  VPMULHUW xmm1,         xmm2, xmm3/m128  VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)   PMULHW xmm1,               xmm2/m128  VPMULHW xmm1,         xmm2, xmm3/m128  VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)   PMULHUW xmm1,               xmm2/m128  VPMULHUW xmm1,         xmm2, xmm3/m128  VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi16 (__m128i a,  __m128i b)   PMULLW xmm1,               xmm2/m128  VPMULLW xmm1,         xmm2, xmm3/m128  VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi16 (__m128i a,  __m128i b)   PMULLW xmm1,               xmm2/m128  VPMULLW xmm1,         xmm2, xmm3/m128  VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi16 (__m128i a,  __m128i b)   PMULLW xmm1,               xmm2/m128  VPMULLW xmm1,         xmm2, xmm3/m128  VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi16 (__m128i a,  __m128i b)   PMULLW xmm1,               xmm2/m128  VPMULLW xmm1,         xmm2, xmm3/m128  VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mul_sd (__m128d a,  __m128d b)   MULSD xmm1,       xmm2/m64  VMULSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def multiply_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mul_sd (__m128d a,  __m128d b)   MULSD xmm1,       xmm2/m64  VMULSD xmm1, xmm2, xmm3/m64"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_or_pd (__m128d a,  __m128d b)   ORPD xmm1,               xmm2/m128  VORPD xmm1,         xmm2, xmm3/m128  VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR xmm1,       xmm2/m128  VPOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,       xmm2/m128  VPOR  xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_or_si128 (__m128i a,  __m128i b)   POR  xmm1,               xmm2/m128  VPOR  xmm1,         xmm2, xmm3/m128  VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_or_pd (__m128d a,  __m128d b)   ORPD xmm1,               xmm2/m128  VORPD xmm1,         xmm2, xmm3/m128  VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packs_epi16 (__m128i a,  __m128i b)   PACKSSWB xmm1,               xmm2/m128  VPACKSSWB xmm1,         xmm2, xmm3/m128  VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packs_epi32 (__m128i a,  __m128i b)   PACKSSDW xmm1,               xmm2/m128  VPACKSSDW xmm1,         xmm2, xmm3/m128  VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packs_epi16 (__m128i a,  __m128i b)   PACKSSWB xmm1,               xmm2/m128  VPACKSSWB xmm1,         xmm2, xmm3/m128  VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packs_epi32 (__m128i a,  __m128i b)   PACKSSDW xmm1,               xmm2/m128  VPACKSSDW xmm1,         xmm2, xmm3/m128  VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packus_epi16 (__m128i a,  __m128i b)   PACKUSWB xmm1,               xmm2/m128  VPACKUSWB xmm1,         xmm2, xmm3/m128  VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packus_epi16 (__m128i a,  __m128i b)   PACKUSWB xmm1,               xmm2/m128  VPACKUSWB xmm1,         xmm2, xmm3/m128  VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi16 (__m128i a, __m128i count)   PSLLW xmm1,               xmm2/m128  VPSLLW xmm1,         xmm2, xmm3/m128  VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi16 (__m128i a,  __m128i count)   PSLLW xmm1,               xmm2/m128  VPSLLW xmm1,         xmm2, xmm3/m128  VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi32 (__m128i a, __m128i count)   PSLLD xmm1,               xmm2/m128  VPSLLD xmm1,         xmm2, xmm3/m128  VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi32 (__m128i a, __m128i count)   PSLLD xmm1,               xmm2/m128  VPSLLD xmm1,         xmm2, xmm3/m128  VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi64 (__m128i a, __m128i count)   PSLLQ xmm1,               xmm2/m128  VPSLLQ xmm1,         xmm2, xmm3/m128  VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi64 (__m128i a, __m128i count)   PSLLQ xmm1,               xmm2/m128  VPSLLQ xmm1,         xmm2, xmm3/m128  VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi16 (__m128i a,  int immediate)   PSLLW xmm1,               imm8  VPSLLW xmm1,         xmm2, imm8  VPSLLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi16 (__m128i a,  int immediate)   PSLLW xmm1,               imm8  VPSLLW xmm1,         xmm2, imm8  VPSLLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi32 (__m128i a,  int immediate)   PSLLD xmm1,               imm8  VPSLLD xmm1,         xmm2, imm8  VPSLLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi32 (__m128i a,  int immediate)   PSLLD xmm1,               imm8  VPSLLD xmm1,         xmm2, imm8  VPSLLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi64 (__m128i a,  int immediate)   PSLLQ xmm1,               imm8  VPSLLQ xmm1,         xmm2, imm8  VPSLLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi64 (__m128i a,  int immediate)   PSLLQ xmm1,               imm8  VPSLLQ xmm1,         xmm2, imm8  VPSLLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi16 (__m128i a, __m128i count)   PSLLW xmm1,               xmm2/m128  VPSLLW xmm1,         xmm2, xmm3/m128  VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi16 (__m128i a,  __m128i count)   PSLLW xmm1,               xmm2/m128  VPSLLW xmm1,         xmm2, xmm3/m128  VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi32 (__m128i a, __m128i count)   PSLLD xmm1,               xmm2/m128  VPSLLD xmm1,         xmm2, xmm3/m128  VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi32 (__m128i a, __m128i count)   PSLLD xmm1,               xmm2/m128  VPSLLD xmm1,         xmm2, xmm3/m128  VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi64 (__m128i a, __m128i count)   PSLLQ xmm1,               xmm2/m128  VPSLLQ xmm1,         xmm2, xmm3/m128  VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sll_epi64 (__m128i a, __m128i count)   PSLLQ xmm1,               xmm2/m128  VPSLLQ xmm1,         xmm2, xmm3/m128  VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi16 (__m128i a,  int immediate)   PSLLW xmm1,               imm8  VPSLLW xmm1,         xmm2, imm8  VPSLLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi16 (__m128i a,  int immediate)   PSLLW xmm1,               imm8  VPSLLW xmm1,         xmm2, imm8  VPSLLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi32 (__m128i a,  int immediate)   PSLLD xmm1,               imm8  VPSLLD xmm1,         xmm2, imm8  VPSLLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi32 (__m128i a,  int immediate)   PSLLD xmm1,               imm8  VPSLLD xmm1,         xmm2, imm8  VPSLLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi64 (__m128i a,  int immediate)   PSLLQ xmm1,               imm8  VPSLLQ xmm1,         xmm2, imm8  VPSLLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_slli_epi64 (__m128i a,  int immediate)   PSLLQ xmm1,               imm8  VPSLLQ xmm1,         xmm2, imm8  VPSLLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bslli_si128 (__m128i a, int imm8)   PSLLDQ xmm1,            imm8  VPSLLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sra_epi16 (__m128i a, __m128i count)   PSRAW xmm1,               xmm2/m128  VPSRAW xmm1,         xmm2, xmm3/m128  VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sra_epi32 (__m128i a, __m128i count)   PSRAD xmm1,               xmm2/m128  VPSRAD xmm1,         xmm2, xmm3/m128  VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srai_epi16 (__m128i a,  int immediate)   PSRAW xmm1,               imm8  VPSRAW xmm1,         xmm2, imm8  VPSRAW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srai_epi32 (__m128i a,  int immediate)   PSRAD xmm1,               imm8  VPSRAD xmm1,         xmm2, imm8  VPSRAD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sra_epi16 (__m128i a, __m128i count)   PSRAW xmm1,               xmm2/m128  VPSRAW xmm1,         xmm2, xmm3/m128  VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sra_epi32 (__m128i a, __m128i count)   PSRAD xmm1,               xmm2/m128  VPSRAD xmm1,         xmm2, xmm3/m128  VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srai_epi16 (__m128i a,  int immediate)   PSRAW xmm1,               imm8  VPSRAW xmm1,         xmm2, imm8  VPSRAW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srai_epi32 (__m128i a,  int immediate)   PSRAD xmm1,               imm8  VPSRAD xmm1,         xmm2, imm8  VPSRAD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi16 (__m128i a, __m128i count)   PSRLW xmm1,               xmm2/m128  VPSRLW xmm1,         xmm2, xmm3/m128  VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi16 (__m128i a, __m128i count)   PSRLW xmm1,               xmm2/m128  VPSRLW xmm1,         xmm2, xmm3/m128  VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi32 (__m128i a, __m128i count)   PSRLD xmm1,               xmm2/m128  VPSRLD xmm1,         xmm2, xmm3/m128  VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi32 (__m128i a, __m128i count)   PSRLD xmm1,               xmm2/m128  VPSRLD xmm1,         xmm2, xmm3/m128  VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi64 (__m128i a, __m128i count)   PSRLQ xmm1,               xmm2/m128  VPSRLQ xmm1,         xmm2, xmm3/m128  VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi64 (__m128i a, __m128i count)   PSRLQ xmm1,               xmm2/m128  VPSRLQ xmm1,         xmm2, xmm3/m128  VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi16 (__m128i a,  int immediate)   PSRLW xmm1,               imm8  VPSRLW xmm1,         xmm2, imm8  VPSRLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi16 (__m128i a,  int immediate)   PSRLW xmm1,               imm8  VPSRLW xmm1,         xmm2, imm8  VPSRLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi32 (__m128i a,  int immediate)   PSRLD xmm1,               imm8  VPSRLD xmm1,         xmm2, imm8  VPSRLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi32 (__m128i a,  int immediate)   PSRLD xmm1,               imm8  VPSRLD xmm1,         xmm2, imm8  VPSRLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi64 (__m128i a,  int immediate)   PSRLQ xmm1,               imm8  VPSRLQ xmm1,         xmm2, imm8  VPSRLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi64 (__m128i a,  int immediate)   PSRLQ xmm1,               imm8  VPSRLQ xmm1,         xmm2, imm8  VPSRLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi16 (__m128i a, __m128i count)   PSRLW xmm1,               xmm2/m128  VPSRLW xmm1,         xmm2, xmm3/m128  VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi16 (__m128i a, __m128i count)   PSRLW xmm1,               xmm2/m128  VPSRLW xmm1,         xmm2, xmm3/m128  VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi32 (__m128i a, __m128i count)   PSRLD xmm1,               xmm2/m128  VPSRLD xmm1,         xmm2, xmm3/m128  VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi32 (__m128i a, __m128i count)   PSRLD xmm1,               xmm2/m128  VPSRLD xmm1,         xmm2, xmm3/m128  VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi64 (__m128i a, __m128i count)   PSRLQ xmm1,               xmm2/m128  VPSRLQ xmm1,         xmm2, xmm3/m128  VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srl_epi64 (__m128i a, __m128i count)   PSRLQ xmm1,               xmm2/m128  VPSRLQ xmm1,         xmm2, xmm3/m128  VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi16 (__m128i a,  int immediate)   PSRLW xmm1,               imm8  VPSRLW xmm1,         xmm2, imm8  VPSRLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi16 (__m128i a,  int immediate)   PSRLW xmm1,               imm8  VPSRLW xmm1,         xmm2, imm8  VPSRLW xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi32 (__m128i a,  int immediate)   PSRLD xmm1,               imm8  VPSRLD xmm1,         xmm2, imm8  VPSRLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi32 (__m128i a,  int immediate)   PSRLD xmm1,               imm8  VPSRLD xmm1,         xmm2, imm8  VPSRLD xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi64 (__m128i a,  int immediate)   PSRLQ xmm1,               imm8  VPSRLQ xmm1,         xmm2, imm8  VPSRLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srli_epi64 (__m128i a,  int immediate)   PSRLQ xmm1,               imm8  VPSRLQ xmm1,         xmm2, imm8  VPSRLQ xmm1 {k1}{z}, xmm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector128[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_bsrli_si128 (__m128i a, int imm8)   PSRLDQ xmm1,            imm8  VPSRLDQ xmm1, xmm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi32 (__m128i a,  int immediate)   PSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi32 (__m128i a,  int immediate)   PSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)   SHUFPD xmm1,               xmm2/m128,         imm8  VSHUFPD xmm1,         xmm2, xmm3/m128,         imm8  VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi32 (__m128i a,  int immediate)   PSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi32 (__m128i a,  int immediate)   PSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1,         xmm2/m128,         imm8  VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)   SHUFPD xmm1,               xmm2/m128,         imm8  VSHUFPD xmm1,         xmm2, xmm3/m128,         imm8  VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)   PSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflehi_epi16 (__m128i a,  int control)   PSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)   PSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflehi_epi16 (__m128i a,  int control)   PSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1,         xmm2/m128, imm8  VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflelo_epi16 (__m128i a,  int control)   PSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflelo_epi16 (__m128i a,  int control)   PSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflelo_epi16 (__m128i a,  int control)   PSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shufflelo_epi16 (__m128i a,  int control)   PSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1,         xmm2/m128, imm8  VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_pd (__m128d a)   SQRTPD xmm1,         xmm2/m128  VSQRTPD xmm1,         xmm2/m128  VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_pd (__m128d a)   SQRTPD xmm1,         xmm2/m128  VSQRTPD xmm1,         xmm2/m128  VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_sd (__m128d a)   SQRTSD xmm1,               xmm2/m64  VSQRTSD xmm1,         xmm2, xmm3/m64  VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_sd (__m128d a, __m128d b)   SQRTSD xmm1,               xmm2/m64  VSQRTSD xmm1,         xmm2, xmm3/m64  VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_sd (__m128d a)   SQRTSD xmm1,               xmm2/m64  VSQRTSD xmm1,         xmm2, xmm3/m64  VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def sqrt_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sqrt_sd (__m128d a, __m128d b)   SQRTSD xmm1,               xmm2/m64  VSQRTSD xmm1,         xmm2, xmm3/m64  VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU  m128,         xmm1  VMOVDQU  m128,         xmm1  VMOVDQU8 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU  m128,         xmm1  VMOVDQU  m128,         xmm1  VMOVDQU8 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU16 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU16 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeu_pd (double* mem_addr, __m128d a)   MOVUPD m128,         xmm1  VMOVUPD m128,         xmm1  VMOVUPD m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU  m128,         xmm1  VMOVDQU  m128,         xmm1  VMOVDQU8 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU  m128,         xmm1  VMOVDQU  m128,         xmm1  VMOVDQU8 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU16 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU16 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)   MOVDQU   m128,         xmm1  VMOVDQU   m128,         xmm1  VMOVDQU64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeu_pd (double* mem_addr, __m128d a)   MOVAPD m128,         xmm1  VMOVAPD m128,         xmm1  VMOVAPD m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_pd (double* mem_addr, __m128d a)   MOVAPD m128,         xmm1  VMOVAPD m128,         xmm1  VMOVAPD m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA32 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_store_si128 (__m128i* mem_addr, __m128i a)   MOVDQA   m128,         xmm1  VMOVDQA   m128,         xmm1  VMOVDQA64 m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_pd (double* mem_addr, __m128d a)   MOVAPD m128,         xmm1  VMOVAPD m128,         xmm1  VMOVAPD m128 {k1}{z}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_stream_pd (double* mem_addr, __m128d a)   MOVNTPD m128, xmm1  VMOVNTPD m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_stream_si128 (__m128i* mem_addr, __m128i a)   MOVNTDQ m128, xmm1  VMOVNTDQ m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_stream_pd (double* mem_addr, __m128d a)   MOVNTPD m128, xmm1  VMOVNTPD m128, xmm1"""
        ...

    @staticmethod
    @overload
    def store_high(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeh_pd (double* mem_addr, __m128d a)   MOVHPD m64, xmm1  VMOVHPD m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_high(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storeh_pd (double* mem_addr, __m128d a)   MOVHPD m64, xmm1  VMOVHPD m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_low(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storel_pd (double* mem_addr, __m128d a)   MOVLPD m64, xmm1  VMOVLPD m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_low(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_storel_pd (double* mem_addr, __m128d a)   MOVLPD m64, xmm1  VMOVLPD m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_non_temporal(address: typing.Any, value: int) -> None:
        """void _mm_stream_si32(int *p, int a)  MOVNTI m32, r32"""
        ...

    @staticmethod
    @overload
    def store_non_temporal(address: typing.Any, value: int) -> None:
        """void _mm_stream_si32(int *p, int a)  MOVNTI m32, r32"""
        ...

    @staticmethod
    @overload
    def store_non_temporal(address: typing.Any, value: int) -> None:
        """void _mm_stream_si32(int *p, int a)  MOVNTI m32, r32"""
        ...

    @staticmethod
    @overload
    def store_non_temporal(address: typing.Any, value: int) -> None:
        """void _mm_stream_si32(int *p, int a)  MOVNTI m32, r32"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si32 (void* mem_addr, __m128i a)   MOVD m32, xmm1  VMOVD m32, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si32 (void* mem_addr, __m128i a)   MOVD m32, xmm1  VMOVD m32, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)   MOVQ m64, xmm1  VMOVQ m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)   MOVQ m64, xmm1  VMOVQ m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_sd (double* mem_addr, __m128d a)   MOVSD m64,      xmm1  VMOVSD m64,      xmm1  VMOVSD m64 {k1}, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si32 (void* mem_addr, __m128i a)   MOVD m32, xmm1  VMOVD m32, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storeu_si32 (void* mem_addr, __m128i a)   MOVD m32, xmm1  VMOVD m32, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)   MOVQ m64, xmm1  VMOVQ m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)   MOVQ m64, xmm1  VMOVQ m64, xmm1"""
        ...

    @staticmethod
    @overload
    def store_scalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_store_sd (double* mem_addr, __m128d a)   MOVSD m64,      xmm1  VMOVSD m64,      xmm1  VMOVSD m64 {k1}, xmm1"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi8 (__m128i a,  __m128i b)   PSUBB xmm1,               xmm2/m128  VPSUBB xmm1,         xmm2, xmm3/m128  VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi8 (__m128i a,  __m128i b)   PSUBB xmm1,               xmm2/m128  VPSUBB xmm1,         xmm2, xmm3/m128  VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi16 (__m128i a,  __m128i b)   PSUBW xmm1,               xmm2/m128  VPSUBW xmm1,         xmm2, xmm3/m128  VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi16 (__m128i a,  __m128i b)   PSUBW xmm1,               xmm2/m128  VPSUBW xmm1,         xmm2, xmm3/m128  VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi32 (__m128i a,  __m128i b)   PSUBD xmm1,               xmm2/m128  VPSUBD xmm1,         xmm2, xmm3/m128  VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi32 (__m128i a,  __m128i b)   PSUBD xmm1,               xmm2/m128  VPSUBD xmm1,         xmm2, xmm3/m128  VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi64 (__m128i a,  __m128i b)   PSUBQ xmm1,               xmm2/m128  VPSUBQ xmm1,         xmm2, xmm3/m128  VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi64 (__m128i a,  __m128i b)   PSUBQ xmm1,               xmm2/m128  VPSUBQ xmm1,         xmm2, xmm3/m128  VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_pd (__m128d a, __m128d b)   SUBPD xmm1,               xmm2/m128  VSUBPD xmm1,         xmm2, xmm3/m128  VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi8 (__m128i a,  __m128i b)   PSUBB xmm1,               xmm2/m128  VPSUBB xmm1,         xmm2, xmm3/m128  VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi8 (__m128i a,  __m128i b)   PSUBB xmm1,               xmm2/m128  VPSUBB xmm1,         xmm2, xmm3/m128  VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi16 (__m128i a,  __m128i b)   PSUBW xmm1,               xmm2/m128  VPSUBW xmm1,         xmm2, xmm3/m128  VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi16 (__m128i a,  __m128i b)   PSUBW xmm1,               xmm2/m128  VPSUBW xmm1,         xmm2, xmm3/m128  VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi32 (__m128i a,  __m128i b)   PSUBD xmm1,               xmm2/m128  VPSUBD xmm1,         xmm2, xmm3/m128  VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi32 (__m128i a,  __m128i b)   PSUBD xmm1,               xmm2/m128  VPSUBD xmm1,         xmm2, xmm3/m128  VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi64 (__m128i a,  __m128i b)   PSUBQ xmm1,               xmm2/m128  VPSUBQ xmm1,         xmm2, xmm3/m128  VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sub_epi64 (__m128i a,  __m128i b)   PSUBQ xmm1,               xmm2/m128  VPSUBQ xmm1,         xmm2, xmm3/m128  VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_pd (__m128d a, __m128d b)   SUBPD xmm1,               xmm2/m128  VSUBPD xmm1,         xmm2, xmm3/m128  VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epi8 (__m128i a,  __m128i b)   PSUBSB xmm1,               xmm2/m128  VPSUBSB xmm1,         xmm2, xmm3/m128  VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epi16 (__m128i a,  __m128i b)   PSUBSW xmm1,               xmm2/m128  VPSUBSW xmm1,         xmm2, xmm3/m128  VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epu8 (__m128i a,  __m128i b)   PSUBUSB xmm1,               xmm2/m128  VPSUBUSB xmm1,         xmm2, xmm3/m128  VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epu16 (__m128i a,  __m128i b)   PSUBUSW xmm1,               xmm2/m128  VPSUBUSW xmm1,         xmm2, xmm3/m128  VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epi8 (__m128i a,  __m128i b)   PSUBSB xmm1,               xmm2/m128  VPSUBSB xmm1,         xmm2, xmm3/m128  VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epi16 (__m128i a,  __m128i b)   PSUBSW xmm1,               xmm2/m128  VPSUBSW xmm1,         xmm2, xmm3/m128  VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epu8 (__m128i a,  __m128i b)   PSUBUSB xmm1,               xmm2/m128  VPSUBUSB xmm1,         xmm2, xmm3/m128  VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_subs_epu16 (__m128i a,  __m128i b)   PSUBUSW xmm1,               xmm2/m128  VPSUBUSW xmm1,         xmm2, xmm3/m128  VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_sd (__m128d a, __m128d b)   SUBSD xmm1,               xmm2/m64  VSUBSD xmm1,         xmm2, xmm3/m64  VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def subtract_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_sub_sd (__m128d a, __m128d b)   SUBSD xmm1,               xmm2/m64  VSUBSD xmm1,         xmm2, xmm3/m64  VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}"""
        ...

    @staticmethod
    @overload
    def sum_absolute_differences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sad_epu8 (__m128i a,  __m128i b)   PSADBW xmm1,               xmm2/m128  VPSADBW xmm1,         xmm2, xmm3/m128  VPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sum_absolute_differences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sad_epu8 (__m128i a,  __m128i b)   PSADBW xmm1,               xmm2/m128  VPSADBW xmm1,         xmm2, xmm3/m128  VPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)   PUNPCKHBW xmm1,               xmm2/m128  VPUNPCKHBW xmm1,         xmm2, xmm3/m128  VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)   PUNPCKHBW xmm1,               xmm2/m128  VPUNPCKHBW xmm1,         xmm2, xmm3/m128  VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)   PUNPCKHWD xmm1,               xmm2/m128  VPUNPCKHWD xmm1,         xmm2, xmm3/m128  VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)   PUNPCKHWD xmm1,               xmm2/m128  VPUNPCKHWD xmm1,         xmm2, xmm3/m128  VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)   PUNPCKHDQ xmm1,               xmm2/m128  VPUNPCKHDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)   PUNPCKHDQ xmm1,               xmm2/m128  VPUNPCKHDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)   PUNPCKHQDQ xmm1,               xmm2/m128  VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)   PUNPCKHQDQ xmm1,               xmm2/m128  VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_unpackhi_pd (__m128d a,  __m128d b)   UNPCKHPD xmm1,               xmm2/m128  VUNPCKHPD xmm1,         xmm2, xmm3/m128  VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)   PUNPCKHBW xmm1,               xmm2/m128  VPUNPCKHBW xmm1,         xmm2, xmm3/m128  VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)   PUNPCKHBW xmm1,               xmm2/m128  VPUNPCKHBW xmm1,         xmm2, xmm3/m128  VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)   PUNPCKHWD xmm1,               xmm2/m128  VPUNPCKHWD xmm1,         xmm2, xmm3/m128  VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)   PUNPCKHWD xmm1,               xmm2/m128  VPUNPCKHWD xmm1,         xmm2, xmm3/m128  VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)   PUNPCKHDQ xmm1,               xmm2/m128  VPUNPCKHDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)   PUNPCKHDQ xmm1,               xmm2/m128  VPUNPCKHDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)   PUNPCKHQDQ xmm1,               xmm2/m128  VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)   PUNPCKHQDQ xmm1,               xmm2/m128  VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_unpackhi_pd (__m128d a,  __m128d b)   UNPCKHPD xmm1,               xmm2/m128  VUNPCKHPD xmm1,         xmm2, xmm3/m128  VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)   PUNPCKLBW xmm1,               xmm2/m128  VPUNPCKLBW xmm1,         xmm2, xmm3/m128  VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)   PUNPCKLBW xmm1,               xmm2/m128  VPUNPCKLBW xmm1,         xmm2, xmm3/m128  VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)   PUNPCKLWD xmm1,               xmm2/m128  VPUNPCKLWD xmm1,         xmm2, xmm3/m128  VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)   PUNPCKLWD xmm1,               xmm2/m128  VPUNPCKLWD xmm1,         xmm2, xmm3/m128  VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)   PUNPCKLDQ xmm1,               xmm2/m128  VPUNPCKLDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)   PUNPCKLDQ xmm1,               xmm2/m128  VPUNPCKLDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)   PUNPCKLQDQ xmm1,               xmm2/m128  VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)   PUNPCKLQDQ xmm1,               xmm2/m128  VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_unpacklo_pd (__m128d a,  __m128d b)   UNPCKLPD xmm1,               xmm2/m128  VUNPCKLPD xmm1,         xmm2, xmm3/m128  VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)   PUNPCKLBW xmm1,               xmm2/m128  VPUNPCKLBW xmm1,         xmm2, xmm3/m128  VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)   PUNPCKLBW xmm1,               xmm2/m128  VPUNPCKLBW xmm1,         xmm2, xmm3/m128  VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)   PUNPCKLWD xmm1,               xmm2/m128  VPUNPCKLWD xmm1,         xmm2, xmm3/m128  VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)   PUNPCKLWD xmm1,               xmm2/m128  VPUNPCKLWD xmm1,         xmm2, xmm3/m128  VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)   PUNPCKLDQ xmm1,               xmm2/m128  VPUNPCKLDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)   PUNPCKLDQ xmm1,               xmm2/m128  VPUNPCKLDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)   PUNPCKLQDQ xmm1,               xmm2/m128  VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)   PUNPCKLQDQ xmm1,               xmm2/m128  VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128  VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_unpacklo_pd (__m128d a,  __m128d b)   UNPCKLPD xmm1,               xmm2/m128  VUNPCKLPD xmm1,         xmm2, xmm3/m128  VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_xor_pd (__m128d a,  __m128d b)   XORPD xmm1,               xmm2/m128  VXORPD xmm1,         xmm2, xmm3/m128  VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR xmm1,       xmm2/m128  VPXOR xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_xor_si128 (__m128i a,  __m128i b)   PXOR  xmm1,               xmm2/m128  VPXOR  xmm1,         xmm2, xmm3/m128  VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_xor_pd (__m128d a,  __m128d b)   XORPD xmm1,               xmm2/m128  VXORPD xmm1,         xmm2, xmm3/m128  VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...


class Sse3(System.Runtime.Intrinsics.X86.Sse2, metaclass=abc.ABCMeta):
    """Provides access to X86 SSE3 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Sse2.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSE3 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_addsub_ps (__m128 a, __m128 b)   ADDSUBPS xmm1,       xmm2/m128  VADDSUBPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_addsub_pd (__m128d a, __m128d b)   ADDSUBPD xmm1,       xmm2/m128  VADDSUBPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_addsub_ps (__m128 a, __m128 b)   ADDSUBPS xmm1,       xmm2/m128  VADDSUBPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_addsub_pd (__m128d a, __m128d b)   ADDSUBPD xmm1,       xmm2/m128  VADDSUBPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_hadd_ps (__m128 a, __m128 b)   HADDPS xmm1,       xmm2/m128  VHADDPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_hadd_pd (__m128d a, __m128d b)   HADDPD xmm1,       xmm2/m128  VHADDPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_hadd_ps (__m128 a, __m128 b)   HADDPS xmm1,       xmm2/m128  VHADDPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_hadd_pd (__m128d a, __m128d b)   HADDPD xmm1,       xmm2/m128  VHADDPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_hsub_ps (__m128 a, __m128 b)   HSUBPS xmm1,       xmm2/m128  VHSUBPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_hsub_pd (__m128d a, __m128d b)   HSUBPD xmm1,       xmm2/m128  VHSUBPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_hsub_ps (__m128 a, __m128 b)   HSUBPS xmm1,       xmm2/m128  VHSUBPS xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_hsub_pd (__m128d a, __m128d b)   HSUBPD xmm1,       xmm2/m128  VHSUBPD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def load_and_duplicate_to_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loaddup_pd (double const* mem_addr)   MOVDDUP xmm1,         m64  VMOVDDUP xmm1,         m64  VMOVDDUP xmm1 {k1}{z}, m64"""
        ...

    @staticmethod
    @overload
    def load_and_duplicate_to_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_loaddup_pd (double const* mem_addr)   MOVDDUP xmm1,         m64  VMOVDDUP xmm1,         m64  VMOVDDUP xmm1 {k1}{z}, m64"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_lddqu_si128 (__m128i const* mem_addr)   LDDQU xmm1, m128  VLDDQU xmm1, m128"""
        ...

    @staticmethod
    @overload
    def move_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_movedup_pd (__m128d a)   MOVDDUP xmm1,         xmm2/m64  VMOVDDUP xmm1,         xmm2/m64  VMOVDDUP xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def move_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_movedup_pd (__m128d a)   MOVDDUP xmm1,         xmm2/m64  VMOVDDUP xmm1,         xmm2/m64  VMOVDDUP xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def move_high_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movehdup_ps (__m128 a)   MOVSHDUP xmm1,         xmm2/m128  VMOVSHDUP xmm1,         xmm2/m128  VMOVSHDUP xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def move_high_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_movehdup_ps (__m128 a)   MOVSHDUP xmm1,         xmm2/m128  VMOVSHDUP xmm1,         xmm2/m128  VMOVSHDUP xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def move_low_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_moveldup_ps (__m128 a)   MOVSLDUP xmm1,         xmm2/m128  VMOVSLDUP xmm1,         xmm2/m128  VMOVSLDUP xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def move_low_and_duplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_moveldup_ps (__m128 a)   MOVSLDUP xmm1,         xmm2/m128  VMOVSLDUP xmm1,         xmm2/m128  VMOVSLDUP xmm1 {k1}{z}, xmm2/m128"""
        ...


class Ssse3(System.Runtime.Intrinsics.X86.Sse3, metaclass=abc.ABCMeta):
    """Provides access to X86 SSSE3 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Sse3.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSSE3 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi8 (__m128i a)   PABSB xmm1,         xmm2/m128  VPABSB xmm1,         xmm2/m128  VPABSB xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi16 (__m128i a)   PABSW xmm1,         xmm2/m128  VPABSW xmm1,         xmm2/m128  VPABSW xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi32 (__m128i a)   PABSD xmm1,         xmm2/m128  VPABSD xmm1,         xmm2/m128  VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi8 (__m128i a)   PABSB xmm1,         xmm2/m128  VPABSB xmm1,         xmm2/m128  VPABSB xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi16 (__m128i a)   PABSW xmm1,         xmm2/m128  VPABSW xmm1,         xmm2/m128  VPABSW xmm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_abs_epi32 (__m128i a)   PABSD xmm1,         xmm2/m128  VPABSD xmm1,         xmm2/m128  VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)   PALIGNR xmm1,               xmm2/m128, imm8  VPALIGNR xmm1,         xmm2, xmm3/m128, imm8  VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadd_epi16 (__m128i a, __m128i b)   PHADDW xmm1,       xmm2/m128  VPHADDW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadd_epi32 (__m128i a, __m128i b)   PHADDD xmm1,       xmm2/m128  VPHADDD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadd_epi16 (__m128i a, __m128i b)   PHADDW xmm1,       xmm2/m128  VPHADDW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadd_epi32 (__m128i a, __m128i b)   PHADDD xmm1,       xmm2/m128  VPHADDD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadds_epi16 (__m128i a, __m128i b)   PHADDSW xmm1,       xmm2/m128  VPHADDSW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_add_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hadds_epi16 (__m128i a, __m128i b)   PHADDSW xmm1,       xmm2/m128  VPHADDSW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsub_epi16 (__m128i a, __m128i b)   PHSUBW xmm1,       xmm2/m128  VPHSUBW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsub_epi32 (__m128i a, __m128i b)   PHSUBD xmm1,       xmm2/m128  VPHSUBD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsub_epi16 (__m128i a, __m128i b)   PHSUBW xmm1,       xmm2/m128  VPHSUBW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsub_epi32 (__m128i a, __m128i b)   PHSUBD xmm1,       xmm2/m128  VPHSUBD xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsubs_epi16 (__m128i a, __m128i b)   PHSUBSW xmm1,       xmm2/m128  VPHSUBSW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_hsubs_epi16 (__m128i a, __m128i b)   PHSUBSW xmm1,       xmm2/m128  VPHSUBSW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maddubs_epi16 (__m128i a, __m128i b)   PMADDUBSW xmm1,               xmm2/m128  VPMADDUBSW xmm1,         xmm2, xmm3/m128  VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maddubs_epi16 (__m128i a, __m128i b)   PMADDUBSW xmm1,               xmm2/m128  VPMADDUBSW xmm1,         xmm2, xmm3/m128  VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high_round_scale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)   PMULHRSW xmm1,               xmm2/m128  VPMULHRSW xmm1,         xmm2, xmm3/m128  VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def multiply_high_round_scale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)   PMULHRSW xmm1,               xmm2/m128  VPMULHRSW xmm1,         xmm2, xmm3/m128  VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi8 (__m128i a, __m128i b)   PSHUFB xmm1,               xmm2/m128  VPSHUFB xmm1,         xmm2, xmm3/m128  VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi8 (__m128i a, __m128i b)   PSHUFB xmm1,               xmm2/m128  VPSHUFB xmm1,         xmm2, xmm3/m128  VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi8 (__m128i a, __m128i b)   PSHUFB xmm1,               xmm2/m128  VPSHUFB xmm1,         xmm2, xmm3/m128  VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_shuffle_epi8 (__m128i a, __m128i b)   PSHUFB xmm1,               xmm2/m128  VPSHUFB xmm1,         xmm2, xmm3/m128  VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi8 (__m128i a, __m128i b)   PSIGNB xmm1,       xmm2/m128  VPSIGNB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi16 (__m128i a, __m128i b)   PSIGNW xmm1,       xmm2/m128  VPSIGNW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi32 (__m128i a, __m128i b)   PSIGND xmm1,       xmm2/m128  VPSIGND xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi8 (__m128i a, __m128i b)   PSIGNB xmm1,       xmm2/m128  VPSIGNB xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi16 (__m128i a, __m128i b)   PSIGNW xmm1,       xmm2/m128  VPSIGNW xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sign_epi32 (__m128i a, __m128i b)   PSIGND xmm1,       xmm2/m128  VPSIGND xmm1, xmm2, xmm3/m128"""
        ...


class Sse41(System.Runtime.Intrinsics.X86.Ssse3, metaclass=abc.ABCMeta):
    """Provides access to X86 SSE4.1 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Ssse3.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSE4.1 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """__int64 _mm_extract_epi64 (__m128i a, const int imm8)   PEXTRQ r/m64, xmm1, imm8  VPEXTRQ r/m64, xmm1, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """__int64 _mm_extract_epi64 (__m128i a, const int imm8)   PEXTRQ r/m64, xmm1, imm8  VPEXTRQ r/m64, xmm1, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """__int64 _mm_extract_epi64 (__m128i a, const int imm8)   PEXTRQ r/m64, xmm1, imm8  VPEXTRQ r/m64, xmm1, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """__int64 _mm_extract_epi64 (__m128i a, const int imm8)   PEXTRQ r/m64, xmm1, imm8  VPEXTRQ r/m64, xmm1, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)   PINSRQ xmm1,       r/m64, imm8  VPINSRQ xmm1, xmm2, r/m64, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)   PINSRQ xmm1,       r/m64, imm8  VPINSRQ xmm1, xmm2, r/m64, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)   PINSRQ xmm1,       r/m64, imm8  VPINSRQ xmm1, xmm2, r/m64, imm8This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)   PINSRQ xmm1,       r/m64, imm8  VPINSRQ xmm1, xmm2, r/m64, imm8This intrinsic is only available on 64-bit processes"""
            ...

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)   PBLENDW xmm1,       xmm2/m128 imm8  VPBLENDW xmm1, xmm2, xmm3/m128 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)   PBLENDW xmm1,       xmm2/m128 imm8  VPBLENDW xmm1, xmm2, xmm3/m128 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)   BLENDPS xmm1,       xmm2/m128, imm8  VBLENDPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)   BLENDPD xmm1,       xmm2/m128, imm8  VBLENDPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)   PBLENDW xmm1,       xmm2/m128 imm8  VPBLENDW xmm1, xmm2, xmm3/m128 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)   PBLENDW xmm1,       xmm2/m128 imm8  VPBLENDW xmm1, xmm2, xmm3/m128 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)   BLENDPS xmm1,       xmm2/m128, imm8  VBLENDPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)   BLENDPD xmm1,       xmm2/m128, imm8  VBLENDPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)   BLENDVPS xmm1,       xmm2/m128, <XMM0>  VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)   BLENDVPD xmm1,       xmm2/m128, <XMM0>  VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)   PBLENDVB xmm1,       xmm2/m128, <XMM0>  VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)   BLENDVPS xmm1,       xmm2/m128, <XMM0>  VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)   BLENDVPD xmm1,       xmm2/m128, <XMM0>  VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ps (__m128 a)   ROUNDPS xmm1, xmm2/m128, imm8(10)  VROUNDPS xmm1, xmm2/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_pd (__m128d a)   ROUNDPD xmm1, xmm2/m128, imm8(10)  VROUNDPD xmm1, xmm2/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ps (__m128 a)   ROUNDPS xmm1, xmm2/m128, imm8(10)  VROUNDPS xmm1, xmm2/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_pd (__m128d a)   ROUNDPD xmm1, xmm2/m128, imm8(10)  VROUNDPD xmm1, xmm2/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ss (__m128 a)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ss (__m128 a, __m128 b)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_sd (__m128d a)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_sd (__m128d a, __m128d b)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ss (__m128 a)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_ceil_ss (__m128 a, __m128 b)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_sd (__m128d a)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def ceiling_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_ceil_sd (__m128d a, __m128d b)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)   PCMPEQQ xmm1,       xmm2/m128  VPCMPEQQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)   PCMPEQQ xmm1,       xmm2/m128  VPCMPEQQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)   PCMPEQQ xmm1,       xmm2/m128  VPCMPEQQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)   PCMPEQQ xmm1,       xmm2/m128  VPCMPEQQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi16 (__m128i a)   PMOVSXBW xmm1,         xmm2/m64  VPMOVSXBW xmm1,         xmm2/m64  VPMOVSXBW xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi16 (__m128i a)   PMOVZXBW xmm1,         xmm2/m64  VPMOVZXBW xmm1,         xmm2/m64  VPMOVZXBW xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBW xmm1,         m64  VPMOVSXBW xmm1,         m64  VPMOVSXBW xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBW xmm1,         m64  VPMOVZXBW xmm1,         m64  VPMOVZXBW xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi16 (__m128i a)   PMOVSXBW xmm1,         xmm2/m64  VPMOVSXBW xmm1,         xmm2/m64  VPMOVSXBW xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi16 (__m128i a)   PMOVZXBW xmm1,         xmm2/m64  VPMOVZXBW xmm1,         xmm2/m64  VPMOVZXBW xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBW xmm1,         m64  VPMOVSXBW xmm1,         m64  VPMOVSXBW xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBW xmm1,         m64  VPMOVZXBW xmm1,         m64  VPMOVZXBW xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi32 (__m128i a)   PMOVSXBD xmm1,         xmm2/m32  VPMOVSXBD xmm1,         xmm2/m32  VPMOVSXBD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi32 (__m128i a)   PMOVZXBD xmm1,         xmm2/m32  VPMOVZXBD xmm1,         xmm2/m32  VPMOVZXBD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi16_epi32 (__m128i a)   PMOVSXWD xmm1,         xmm2/m64  VPMOVSXWD xmm1,         xmm2/m64  VPMOVSXWD xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu16_epi32 (__m128i a)   PMOVZXWD xmm1,         xmm2/m64  VPMOVZXWD xmm1,         xmm2/m64  VPMOVZXWD xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBD xmm1,         m32  VPMOVSXBD xmm1,         m32  VPMOVSXBD xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBD xmm1,         m32  VPMOVZXBD xmm1,         m32  VPMOVZXBD xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXWD xmm1,         m64  VPMOVSXWD xmm1,         m64  VPMOVSXWD xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXWD xmm1,         m64  VPMOVZXWD xmm1,         m64  VPMOVZXWD xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi32 (__m128i a)   PMOVSXBD xmm1,         xmm2/m32  VPMOVSXBD xmm1,         xmm2/m32  VPMOVSXBD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi32 (__m128i a)   PMOVZXBD xmm1,         xmm2/m32  VPMOVZXBD xmm1,         xmm2/m32  VPMOVZXBD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi16_epi32 (__m128i a)   PMOVSXWD xmm1,         xmm2/m64  VPMOVSXWD xmm1,         xmm2/m64  VPMOVSXWD xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu16_epi32 (__m128i a)   PMOVZXWD xmm1,         xmm2/m64  VPMOVZXWD xmm1,         xmm2/m64  VPMOVZXWD xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBD xmm1,         m32  VPMOVSXBD xmm1,         m32  VPMOVSXBD xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBD xmm1,         m32  VPMOVZXBD xmm1,         m32  VPMOVZXBD xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXWD xmm1,         m64  VPMOVSXWD xmm1,         m64  VPMOVSXWD xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXWD xmm1,         m64  VPMOVZXWD xmm1,         m64  VPMOVZXWD xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi64 (__m128i a)   PMOVSXBQ xmm1,         xmm2/m16  VPMOVSXBQ xmm1,         xmm2/m16  VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi64 (__m128i a)   PMOVZXBQ xmm1,         xmm2/m16  VPMOVZXBQ xmm1,         xmm2/m16  VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi16_epi64 (__m128i a)   PMOVSXWQ xmm1,         xmm2/m32  VPMOVSXWQ xmm1,         xmm2/m32  VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu16_epi64 (__m128i a)   PMOVZXWQ xmm1,         xmm2/m32  VPMOVZXWQ xmm1,         xmm2/m32  VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi32_epi64 (__m128i a)   PMOVSXDQ xmm1,         xmm2/m64  VPMOVSXDQ xmm1,         xmm2/m64  VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu32_epi64 (__m128i a)   PMOVZXDQ xmm1,         xmm2/m64  VPMOVZXDQ xmm1,         xmm2/m64  VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBQ xmm1,         m16  VPMOVSXBQ xmm1,         m16  VPMOVSXBQ xmm1 {k1}{z}, m16The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBQ xmm1,         m16  VPMOVZXBQ xmm1,         m16  VPMOVZXBQ xmm1 {k1}{z}, m16The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXWQ xmm1,         m32  VPMOVSXWQ xmm1,         m32  VPMOVSXWQ xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXWQ xmm1,         m32  VPMOVZXWQ xmm1,         m32  VPMOVZXWQ xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXDQ xmm1,         m64  VPMOVSXDQ xmm1,         m64  VPMOVSXDQ xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXDQ xmm1,         m64  VPMOVZXDQ xmm1,         m64  VPMOVZXDQ xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi8_epi64 (__m128i a)   PMOVSXBQ xmm1,         xmm2/m16  VPMOVSXBQ xmm1,         xmm2/m16  VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu8_epi64 (__m128i a)   PMOVZXBQ xmm1,         xmm2/m16  VPMOVZXBQ xmm1,         xmm2/m16  VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi16_epi64 (__m128i a)   PMOVSXWQ xmm1,         xmm2/m32  VPMOVSXWQ xmm1,         xmm2/m32  VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu16_epi64 (__m128i a)   PMOVZXWQ xmm1,         xmm2/m32  VPMOVZXWQ xmm1,         xmm2/m32  VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepi32_epi64 (__m128i a)   PMOVSXDQ xmm1,         xmm2/m64  VPMOVSXDQ xmm1,         xmm2/m64  VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cvtepu32_epi64 (__m128i a)   PMOVZXDQ xmm1,         xmm2/m64  VPMOVZXDQ xmm1,         xmm2/m64  VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXBQ xmm1,         m16  VPMOVSXBQ xmm1,         m16  VPMOVSXBQ xmm1 {k1}{z}, m16The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXBQ xmm1,         m16  VPMOVZXBQ xmm1,         m16  VPMOVZXBQ xmm1 {k1}{z}, m16The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXWQ xmm1,         m32  VPMOVSXWQ xmm1,         m32  VPMOVSXWQ xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXWQ xmm1,         m32  VPMOVZXWQ xmm1,         m32  VPMOVZXWQ xmm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVSXDQ xmm1,         m64  VPMOVSXDQ xmm1,         m64  VPMOVSXDQ xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """PMOVZXDQ xmm1,         m64  VPMOVZXDQ xmm1,         m64  VPMOVZXDQ xmm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)   DPPS xmm1,       xmm2/m128, imm8  VDPPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)   DPPD xmm1,       xmm2/m128, imm8  VDPPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)   DPPS xmm1,       xmm2/m128, imm8  VDPPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)   DPPD xmm1,       xmm2/m128, imm8  VDPPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi8 (__m128i a, const int imm8)   PEXTRB r/m8, xmm1, imm8  VPEXTRB r/m8, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi32 (__m128i a, const int imm8)   PEXTRD r/m32, xmm1, imm8  VPEXTRD r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi32 (__m128i a, const int imm8)   PEXTRD r/m32, xmm1, imm8  VPEXTRD r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """int _mm_extract_ps (__m128 a, const int imm8)   EXTRACTPS r/m32, xmm1, imm8  VEXTRACTPS r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi8 (__m128i a, const int imm8)   PEXTRB r/m8, xmm1, imm8  VPEXTRB r/m8, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi32 (__m128i a, const int imm8)   PEXTRD r/m32, xmm1, imm8  VPEXTRD r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """int _mm_extract_epi32 (__m128i a, const int imm8)   PEXTRD r/m32, xmm1, imm8  VPEXTRD r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """int _mm_extract_ps (__m128 a, const int imm8)   EXTRACTPS r/m32, xmm1, imm8  VEXTRACTPS r/m32, xmm1, imm8"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ps (__m128 a)   ROUNDPS xmm1, xmm2/m128, imm8(9)  VROUNDPS xmm1, xmm2/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_pd (__m128d a)   ROUNDPD xmm1, xmm2/m128, imm8(9)  VROUNDPD xmm1, xmm2/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ps (__m128 a)   ROUNDPS xmm1, xmm2/m128, imm8(9)  VROUNDPS xmm1, xmm2/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_pd (__m128d a)   ROUNDPD xmm1, xmm2/m128, imm8(9)  VROUNDPD xmm1, xmm2/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ss (__m128 a)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def floor_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ss (__m128 a, __m128 b)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_sd (__m128d a)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def floor_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_sd (__m128d a, __m128d b)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ss (__m128 a)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def floor_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_floor_ss (__m128 a, __m128 b)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_sd (__m128d a)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def floor_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_floor_sd (__m128d a, __m128d b)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)   PINSRB xmm1,       r/m8, imm8  VPINSRB xmm1, xmm2, r/m8, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)   PINSRB xmm1,       r/m8, imm8  VPINSRB xmm1, xmm2, r/m8, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)   PINSRD xmm1,       r/m32, imm8  VPINSRD xmm1, xmm2, r/m32, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)   PINSRD xmm1,       r/m32, imm8  VPINSRD xmm1, xmm2, r/m32, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)   INSERTPS xmm1,       xmm2/m32, imm8  VINSERTPS xmm1, xmm2, xmm3/m32, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)   PINSRB xmm1,       r/m8, imm8  VPINSRB xmm1, xmm2, r/m8, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)   PINSRB xmm1,       r/m8, imm8  VPINSRB xmm1, xmm2, r/m8, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)   PINSRD xmm1,       r/m32, imm8  VPINSRD xmm1, xmm2, r/m32, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)   PINSRD xmm1,       r/m32, imm8  VPINSRD xmm1, xmm2, r/m32, imm8"""
        ...

    @staticmethod
    @overload
    def insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)   INSERTPS xmm1,       xmm2/m32, imm8  VINSERTPS xmm1, xmm2, xmm3/m32, imm8"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_128_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_stream_load_si128 (const __m128i* mem_addr)   MOVNTDQA xmm1, m128  VMOVNTDQA xmm1, m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi8 (__m128i a, __m128i b)   PMAXSB xmm1,               xmm2/m128  VPMAXSB xmm1,         xmm2, xmm3/m128  VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu16 (__m128i a, __m128i b)   PMAXUW xmm1,               xmm2/m128  VPMAXUW xmm1,         xmm2, xmm3/m128  VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi32 (__m128i a, __m128i b)   PMAXSD xmm1,               xmm2/m128  VPMAXSD xmm1,         xmm2, xmm3/m128  VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu32 (__m128i a, __m128i b)   PMAXUD xmm1,               xmm2/m128  VPMAXUD xmm1,         xmm2, xmm3/m128  VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi8 (__m128i a, __m128i b)   PMAXSB xmm1,               xmm2/m128  VPMAXSB xmm1,         xmm2, xmm3/m128  VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu16 (__m128i a, __m128i b)   PMAXUW xmm1,               xmm2/m128  VPMAXUW xmm1,         xmm2, xmm3/m128  VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epi32 (__m128i a, __m128i b)   PMAXSD xmm1,               xmm2/m128  VPMAXSD xmm1,         xmm2, xmm3/m128  VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_max_epu32 (__m128i a, __m128i b)   PMAXUD xmm1,               xmm2/m128  VPMAXUD xmm1,         xmm2, xmm3/m128  VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi8 (__m128i a, __m128i b)   PMINSB xmm1,               xmm2/m128  VPMINSB xmm1,         xmm2, xmm3/m128  VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu16 (__m128i a, __m128i b)   PMINUW xmm1,               xmm2/m128  VPMINUW xmm1,         xmm2, xmm3/m128  VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi32 (__m128i a, __m128i b)   PMINSD xmm1,               xmm2/m128  VPMINSD xmm1,         xmm2, xmm3/m128  VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu32 (__m128i a, __m128i b)   PMINUD xmm1,               xmm2/m128  VPMINUD xmm1,         xmm2, xmm3/m128  VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi8 (__m128i a, __m128i b)   PMINSB xmm1,               xmm2/m128  VPMINSB xmm1,         xmm2, xmm3/m128  VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu16 (__m128i a, __m128i b)   PMINUW xmm1,               xmm2/m128  VPMINUW xmm1,         xmm2, xmm3/m128  VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epi32 (__m128i a, __m128i b)   PMINSD xmm1,               xmm2/m128  VPMINSD xmm1,         xmm2, xmm3/m128  VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_min_epu32 (__m128i a, __m128i b)   PMINUD xmm1,               xmm2/m128  VPMINUD xmm1,         xmm2, xmm3/m128  VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def min_horizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_minpos_epu16 (__m128i a)   PHMINPOSUW xmm1, xmm2/m128  VPHMINPOSUW xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def min_horizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_minpos_epu16 (__m128i a)   PHMINPOSUW xmm1, xmm2/m128  VPHMINPOSUW xmm1, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def multiple_sum_absolute_differences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)   MPSADBW xmm1,       xmm2/m128, imm8  VMPSADBW xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def multiple_sum_absolute_differences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)   MPSADBW xmm1,       xmm2/m128, imm8  VMPSADBW xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mul_epi32 (__m128i a, __m128i b)   PMULDQ xmm1,               xmm2/m128  VPMULDQ xmm1,         xmm2, xmm3/m128  VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mul_epi32 (__m128i a, __m128i b)   PMULDQ xmm1,               xmm2/m128  VPMULDQ xmm1,         xmm2, xmm3/m128  VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi32 (__m128i a, __m128i b)   PMULLD xmm1,               xmm2/m128  VPMULLD xmm1,         xmm2, xmm3/m128  VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi32 (__m128i a, __m128i b)   PMULLD xmm1,               xmm2/m128  VPMULLD xmm1,         xmm2, xmm3/m128  VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi32 (__m128i a, __m128i b)   PMULLD xmm1,               xmm2/m128  VPMULLD xmm1,         xmm2, xmm3/m128  VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mullo_epi32 (__m128i a, __m128i b)   PMULLD xmm1,               xmm2/m128  VPMULLD xmm1,         xmm2, xmm3/m128  VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packus_epi32 (__m128i a, __m128i b)   PACKUSDW xmm1,               xmm2/m128  VPACKUSDW xmm1,         xmm2, xmm3/m128  VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_packus_epi32 (__m128i a, __m128i b)   PACKUSDW xmm1,               xmm2/m128  VPACKUSDW xmm1,         xmm2, xmm3/m128  VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_CUR_DIRECTION)   ROUNDPS xmm1, xmm2/m128, imm8(4)  VROUNDPS xmm1, xmm2/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_pd (__m128d a, _MM_FROUND_CUR_DIRECTION)   ROUNDPD xmm1, xmm2/m128, imm8(4)  VROUNDPD xmm1, xmm2/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_CUR_DIRECTION)   ROUNDPS xmm1, xmm2/m128, imm8(4)  VROUNDPS xmm1, xmm2/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_pd (__m128d a, _MM_FROUND_CUR_DIRECTION)   ROUNDPD xmm1, xmm2/m128, imm8(4)  VROUNDPD xmm1, xmm2/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)   ROUNDSS xmm1,       xmm2/m128, imm8(4)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)   ROUNDSS xmm1,       xmm2/m128, imm8(4)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)   ROUNDSD xmm1,       xmm2/m128, imm8(4)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)   ROUNDSD xmm1,       xmm2/m128, imm8(4)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)   ROUNDSS xmm1,       xmm2/m128, imm8(4)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)   ROUNDSS xmm1,       xmm2/m128, imm8(4)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)   ROUNDSD xmm1,       xmm2/m128, imm8(4)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)   ROUNDSD xmm1,       xmm2/m128, imm8(4)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(8)  VROUNDPS xmm1, xmm2/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(8)  VROUNDPD xmm1, xmm2/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(8)  VROUNDPS xmm1, xmm2/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(8)  VROUNDPD xmm1, xmm2/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(8)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(8)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(8)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(8)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(8)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(8)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(8)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(8)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(9)  VROUNDPS xmm1, xmm2/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(9)  VROUNDPD xmm1, xmm2/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(9)  VROUNDPS xmm1, xmm2/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(9)  VROUNDPD xmm1, xmm2/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(9)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(9)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(10)  VROUNDPS xmm1, xmm2/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(10)  VROUNDPD xmm1, xmm2/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(10)  VROUNDPS xmm1, xmm2/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(10)  VROUNDPD xmm1, xmm2/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(10)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(10)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(11)  VROUNDPS xmm1, xmm2/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(11)  VROUNDPD xmm1, xmm2/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)   ROUNDPS xmm1, xmm2/m128, imm8(11)  VROUNDPS xmm1, xmm2/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)   ROUNDPD xmm1, xmm2/m128, imm8(11)  VROUNDPD xmm1, xmm2/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(11)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(11)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(11)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(11)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(11)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSS xmm1,       xmm2/m128, imm8(11)  VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(11)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero_scalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_round_sd (__m128d a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)   ROUNDSD xmm1,       xmm2/m128, imm8(11)  VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; CF=1  VPTEST xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testnzc_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0  VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """int _mm_testz_si128 (__m128i a, __m128i b)   PTEST xmm1, xmm2/m128    ; ZF=1  VPTEST xmm1, xmm2/m128    ; ZF=1"""
        ...


class Sse42(System.Runtime.Intrinsics.X86.Sse41, metaclass=abc.ABCMeta):
    """Provides access to X86 SSE4.2 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Sse41.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 SSE4.2 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def crc_32(crc: int, data: int) -> int:
            """unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)  CRC32 r64, r/m64This intrinsic is only available on 64-bit processes"""
            ...

        @staticmethod
        @overload
        def crc_32(crc: int, data: int) -> int:
            """unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)  CRC32 r64, r/m64This intrinsic is only available on 64-bit processes"""
            ...

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)   PCMPGTQ xmm1,       xmm2/m128  VPCMPGTQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)   PCMPGTQ xmm1,       xmm2/m128  VPCMPGTQ xmm1, xmm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)  CRC32 r32, r/m8"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)  CRC32 r32, r/m16"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)  CRC32 r32, r/m32"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)  CRC32 r32, r/m8"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)  CRC32 r32, r/m16"""
        ...

    @staticmethod
    @overload
    def crc_32(crc: int, data: int) -> int:
        """unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)  CRC32 r32, r/m32"""
        ...


class FloatComparisonMode(Enum):
    """This class has no documentation."""

    ORDERED_EQUAL_NON_SIGNALING = 0
    """_CMP_EQ_OQ"""

    ORDERED_LESS_THAN_SIGNALING = 1
    """_CMP_LT_OS"""

    ORDERED_LESS_THAN_OR_EQUAL_SIGNALING = 2
    """_CMP_LE_OS"""

    UNORDERED_NON_SIGNALING = 3
    """_CMP_UNORD_Q"""

    UNORDERED_NOT_EQUAL_NON_SIGNALING = 4
    """_CMP_NEQ_UQ"""

    UNORDERED_NOT_LESS_THAN_SIGNALING = 5
    """_CMP_NLT_US"""

    UNORDERED_NOT_LESS_THAN_OR_EQUAL_SIGNALING = 6
    """_CMP_NLE_US"""

    ORDERED_NON_SIGNALING = 7
    """_CMP_ORD_Q"""

    UNORDERED_EQUAL_NON_SIGNALING = 8
    """_CMP_EQ_UQ"""

    UNORDERED_NOT_GREATER_THAN_OR_EQUAL_SIGNALING = 9
    """_CMP_NGE_US"""

    UNORDERED_NOT_GREATER_THAN_SIGNALING = 10
    """_CMP_NGT_US"""

    ORDERED_FALSE_NON_SIGNALING = 11
    """_CMP_FALSE_OQ"""

    ORDERED_NOT_EQUAL_NON_SIGNALING = 12
    """_CMP_NEQ_OQ"""

    ORDERED_GREATER_THAN_OR_EQUAL_SIGNALING = 13
    """_CMP_GE_OS"""

    ORDERED_GREATER_THAN_SIGNALING = 14
    """_CMP_GT_OS"""

    UNORDERED_TRUE_NON_SIGNALING = 15
    """_CMP_TRUE_UQ"""

    ORDERED_EQUAL_SIGNALING = 16
    """_CMP_EQ_OS"""

    ORDERED_LESS_THAN_NON_SIGNALING = 17
    """_CMP_LT_OQ"""

    ORDERED_LESS_THAN_OR_EQUAL_NON_SIGNALING = 18
    """_CMP_LE_OQ"""

    UNORDERED_SIGNALING = 19
    """_CMP_UNORD_S"""

    UNORDERED_NOT_EQUAL_SIGNALING = 20
    """_CMP_NEQ_US"""

    UNORDERED_NOT_LESS_THAN_NON_SIGNALING = 21
    """_CMP_NLT_UQ"""

    UNORDERED_NOT_LESS_THAN_OR_EQUAL_NON_SIGNALING = 22
    """_CMP_NLE_UQ"""

    ORDERED_SIGNALING = 23
    """_CMP_ORD_S"""

    UNORDERED_EQUAL_SIGNALING = 24
    """_CMP_EQ_US"""

    UNORDERED_NOT_GREATER_THAN_OR_EQUAL_NON_SIGNALING = 25
    """_CMP_NGE_UQ"""

    UNORDERED_NOT_GREATER_THAN_NON_SIGNALING = 26
    """_CMP_NGT_UQ"""

    ORDERED_FALSE_SIGNALING = 27
    """_CMP_FALSE_OS"""

    ORDERED_NOT_EQUAL_SIGNALING = 28
    """_CMP_NEQ_OS"""

    ORDERED_GREATER_THAN_OR_EQUAL_NON_SIGNALING = 29
    """_CMP_GE_OQ"""

    ORDERED_GREATER_THAN_NON_SIGNALING = 30
    """_CMP_GT_OQ"""

    UNORDERED_TRUE_SIGNALING = 31
    """_CMP_TRUE_US"""


class Avx(System.Runtime.Intrinsics.X86.Sse42, metaclass=abc.ABCMeta):
    """Provides access to X86 AVX hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Sse42.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 AVX hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_add_ps (__m256 a, __m256 b)  VADDPS ymm1,         ymm2, ymm3/m256  VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_add_pd (__m256d a, __m256d b)  VADDPD ymm1,         ymm2, ymm3/m256  VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_add_ps (__m256 a, __m256 b)  VADDPS ymm1,         ymm2, ymm3/m256  VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_add_pd (__m256d a, __m256d b)  VADDPD ymm1,         ymm2, ymm3/m256  VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_addsub_ps (__m256 a, __m256 b)  VADDSUBPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_addsub_pd (__m256d a, __m256d b)  VADDSUBPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_addsub_ps (__m256 a, __m256 b)  VADDSUBPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_addsub_pd (__m256d a, __m256d b)  VADDSUBPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_and_ps (__m256 a, __m256 b)  VANDPS ymm1,         ymm2, ymm2/m256  VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_and_pd (__m256d a, __m256d b)  VANDPD ymm1,         ymm2, ymm2/m256  VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_and_ps (__m256 a, __m256 b)  VANDPS ymm1,         ymm2, ymm2/m256  VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_and_pd (__m256d a, __m256d b)  VANDPD ymm1,         ymm2, ymm2/m256  VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_andnot_ps (__m256 a, __m256 b)  VANDNPS ymm1,         ymm2, ymm2/m256  VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_andnot_pd (__m256d a, __m256d b)  VANDNPD ymm1,         ymm2, ymm2/m256  VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_andnot_ps (__m256 a, __m256 b)  VANDNPS ymm1,         ymm2, ymm2/m256  VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_andnot_pd (__m256d a, __m256d b)  VANDNPD ymm1,         ymm2, ymm2/m256  VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)  VBLENDPS ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)  VBLENDPD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)  VBLENDPS ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)  VBLENDPD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)  VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)  VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)  VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)  VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_broadcast_ss (float const * mem_addr)  VBROADCASTSS xmm1,         m32  VBROADCASTSS xmm1 {k1}{z}, m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_broadcast_ss (float const * mem_addr)  VBROADCASTSS xmm1,         m32  VBROADCASTSS xmm1 {k1}{z}, m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcast_ss (float const * mem_addr)  VBROADCASTSS ymm1,         m32  VBROADCASTSS ymm1 {k1}{z}, m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcast_sd (double const * mem_addr)  VBROADCASTSD ymm1,         m64  VBROADCASTSD ymm1 {k1}{z}, m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcast_ss (float const * mem_addr)  VBROADCASTSS ymm1,         m32  VBROADCASTSS ymm1 {k1}{z}, m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcast_sd (double const * mem_addr)  VBROADCASTSD ymm1,         m64  VBROADCASTSD ymm1 {k1}{z}, m64"""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcast_ps (__m128 const * mem_addr)  VBROADCASTF128  ymm1,         m128  VBROADCASTF32x4 ymm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcast_pd (__m128d const * mem_addr)  VBROADCASTF128  ymm1,         m128  VBROADCASTF64x2 ymm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcast_ps (__m128 const * mem_addr)  VBROADCASTF128  ymm1,         m128  VBROADCASTF32x4 ymm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcast_pd (__m128d const * mem_addr)  VBROADCASTF128  ymm1,         m128  VBROADCASTF64x2 ymm1 {k1}{z}, m128"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_ceil_ps (__m128 a)  VROUNDPS ymm1, ymm2/m256, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_ceil_pd (__m128d a)  VROUNDPD ymm1, ymm2/m256, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_ceil_ps (__m128 a)  VROUNDPS ymm1, ymm2/m256, imm8(10)"""
        ...

    @staticmethod
    @overload
    def ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_ceil_pd (__m128d a)  VROUNDPD ymm1, ymm2/m256, imm8(10)"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)  VCMPPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)  VCMPPS ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)  VCMPPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)  VCMPPD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)  VCMPPS xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)  VCMPPS ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)  VCMPPD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)  VCMPPD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(0)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(0)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(0)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(0)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(14)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(14)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(14)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(14)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpge_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(13)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpge_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(13)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpge_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(13)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpge_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(13)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmplt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(1)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmplt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(1)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmplt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(1)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmplt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(1)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmple_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(2)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmple_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(2)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmple_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(2)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmple_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(2)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(5)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(5)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(5)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(5)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(6)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(6)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(6)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_not_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(6)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpord_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(7)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpord_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(7)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpord_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(7)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_ordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpord_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(7)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)  VCMPSD xmm1, xmm2, xmm3/m64, imm8"""
        ...

    @staticmethod
    @overload
    def compare_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)  VCMPSS xmm1, xmm2, xmm3/m32, imm8"""
        ...

    @staticmethod
    @overload
    def compare_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)  VCMPSD xmm1, xmm2, xmm3/m64, imm8"""
        ...

    @staticmethod
    @overload
    def compare_scalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)  VCMPSS xmm1, xmm2, xmm3/m32, imm8"""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(3)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(3)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)  VCMPPS ymm1, ymm2/m256, imm8(3)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def compare_unordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)  VCMPPD ymm1, ymm2/m256, imm8(3)The above native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_cvtpd_epi32 (__m256d a)  VCVTPD2DQ xmm1,         ymm2/m256  VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_cvtpd_epi32 (__m256d a)  VCVTPD2DQ xmm1,         ymm2/m256  VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_cvttpd_epi32 (__m256d a)  VCVTTPD2DQ xmm1,         ymm2/m256  VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_cvttpd_epi32 (__m256d a)  VCVTTPD2DQ xmm1,         ymm2/m256  VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_cvtpd_ps (__m256d a)  VCVTPD2PS xmm1,         ymm2/m256  VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_cvtpd_ps (__m256d a)  VCVTPD2PS xmm1,         ymm2/m256  VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cvtepi32_pd (__m128i a)  VCVTDQ2PD ymm1,         xmm2/m128  VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cvtps_pd (__m128 a)  VCVTPS2PD ymm1,         xmm2/m128  VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cvtepi32_pd (__m128i a)  VCVTDQ2PD ymm1,         xmm2/m128  VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_cvtps_pd (__m128 a)  VCVTPS2PD ymm1,         xmm2/m128  VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtps_epi32 (__m256 a)  VCVTPS2DQ ymm1,         ymm2/m256  VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtps_epi32 (__m256 a)  VCVTPS2DQ ymm1,         ymm2/m256  VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvttps_epi32 (__m256 a)  VCVTTPS2DQ ymm1,         ymm2/m256  VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvttps_epi32 (__m256 a)  VCVTTPS2DQ ymm1,         ymm2/m256  VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cvtepi32_ps (__m256i a)  VCVTDQ2PS ymm1,         ymm2/m256  VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_cvtepi32_ps (__m256i a)  VCVTDQ2PS ymm1,         ymm2/m256  VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_div_ps (__m256 a, __m256 b)  VDIVPS ymm1,         ymm2, ymm3/m256  VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_div_pd (__m256d a, __m256d b)  VDIVPD ymm1,         ymm2, ymm3/m256  VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_div_ps (__m256 a, __m256 b)  VDIVPS ymm1,         ymm2, ymm3/m256  VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_div_pd (__m256d a, __m256d b)  VDIVPD ymm1,         ymm2, ymm3/m256  VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)  VDPPS ymm, ymm, ymm/m256, imm8"""
        ...

    @staticmethod
    @overload
    def dot_product(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)  VDPPS ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def duplicate_even_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_moveldup_ps (__m256 a)  VMOVSLDUP ymm1,         ymm2/m256  VMOVSLDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def duplicate_even_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_movedup_pd (__m256d a)  VMOVDDUP ymm1,         ymm2/m256  VMOVDDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def duplicate_even_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_moveldup_ps (__m256 a)  VMOVSLDUP ymm1,         ymm2/m256  VMOVSLDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def duplicate_even_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_movedup_pd (__m256d a)  VMOVDDUP ymm1,         ymm2/m256  VMOVDDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def duplicate_odd_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_movehdup_ps (__m256 a)  VMOVSHDUP ymm1,         ymm2/m256  VMOVSHDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def duplicate_odd_indexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_movehdup_ps (__m256 a)  VMOVSHDUP ymm1,         ymm2/m256  VMOVSHDUP ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_extractf128_ps (__m256 a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm256_extractf128_pd (__m256d a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extractf128_si256 (__m256i a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_extractf128_ps (__m256 a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm256_extractf128_pd (__m256d a, const int imm8)  VEXTRACTF128  xmm1/m128,         ymm2, imm8  VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_floor_ps (__m256 a)  VROUNDPS ymm1, ymm2/m256, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_floor_pd (__m256d a)  VROUNDPD ymm1, ymm2/m256, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_floor_ps (__m256 a)  VROUNDPS ymm1, ymm2/m256, imm8(9)"""
        ...

    @staticmethod
    @overload
    def floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_floor_pd (__m256d a)  VROUNDPD ymm1, ymm2/m256, imm8(9)"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_hadd_ps (__m256 a, __m256 b)  VHADDPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_hadd_pd (__m256d a, __m256d b)  VHADDPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_hadd_ps (__m256 a, __m256 b)  VHADDPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_hadd_pd (__m256d a, __m256d b)  VHADDPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_hsub_ps (__m256 a, __m256 b)  VHSUBPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_hsub_pd (__m256d a, __m256d b)  VHSUBPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_hsub_ps (__m256 a, __m256 b)  VHSUBPS ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_hsub_pd (__m256d a, __m256d b)  VHSUBPD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)  VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_load_ps (float const * mem_addr)  VMOVAPS ymm1,         m256  VMOVAPS ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_load_pd (double const * mem_addr)  VMOVAPD ymm1,         m256  VMOVAPD ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_load_si256 (__m256i const * mem_addr)  VMOVDQA   ymm1,         m256  VMOVDQA64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_load_ps (float const * mem_addr)  VMOVAPS ymm1,         m256  VMOVAPS ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_load_pd (double const * mem_addr)  VMOVAPD ymm1,         m256  VMOVAPD ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_dqu_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_lddqu_si256 (__m256i const * mem_addr)  VLDDQU ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU  ymm1,         m256  VMOVDQU8 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU  ymm1,         m256  VMOVDQU8 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU16 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU16 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_loadu_ps (float const * mem_addr)  VMOVUPS ymm1,         m256  VMOVUPS ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_loadu_pd (double const * mem_addr)  VMOVUPD ymm1,         m256  VMOVUPD ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU  ymm1,         m256  VMOVDQU8 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU  ymm1,         m256  VMOVDQU8 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU16 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU16 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU32 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_loadu_si256 (__m256i const * mem_addr)  VMOVDQU   ymm1,         m256  VMOVDQU64 ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_loadu_ps (float const * mem_addr)  VMOVUPS ymm1,         m256  VMOVUPS ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def load_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_loadu_pd (double const * mem_addr)  VMOVUPD ymm1,         m256  VMOVUPD ymm1 {k1}{z}, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)  VMASKMOVPS xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)  VMASKMOVPD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)  VMASKMOVPS ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)  VMASKMOVPD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)  VMASKMOVPS xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)  VMASKMOVPD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)  VMASKMOVPS ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)  VMASKMOVPD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)  VMASKMOVPS m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)  VMASKMOVPD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)  VMASKMOVPS m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)  VMASKMOVPD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)  VMASKMOVPS m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)  VMASKMOVPD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)  VMASKMOVPS m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)  VMASKMOVPD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_max_ps (__m256 a, __m256 b)  VMAXPS ymm1,         ymm2, ymm3/m256  VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_max_pd (__m256d a, __m256d b)  VMAXPD ymm1,         ymm2, ymm3/m256  VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_max_ps (__m256 a, __m256 b)  VMAXPS ymm1,         ymm2, ymm3/m256  VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_max_pd (__m256d a, __m256d b)  VMAXPD ymm1,         ymm2, ymm3/m256  VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_min_ps (__m256 a, __m256 b)  VMINPS ymm1,         ymm2, ymm3/m256  VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_min_pd (__m256d a, __m256d b)  VMINPD ymm1,         ymm2, ymm3/m256  VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_min_ps (__m256 a, __m256 b)  VMINPS ymm1,         ymm2, ymm3/m256  VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_min_pd (__m256d a, __m256d b)  VMINPD ymm1,         ymm2, ymm3/m256  VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """int _mm256_movemask_ps (__m256 a)  VMOVMSKPS r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """int _mm256_movemask_pd (__m256d a)  VMOVMSKPD r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """int _mm256_movemask_ps (__m256 a)  VMOVMSKPS r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """int _mm256_movemask_pd (__m256d a)  VMOVMSKPD r32, ymm1"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_mul_ps (__m256 a, __m256 b)  VMULPS ymm1,         ymm2, ymm3/m256  VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mul_pd (__m256d a, __m256d b)  VMULPD ymm1,         ymm2, ymm3/m256  VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_mul_ps (__m256 a, __m256 b)  VMULPS ymm1,         ymm2, ymm3/m256  VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mul_pd (__m256d a, __m256d b)  VMULPD ymm1,         ymm2, ymm3/m256  VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_or_ps (__m256 a, __m256 b)  VORPS ymm1,         ymm2, ymm3/m256  VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_or_pd (__m256d a, __m256d b)  VORPD ymm1,         ymm2, ymm3/m256  VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_or_ps (__m256 a, __m256 b)  VORPS ymm1,         ymm2, ymm3/m256  VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_or_pd (__m256d a, __m256d b)  VORPD ymm1,         ymm2, ymm3/m256  VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_permute_ps (__m128 a, int imm8)  VPERMILPS xmm1,         xmm2/m128,         imm8  VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_permute_pd (__m128d a, int imm8)  VPERMILPD xmm1,         xmm2/m128,         imm8  VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permute_ps (__m256 a, int imm8)  VPERMILPS ymm1,         ymm2/m256,         imm8  VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute_pd (__m256d a, int imm8)  VPERMILPD ymm1,         ymm2/m256,         imm8  VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_permute_ps (__m128 a, int imm8)  VPERMILPS xmm1,         xmm2/m128,         imm8  VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_permute_pd (__m128d a, int imm8)  VPERMILPD xmm1,         xmm2/m128,         imm8  VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permute_ps (__m256 a, int imm8)  VPERMILPS ymm1,         ymm2/m256,         imm8  VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute_pd (__m256d a, int imm8)  VPERMILPD ymm1,         ymm2/m256,         imm8  VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)  VPERM2F128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_permutevar_ps (__m128 a, __m128i b)  VPERMILPS xmm1,         xmm2, xmm3/m128  VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_permutevar_pd (__m128d a, __m128i b)  VPERMILPD xmm1,         xmm2, xmm3/m128  VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permutevar_ps (__m256 a, __m256i b)  VPERMILPS ymm1,         ymm2, ymm3/m256  VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permutevar_pd (__m256d a, __m256i b)  VPERMILPD ymm1,         ymm2, ymm3/m256  VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_permutevar_ps (__m128 a, __m128i b)  VPERMILPS xmm1,         xmm2, xmm3/m128  VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_permutevar_pd (__m128d a, __m128i b)  VPERMILPD xmm1,         xmm2, xmm3/m128  VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permutevar_ps (__m256 a, __m256i b)  VPERMILPS ymm1,         ymm2, ymm3/m256  VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def permute_var(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permutevar_pd (__m256d a, __m256i b)  VPERMILPD ymm1,         ymm2, ymm3/m256  VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_rcp_ps (__m256 a)  VRCPPS ymm1, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_rcp_ps (__m256 a)  VRCPPS ymm1, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_rsqrt_ps (__m256 a)  VRSQRTPS ymm1, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def reciprocal_sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_rsqrt_ps (__m256 a)  VRSQRTPS ymm1, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)  VROUNDPS ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_ps (__m256d a, _MM_FROUND_CUR_DIRECTION)  VROUNDPD ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)  VROUNDPS ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_current_direction(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_ps (__m256d a, _MM_FROUND_CUR_DIRECTION)  VROUNDPD ymm1, ymm2/m256, imm8(4)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT)  VROUNDPS ymm1, ymm2/m256, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT)  VROUNDPD ymm1, ymm2/m256, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT)  VROUNDPS ymm1, ymm2/m256, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_nearest_integer(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT)  VROUNDPD ymm1, ymm2/m256, imm8(8)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_negative_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(9)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_positive_infinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(10)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)  VROUNDPS ymm1, ymm2/m256, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def round_to_zero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)  VROUNDPD ymm1, ymm2/m256, imm8(11)The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic."""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)  VSHUFPS ymm1,         ymm2, ymm3/m256,         imm8  VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)  VSHUFPD ymm1,         ymm2, ymm3/m256,         imm8  VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)  VSHUFPS ymm1,         ymm2, ymm3/m256,         imm8  VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)  VSHUFPD ymm1,         ymm2, ymm3/m256,         imm8  VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_sqrt_ps (__m256 a)  VSQRTPS ymm1,         ymm2/m256  VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_sqrt_pd (__m256d a)  VSQRTPD ymm1,         ymm2/m256  VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_sqrt_ps (__m256 a)  VSQRTPS ymm1,         ymm2/m256  VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_sqrt_pd (__m256d a)  VSQRTPD ymm1,         ymm2/m256  VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU  m256,         ymm1  VMOVDQU8 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU  m256,         ymm1  VMOVDQU8 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU16 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU16 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_storeu_ps (float * mem_addr, __m256 a)  VMOVUPS m256,         ymm1  VMOVUPS m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_storeu_pd (double * mem_addr, __m256d a)  VMOVUPD m256,         ymm1  VMOVUPD m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU  m256,         ymm1  VMOVDQU8 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU  m256,         ymm1  VMOVDQU8 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU16 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU16 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)  VMOVDQU   m256,         ymm1  VMOVDQU64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_storeu_ps (float * mem_addr, __m256 a)  VMOVUPS m256,         ymm1  VMOVUPS m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_storeu_pd (double * mem_addr, __m256d a)  VMOVUPD m256,         ymm1  VMOVUPD m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_store_ps (float * mem_addr, __m256 a)  VMOVAPS m256,         ymm1  VMOVAPS m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_store_pd (double * mem_addr, __m256d a)  VMOVAPD m256,         ymm1  VMOVAPD m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA32 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_store_si256 (__m256i * mem_addr, __m256i a)  VMOVDQA   m256,         ymm1  VMOVDQA64 m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_store_ps (float * mem_addr, __m256 a)  VMOVAPS m256,         ymm1  VMOVAPS m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_store_pd (double * mem_addr, __m256d a)  VMOVAPD m256,         ymm1  VMOVAPD m256 {k1}{z}, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_stream_ps (float * mem_addr, __m256 a)  VMOVNTPS m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_stream_pd (double * mem_addr, __m256d a)  VMOVNTPD m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)  VMOVNTDQ m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_stream_ps (float * mem_addr, __m256 a)  VMOVNTPS m256, ymm1"""
        ...

    @staticmethod
    @overload
    def store_aligned_non_temporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """void _mm256_stream_pd (double * mem_addr, __m256d a)  VMOVNTPD m256, ymm1"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_sub_ps (__m256 a, __m256 b)  VSUBPS ymm1,         ymm2, ymm3/m256  VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_sub_pd (__m256d a, __m256d b)  VSUBPD ymm1,         ymm2, ymm3/m256  VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_sub_ps (__m256 a, __m256 b)  VSUBPS ymm1,         ymm2, ymm3/m256  VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_sub_pd (__m256d a, __m256d b)  VSUBPD ymm1,         ymm2, ymm3/m256  VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testc_ps (__m128 a, __m128 b)  VTESTPS xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testc_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testc_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testc_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testc_ps (__m128 a, __m128 b)  VTESTPS xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testc_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testc_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testc_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; CF=1"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testnzc_ps (__m128 a, __m128 b)  VTESTPS xmm1, ymm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testnzc_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testnzc_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testnzc_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testnzc_ps (__m128 a, __m128 b)  VTESTPS xmm1, ymm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testnzc_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testnzc_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testnzc_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_not_z_and_not_c(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testnzc_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; ZF=0 && CF=0"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testz_ps (__m128 a, __m128 b)  VTESTPS xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testz_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testz_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testz_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testz_ps (__m128 a, __m128 b)  VTESTPS xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """int _mm_testz_pd (__m128d a, __m128d b)  VTESTPD xmm1, xmm2/m128    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """int _mm256_testz_si256 (__m256i a, __m256i b)  VPTEST ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testz_ps (__m256 a, __m256 b)  VTESTPS ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def test_z(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """int _mm256_testz_pd (__m256d a, __m256d b)  VTESTPD ymm1, ymm2/m256    ; ZF=1"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_unpackhi_ps (__m256 a, __m256 b)  VUNPCKHPS ymm1,         ymm2, ymm3/m256  VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_unpackhi_pd (__m256d a, __m256d b)  VUNPCKHPD ymm1,         ymm2, ymm3/m256  VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_unpackhi_ps (__m256 a, __m256 b)  VUNPCKHPS ymm1,         ymm2, ymm3/m256  VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_unpackhi_pd (__m256d a, __m256d b)  VUNPCKHPD ymm1,         ymm2, ymm3/m256  VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_unpacklo_ps (__m256 a, __m256 b)  VUNPCKLPS ymm1,         ymm2, ymm3/m256  VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_unpacklo_pd (__m256d a, __m256d b)  VUNPCKLPD ymm1,         ymm2, ymm3/m256  VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_unpacklo_ps (__m256 a, __m256 b)  VUNPCKLPS ymm1,         ymm2, ymm3/m256  VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_unpacklo_pd (__m256d a, __m256d b)  VUNPCKLPD ymm1,         ymm2, ymm3/m256  VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_xor_ps (__m256 a, __m256 b)  VXORPS ymm1,         ymm2, ymm3/m256  VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_xor_pd (__m256d a, __m256d b)  VXORPD ymm1,         ymm2, ymm3/m256  VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_xor_ps (__m256 a, __m256 b)  VXORPS ymm1,         ymm2, ymm3/m256  VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_xor_pd (__m256d a, __m256d b)  VXORPD ymm1,         ymm2, ymm3/m256  VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...


class Avx2(System.Runtime.Intrinsics.X86.Avx, metaclass=abc.ABCMeta):
    """Provides access to X86 AVX2 hardware instructions via intrinsics."""

    class X64(System.Runtime.Intrinsics.X86.Avx.X64, metaclass=abc.ABCMeta):
        """Provides access to the x86 AVX2 hardware instructions, that are only available to 64-bit processes, via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

    IS_SUPPORTED: bool
    """Gets a value that indicates whether the APIs in this class are supported."""

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi8 (__m256i a)  VPABSB ymm1,         ymm2/m256  VPABSB ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi16 (__m256i a)  VPABSW ymm1,         ymm2/m256  VPABSW ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi32 (__m256i a)  VPABSD ymm1,         ymm2/m256  VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi8 (__m256i a)  VPABSB ymm1,         ymm2/m256  VPABSB ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi16 (__m256i a)  VPABSW ymm1,         ymm2/m256  VPABSW ymm1 {k1}{z}, ymm2/m256"""
        ...

    @staticmethod
    @overload
    def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_abs_epi32 (__m256i a)  VPABSD ymm1,         ymm2/m256  VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi8 (__m256i a, __m256i b)  VPADDB ymm1,         ymm2, ymm3/m256  VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi8 (__m256i a, __m256i b)  VPADDB ymm1,         ymm2, ymm3/m256  VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi16 (__m256i a, __m256i b)  VPADDW ymm1,         ymm2, ymm3/m256  VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi16 (__m256i a, __m256i b)  VPADDW ymm1,         ymm2, ymm3/m256  VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi32 (__m256i a, __m256i b)  VPADDD ymm1,         ymm2, ymm3/m256  VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi32 (__m256i a, __m256i b)  VPADDD ymm1,         ymm2, ymm3/m256  VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi64 (__m256i a, __m256i b)  VPADDQ ymm1,         ymm2, ymm3/m256  VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi64 (__m256i a, __m256i b)  VPADDQ ymm1,         ymm2, ymm3/m256  VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi8 (__m256i a, __m256i b)  VPADDB ymm1,         ymm2, ymm3/m256  VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi8 (__m256i a, __m256i b)  VPADDB ymm1,         ymm2, ymm3/m256  VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi16 (__m256i a, __m256i b)  VPADDW ymm1,         ymm2, ymm3/m256  VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi16 (__m256i a, __m256i b)  VPADDW ymm1,         ymm2, ymm3/m256  VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi32 (__m256i a, __m256i b)  VPADDD ymm1,         ymm2, ymm3/m256  VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi32 (__m256i a, __m256i b)  VPADDD ymm1,         ymm2, ymm3/m256  VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi64 (__m256i a, __m256i b)  VPADDQ ymm1,         ymm2, ymm3/m256  VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_add_epi64 (__m256i a, __m256i b)  VPADDQ ymm1,         ymm2, ymm3/m256  VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epi8 (__m256i a, __m256i b)  VPADDSB ymm1,         ymm2, ymm3/m256  VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epu8 (__m256i a, __m256i b)  VPADDUSB ymm1,         ymm2, ymm3/m256  VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epi16 (__m256i a, __m256i b)  VPADDSW ymm1,         ymm2, ymm3/m256  VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epu16 (__m256i a, __m256i b)  VPADDUSW ymm1,         ymm2, ymm3/m256  VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epi8 (__m256i a, __m256i b)  VPADDSB ymm1,         ymm2, ymm3/m256  VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epu8 (__m256i a, __m256i b)  VPADDUSB ymm1,         ymm2, ymm3/m256  VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epi16 (__m256i a, __m256i b)  VPADDSW ymm1,         ymm2, ymm3/m256  VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_adds_epu16 (__m256i a, __m256i b)  VPADDUSW ymm1,         ymm2, ymm3/m256  VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def align_right(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)  VPALIGNR ymm1,         ymm2, ymm3/m256, imm8  VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_and_si256 (__m256i a, __m256i b)  VPAND  ymm1,         ymm2, ymm3/m256  VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def and_not(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_andnot_si256 (__m256i a, __m256i b)  VPANDN  ymm1,         ymm2, ymm3/m256  VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_avg_epu8 (__m256i a, __m256i b)  VPAVGB ymm1,         ymm2, ymm3/m256  VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_avg_epu16 (__m256i a, __m256i b)  VPAVGW ymm1,         ymm2, ymm3/m256  VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_avg_epu8 (__m256i a, __m256i b)  VPAVGB ymm1,         ymm2, ymm3/m256  VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_avg_epu16 (__m256i a, __m256i b)  VPAVGW ymm1,         ymm2, ymm3/m256  VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)  VPBLENDD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)  VPBLENDD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)  VPBLENDW ymm1, ymm2, ymm3/m256 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)  VPBLENDW ymm1, ymm2, ymm3/m256 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)  VPBLENDD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)  VPBLENDD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)  VPBLENDD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)  VPBLENDD xmm1, xmm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)  VPBLENDW ymm1, ymm2, ymm3/m256 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)  VPBLENDW ymm1, ymm2, ymm3/m256 imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)  VPBLENDD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)  VPBLENDD ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4"""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def blend_variable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)  VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         xmm2/m8  VPBROADCASTB xmm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         xmm2/m8  VPBROADCASTB xmm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         xmm2/m16  VPBROADCASTW xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         xmm2/m16  VPBROADCASTW xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         xmm2/m32  VPBROADCASTD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         xmm2/m32  VPBROADCASTD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         xmm2/m64  VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         xmm2/m64  VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_broadcastss_ps (__m128 a)  VBROADCASTSS xmm1,         xmm2/m32  VBROADCASTSS xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_broadcastsd_pd (__m128d a)  VMOVDDUP xmm1, xmm/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         m8  VPBROADCASTB xmm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         m8  VPBROADCASTB xmm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         m16  VPBROADCASTW xmm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         m16  VPBROADCASTW xmm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         m32  VPBROADCASTD xmm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         m32  VPBROADCASTD xmm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         m64  VPBROADCASTQ xmm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         m64  VPBROADCASTQ xmm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         xmm2/m8  VPBROADCASTB xmm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         xmm2/m8  VPBROADCASTB xmm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         xmm2/m16  VPBROADCASTW xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         xmm2/m16  VPBROADCASTW xmm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         xmm2/m32  VPBROADCASTD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         xmm2/m32  VPBROADCASTD xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         xmm2/m64  VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         xmm2/m64  VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_broadcastss_ps (__m128 a)  VBROADCASTSS xmm1,         xmm2/m32  VBROADCASTSS xmm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_broadcastsd_pd (__m128d a)  VMOVDDUP xmm1, xmm/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         m8  VPBROADCASTB xmm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastb_epi8 (__m128i a)  VPBROADCASTB xmm1,         m8  VPBROADCASTB xmm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         m16  VPBROADCASTW xmm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastw_epi16 (__m128i a)  VPBROADCASTW xmm1,         m16  VPBROADCASTW xmm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         m32  VPBROADCASTD xmm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastd_epi32 (__m128i a)  VPBROADCASTD xmm1,         m32  VPBROADCASTD xmm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         m64  VPBROADCASTQ xmm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_broadcastq_epi64 (__m128i a)  VPBROADCASTQ xmm1,         m64  VPBROADCASTQ xmm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         xmm2/m8  VPBROADCASTB ymm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         xmm2/m8  VPBROADCASTB ymm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         xmm2/m16  VPBROADCASTW ymm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         xmm2/m16  VPBROADCASTW ymm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         xmm2/m32  VPBROADCASTD ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         xmm2/m32  VPBROADCASTD ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         xmm2/m64  VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         xmm2/m64  VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcastss_ps (__m128 a)  VBROADCASTSS ymm1,         xmm2/m32  VBROADCASTSS ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcastsd_pd (__m128d a)  VBROADCASTSD ymm1,         xmm2/m64  VBROADCASTSD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         m8  VPBROADCASTB ymm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         m8  VPBROADCASTB ymm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         m16  VPBROADCASTW ymm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         m16  VPBROADCASTW ymm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         m32  VPBROADCASTD ymm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         m32  VPBROADCASTD ymm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         m64  VPBROADCASTQ ymm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         m64  VPBROADCASTQ ymm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         xmm2/m8  VPBROADCASTB ymm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         xmm2/m8  VPBROADCASTB ymm1 {k1}{z}, xmm2/m8"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         xmm2/m16  VPBROADCASTW ymm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         xmm2/m16  VPBROADCASTW ymm1 {k1}{z}, xmm2/m16"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         xmm2/m32  VPBROADCASTD ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         xmm2/m32  VPBROADCASTD ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         xmm2/m64  VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         xmm2/m64  VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_broadcastss_ps (__m128 a)  VBROADCASTSS ymm1,         xmm2/m32  VBROADCASTSS ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_broadcastsd_pd (__m128d a)  VBROADCASTSD ymm1,         xmm2/m64  VBROADCASTSD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         m8  VPBROADCASTB ymm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastb_epi8 (__m128i a)  VPBROADCASTB ymm1,         m8  VPBROADCASTB ymm1 {k1}{z}, m8The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         m16  VPBROADCASTW ymm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastw_epi16 (__m128i a)  VPBROADCASTW ymm1,         m16  VPBROADCASTW ymm1 {k1}{z}, m16The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         m32  VPBROADCASTD ymm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastd_epi32 (__m128i a)  VPBROADCASTD ymm1,         m32  VPBROADCASTD ymm1 {k1}{z}, m32The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         m64  VPBROADCASTQ ymm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_scalar_to_vector_256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastq_epi64 (__m128i a)  VPBROADCASTQ ymm1,         m64  VPBROADCASTQ ymm1 {k1}{z}, m64The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI64x2 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI64x2 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI32x4 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI64x2 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def broadcast_vector_128_to_vector_256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_broadcastsi128_si256 (__m128i a)  VBROADCASTI128  ymm1,         m128  VBROADCASTI64x2 ymm1 {k1}{z}, m128The above native signature does not directly correspond to the managed signature."""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)  VPCMPEQB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)  VPCMPEQB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)  VPCMPEQW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)  VPCMPEQW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)  VPCMPEQD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)  VPCMPEQD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)  VPCMPEQQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)  VPCMPEQQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)  VPCMPEQB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)  VPCMPEQB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)  VPCMPEQW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)  VPCMPEQW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)  VPCMPEQD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)  VPCMPEQD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)  VPCMPEQQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)  VPCMPEQQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)  VPCMPGTB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)  VPCMPGTW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)  VPCMPGTD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)  VPCMPGTQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)  VPCMPGTB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)  VPCMPGTW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)  VPCMPGTD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)  VPCMPGTQ ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_cvtsi256_si32 (__m256i a)  VMOVD r/m32, ymm1"""
        ...

    @staticmethod
    @overload
    def convert_to_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_cvtsi256_si32 (__m256i a)  VMOVD r/m32, ymm1"""
        ...

    @staticmethod
    @overload
    def convert_to_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_cvtsi256_si32 (__m256i a)  VMOVD r/m32, ymm1"""
        ...

    @staticmethod
    @overload
    def convert_to_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_cvtsi256_si32 (__m256i a)  VMOVD r/m32, ymm1"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi16 (__m128i a)  VPMOVSXBW ymm1,         xmm2/m128  VPMOVSXBW ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi16 (__m128i a)  VPMOVZXBW ymm1,         xmm2/m128  VPMOVZXBW ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBW ymm1,         m128  VPMOVSXBW ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBW ymm1,         m128  VPMOVZXBW ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi16 (__m128i a)  VPMOVSXBW ymm1,         xmm2/m128  VPMOVSXBW ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi16 (__m128i a)  VPMOVZXBW ymm1,         xmm2/m128  VPMOVZXBW ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBW ymm1,         m128  VPMOVSXBW ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBW ymm1,         m128  VPMOVZXBW ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi32 (__m128i a)  VPMOVSXBD ymm1,         xmm2/m64  VPMOVSXBD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi32 (__m128i a)  VPMOVZXBD ymm1,         xmm2/m64  VPMOVZXBD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi16_epi32 (__m128i a)  VPMOVSXWD ymm1,         xmm2/m128  VPMOVSXWD ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu16_epi32 (__m128i a)  VPMOVZXWD ymm1,         xmm2/m128  VPMOVZXWD ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBD ymm1,         m64  VPMOVSXBD ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBD ymm1,         m64  VPMOVZXBD ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXWD ymm1,         m128  VPMOVSXWD ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXWD ymm1,         m128  VPMOVZXWD ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi32 (__m128i a)  VPMOVSXBD ymm1,         xmm2/m64  VPMOVSXBD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi32 (__m128i a)  VPMOVZXBD ymm1,         xmm2/m64  VPMOVZXBD ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi16_epi32 (__m128i a)  VPMOVSXWD ymm1,         xmm2/m128  VPMOVSXWD ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu16_epi32 (__m128i a)  VPMOVZXWD ymm1,         xmm2/m128  VPMOVZXWD ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBD ymm1,         m64  VPMOVSXBD ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBD ymm1,         m64  VPMOVZXBD ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXWD ymm1,         m128  VPMOVSXWD ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXWD ymm1,         m128  VPMOVZXWD ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi64 (__m128i a)  VPMOVSXBQ ymm1,         xmm2/m32  VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi64 (__m128i a)  VPMOVZXBQ ymm1,         xmm2/m32  VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi16_epi64 (__m128i a)  VPMOVSXWQ ymm1,         xmm2/m64  VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu16_epi64 (__m128i a)  VPMOVZXWQ ymm1,         xmm2/m64  VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi32_epi64 (__m128i a)  VPMOVSXDQ ymm1,         xmm2/m128  VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu32_epi64 (__m128i a)  VPMOVZXDQ ymm1,         xmm2/m128  VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBQ ymm1,         m32  VPMOVSXBQ ymm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBQ ymm1,         m32  VPMOVZXBQ ymm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXWQ ymm1,         m64  VPMOVSXWQ ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXWQ ymm1,         m64  VPMOVZXWQ ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXDQ ymm1,         m128  VPMOVSXDQ ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXDQ ymm1,         m128  VPMOVZXDQ ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi8_epi64 (__m128i a)  VPMOVSXBQ ymm1,         xmm2/m32  VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu8_epi64 (__m128i a)  VPMOVZXBQ ymm1,         xmm2/m32  VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi16_epi64 (__m128i a)  VPMOVSXWQ ymm1,         xmm2/m64  VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu16_epi64 (__m128i a)  VPMOVZXWQ ymm1,         xmm2/m64  VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepi32_epi64 (__m128i a)  VPMOVSXDQ ymm1,         xmm2/m128  VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_cvtepu32_epi64 (__m128i a)  VPMOVZXDQ ymm1,         xmm2/m128  VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128"""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXBQ ymm1,         m32  VPMOVSXBQ ymm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXBQ ymm1,         m32  VPMOVZXBQ ymm1 {k1}{z}, m32The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXWQ ymm1,         m64  VPMOVSXWQ ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXWQ ymm1,         m64  VPMOVZXWQ ymm1 {k1}{z}, m64The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVSXDQ ymm1,         m128  VPMOVSXDQ ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def convert_to_vector_256_int_64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """VPMOVZXDQ ymm1,         m128  VPMOVZXDQ ymm1 {k1}{z}, m128The native signature does not exist. We provide this additional overload for completeness."""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def extract_vector_128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_extracti128_si256 (__m256i a, const int imm8)  VEXTRACTI128  xmm1/m128,         ymm2, imm8  VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)  VGATHERDPS xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)  VGATHERDPD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)  VGATHERQPS xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)  VGATHERQPD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)  VGATHERQPS xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)  VGATHERDPS xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)  VGATHERDPD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)  VGATHERQPS xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)  VGATHERQPD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)  VPGATHERQD xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_128(source: System.Runtime.Intrinsics.Vector128[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)  VGATHERQPS xmm1, vm32y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)  VPGATHERDPS ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)  VPGATHERDPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERQQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERQQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)  VGATHERQPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)  VPGATHERDPS ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)  VPGATHERDPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERQQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[int], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)  VPGATHERQQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_mask_vector_256(source: System.Runtime.Intrinsics.Vector256[float], base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)  VGATHERQPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)  VGATHERDPS xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERDPD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)  VGATHERQPS xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERQPD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERQD xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERQD xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)  VGATHERQPS xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERDD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)  VGATHERDPS xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERDPD xmm1, vm32x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)  VPGATHERQD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERQQ xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)  VGATHERQPS xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERQPD xmm1, vm64x, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERQD xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERQD xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_128(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """__m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)  VGATHERQPS xmm1, vm64y, xmm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)  VGATHERDPS ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERDPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)  VPGATHERQQ ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)  VPGATHERQQ ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)  VGATHERQPD ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)  VPGATHERDD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)  VPGATHERDQ ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)  VGATHERDPS ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)  VGATHERDPD ymm1, vm32y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)  VPGATHERQQ ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)  VPGATHERQQ ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def gather_vector_256(base_address: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)  VGATHERQPD ymm1, vm64y, ymm2The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown."""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadd_epi16 (__m256i a, __m256i b)  VPHADDW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadd_epi32 (__m256i a, __m256i b)  VPHADDD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadd_epi16 (__m256i a, __m256i b)  VPHADDW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadd_epi32 (__m256i a, __m256i b)  VPHADDD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadds_epi16 (__m256i a, __m256i b)  VPHADDSW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_add_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hadds_epi16 (__m256i a, __m256i b)  VPHADDSW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsub_epi16 (__m256i a, __m256i b)  VPHSUBW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsub_epi32 (__m256i a, __m256i b)  VPHSUBD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsub_epi16 (__m256i a, __m256i b)  VPHSUBW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsub_epi32 (__m256i a, __m256i b)  VPHSUBD ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)  VPHSUBSW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def horizontal_subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)  VPHSUBSW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def insert_vector_128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)  VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8  VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def load_aligned_vector_256_non_temporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_stream_load_si256 (__m256i const* mem_addr)  VMOVNTDQA ymm1, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)  VPMASKMOVD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)  VPMASKMOVD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)  VPMASKMOVQ xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)  VPMASKMOVQ xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)  VPMASKMOVD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)  VPMASKMOVD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)  VPMASKMOVQ ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)  VPMASKMOVQ ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)  VPMASKMOVD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)  VPMASKMOVD xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)  VPMASKMOVQ xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)  VPMASKMOVQ xmm1, xmm2, m128"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)  VPMASKMOVD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)  VPMASKMOVD ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)  VPMASKMOVQ ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_load(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)  VPMASKMOVQ ymm1, ymm2, m256"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)  VPMASKMOVD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)  VPMASKMOVD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)  VPMASKMOVQ m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)  VPMASKMOVQ m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)  VPMASKMOVD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)  VPMASKMOVD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)  VPMASKMOVQ m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)  VPMASKMOVQ m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)  VPMASKMOVD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)  VPMASKMOVD m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)  VPMASKMOVQ m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)  VPMASKMOVQ m128, xmm1, xmm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)  VPMASKMOVD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)  VPMASKMOVD m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)  VPMASKMOVQ m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def mask_store(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)  VPMASKMOVQ m256, ymm1, ymm2"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi8 (__m256i a, __m256i b)  VPMAXSB ymm1,         ymm2, ymm3/m256  VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu8 (__m256i a, __m256i b)  VPMAXUB ymm1,         ymm2, ymm3/m256  VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi16 (__m256i a, __m256i b)  VPMAXSW ymm1,         ymm2, ymm3/m256  VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu16 (__m256i a, __m256i b)  VPMAXUW ymm1,         ymm2, ymm3/m256  VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi32 (__m256i a, __m256i b)  VPMAXSD ymm1,         ymm2, ymm3/m256  VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu32 (__m256i a, __m256i b)  VPMAXUD ymm1,         ymm2, ymm3/m256  VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi8 (__m256i a, __m256i b)  VPMAXSB ymm1,         ymm2, ymm3/m256  VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu8 (__m256i a, __m256i b)  VPMAXUB ymm1,         ymm2, ymm3/m256  VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi16 (__m256i a, __m256i b)  VPMAXSW ymm1,         ymm2, ymm3/m256  VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu16 (__m256i a, __m256i b)  VPMAXUW ymm1,         ymm2, ymm3/m256  VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epi32 (__m256i a, __m256i b)  VPMAXSD ymm1,         ymm2, ymm3/m256  VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_max_epu32 (__m256i a, __m256i b)  VPMAXUD ymm1,         ymm2, ymm3/m256  VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi8 (__m256i a, __m256i b)  VPMINSB ymm1,         ymm2, ymm3/m256  VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu8 (__m256i a, __m256i b)  VPMINUB ymm1,         ymm2, ymm3/m256  VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi16 (__m256i a, __m256i b)  VPMINSW ymm1,         ymm2, ymm3/m256  VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu16 (__m256i a, __m256i b)  VPMINUW ymm1,         ymm2, ymm3/m256  VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi32 (__m256i a, __m256i b)  VPMINSD ymm1,         ymm2, ymm3/m256  VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu32 (__m256i a, __m256i b)  VPMINUD ymm1,         ymm2, ymm3/m256  VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi8 (__m256i a, __m256i b)  VPMINSB ymm1,         ymm2, ymm3/m256  VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu8 (__m256i a, __m256i b)  VPMINUB ymm1,         ymm2, ymm3/m256  VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi16 (__m256i a, __m256i b)  VPMINSW ymm1,         ymm2, ymm3/m256  VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu16 (__m256i a, __m256i b)  VPMINUW ymm1,         ymm2, ymm3/m256  VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epi32 (__m256i a, __m256i b)  VPMINSD ymm1,         ymm2, ymm3/m256  VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_min_epu32 (__m256i a, __m256i b)  VPMINUD ymm1,         ymm2, ymm3/m256  VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_movemask_epi8 (__m256i a)  VPMOVMSKB r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_movemask_epi8 (__m256i a)  VPMOVMSKB r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_movemask_epi8 (__m256i a)  VPMOVMSKB r32, ymm1"""
        ...

    @staticmethod
    @overload
    def move_mask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """int _mm256_movemask_epi8 (__m256i a)  VPMOVMSKB r32, ymm1"""
        ...

    @staticmethod
    @overload
    def multiple_sum_absolute_differences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)  VMPSADBW ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def multiple_sum_absolute_differences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)  VMPSADBW ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mul_epi32 (__m256i a, __m256i b)  VPMULDQ ymm1,         ymm2, ymm3/m256  VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mul_epu32 (__m256i a, __m256i b)  VPMULUDQ ymm1,         ymm2, ymm3/m256  VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mul_epi32 (__m256i a, __m256i b)  VPMULDQ ymm1,         ymm2, ymm3/m256  VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mul_epu32 (__m256i a, __m256i b)  VPMULUDQ ymm1,         ymm2, ymm3/m256  VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_madd_epi16 (__m256i a, __m256i b)  VPMADDWD ymm1,         ymm2, ymm3/m256  VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)  VPMADDUBSW ymm1,         ymm2, ymm3/m256  VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_madd_epi16 (__m256i a, __m256i b)  VPMADDWD ymm1,         ymm2, ymm3/m256  VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_add_adjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)  VPMADDUBSW ymm1,         ymm2, ymm3/m256  VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)  VPMULHW ymm1,         ymm2, ymm3/m256  VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)  VPMULHUW ymm1,         ymm2, ymm3/m256  VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)  VPMULHW ymm1,         ymm2, ymm3/m256  VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)  VPMULHUW ymm1,         ymm2, ymm3/m256  VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high_round_scale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)  VPMULHRSW ymm1,         ymm2, ymm3/m256  VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_high_round_scale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)  VPMULHRSW ymm1,         ymm2, ymm3/m256  VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi16 (__m256i a, __m256i b)  VPMULLW ymm1,         ymm2, ymm3/m256  VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi16 (__m256i a, __m256i b)  VPMULLW ymm1,         ymm2, ymm3/m256  VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi32 (__m256i a, __m256i b)  VPMULLD ymm1,         ymm2, ymm3/m256  VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi32 (__m256i a, __m256i b)  VPMULLD ymm1,         ymm2, ymm3/m256  VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi16 (__m256i a, __m256i b)  VPMULLW ymm1,         ymm2, ymm3/m256  VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi16 (__m256i a, __m256i b)  VPMULLW ymm1,         ymm2, ymm3/m256  VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi32 (__m256i a, __m256i b)  VPMULLD ymm1,         ymm2, ymm3/m256  VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def multiply_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_mullo_epi32 (__m256i a, __m256i b)  VPMULLD ymm1,         ymm2, ymm3/m256  VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_or_si256 (__m256i a, __m256i b)  VPOR  ymm1,         ymm2, ymm3/m256  VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packs_epi16 (__m256i a, __m256i b)  VPACKSSWB ymm1,         ymm2, ymm3/m256  VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packs_epi32 (__m256i a, __m256i b)  VPACKSSDW ymm1,         ymm2, ymm3/m256  VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packs_epi16 (__m256i a, __m256i b)  VPACKSSWB ymm1,         ymm2, ymm3/m256  VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def pack_signed_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packs_epi32 (__m256i a, __m256i b)  VPACKSSDW ymm1,         ymm2, ymm3/m256  VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packus_epi16 (__m256i a, __m256i b)  VPACKUSWB ymm1,         ymm2, ymm3/m256  VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packus_epi32 (__m256i a, __m256i b)  VPACKUSDW ymm1,         ymm2, ymm3/m256  VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packus_epi16 (__m256i a, __m256i b)  VPACKUSWB ymm1,         ymm2, ymm3/m256  VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def pack_unsigned_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_packus_epi32 (__m256i a, __m256i b)  VPACKUSDW ymm1,         ymm2, ymm3/m256  VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)  VPERM2I128 ymm1, ymm2, ymm3/m256, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)  VPERMQ ymm1,         ymm2/m256,         imm8  VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)  VPERMQ ymm1,         ymm2/m256,         imm8  VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute4x64_pd (__m256d a, const int imm8)  VPERMPD ymm1,         ymm2/m256,         imm8  VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)  VPERMQ ymm1,         ymm2/m256,         imm8  VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)  VPERMQ ymm1,         ymm2/m256,         imm8  VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_4x_64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256d _mm256_permute4x64_pd (__m256d a, const int imm8)  VPERMPD ymm1,         ymm2/m256,         imm8  VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)  VPERMD ymm1,         ymm2/m256,         imm8  VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)  VPERMD ymm1,         ymm2/m256,         imm8  VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)  VPERMPS ymm1,         ymm2/m256,         imm8  VPERMPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)  VPERMD ymm1,         ymm2/m256,         imm8  VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)  VPERMD ymm1,         ymm2/m256,         imm8  VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def permute_var_8x_32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """__m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)  VPERMPS ymm1,         ymm2/m256,         imm8  VPERMPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi16 (__m256i a, __m128i count)  VPSLLW ymm1,         ymm2, xmm3/m128  VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi16 (__m256i a, __m128i count)  VPSLLW ymm1,         ymm2, xmm3/m128  VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi32 (__m256i a, __m128i count)  VPSLLD ymm1,         ymm2, xmm3/m128  VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi32 (__m256i a, __m128i count)  VPSLLD ymm1,         ymm2, xmm3/m128  VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi64 (__m256i a, __m128i count)  VPSLLQ ymm1,         ymm2, xmm3/m128  VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi64 (__m256i a, __m128i count)  VPSLLQ ymm1,         ymm2, xmm3/m128  VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi16 (__m256i a, int imm8)  VPSLLW ymm1,         ymm2, imm8  VPSLLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi16 (__m256i a, int imm8)  VPSLLW ymm1,         ymm2, imm8  VPSLLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi32 (__m256i a, int imm8)  VPSLLD ymm1,         ymm2, imm8  VPSLLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi32 (__m256i a, int imm8)  VPSLLD ymm1,         ymm2, imm8  VPSLLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi64 (__m256i a, int imm8)  VPSLLQ ymm1,         ymm2, imm8  VPSLLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi64 (__m256i a, int imm8)  VPSLLQ ymm1,         ymm2, imm8  VPSLLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi16 (__m256i a, __m128i count)  VPSLLW ymm1,         ymm2, xmm3/m128  VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi16 (__m256i a, __m128i count)  VPSLLW ymm1,         ymm2, xmm3/m128  VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi32 (__m256i a, __m128i count)  VPSLLD ymm1,         ymm2, xmm3/m128  VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi32 (__m256i a, __m128i count)  VPSLLD ymm1,         ymm2, xmm3/m128  VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi64 (__m256i a, __m128i count)  VPSLLQ ymm1,         ymm2, xmm3/m128  VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sll_epi64 (__m256i a, __m128i count)  VPSLLQ ymm1,         ymm2, xmm3/m128  VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi16 (__m256i a, int imm8)  VPSLLW ymm1,         ymm2, imm8  VPSLLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi16 (__m256i a, int imm8)  VPSLLW ymm1,         ymm2, imm8  VPSLLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi32 (__m256i a, int imm8)  VPSLLD ymm1,         ymm2, imm8  VPSLLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi32 (__m256i a, int imm8)  VPSLLD ymm1,         ymm2, imm8  VPSLLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi64 (__m256i a, int imm8)  VPSLLQ ymm1,         ymm2, imm8  VPSLLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_slli_epi64 (__m256i a, int imm8)  VPSLLQ ymm1,         ymm2, imm8  VPSLLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bslli_epi128 (__m256i a, const int imm8)  VPSLLDQ ymm1, ymm2/m256, imm8This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi32 (__m128i a, __m128i count)  VPSLLVD xmm1,         xmm2, xmm3/m128  VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi32 (__m128i a, __m128i count)  VPSLLVD xmm1,         xmm2, xmm3/m128  VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi64 (__m128i a, __m128i count)  VPSLLVQ xmm1,         xmm2, xmm3/m128  VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi64 (__m128i a, __m128i count)  VPSLLVQ xmm1,         xmm2, xmm3/m128  VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi32 (__m256i a, __m256i count)  VPSLLVD ymm1,         ymm2, ymm3/m256  VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi32 (__m256i a, __m256i count)  VPSLLVD ymm1,         ymm2, ymm3/m256  VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi64 (__m256i a, __m256i count)  VPSLLVQ ymm1,         ymm2, ymm3/m256  VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi64 (__m256i a, __m256i count)  VPSLLVQ ymm1,         ymm2, ymm3/m256  VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi32 (__m128i a, __m128i count)  VPSLLVD xmm1,         xmm2, xmm3/m128  VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi32 (__m128i a, __m128i count)  VPSLLVD xmm1,         xmm2, xmm3/m128  VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi64 (__m128i a, __m128i count)  VPSLLVQ xmm1,         xmm2, xmm3/m128  VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_sllv_epi64 (__m128i a, __m128i count)  VPSLLVQ xmm1,         xmm2, xmm3/m128  VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi32 (__m256i a, __m256i count)  VPSLLVD ymm1,         ymm2, ymm3/m256  VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi32 (__m256i a, __m256i count)  VPSLLVD ymm1,         ymm2, ymm3/m256  VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi64 (__m256i a, __m256i count)  VPSLLVQ ymm1,         ymm2, ymm3/m256  VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_left_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sllv_epi64 (__m256i a, __m256i count)  VPSLLVQ ymm1,         ymm2, ymm3/m256  VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """_mm256_sra_epi16 (__m256i a, __m128i count)  VPSRAW ymm1,         ymm2, xmm3/m128  VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """_mm256_sra_epi32 (__m256i a, __m128i count)  VPSRAD ymm1,         ymm2, xmm3/m128  VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srai_epi16 (__m256i a, int imm8)  VPSRAW ymm1,         ymm2, imm8  VPSRAW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srai_epi32 (__m256i a, int imm8)  VPSRAD ymm1,         ymm2, imm8  VPSRAD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """_mm256_sra_epi16 (__m256i a, __m128i count)  VPSRAW ymm1,         ymm2, xmm3/m128  VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """_mm256_sra_epi32 (__m256i a, __m128i count)  VPSRAD ymm1,         ymm2, xmm3/m128  VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srai_epi16 (__m256i a, int imm8)  VPSRAW ymm1,         ymm2, imm8  VPSRAW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srai_epi32 (__m256i a, int imm8)  VPSRAD ymm1,         ymm2, imm8  VPSRAD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srav_epi32 (__m128i a, __m128i count)  VPSRAVD xmm1,         xmm2, xmm3/m128  VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srav_epi32 (__m256i a, __m256i count)  VPSRAVD ymm1,         ymm2, ymm3/m256  VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srav_epi32 (__m128i a, __m128i count)  VPSRAVD xmm1,         xmm2, xmm3/m128  VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srav_epi32 (__m256i a, __m256i count)  VPSRAVD ymm1,         ymm2, ymm3/m256  VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi16 (__m256i a, __m128i count)  VPSRLW ymm1,         ymm2, xmm3/m128  VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi16 (__m256i a, __m128i count)  VPSRLW ymm1,         ymm2, xmm3/m128  VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi32 (__m256i a, __m128i count)  VPSRLD ymm1,         ymm2, xmm3/m128  VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi32 (__m256i a, __m128i count)  VPSRLD ymm1,         ymm2, xmm3/m128  VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi64 (__m256i a, __m128i count)  VPSRLQ ymm1,         ymm2, xmm3/m128  VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi64 (__m256i a, __m128i count)  VPSRLQ ymm1,         ymm2, xmm3/m128  VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi16 (__m256i a, int imm8)  VPSRLW ymm1,         ymm2, imm8  VPSRLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi16 (__m256i a, int imm8)  VPSRLW ymm1,         ymm2, imm8  VPSRLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi32 (__m256i a, int imm8)  VPSRLD ymm1,         ymm2, imm8  VPSRLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi32 (__m256i a, int imm8)  VPSRLD ymm1,         ymm2, imm8  VPSRLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi64 (__m256i a, int imm8)  VPSRLQ ymm1,         ymm2, imm8  VPSRLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi64 (__m256i a, int imm8)  VPSRLQ ymm1,         ymm2, imm8  VPSRLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi16 (__m256i a, __m128i count)  VPSRLW ymm1,         ymm2, xmm3/m128  VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi16 (__m256i a, __m128i count)  VPSRLW ymm1,         ymm2, xmm3/m128  VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi32 (__m256i a, __m128i count)  VPSRLD ymm1,         ymm2, xmm3/m128  VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi32 (__m256i a, __m128i count)  VPSRLD ymm1,         ymm2, xmm3/m128  VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi64 (__m256i a, __m128i count)  VPSRLQ ymm1,         ymm2, xmm3/m128  VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srl_epi64 (__m256i a, __m128i count)  VPSRLQ ymm1,         ymm2, xmm3/m128  VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi16 (__m256i a, int imm8)  VPSRLW ymm1,         ymm2, imm8  VPSRLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi16 (__m256i a, int imm8)  VPSRLW ymm1,         ymm2, imm8  VPSRLW ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi32 (__m256i a, int imm8)  VPSRLD ymm1,         ymm2, imm8  VPSRLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi32 (__m256i a, int imm8)  VPSRLD ymm1,         ymm2, imm8  VPSRLD ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi64 (__m256i a, int imm8)  VPSRLQ ymm1,         ymm2, imm8  VPSRLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srli_epi64 (__m256i a, int imm8)  VPSRLQ ymm1,         ymm2, imm8  VPSRLQ ymm1 {k1}{z}, ymm2, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_128_bit_lane(value: System.Runtime.Intrinsics.Vector256[int], num_bytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)  VPSRLDQ ymm1, ymm2/m128, imm8This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors."""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi32 (__m128i a, __m128i count)  VPSRLVD xmm1,         xmm2, xmm3/m128  VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi32 (__m128i a, __m128i count)  VPSRLVD xmm1,         xmm2, xmm3/m128  VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi64 (__m128i a, __m128i count)  VPSRLVQ xmm1,         xmm2, xmm3/m128  VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi64 (__m128i a, __m128i count)  VPSRLVQ xmm1,         xmm2, xmm3/m128  VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi32 (__m256i a, __m256i count)  VPSRLVD ymm1,         ymm2, ymm3/m256  VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi32 (__m256i a, __m256i count)  VPSRLVD ymm1,         ymm2, ymm3/m256  VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi64 (__m256i a, __m256i count)  VPSRLVQ ymm1,         ymm2, ymm3/m256  VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi64 (__m256i a, __m256i count)  VPSRLVQ ymm1,         ymm2, ymm3/m256  VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi32 (__m128i a, __m128i count)  VPSRLVD xmm1,         xmm2, xmm3/m128  VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi32 (__m128i a, __m128i count)  VPSRLVD xmm1,         xmm2, xmm3/m128  VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi64 (__m128i a, __m128i count)  VPSRLVQ xmm1,         xmm2, xmm3/m128  VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """__m128i _mm_srlv_epi64 (__m128i a, __m128i count)  VPSRLVQ xmm1,         xmm2, xmm3/m128  VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi32 (__m256i a, __m256i count)  VPSRLVD ymm1,         ymm2, ymm3/m256  VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi32 (__m256i a, __m256i count)  VPSRLVD ymm1,         ymm2, ymm3/m256  VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi64 (__m256i a, __m256i count)  VPSRLVQ ymm1,         ymm2, ymm3/m256  VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shift_right_logical_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_srlv_epi64 (__m256i a, __m256i count)  VPSRLVQ ymm1,         ymm2, ymm3/m256  VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)  VPSHUFB ymm1,         ymm2, ymm3/m256  VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)  VPSHUFB ymm1,         ymm2, ymm3/m256  VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)  VPSHUFD ymm1,         ymm2/m256,         imm8  VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)  VPSHUFD ymm1,         ymm2/m256,         imm8  VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)  VPSHUFB ymm1,         ymm2, ymm3/m256  VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)  VPSHUFB ymm1,         ymm2, ymm3/m256  VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)  VPSHUFD ymm1,         ymm2/m256,         imm8  VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)  VPSHUFD ymm1,         ymm2/m256,         imm8  VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)  VPSHUFHW ymm1,         ymm2/m256, imm8  VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)  VPSHUFHW ymm1,         ymm2/m256, imm8  VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)  VPSHUFHW ymm1,         ymm2/m256, imm8  VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_high(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)  VPSHUFHW ymm1,         ymm2/m256, imm8  VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)  VPSHUFLW ymm1,         ymm2/m256, imm8  VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)  VPSHUFLW ymm1,         ymm2/m256, imm8  VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)  VPSHUFLW ymm1,         ymm2/m256, imm8  VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def shuffle_low(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)  VPSHUFLW ymm1,         ymm2/m256, imm8  VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi8 (__m256i a, __m256i b)  VPSIGNB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi16 (__m256i a, __m256i b)  VPSIGNW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi32 (__m256i a, __m256i b)  VPSIGND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi8 (__m256i a, __m256i b)  VPSIGNB ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi16 (__m256i a, __m256i b)  VPSIGNW ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sign_epi32 (__m256i a, __m256i b)  VPSIGND ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi8 (__m256i a, __m256i b)  VPSUBB ymm1,         ymm2, ymm3/m256  VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi8 (__m256i a, __m256i b)  VPSUBB ymm1,         ymm2, ymm3/m256  VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi16 (__m256i a, __m256i b)  VPSUBW ymm1,         ymm2, ymm3/m256  VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi16 (__m256i a, __m256i b)  VPSUBW ymm1,         ymm2, ymm3/m256  VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi32 (__m256i a, __m256i b)  VPSUBD ymm1,         ymm2, ymm3/m256  VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi32 (__m256i a, __m256i b)  VPSUBD ymm1,         ymm2, ymm3/m256  VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi64 (__m256i a, __m256i b)  VPSUBQ ymm1,         ymm2, ymm3/m256  VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi64 (__m256i a, __m256i b)  VPSUBQ ymm1,         ymm2, ymm3/m256  VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi8 (__m256i a, __m256i b)  VPSUBB ymm1,         ymm2, ymm3/m256  VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi8 (__m256i a, __m256i b)  VPSUBB ymm1,         ymm2, ymm3/m256  VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi16 (__m256i a, __m256i b)  VPSUBW ymm1,         ymm2, ymm3/m256  VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi16 (__m256i a, __m256i b)  VPSUBW ymm1,         ymm2, ymm3/m256  VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi32 (__m256i a, __m256i b)  VPSUBD ymm1,         ymm2, ymm3/m256  VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi32 (__m256i a, __m256i b)  VPSUBD ymm1,         ymm2, ymm3/m256  VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi64 (__m256i a, __m256i b)  VPSUBQ ymm1,         ymm2, ymm3/m256  VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sub_epi64 (__m256i a, __m256i b)  VPSUBQ ymm1,         ymm2, ymm3/m256  VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epi8 (__m256i a, __m256i b)  VPSUBSB ymm1,         ymm2, ymm3/m128  VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epi16 (__m256i a, __m256i b)  VPSUBSW ymm1,         ymm2, ymm3/m128  VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epu8 (__m256i a, __m256i b)  VPSUBUSB ymm1,         ymm2, ymm3/m128  VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epu16 (__m256i a, __m256i b)  VPSUBUSW ymm1,         ymm2, ymm3/m128  VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epi8 (__m256i a, __m256i b)  VPSUBSB ymm1,         ymm2, ymm3/m128  VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epi16 (__m256i a, __m256i b)  VPSUBSW ymm1,         ymm2, ymm3/m128  VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epu8 (__m256i a, __m256i b)  VPSUBUSB ymm1,         ymm2, ymm3/m128  VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def subtract_saturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_subs_epu16 (__m256i a, __m256i b)  VPSUBUSW ymm1,         ymm2, ymm3/m128  VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m128"""
        ...

    @staticmethod
    @overload
    def sum_absolute_differences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sad_epu8 (__m256i a, __m256i b)  VPSADBW ymm1,         ymm2, ymm3/m256  VPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def sum_absolute_differences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_sad_epu8 (__m256i a, __m256i b)  VPSADBW ymm1,         ymm2, ymm3/m256  VPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)  VPUNPCKHBW ymm1,         ymm2, ymm3/m256  VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)  VPUNPCKHBW ymm1,         ymm2, ymm3/m256  VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)  VPUNPCKHWD ymm1,         ymm2, ymm3/m256  VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)  VPUNPCKHWD ymm1,         ymm2, ymm3/m256  VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)  VPUNPCKHDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)  VPUNPCKHDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)  VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)  VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)  VPUNPCKHBW ymm1,         ymm2, ymm3/m256  VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)  VPUNPCKHBW ymm1,         ymm2, ymm3/m256  VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)  VPUNPCKHWD ymm1,         ymm2, ymm3/m256  VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)  VPUNPCKHWD ymm1,         ymm2, ymm3/m256  VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)  VPUNPCKHDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)  VPUNPCKHDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)  VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_high(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)  VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)  VPUNPCKLBW ymm1,         ymm2, ymm3/m256  VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)  VPUNPCKLBW ymm1,         ymm2, ymm3/m256  VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)  VPUNPCKLWD ymm1,         ymm2, ymm3/m256  VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)  VPUNPCKLWD ymm1,         ymm2, ymm3/m256  VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)  VPUNPCKLDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)  VPUNPCKLDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)  VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)  VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)  VPUNPCKLBW ymm1,         ymm2, ymm3/m256  VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)  VPUNPCKLBW ymm1,         ymm2, ymm3/m256  VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)  VPUNPCKLWD ymm1,         ymm2, ymm3/m256  VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)  VPUNPCKLWD ymm1,         ymm2, ymm3/m256  VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)  VPUNPCKLDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)  VPUNPCKLDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)  VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def unpack_low(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)  VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256  VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR ymm1, ymm2, ymm3/m256"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...

    @staticmethod
    @overload
    def xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """__m256i _mm256_xor_si256 (__m256i a, __m256i b)  VPXOR  ymm1,         ymm2, ymm3/m256  VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
        ...


class FloatRoundingMode(Enum):
    """This class has no documentation."""

    TO_EVEN = ...
    """_MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC"""

    TO_NEGATIVE_INFINITY = ...
    """_MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC"""

    TO_POSITIVE_INFINITY = ...
    """_MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC"""

    TO_ZERO = ...
    """_MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC"""


class Avx512F(System.Runtime.Intrinsics.X86.Avx2, metaclass=abc.ABCMeta):
    """Provides access to X86 AVX512F hardware instructions via intrinsics."""

    class VL(System.Object, metaclass=abc.ABCMeta):
        """Provides access to the x86 AVX512F+VL hardware instructions via intrinsics."""

        IS_SUPPORTED: bool
        """Gets a value that indicates whether the APIs in this class are supported."""

        @staticmethod
        @overload
        def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_abs_epi64 (__m128i a)  VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_abs_epi64 (__m128i a)  VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_abs_epi64 (__m128i a)  VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_abs_epi64 (__m128i a)  VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi32 (__m128i a, __m128i b, const int count)  VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi32 (__m128i a, __m128i b, const int count)  VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi32 (__m256i a, __m256i b, const int count)  VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi32 (__m256i a, __m256i b, const int count)  VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi32 (__m128i a, __m128i b, const int count)  VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi32 (__m128i a, __m128i b, const int count)  VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi32 (__m256i a, __m256i b, const int count)  VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_32(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi32 (__m256i a, __m256i b, const int count)  VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi64 (__m128i a, __m128i b, const int count)  VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi64 (__m128i a, __m128i b, const int count)  VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi64 (__m256i a, __m256i b, const int count)  VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi64 (__m256i a, __m256i b, const int count)  VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi64 (__m128i a, __m128i b, const int count)  VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_alignr_epi64 (__m128i a, __m128i b, const int count)  VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi64 (__m256i a, __m256i b, const int count)  VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def align_right_64(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_alignr_epi64 (__m256i a, __m256i b, const int count)  VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpgt_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpgt_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpgt_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpgt_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpgt_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpgt_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpgt_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpgt_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(6)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpge_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_greater_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpge_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(5)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmplt_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmplt_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(1)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmple_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_less_than_or_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmple_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(2)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epi32 (__m128i a, __m128i b)  VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epi32 (__m256i a, __m256i b)  VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epi64 (__m128i a, __m128i b)  VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epi64 (__m256i a, __m256i b)  VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epu32 (__m128i a, __m128i b)  VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epu32 (__m256i a, __m256i b)  VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cmpne_epu64 (__m128i a, __m128i b)  VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def compare_not_equal(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cmpne_epu64 (__m256i a, __m256i b)  VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8(4)"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi32_epi8 (__m128i a)  VPMOVUSDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi64_epi8 (__m128i a)  VPMOVUSQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi32_epi8 (__m256i a)  VPMOVUSDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi8 (__m256i a)  VPMOVUSQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi32_epi8 (__m128i a)  VPMOVUSDB xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi64_epi8 (__m128i a)  VPMOVUSQB xmm1/m16 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi32_epi8 (__m256i a)  VPMOVUSDB xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi8 (__m256i a)  VPMOVUSQB xmm1/m32 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_cvtepu32_pd (__m128i a)  VCVTUDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_cvtepu32_pd (__m128i a)  VCVTUDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi32_epi16 (__m128i a)  VPMOVSDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi64_epi16 (__m128i a)  VPMOVSQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi32_epi16 (__m256i a)  VPMOVSDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi16 (__m256i a)  VPMOVSQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi32_epi16 (__m128i a)  VPMOVSDW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi64_epi16 (__m128i a)  VPMOVSQW xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi32_epi16 (__m256i a)  VPMOVSDW xmm1/m128 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi16 (__m256i a)  VPMOVSQW xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm128_cvtsepi64_epi32 (__m128i a)  VPMOVSQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi32 (__m256i a)  VPMOVSQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi64_epi32 (__m128i a)  VPMOVSQD xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi32 (__m256i a)  VPMOVSQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi8 (__m128i a)  VPMOVDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi8 (__m128i a)  VPMOVQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi8 (__m256i a)  VPMOVDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi8 (__m256i a)  VPMOVQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi32_epi8 (__m128i a)  VPMOVSDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi64_epi8 (__m128i a)  VPMOVSQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi32_epi8 (__m256i a)  VPMOVSDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi8 (__m256i a)  VPMOVSQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi32_epi8 (__m128i a)  VPMOVSDB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtsepi64_epi8 (__m128i a)  VPMOVSQB xmm1/m16 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi32_epi8 (__m256i a)  VPMOVSDB xmm1/m64 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_s_byte_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtsepi64_epi8 (__m256i a)  VPMOVSQB xmm1/m32 {k1}{z}, zmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_cvtepu32_ps (__m128i a)  VCVTUDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_cvtepu32_ps (__m128i a)  VCVTUDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi32_epi16 (__m128i a)  VPMOVDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi16 (__m128i a)  VPMOVQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi32_epi16 (__m256i a)  VPMOVDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi16 (__m256i a)  VPMOVQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi32_epi16 (__m128i a)  VPMOVUSDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi64_epi16 (__m128i a)  VPMOVUSQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi32_epi16 (__m256i a)  VPMOVUSDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi16 (__m256i a)  VPMOVUSQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi32_epi16 (__m128i a)  VPMOVUSDW xmm1/m64 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi64_epi16 (__m128i a)  VPMOVUSQW xmm1/m32 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi32_epi16 (__m256i a)  VPMOVUSDW xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_16_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi16 (__m256i a)  VPMOVUSQW xmm1/m64 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm128_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm128_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtps_epu32 (__m128 a)  VCVTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtpd_epu32 (__m128d a)  VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtpd_epu32 (__m256d a)  VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtepi64_epi32 (__m128i a)  VPMOVQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtps_epu32 (__m128 a)  VCVTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtpd_epu32 (__m128d a)  VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtepi64_epi32 (__m256i a)  VPMOVQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtpd_epu32 (__m256d a)  VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm128_cvtusepi64_epi32 (__m128i a)  VPMOVUSQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi32 (__m256i a)  VPMOVUSQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvtusepi64_epi32 (__m128i a)  VPMOVUSQD xmm1/m128 {k1}{z}, xmm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_saturation(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvtusepi64_epi32 (__m256i a)  VPMOVUSQD xmm1/m128 {k1}{z}, ymm2"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvttps_epu32 (__m128 a)  VCVTTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvttpd_epu32 (__m128d a)  VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvttpd_epu32 (__m256d a)  VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvttps_epu32 (__m128 a)  VCVTTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_cvttpd_epu32 (__m128d a)  VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_128_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm256_cvttpd_epu32 (__m256d a)  VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm512_cvtepu32_pd (__m128i a)  VCVTUDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm512_cvtepu32_pd (__m128i a)  VCVTUDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_cvtepu32_ps (__m256i a)  VCVTUDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_cvtepu32_ps (__m256i a)  VCVTUDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_u_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cvtps_epu32 (__m256 a)  VCVTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_u_int_32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cvtps_epu32 (__m256 a)  VCVTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cvttps_epu32 (__m256 a)  VCVTTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def convert_to_vector_256_u_int_32_with_truncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_cvttps_epu32 (__m256 a)  VCVTTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], table: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_fixupimm_ps(__m128 a, __m128 b, __m128i tbl, int imm);  VFIXUPIMMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], table: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_fixupimm_pd(__m128d a, __m128d b, __m128i tbl, int imm);  VFIXUPIMMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], table: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_fixupimm_ps(__m256 a, __m256 b, __m256i tbl, int imm);  VFIXUPIMMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], table: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_fixupimm_pd(__m256d a, __m256d b, __m256i tbl, int imm);  VFIXUPIMMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], table: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_fixupimm_ps(__m128 a, __m128 b, __m128i tbl, int imm);  VFIXUPIMMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], table: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_fixupimm_pd(__m128d a, __m128d b, __m128i tbl, int imm);  VFIXUPIMMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], table: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_fixupimm_ps(__m256 a, __m256 b, __m256i tbl, int imm);  VFIXUPIMMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def fixup(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], table: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_fixupimm_pd(__m256d a, __m256d b, __m256i tbl, int imm);  VFIXUPIMMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_getexp_ps (__m128 a)  VGETEXPPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_getexp_pd (__m128d a)  VGETEXPPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_getexp_ps (__m256 a)  VGETEXPPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_getexp_pd (__m256d a)  VGETEXPPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_getexp_ps (__m128 a)  VGETEXPPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_getexp_pd (__m128d a)  VGETEXPPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_getexp_ps (__m256 a)  VGETEXPPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_exponent(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_getexp_pd (__m256d a)  VGETEXPPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_getmant_ps (__m128 a)  VGETMANTPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_getmant_pd (__m128d a)  VGETMANTPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_getmant_ps (__m256 a)  VGETMANTPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_getmant_pd (__m256d a)  VGETMANTPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_getmant_ps (__m128 a)  VGETMANTPS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_getmant_pd (__m128d a)  VGETMANTPD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_getmant_ps (__m256 a)  VGETMANTPS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def get_mantissa(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_getmant_pd (__m256d a)  VGETMANTPD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_max_epi64 (__m128i a, __m128i b)  VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_max_epu64 (__m128i a, __m128i b)  VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_max_epi64 (__m256i a, __m256i b)  VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_max_epu64 (__m256i a, __m256i b)  VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_max_epi64 (__m128i a, __m128i b)  VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_max_epu64 (__m128i a, __m128i b)  VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_max_epi64 (__m256i a, __m256i b)  VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_max_epu64 (__m256i a, __m256i b)  VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_min_epi64 (__m128i a, __m128i b)  VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_min_epu64 (__m128i a, __m128i b)  VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_min_epi64 (__m256i a, __m256i b)  VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_min_epu64 (__m256i a, __m256i b)  VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_min_epi64 (__m128i a, __m128i b)  VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_min_epu64 (__m128i a, __m128i b)  VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_min_epi64 (__m256i a, __m256i b)  VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_min_epu64 (__m256i a, __m256i b)  VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi64 (__m128i a, __m128i idx, __m128i b)  VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi64 (__m128i a, __m128i idx, __m128i b)  VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_permutex2var_pd (__m128d a, __m128i idx, __m128i b)  VPERMI2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi64 (__m128i a, __m128i idx, __m128i b)  VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi64 (__m128i a, __m128i idx, __m128i b)  VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_2x_64x_2(lower: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_permutex2var_pd (__m128d a, __m128i idx, __m128i b)  VPERMI2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst  VPERMT2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi32 (__m128i a, __m128i idx, __m128i b)  VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi32 (__m128i a, __m128i idx, __m128i b)  VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_permutex2var_ps (__m128 a, __m128i idx, __m128i b)  VPERMI2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi32 (__m128i a, __m128i idx, __m128i b)  VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_permutex2var_epi32 (__m128i a, __m128i idx, __m128i b)  VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_32x_2(lower: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_permutex2var_ps (__m128 a, __m128i idx, __m128i b)  VPERMI2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst  VPERMT2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permute4x64_epi64 (__m256i a, __m256i b)  VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permute4x64_pd (__m256d a, __m256i b)  VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_permute4x64_pd (__m256d a, __m256i b)  VPERMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permute4x64_epi64 (__m256i a, __m256i b)  VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permute4x64_pd (__m256d a, __m256i b)  VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64(value: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_permute4x64_pd (__m256d a, __m256i b)  VPERMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi64 (__m256i a, __m256i idx, __m256i b)  VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi64 (__m256i a, __m256i idx, __m256i b)  VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_permutex2var_pd (__m256d a, __m256i idx, __m256i b)  VPERMI2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi64 (__m256i a, __m256i idx, __m256i b)  VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi64 (__m256i a, __m256i idx, __m256i b)  VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_4x_64x_2(lower: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_permutex2var_pd (__m256d a, __m256i idx, __m256i b)  VPERMI2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst  VPERMT2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi32 (__m256i a, __m256i idx, __m256i b)  VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi32 (__m256i a, __m256i idx, __m256i b)  VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_permutex2var_ps (__m256 a, __m256i idx, __m256i b)  VPERMI2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi32 (__m256i a, __m256i idx, __m256i b)  VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_permutex2var_epi32 (__m256i a, __m256i idx, __m256i b)  VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def permute_var_8x_32x_2(lower: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_permutex2var_ps (__m256 a, __m256i idx, __m256i b)  VPERMI2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst  VPERMT2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_rcp14_ps (__m128 a, __m128 b)  VRCP14PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_rcp14_pd (__m128d a, __m128d b)  VRCP14PD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_rcp14_ps (__m256 a, __m256 b)  VRCP14PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_rcp14_pd (__m256d a, __m256d b)  VRCP14PD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_rcp14_ps (__m128 a, __m128 b)  VRCP14PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_rcp14_pd (__m128d a, __m128d b)  VRCP14PD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_rcp14_ps (__m256 a, __m256 b)  VRCP14PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_rcp14_pd (__m256d a, __m256d b)  VRCP14PD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_rsqrt14_ps (__m128 a, __m128 b)  VRSQRT14PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_rsqrt14_pd (__m128d a, __m128d b)  VRSQRT14PD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_rsqrt14_ps (__m256 a, __m256 b)  VRSQRT14PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_rsqrt14_pd (__m256d a, __m256d b)  VRSQRT14PD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_rsqrt14_ps (__m128 a, __m128 b)  VRSQRT14PS xmm1 {k1}{z}, xmm2/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_rsqrt14_pd (__m128d a, __m128d b)  VRSQRT14PD xmm1 {k1}{z}, xmm2/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_rsqrt14_ps (__m256 a, __m256 b)  VRSQRT14PS ymm1 {k1}{z}, ymm2/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def reciprocal_sqrt_14(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_rsqrt14_pd (__m256d a, __m256d b)  VRSQRT14PD ymm1 {k1}{z}, ymm2/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi32 (__m128i a, int imm8)  VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi32 (__m128i a, int imm8)  VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi64 (__m128i a, int imm8)  VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi64 (__m128i a, int imm8)  VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi32 (__m256i a, int imm8)  VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi32 (__m256i a, int imm8)  VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi64 (__m256i a, int imm8)  VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi64 (__m256i a, int imm8)  VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi32 (__m128i a, int imm8)  VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi32 (__m128i a, int imm8)  VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi64 (__m128i a, int imm8)  VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rol_epi64 (__m128i a, int imm8)  VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi32 (__m256i a, int imm8)  VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi32 (__m256i a, int imm8)  VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi64 (__m256i a, int imm8)  VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rol_epi64 (__m256i a, int imm8)  VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi32 (__m128i a, __m128i b)  VPROLDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi32 (__m128i a, __m128i b)  VPROLDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi64 (__m128i a, __m128i b)  VPROLQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi64 (__m128i a, __m128i b)  VPROLQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi32 (__m256i a, __m256i b)  VPROLDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi32 (__m256i a, __m256i b)  VPROLDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi64 (__m256i a, __m256i b)  VPROLQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi64 (__m256i a, __m256i b)  VPROLQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi32 (__m128i a, __m128i b)  VPROLDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi32 (__m128i a, __m128i b)  VPROLDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi64 (__m128i a, __m128i b)  VPROLQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rolv_epi64 (__m128i a, __m128i b)  VPROLQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi32 (__m256i a, __m256i b)  VPROLDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi32 (__m256i a, __m256i b)  VPROLDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi64 (__m256i a, __m256i b)  VPROLQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_left_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rolv_epi64 (__m256i a, __m256i b)  VPROLQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi32 (__m128i a, int imm8)  VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi32 (__m128i a, int imm8)  VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi64 (__m128i a, int imm8)  VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi64 (__m128i a, int imm8)  VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi32 (__m256i a, int imm8)  VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi32 (__m256i a, int imm8)  VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi64 (__m256i a, int imm8)  VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi64 (__m256i a, int imm8)  VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi32 (__m128i a, int imm8)  VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi32 (__m128i a, int imm8)  VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi64 (__m128i a, int imm8)  VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_ror_epi64 (__m128i a, int imm8)  VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi32 (__m256i a, int imm8)  VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi32 (__m256i a, int imm8)  VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi64 (__m256i a, int imm8)  VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_ror_epi64 (__m256i a, int imm8)  VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi32 (__m128i a, __m128i b)  VPRORDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi32 (__m128i a, __m128i b)  VPRORDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi64 (__m128i a, __m128i b)  VPRORQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi64 (__m128i a, __m128i b)  VPRORQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi32 (__m256i a, __m256i b)  VPRORDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi32 (__m256i a, __m256i b)  VPRORDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi64 (__m256i a, __m256i b)  VPRORQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi64 (__m256i a, __m256i b)  VPRORQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi32 (__m128i a, __m128i b)  VPRORDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi32 (__m128i a, __m128i b)  VPRORDV xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi64 (__m128i a, __m128i b)  VPRORQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_rorv_epi64 (__m128i a, __m128i b)  VPRORQV xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi32 (__m256i a, __m256i b)  VPRORDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi32 (__m256i a, __m256i b)  VPRORDV ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi64 (__m256i a, __m256i b)  VPRORQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def rotate_right_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_rorv_epi64 (__m256i a, __m256i b)  VPRORQV ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_roundscale_ps (__m128 a, int imm)  VRNDSCALEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_roundscale_pd (__m128d a, int imm)  VRNDSCALEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_roundscale_ps (__m256 a, int imm)  VRNDSCALEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_roundscale_pd (__m256d a, int imm)  VRNDSCALEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_roundscale_ps (__m128 a, int imm)  VRNDSCALEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_roundscale_pd (__m128d a, int imm)  VRNDSCALEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_roundscale_ps (__m256 a, int imm)  VRNDSCALEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def round_scale(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_roundscale_pd (__m256d a, int imm)  VRNDSCALEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_scalef_ps (__m128 a, int imm)  VSCALEFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_scalef_pd (__m128d a, int imm)  VSCALEFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_scalef_ps (__m256 a, int imm)  VSCALEFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_scalef_pd (__m256d a, int imm)  VSCALEFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128 _mm_scalef_ps (__m128 a, int imm)  VSCALEFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
            """__m128d _mm_scalef_pd (__m128d a, int imm)  VSCALEFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_scalef_ps (__m256 a, int imm)  VSCALEFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst"""
            ...

        @staticmethod
        @overload
        def scale(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_scalef_pd (__m256d a, int imm)  VSCALEFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_sra_epi64 (__m128i a, __m128i count)  VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_sra_epi64 (__m256i a, __m128i count)  VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__128i _mm_srai_epi64 (__m128i a, int imm8)  VPSRAQ xmm1 {k1}{z}, xmm2, imm8"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_srai_epi64 (__m256i a, int imm8)  VPSRAQ ymm1 {k1}{z}, ymm2, imm8"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_sra_epi64 (__m128i a, __m128i count)  VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_sra_epi64 (__m256i a, __m128i count)  VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """__128i _mm_srai_epi64 (__m128i a, int imm8)  VPSRAQ xmm1 {k1}{z}, xmm2, imm8"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_srai_epi64 (__m256i a, int imm8)  VPSRAQ ymm1 {k1}{z}, ymm2, imm8"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_srav_epi64 (__m128i a, __m128i count)  VPSRAVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_srav_epi64 (__m256i a, __m256i count)  VPSRAVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """__m128i _mm_srav_epi64 (__m128i a, __m128i count)  VPSRAVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst"""
            ...

        @staticmethod
        @overload
        def shift_right_arithmetic_variable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_srav_epi64 (__m256i a, __m256i count)  VPSRAVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_shuffle_f64x2 (__m256d a, __m256d b, const int imm8)  VSHUFF64x2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i32x4 (__m256i a, __m256i b, const int imm8)  VSHUFI32x4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i64x2 (__m256i a, __m256i b, const int imm8)  VSHUFI64x2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256 _mm256_shuffle_f32x4 (__m256 a, __m256 b, const int imm8)  VSHUFF32x4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i32x4 (__m256i a, __m256i b, const int imm8)  VSHUFI32x4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i64x2 (__m256i a, __m256i b, const int imm8)  VSHUFI64x2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
            """__m256d _mm256_shuffle_f64x2 (__m256d a, __m256d b, const int imm8)  VSHUFF64x2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i32x4 (__m256i a, __m256i b, const int imm8)  VSHUFI32x4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """__m256i _mm256_shuffle_i64x2 (__m256i a, __m256i b, const int imm8)  VSHUFI64x2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8"""
            ...

        @staticmethod
        @overload
        def shuffle_2x_128(left: System.Runtime.Intri