from enum import Enum

ACCESS_TOKEN_VAR_NAMES = {
    'gitlab.com': 'GITLAB_ACCESS_TOKEN',
    'github.com': 'GITHUB_OAUTH_TOKEN',
    'DEFAULT': 'GIT_TOKEN',
}


class CloningStates(Enum):
    NOT_STARTED = 'NOT_STARTED'
    SOURCE_BRANCH_DOES_NOT_EXIST = 'SOURCE_BRANCH_DOES_NOT_EXIST'
    ACCESS_TOKEN_NOT_PROVIDED = 'ACCESS_TOKEN_NOT_PROVIDED'
    CLONING = 'CLONING'
    CLONED = 'CLONED'
    NOT_FOUND = 'NOT_FOUND'
    SKIPPED = 'SKIPPED'
    DIRECTORY_NOT_EMPTY = 'DIRECTORY_NOT_EMPTY'


class PullRequestStates(Enum):
    NOT_CREATED = 'NOT_CREATED'
    CREATED = 'CREATED'
    GOT_BAD_RESPONSE = 'GOT_BAD_RESPONSE'
    MERGED = 'MERGED'


class ModificationState(Enum):
    NOT_STARTED = 'NOT_STARTED'
    GOT_EXCEPTION = 'GOT_EXCEPTION'
    MODIFIED = 'MODIFIED'
    NO_FILES_CHANGED = 'NO_FILES_CHANGED'
    PUSHED_TO_REMOTE = 'PUSHED_TO_REMOTE'
