<div align="center">

# 🗣️ ORATIO

**The Eloquence of Code**

*The first true natural language programming language*

[\![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[\![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[\![Status: Alpha](https://img.shields.io/badge/status-alpha-orange.svg)]()

[🌐 Website](https://oratio.dev) • [📚 Docs](https://docs.oratio.dev) • [💬 Community](https://t.me/manu_lz88)

---

### 🇮🇹 Parli Italiano. 🇬🇧 Speak English. 🇪🇸 Hablas Español.
### The Computer Understands.

---

[🇮🇹 Leggi in Italiano](README_IT.md)

</div>

## 🎯 What is ORATIO?

**ORATIO** is the first programming language that truly understands your language.

No more syntax to learn. No more cryptic code. **You speak, it works.**

```ora
# This is ORATIO code
Load sales.csv.
Filter rows where amount > 1000.
Calculate the average.
Create a bar chart.
Print "Analysis completed\!"
```

**It works. Really.**

---

## 🚀 Quick Start

### Installation

```bash
pip install oratio
```

### Your First Program

```bash
# Create a file
echo "Print 'Hello World\!'" > hello.ora

# Run it
oratio run hello.ora
```

**Output:**
```
📄 Hello World\!
```

---

## ✨ Why ORATIO?

### Before (Python)
```python
import pandas as pd
df = pd.read_csv('sales.csv')
filtered = df[df['amount'] > 1000]
mean = filtered['amount'].mean()
print(f"Average: {mean}")
```
❌ Complex, rigid syntax, you need to know Python

### Now (ORATIO)
```ora
Load sales.csv.
Filter where amount > 1000.
Calculate the average.
Print the result.
```
✅ Simple, natural, immediate

---

## 🌍 Multilingual

ORATIO speaks YOUR language:

```ora
# 🇮🇹 Italian
Carica dati.csv e calcola la media.

# 🇬🇧 English  
Load data.csv and calculate the average.

# 🇪🇸 Spanish (Coming Q2 2026)
Carga datos.csv y calcula el promedio.
```

---

## 📊 What You Can Do

- ✅ Data analysis (CSV, Excel, JSON)
- ✅ Statistics and calculations
- ✅ Visualizations and charts
- ✅ Filters and transformations
- ✅ Automated reports
- ✅ Workflow automation

**Coming Soon:**
- 🔜 Databases (SQL, MongoDB)
- 🔜 APIs and Web scraping
- 🔜 Machine Learning
- 🔜 Robot and IoT control

---

## 📚 Examples

### Sales Analysis
```ora
Load sales.csv.
Show first 5 rows.
Filter where amount > 1000.
Calculate average of amount column.
Create a bar chart.
Save as report.pdf.
```

### Statistics
```ora
Load data.csv.
Calculate mean, median and standard deviation.
Create a histogram.
Print the results.
```

### Automation
```ora
For each file in data_folder:
    Load the file.
    Filter where value > 100.
    Save in results_folder.
Print "Processing completed\!"
```

---

## 🏗️ Architecture

```
┌─────────────────────────────────────┐
│  Natural Language                   │
│  "Load data and calculate average"  │
└─────────────────────────────────────┘
              ↓
┌─────────────────────────────────────┐
│  ORATIO Parser                      │
│  (Semantic Understanding)           │
└─────────────────────────────────────┘
              ↓
┌─────────────────────────────────────┐
│  Operations                         │
│  [io.read_csv, math.mean]           │
└─────────────────────────────────────┘
              ↓
┌─────────────────────────────────────┐
│  ORATIO Runtime                     │
│  (Execution Engine)                 │
└─────────────────────────────────────┘
              ↓
┌─────────────────────────────────────┐
│  Result                             │
└─────────────────────────────────────┘
```

---

## 🤝 Contributing

ORATIO is open source\! Contribute by:

1. **New Operations** - Add functionality
2. **Connectors** - Integrate new services
3. **Bug Fixes** - Improve stability
4. **Documentation** - Help others
5. **Translations** - Bring ORATIO to your language

Read [CONTRIBUTING.md](CONTRIBUTING.md) to get started.

---

## 📖 Documentation

- [Getting Started](docs/getting-started.md)
- [Language Guide](docs/language-guide.md)
- [Operations Reference](docs/operations.md)
- [Examples](examples/)
- [FAQ](docs/faq.md)

---

## 🗺️ Roadmap

### ✅ Phase 1: Foundation (Q4 2025)
- [x] Core runtime
- [x] Basic operations
- [x] CLI
- [x] Italian support

### 🚧 Phase 2: Expansion (Q1 2026)
- [ ] English support (Beta)
- [ ] Cloud platform
- [ ] IDE integration
- [ ] Plugin system

### 🔮 Phase 3: Scale (Q2-Q3 2026)
- [ ] Spanish, French support
- [ ] Database connectors
- [ ] ML operations
- [ ] Robot/IoT control

### 🌍 Phase 4: Global (2027+)
- [ ] 10+ languages
- [ ] Enterprise features
- [ ] Marketplace
- [ ] Universal standard

---

## 📜 License

MIT License - see [LICENSE](LICENSE)

---

## 👨‍💻 Creator

**Manuel Lazzaro**

*"The future of programming isn't written. It's spoken."*

- 🌐 [oratio.dev](https://oratio.dev)
- 🐦 [@oratio_lang](https://twitter.com/oratio_lang)
- 💼 [LinkedIn](https://linkedin.com/in/manuellazzaro)
- 💬 Telegram: [@manu_lz88](https://t.me/manu_lz88)

---

## 🌟 Support the Project

If you like ORATIO:

- ⭐ Star on GitHub
- 🐦 Share on Twitter
- 💬 Join the community
- 🤝 Contribute code

---

## 📊 Stats

\![GitHub stars](https://img.shields.io/github/stars/manuzz88/oratio?style=social)
\![GitHub forks](https://img.shields.io/github/forks/manuzz88/oratio?style=social)
\![GitHub watchers](https://img.shields.io/github/watchers/manuzz88/oratio?style=social)

---

<div align="center">

**Made with ❤️ in Italy 🇮🇹**

*ORATIO - The Eloquence of Code*

**November 13, 2025 - The Day Programming Changed Forever**

</div>
