# Calling all student developers! Join our open-source AI web app project. (Volunteer and 100% Remote)

_Last update August 24, 2025_

Oppkey, a developer relations firm in Silicon Valley, is seeking undergraduate computer science students to receive hands-on training on modern AI software development using cutting-edge technologies. Gain hands-on experience and build your portfolio. Pair with mentors for working through projects, get issues assigned in GitHub, and contribute to Silicon Valley-based Oppkey-supported open source project.

## What You'll Learn

You will receive comprehensive training with a **production-ready AI technology stack** that's used by top tech companies:

### Core Technologies

- **[FastAPI](https://fastapi.tiangolo.com/)** - Modern, high-performance Python web framework
  - Automatic API documentation generation
  - Type safety with Pydantic validation
  - Async/await support for high concurrency
  - Used by Netflix, Uber, and Microsoft

- **PostgreSQL + SQLite** - Professional database management
  - Vector database support with pgvector
  - Embedding storage for AI applications
  - Production-ready data persistence

- **[pgvector](https://github.com/pgvector/pgvector)** - Vector database for AI
  - Store and query embeddings
  - Semantic search capabilities
  - RAG (Retrieval-Augmented Generation) support

- **OpenRouter API** - Multi-model AI access
  - Drop-in replacement for OpenAI API
  - Access to 100+ AI models (GPT-4, Claude, Llama, etc.)
  - Cost-effective AI model switching

### Modern Web Technologies

- **HTMX** - Dynamic web interfaces without JavaScript frameworks
- **Alpine.js** - Lightweight reactive JavaScript
- **Tailwind CSS** - Utility-first CSS framework
- **DaisyUI** - Component library for rapid UI development

### Development Tools

- **[uv](https://docs.astral.sh/uv/)** - Fast Python package manager
- **Alembic** - Database migration management
- **SQLModel** - SQL databases in Python with type safety
- **FastAPI Users** - Authentication and user management

## 🎯 Real-World Experience

You'll work on a **production-ready application** that demonstrates:

### Architecture & Best Practices

- **Model-View-Service (MVS) Architecture** - Clean separation of concerns
- **Async/await patterns** for high-performance applications
- **Environment-based configuration** (development vs production)
- **Database migrations** with Alembic
- **Authentication systems** with JWT and session management

### AI Integration

- **Real-time chat interfaces** with LLM integration
- **Vector database operations** for semantic search
- **Multi-model AI access** through OpenRouter
- **Streaming responses** from AI models

### Production Features

- **Admin panel** with SQLAdmin
- **User management** with role-based permissions
- **File upload** and image processing
- **Database backup** and recovery systems
- **Environment management** tools

## Career Benefits

### Industry-Relevant Skills

- **FastAPI** is rapidly growing in popularity for AI applications
- **Vector databases** are essential for modern AI systems
- **Async programming** is the future of web development
- **Type safety** reduces bugs and improves code quality

### Portfolio Project

- **Open source contribution** to a real application
- **Production-ready code** you can showcase
- **Modern tech stack** that employers value
- **AI integration** experience in high demand

### Learning Outcomes

- Build **scalable web applications** with modern Python
- Integrate **AI models** into production systems
- Implement **vector databases** for semantic search
- Deploy **async applications** with proper architecture
- Use **modern development tools** and best practices

## What You'll Build

### Core Features

- **AI Chat Interface** - Real-time conversations with LLMs
- **Admin Dashboard** - Database management and user administration
- **Authentication System** - Secure user login and role management
- **File Management** - Photo upload and processing
- **API Development** - RESTful endpoints with automatic documentation

### Advanced Features

- **Vector Search** - Semantic similarity with pgvector
- **Multi-model AI** - Switch between different AI providers
- **Real-time Updates** - HTMX for dynamic interfaces
- **Database Migrations** - Schema evolution management
- **Production Deployment** - Environment configuration

## Why This Stack Matters

### FastAPI Advantages

- **10x faster** than traditional frameworks
- **Automatic API docs** with OpenAPI/Swagger
- **Type safety** prevents runtime errors
- **Async by default** for high concurrency
- **Growing ecosystem** with strong community support

### AI-First Design

- **Built for AI integration** from the ground up
- **Vector database support** for embeddings
- **Multi-model AI access** through OpenRouter
- **Real-time streaming** for AI responses
- **Production-ready** AI deployment patterns

### Modern Development

- **Type-safe development** with Python type hints
- **Environment-based configuration** for different deployments
- **Database migrations** for schema evolution
- **Authentication systems** with modern security
- **Admin interfaces** for data management

## Mentorship & Support

### Weekly Video Meetings

- **Weekly video meetings** with senior manager
- **Daily availability** - may meet every day you work if manager is available
- **Clear instructions** on tasks and how to advance
- **Structured learning path** with defined milestones

### Professional Development

- **Git and GitHub experience** - push, pull requests, review, issues
- **Open source contribution** - project will be open source and you can point to accomplishments
- **Professional reference** - Jesse Casman, President of Oppkey, will be available as reference for your future job search
- **AI-enhanced coding** - experience with in-editor tools such as Cursor, Copilot
- **Resume enhancement** - can put "Junior Software Developer for Oppkey" on resume

## Time Commitment & Schedule

### Minimum Requirements

- **Minimum 4 hours per week** during California work hours
- **Each work day must be at least 2 hours** for focused development
- **Preferred: single 4-hour block** to focus on coding problems
- **Flexible scheduling** within California work hours

### Work Environment

- **100% remote** work environment
- **Regular check-ins** and progress reviews
- **Structured feedback** on code quality and progress
- **Mentorship-driven** learning approach

## 📚 Learning Path

### Phase 1: Foundation

- Set up development environment
- Understand FastAPI basics and async programming
- Learn database operations with SQLModel
- Implement basic CRUD operations

### Phase 2: AI Integration

- Integrate OpenRouter API for multi-model access
- Implement vector database operations
- Build real-time chat interfaces
- Add streaming AI responses

### Phase 3: Production Features

- Implement authentication and authorization
- Add admin panel functionality
- Set up database migrations
- Configure environment management

### Phase 4: Advanced Features

- Add vector search capabilities
- Implement file upload and processing
- Build real-time interfaces with HTMX
- Deploy to production environment

## 🎯 Requirements and Preferences

### Required Experience

- **Must have prior Python coding experience**, preferably through a structured academic program
- **1 year of Python experience preferred**
- **Basic understanding of web development concepts**
- Familiarity with Git and command line
- Enthusiasm for learning new technologies

### Preferred Knowledge

- **Understanding of these concepts**: class, async io, data types, data streaming
- **Prior experience with HTML, CSS, JavaScript** (as we are building a web application)
- **Familiarity with Git and version control**
- **Interest in AI and machine learning**

### Personal Qualities

- **Self-motivated** and eager to learn
- **Good communication skills** for remote collaboration
- **Attention to detail** for code quality
- **Problem-solving mindset** for debugging and development

## Getting Started

### What We Provide

- **Comprehensive documentation** and tutorials
- **Mentorship** from experienced developers
- **Real-world project** experience
- **Open source contribution** opportunities
- **Career guidance** and networking

### What You'll Gain

- **Industry-standard AI development** skills
- **Production-ready portfolio** project
- **Professional reference** from company president
- **Modern technology stack** experience
- **Open source contribution** to showcase

## 📞 How to Apply

Fill out the form on the Apply page.

### Application Process

Please include in your application:

1. **Your learning goals** and career aspirations
2. **Brief introduction** about your background
3. **Why you're interested** in this technology stack
4. **Previous programming experience** and Python knowledge
5. **Your availability** during California work hours
6. **Any relevant projects** or coursework you've completed

This is an excellent opportunity to learn **industry-standard AI development** with a modern, high-performance technology stack that's in high demand by top tech companies.

---

*This position offers hands-on experience with the same technologies used by companies like Netflix, Uber, Microsoft, and many AI startups. You'll build a portfolio project that demonstrates real-world AI application development skills and gain a professional reference from the company president.*
