# This file was auto-generated by Fern from our API Definition.

import typing

from ..commons.types.action_parameter import ActionParameter
from ..commons.types.action_response import ActionResponse
from ..commons.types.entity_id import EntityId
from ..commons.types.entity_id_base import EntityIdBase
from ..commons.types.llm_inclusion_status import LlmInclusionStatus
from ..commons.types.precondition import Precondition
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawActionsClient, RawActionsClient
from .types.action_field import ActionField
from .types.action_filter import ActionFilter
from .types.actions_response import ActionsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ActionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawActionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawActionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawActionsClient
        """
        return self._raw_client

    def search(
        self,
        *,
        sort: typing.Optional[ActionField] = OMIT,
        filter: typing.Optional[ActionFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionsResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[ActionField]

        filter : typing.Optional[ActionFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionsResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.actions.search()
        """
        _response = self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def create_or_update(
        self,
        *,
        action_id: EntityIdBase,
        name: str,
        description: str,
        user_interaction_required: bool,
        user_form_parameters: typing.Sequence[ActionParameter],
        button_name: typing.Optional[str] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        language: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Update an action or create it if it doesn't exist

        Parameters
        ----------
        action_id : EntityIdBase
            ID that uniquely identifies this action

        name : str
            The name of the action. This is displayed to the end user as part of forms when user interaction is required. It is also used to help Maven decide if the action is relevant to a conversation.

        description : str
            The description of the action. Must be less than 1024 characters. This helps Maven decide if the action is relevant to a conversation and is not displayed directly to the end user. Descriptions are used by the LLM.

        user_interaction_required : bool
            Whether the action requires user interaction to execute. If false, and all of the required action parameters are known, the LLM may call the action automatically. If true, an conversations ask call will return a BotActionFormResponse which must be submitted by an API caller. API callers must display a button with the buttonName label to confirm the user's intent.

        user_form_parameters : typing.Sequence[ActionParameter]
            The parameters that the action uses as input. An action will only be executed when all of the required parameters are provided. During execution, actions all have access to the full Conversation and User objects. Parameter values may be inferred from the user's conversation by the LLM.

        button_name : typing.Optional[str]
            When user interaction is required, the name of the button that is shown to the end user to confirm execution of the action. Defaults to "Submit" if not supplied.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for an action to be relevant to a conversation. Can be used to restrict actions to certain types of users.

        language : typing.Optional[str]
            The ISO 639-1 code for the language used in all fields of this action. Will be derived using the description's text if not specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.actions.create_or_update(
            action_id=EntityIdBase(
                reference_id="get-balance",
            ),
            name="Get the user's balance",
            description="This action calls an API to get the user's current balance.",
            user_interaction_required=False,
            user_form_parameters=[],
            precondition=Precondition_Group(
                operator="AND",
                preconditions=[
                    Precondition_User(
                        key="userKey",
                    ),
                    Precondition_User(
                        key="userKey2",
                    ),
                ],
            ),
            language="en",
        )
        """
        _response = self._raw_client.create_or_update(
            action_id=action_id,
            name=name,
            description=description,
            user_interaction_required=user_interaction_required,
            user_form_parameters=user_form_parameters,
            button_name=button_name,
            precondition=precondition,
            language=language,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        action_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Get an action by its supplied ID

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the action to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.actions.get(
            action_reference_id="get-balance",
        )
        """
        _response = self._raw_client.get(action_reference_id, app_id=app_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        action_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        llm_inclusion_status: typing.Optional[LlmInclusionStatus] = OMIT,
        segment_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Update mutable action fields

        The `appId` field can be provided to update an action owned by a different app.
        All other fields will overwrite the existing value on the action only if provided.

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to patch.

        app_id : typing.Optional[str]
            The App ID of the action to patch. If not provided the ID of the calling app will be used.

        instructions : typing.Optional[str]
            The instructions given to the LLM when determining whether to execute the action.

        llm_inclusion_status : typing.Optional[LlmInclusionStatus]
            Determines whether the action is sent to the LLM as part of a conversation.

        segment_id : typing.Optional[EntityId]
            The ID of the segment that must be matched for the action to be relevant to a conversation.
            A null value will remove the segment from the action, it will be available on all conversations.

            Segments are replacing inline preconditions - an action may not have both an inline precondition and a segment.
            Inline precondition support will be removed in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.actions.patch(
            action_reference_id="actionReferenceId",
        )
        """
        _response = self._raw_client.patch(
            action_reference_id,
            app_id=app_id,
            instructions=instructions,
            llm_inclusion_status=llm_inclusion_status,
            segment_id=segment_id,
            request_options=request_options,
        )
        return _response.data

    def delete(self, action_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete an action

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to unregister. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.actions.delete(
            action_reference_id="get-balance",
        )
        """
        _response = self._raw_client.delete(action_reference_id, request_options=request_options)
        return _response.data


class AsyncActionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawActionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawActionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawActionsClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        sort: typing.Optional[ActionField] = OMIT,
        filter: typing.Optional[ActionFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionsResponse:
        """
        Parameters
        ----------
        sort : typing.Optional[ActionField]

        filter : typing.Optional[ActionFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionsResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.actions.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def create_or_update(
        self,
        *,
        action_id: EntityIdBase,
        name: str,
        description: str,
        user_interaction_required: bool,
        user_form_parameters: typing.Sequence[ActionParameter],
        button_name: typing.Optional[str] = OMIT,
        precondition: typing.Optional[Precondition] = OMIT,
        language: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Update an action or create it if it doesn't exist

        Parameters
        ----------
        action_id : EntityIdBase
            ID that uniquely identifies this action

        name : str
            The name of the action. This is displayed to the end user as part of forms when user interaction is required. It is also used to help Maven decide if the action is relevant to a conversation.

        description : str
            The description of the action. Must be less than 1024 characters. This helps Maven decide if the action is relevant to a conversation and is not displayed directly to the end user. Descriptions are used by the LLM.

        user_interaction_required : bool
            Whether the action requires user interaction to execute. If false, and all of the required action parameters are known, the LLM may call the action automatically. If true, an conversations ask call will return a BotActionFormResponse which must be submitted by an API caller. API callers must display a button with the buttonName label to confirm the user's intent.

        user_form_parameters : typing.Sequence[ActionParameter]
            The parameters that the action uses as input. An action will only be executed when all of the required parameters are provided. During execution, actions all have access to the full Conversation and User objects. Parameter values may be inferred from the user's conversation by the LLM.

        button_name : typing.Optional[str]
            When user interaction is required, the name of the button that is shown to the end user to confirm execution of the action. Defaults to "Submit" if not supplied.

        precondition : typing.Optional[Precondition]
            The preconditions that must be met for an action to be relevant to a conversation. Can be used to restrict actions to certain types of users.

        language : typing.Optional[str]
            The ISO 639-1 code for the language used in all fields of this action. Will be derived using the description's text if not specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.actions.create_or_update(
                action_id=EntityIdBase(
                    reference_id="get-balance",
                ),
                name="Get the user's balance",
                description="This action calls an API to get the user's current balance.",
                user_interaction_required=False,
                user_form_parameters=[],
                precondition=Precondition_Group(
                    operator="AND",
                    preconditions=[
                        Precondition_User(
                            key="userKey",
                        ),
                        Precondition_User(
                            key="userKey2",
                        ),
                    ],
                ),
                language="en",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            action_id=action_id,
            name=name,
            description=description,
            user_interaction_required=user_interaction_required,
            user_form_parameters=user_form_parameters,
            button_name=button_name,
            precondition=precondition,
            language=language,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        action_reference_id: str,
        *,
        app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Get an action by its supplied ID

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to get. All other entity ID fields are inferred from the request.

        app_id : typing.Optional[str]
            The App ID of the action to get. If not provided the ID of the calling app will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.actions.get(
                action_reference_id="get-balance",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(action_reference_id, app_id=app_id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        action_reference_id: str,
        *,
        app_id: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        llm_inclusion_status: typing.Optional[LlmInclusionStatus] = OMIT,
        segment_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActionResponse:
        """
        Update mutable action fields

        The `appId` field can be provided to update an action owned by a different app.
        All other fields will overwrite the existing value on the action only if provided.

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to patch.

        app_id : typing.Optional[str]
            The App ID of the action to patch. If not provided the ID of the calling app will be used.

        instructions : typing.Optional[str]
            The instructions given to the LLM when determining whether to execute the action.

        llm_inclusion_status : typing.Optional[LlmInclusionStatus]
            Determines whether the action is sent to the LLM as part of a conversation.

        segment_id : typing.Optional[EntityId]
            The ID of the segment that must be matched for the action to be relevant to a conversation.
            A null value will remove the segment from the action, it will be available on all conversations.

            Segments are replacing inline preconditions - an action may not have both an inline precondition and a segment.
            Inline precondition support will be removed in a future release.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActionResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.actions.patch(
                action_reference_id="actionReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            action_reference_id,
            app_id=app_id,
            instructions=instructions,
            llm_inclusion_status=llm_inclusion_status,
            segment_id=segment_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, action_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete an action

        Parameters
        ----------
        action_reference_id : str
            The reference ID of the action to unregister. All other entity ID fields are inferred from the request.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.actions.delete(
                action_reference_id="get-balance",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(action_reference_id, request_options=request_options)
        return _response.data
