# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.action_base import ActionBase
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata


class ActionRequest(ActionBase):
    """
    Examples
    --------
    from mavenagi.actions import ActionRequest
    from mavenagi.commons import EntityIdBase, Precondition_Group, Precondition_User

    ActionRequest(
        action_id=EntityIdBase(
            reference_id="get-balance",
        ),
        name="Get the user's balance",
        description="This action calls an API to get the user's current balance.",
        user_interaction_required=False,
        user_form_parameters=[],
        precondition=Precondition_Group(
            operator="AND",
            preconditions=[
                Precondition_User(
                    key="userKey",
                ),
                Precondition_User(
                    key="userKey2",
                ),
            ],
        ),
        language="en",
    )
    """

    action_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="actionId")] = pydantic.Field()
    """
    ID that uniquely identifies this action
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
