# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAgentCapabilitiesClient, RawAgentCapabilitiesClient
from .types.agent_capability import AgentCapability
from .types.agent_capability_field import AgentCapabilityField
from .types.agent_capability_type import AgentCapabilityType
from .types.list_agent_capabilities_response import ListAgentCapabilitiesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentCapabilitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentCapabilitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAgentCapabilitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentCapabilitiesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        capability_type: typing.Optional[AgentCapabilityType] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        integration_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        user_interaction_required: typing.Optional[bool] = OMIT,
        sort_id: typing.Optional[AgentCapabilityField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListAgentCapabilitiesResponse:
        """
        List all capabilities for an agent.

        Parameters
        ----------
        capability_type : typing.Optional[AgentCapabilityType]

        pinned : typing.Optional[bool]

        enabled : typing.Optional[bool]

        integration_ids : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        user_interaction_required : typing.Optional[bool]

        sort_id : typing.Optional[AgentCapabilityField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAgentCapabilitiesResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agent_capabilities.list()
        """
        _response = self._raw_client.list(
            capability_type=capability_type,
            pinned=pinned,
            enabled=enabled,
            integration_ids=integration_ids,
            description=description,
            user_interaction_required=user_interaction_required,
            sort_id=sort_id,
            page=page,
            size=size,
            sort_desc=sort_desc,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, integration_id: str, capability_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentCapability:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentCapability

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agent_capabilities.get(
            integration_id="integrationId",
            capability_id="capabilityId",
        )
        """
        _response = self._raw_client.get(integration_id, capability_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        integration_id: str,
        capability_id: str,
        *,
        enabled: typing.Optional[bool] = OMIT,
        description_override: typing.Optional[str] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentCapability:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        enabled : typing.Optional[bool]
            Whether this capability is enabled or disabled

        description_override : typing.Optional[str]
            Override description for action capabilities. Only applies to actions, ignored for triggers.

        pinned : typing.Optional[bool]
            Whether this action capability is pinned. Only applies to actions, ignored for triggers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentCapability

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agent_capabilities.patch(
            integration_id="integrationId",
            capability_id="capabilityId",
        )
        """
        _response = self._raw_client.patch(
            integration_id,
            capability_id,
            enabled=enabled,
            description_override=description_override,
            pinned=pinned,
            request_options=request_options,
        )
        return _response.data


class AsyncAgentCapabilitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentCapabilitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAgentCapabilitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentCapabilitiesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        capability_type: typing.Optional[AgentCapabilityType] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        integration_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        user_interaction_required: typing.Optional[bool] = OMIT,
        sort_id: typing.Optional[AgentCapabilityField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListAgentCapabilitiesResponse:
        """
        List all capabilities for an agent.

        Parameters
        ----------
        capability_type : typing.Optional[AgentCapabilityType]

        pinned : typing.Optional[bool]

        enabled : typing.Optional[bool]

        integration_ids : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        user_interaction_required : typing.Optional[bool]

        sort_id : typing.Optional[AgentCapabilityField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAgentCapabilitiesResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agent_capabilities.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            capability_type=capability_type,
            pinned=pinned,
            enabled=enabled,
            integration_ids=integration_ids,
            description=description,
            user_interaction_required=user_interaction_required,
            sort_id=sort_id,
            page=page,
            size=size,
            sort_desc=sort_desc,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, integration_id: str, capability_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentCapability:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentCapability

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agent_capabilities.get(
                integration_id="integrationId",
                capability_id="capabilityId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(integration_id, capability_id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        integration_id: str,
        capability_id: str,
        *,
        enabled: typing.Optional[bool] = OMIT,
        description_override: typing.Optional[str] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentCapability:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        enabled : typing.Optional[bool]
            Whether this capability is enabled or disabled

        description_override : typing.Optional[str]
            Override description for action capabilities. Only applies to actions, ignored for triggers.

        pinned : typing.Optional[bool]
            Whether this action capability is pinned. Only applies to actions, ignored for triggers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentCapability

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agent_capabilities.patch(
                integration_id="integrationId",
                capability_id="capabilityId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            integration_id,
            capability_id,
            enabled=enabled,
            description_override=description_override,
            pinned=pinned,
            request_options=request_options,
        )
        return _response.data
