# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..commons.errors.bad_request_error import BadRequestError
from ..commons.errors.not_found_error import NotFoundError
from ..commons.errors.server_error import ServerError
from ..commons.types.error_message import ErrorMessage
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from .types.agent_capability import AgentCapability
from .types.agent_capability_field import AgentCapabilityField
from .types.agent_capability_type import AgentCapabilityType
from .types.list_agent_capabilities_response import ListAgentCapabilitiesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAgentCapabilitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        capability_type: typing.Optional[AgentCapabilityType] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        integration_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        user_interaction_required: typing.Optional[bool] = OMIT,
        sort_id: typing.Optional[AgentCapabilityField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListAgentCapabilitiesResponse]:
        """
        List all capabilities for an agent.

        Parameters
        ----------
        capability_type : typing.Optional[AgentCapabilityType]

        pinned : typing.Optional[bool]

        enabled : typing.Optional[bool]

        integration_ids : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        user_interaction_required : typing.Optional[bool]

        sort_id : typing.Optional[AgentCapabilityField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListAgentCapabilitiesResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/capabilities",
            method="POST",
            json={
                "capabilityType": capability_type,
                "pinned": pinned,
                "enabled": enabled,
                "integrationIds": integration_ids,
                "description": description,
                "userInteractionRequired": user_interaction_required,
                "sortId": sort_id,
                "page": page,
                "size": size,
                "sortDesc": sort_desc,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListAgentCapabilitiesResponse,
                    parse_obj_as(
                        type_=ListAgentCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, integration_id: str, capability_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[AgentCapability]:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AgentCapability]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/integrations/{jsonable_encoder(integration_id)}/capabilities/{jsonable_encoder(capability_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AgentCapability,
                    parse_obj_as(
                        type_=AgentCapability,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch(
        self,
        integration_id: str,
        capability_id: str,
        *,
        enabled: typing.Optional[bool] = OMIT,
        description_override: typing.Optional[str] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AgentCapability]:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        enabled : typing.Optional[bool]
            Whether this capability is enabled or disabled

        description_override : typing.Optional[str]
            Override description for action capabilities. Only applies to actions, ignored for triggers.

        pinned : typing.Optional[bool]
            Whether this action capability is pinned. Only applies to actions, ignored for triggers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AgentCapability]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/integrations/{jsonable_encoder(integration_id)}/capabilities/{jsonable_encoder(capability_id)}",
            method="PATCH",
            json={
                "enabled": enabled,
                "descriptionOverride": description_override,
                "pinned": pinned,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AgentCapability,
                    parse_obj_as(
                        type_=AgentCapability,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAgentCapabilitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        capability_type: typing.Optional[AgentCapabilityType] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        integration_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        description: typing.Optional[str] = OMIT,
        user_interaction_required: typing.Optional[bool] = OMIT,
        sort_id: typing.Optional[AgentCapabilityField] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListAgentCapabilitiesResponse]:
        """
        List all capabilities for an agent.

        Parameters
        ----------
        capability_type : typing.Optional[AgentCapabilityType]

        pinned : typing.Optional[bool]

        enabled : typing.Optional[bool]

        integration_ids : typing.Optional[typing.Sequence[str]]

        description : typing.Optional[str]

        user_interaction_required : typing.Optional[bool]

        sort_id : typing.Optional[AgentCapabilityField]
            The field to sort by, defaults to created timestamp

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListAgentCapabilitiesResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/capabilities",
            method="POST",
            json={
                "capabilityType": capability_type,
                "pinned": pinned,
                "enabled": enabled,
                "integrationIds": integration_ids,
                "description": description,
                "userInteractionRequired": user_interaction_required,
                "sortId": sort_id,
                "page": page,
                "size": size,
                "sortDesc": sort_desc,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListAgentCapabilitiesResponse,
                    parse_obj_as(
                        type_=ListAgentCapabilitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, integration_id: str, capability_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[AgentCapability]:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AgentCapability]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/integrations/{jsonable_encoder(integration_id)}/capabilities/{jsonable_encoder(capability_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AgentCapability,
                    parse_obj_as(
                        type_=AgentCapability,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch(
        self,
        integration_id: str,
        capability_id: str,
        *,
        enabled: typing.Optional[bool] = OMIT,
        description_override: typing.Optional[str] = OMIT,
        pinned: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AgentCapability]:
        """
        Parameters
        ----------
        integration_id : str

        capability_id : str

        enabled : typing.Optional[bool]
            Whether this capability is enabled or disabled

        description_override : typing.Optional[str]
            Override description for action capabilities. Only applies to actions, ignored for triggers.

        pinned : typing.Optional[bool]
            Whether this action capability is pinned. Only applies to actions, ignored for triggers.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AgentCapability]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/integrations/{jsonable_encoder(integration_id)}/capabilities/{jsonable_encoder(capability_id)}",
            method="PATCH",
            json={
                "enabled": enabled,
                "descriptionOverride": description_override,
                "pinned": pinned,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AgentCapability,
                    parse_obj_as(
                        type_=AgentCapability,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
