# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...commons.types.action_parameter import ActionParameter
from ...core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ...core.serialization import FieldMetadata
from .agent_capability_base import AgentCapabilityBase


class ActionCapability(AgentCapabilityBase):
    user_interaction_required: typing_extensions.Annotated[bool, FieldMetadata(alias="userInteractionRequired")]
    button_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="buttonName")] = pydantic.Field(
        default=None
    )
    """
    When user interaction is required, the name of the button that is shown to the end user to confirm execution of the action. Defaults to "Submit" if not supplied.
    """

    user_form_parameters: typing_extensions.Annotated[
        typing.List[ActionParameter], FieldMetadata(alias="userFormParameters")
    ] = pydantic.Field()
    """
    The parameters that the action uses as input. An action will only be executed when all of the required parameters are provided. Parameter values may be inferred from the user's conversation by the LLM.
    """

    precondition: typing.Optional["Precondition"] = None
    description_override: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="descriptionOverride")
    ] = None
    precondition_explanation: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="preconditionExplanation")
    ] = pydantic.Field(default=None)
    """
    A human-readable explanation of the precondition associated with this action, if present.
    """

    pinned: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
from ...commons.types.precondition import Precondition  # noqa: E402, F401, I001

update_forward_refs(ActionCapability)
