# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.action_parameter import ActionParameter
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ...core.serialization import FieldMetadata
from .trigger_type import TriggerType


class AgentCapability_Action(UniversalBaseModel):
    type: typing.Literal["ACTION"] = "ACTION"
    user_interaction_required: typing_extensions.Annotated[bool, FieldMetadata(alias="userInteractionRequired")]
    button_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="buttonName")] = None
    user_form_parameters: typing_extensions.Annotated[
        typing.List[ActionParameter], FieldMetadata(alias="userFormParameters")
    ]
    precondition: typing.Optional["Precondition"] = None
    description_override: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="descriptionOverride")
    ] = None
    precondition_explanation: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="preconditionExplanation")
    ] = None
    pinned: bool
    name: str
    description: typing.Optional[str] = None
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    enabled: bool
    version: int
    capability_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="capabilityId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from ...commons.types.precondition_group import PreconditionGroup  # noqa: E402, F401, I001
from ...commons.types.precondition import Precondition  # noqa: E402, F401, I001


class AgentCapability_Trigger(UniversalBaseModel):
    type: typing.Literal["TRIGGER"] = "TRIGGER"
    trigger_type: typing_extensions.Annotated[TriggerType, FieldMetadata(alias="triggerType")]
    name: str
    description: typing.Optional[str] = None
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    enabled: bool
    version: int
    capability_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="capabilityId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AgentCapability = typing.Union[AgentCapability_Action, AgentCapability_Trigger]
update_forward_refs(AgentCapability_Action)
