# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class AgentCapabilityBase(UniversalBaseModel):
    name: str
    description: typing.Optional[str] = None
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    Timestamp when the capability was created
    """

    enabled: bool = pydantic.Field()
    """
    Whether this capability will be called by Maven.
    """

    version: int
    capability_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="capabilityId")] = pydantic.Field()
    """
    ID that uniquely identifies this capability
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
