# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class PatchAgentCapabilityRequest(UniversalBaseModel):
    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this capability is enabled or disabled
    """

    description_override: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="descriptionOverride")
    ] = pydantic.Field(default=None)
    """
    Override description for action capabilities. Only applies to actions, ignored for triggers.
    """

    pinned: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this action capability is pinned. Only applies to actions, ignored for triggers.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
