# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAgentsClient, RawAgentsClient
from .types.agent import Agent
from .types.agent_environment import AgentEnvironment
from .types.agent_field import AgentField
from .types.agent_filter import AgentFilter
from .types.agents_search_response import AgentsSearchResponse
from .types.pii_category import PiiCategory

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentsClient
        """
        return self._raw_client

    def search(
        self,
        *,
        sort: typing.Optional[AgentField] = OMIT,
        filter: typing.Optional[AgentFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentsSearchResponse:
        """
        Search for agents across all organizations.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        sort : typing.Optional[AgentField]

        filter : typing.Optional[AgentFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentsSearchResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.search()
        """
        _response = self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    def list(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Agent]:
        """
        Lists all agents for an organization

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Agent]
            List of all agents for the organization

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.list(
            organization_reference_id="organizationReferenceId",
        )
        """
        _response = self._raw_client.list(organization_reference_id, request_options=request_options)
        return _response.data

    def create(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        name: str,
        environment: AgentEnvironment,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Create a new agent

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        name : str
            The name of the agent.

        environment : AgentEnvironment
            The environment of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            The newly created agent

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.create(
            organization_reference_id="organizationReferenceId",
            agent_reference_id="agentReferenceId",
            name="name",
            environment="DEMO",
        )
        """
        _response = self._raw_client.create(
            organization_reference_id,
            agent_reference_id,
            name=name,
            environment=environment,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Get an agent

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.get(
            organization_reference_id="organizationReferenceId",
            agent_reference_id="agentReferenceId",
        )
        """
        _response = self._raw_client.get(organization_reference_id, agent_reference_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        environment: typing.Optional[AgentEnvironment] = OMIT,
        default_timezone: typing.Optional[str] = OMIT,
        enabled_pii_categories: typing.Optional[typing.Set[PiiCategory]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Update mutable agent fields
        All fields will overwrite the existing value on the agent only if provided.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        name : typing.Optional[str]
            The name of the agent.

        environment : typing.Optional[AgentEnvironment]
            The environment of the agent.

        default_timezone : typing.Optional[str]
            The agent's default timezone. This is used when a timezone is not set on a conversation.

        enabled_pii_categories : typing.Optional[typing.Set[PiiCategory]]
            The PII categories that are enabled for the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.patch(
            organization_reference_id="organizationReferenceId",
            agent_reference_id="agentReferenceId",
        )
        """
        _response = self._raw_client.patch(
            organization_reference_id,
            agent_reference_id,
            name=name,
            environment=environment,
            default_timezone=default_timezone,
            enabled_pii_categories=enabled_pii_categories,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete an agent.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.agents.delete(
            organization_reference_id="organizationReferenceId",
            agent_reference_id="agentReferenceId",
        )
        """
        _response = self._raw_client.delete(
            organization_reference_id, agent_reference_id, request_options=request_options
        )
        return _response.data


class AsyncAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentsClient
        """
        return self._raw_client

    async def search(
        self,
        *,
        sort: typing.Optional[AgentField] = OMIT,
        filter: typing.Optional[AgentFilter] = OMIT,
        page: typing.Optional[int] = OMIT,
        size: typing.Optional[int] = OMIT,
        sort_desc: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentsSearchResponse:
        """
        Search for agents across all organizations.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        sort : typing.Optional[AgentField]

        filter : typing.Optional[AgentFilter]

        page : typing.Optional[int]
            Page number to return, defaults to 0

        size : typing.Optional[int]
            The size of the page to return, defaults to 20

        sort_desc : typing.Optional[bool]
            Whether to sort descending, defaults to true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentsSearchResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.search()


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            sort=sort, filter=filter, page=page, size=size, sort_desc=sort_desc, request_options=request_options
        )
        return _response.data

    async def list(
        self, organization_reference_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Agent]:
        """
        Lists all agents for an organization

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Agent]
            List of all agents for the organization

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.list(
                organization_reference_id="organizationReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(organization_reference_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        name: str,
        environment: AgentEnvironment,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Create a new agent

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        name : str
            The name of the agent.

        environment : AgentEnvironment
            The environment of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent
            The newly created agent

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.create(
                organization_reference_id="organizationReferenceId",
                agent_reference_id="agentReferenceId",
                name="name",
                environment="DEMO",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            organization_reference_id,
            agent_reference_id,
            name=name,
            environment=environment,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Get an agent

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.get(
                organization_reference_id="organizationReferenceId",
                agent_reference_id="agentReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            organization_reference_id, agent_reference_id, request_options=request_options
        )
        return _response.data

    async def patch(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        environment: typing.Optional[AgentEnvironment] = OMIT,
        default_timezone: typing.Optional[str] = OMIT,
        enabled_pii_categories: typing.Optional[typing.Set[PiiCategory]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Agent:
        """
        Update mutable agent fields
        All fields will overwrite the existing value on the agent only if provided.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        name : typing.Optional[str]
            The name of the agent.

        environment : typing.Optional[AgentEnvironment]
            The environment of the agent.

        default_timezone : typing.Optional[str]
            The agent's default timezone. This is used when a timezone is not set on a conversation.

        enabled_pii_categories : typing.Optional[typing.Set[PiiCategory]]
            The PII categories that are enabled for the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Agent

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.patch(
                organization_reference_id="organizationReferenceId",
                agent_reference_id="agentReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            organization_reference_id,
            agent_reference_id,
            name=name,
            environment=environment,
            default_timezone=default_timezone,
            enabled_pii_categories=enabled_pii_categories,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        organization_reference_id: str,
        agent_reference_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete an agent.

        <Tip>
        This endpoint requires additional permissions. Contact support to request access.
        </Tip>

        Parameters
        ----------
        organization_reference_id : str
            The ID of the organization.

        agent_reference_id : str
            The ID of the agent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.agents.delete(
                organization_reference_id="organizationReferenceId",
                agent_reference_id="agentReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            organization_reference_id, agent_reference_id, request_options=request_options
        )
        return _response.data
