# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id import EntityId
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .agent_environment import AgentEnvironment
from .pii_category import PiiCategory


class Agent(UniversalBaseModel):
    agent_id: typing_extensions.Annotated[EntityId, FieldMetadata(alias="agentId")] = pydantic.Field()
    """
    ID that uniquely identifies this action
    """

    name: str = pydantic.Field()
    """
    The name of the agent.
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    When the agent was created.
    """

    environment: AgentEnvironment = pydantic.Field()
    """
    The environment of the agent. Default is `DEMO`.
    """

    default_timezone: typing_extensions.Annotated[str, FieldMetadata(alias="defaultTimezone")] = pydantic.Field()
    """
    The agent's default timezone. This is used when a timezone is not set on a conversation.
    """

    enabled_pii_categories: typing_extensions.Annotated[
        typing.Set[PiiCategory], FieldMetadata(alias="enabledPiiCategories")
    ] = pydantic.Field()
    """
    The PII categories that are enabled for the agent. 
    PII will be automatically redacted from all conversation message text. 
    Attachments and form submissions are not affected. 
    
    Defaults to `AbaRoutingNumber`, `CreditCardNumber`, `IpAddress`, `PhoneNumber`, `SwiftCode`, 
    `UsBankAccountNumber`, `UsDriversLicenseNumber`, `UsIndividualTaxpayerIdentification`,
    `UsUkPassportNumber`, `UsSocialSecurityNumber`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
