# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .agent_environment import AgentEnvironment
from .pii_category import PiiCategory


class AgentPatchRequest(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the agent.
    """

    environment: typing.Optional[AgentEnvironment] = pydantic.Field(default=None)
    """
    The environment of the agent.
    """

    default_timezone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="defaultTimezone")] = (
        pydantic.Field(default=None)
    )
    """
    The agent's default timezone. This is used when a timezone is not set on a conversation.
    """

    enabled_pii_categories: typing_extensions.Annotated[
        typing.Optional[typing.Set[PiiCategory]], FieldMetadata(alias="enabledPiiCategories")
    ] = pydantic.Field(default=None)
    """
    The PII categories that are enabled for the agent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
