# This file was auto-generated by Fern from our API Definition.

import typing

from ..conversation.types.conversation_filter import ConversationFilter
from ..conversation.types.feedback_filter import FeedbackFilter
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAnalyticsClient, RawAnalyticsClient
from .types.chart_response import ChartResponse
from .types.conversation_chart_request import ConversationChartRequest
from .types.conversation_column_definition import ConversationColumnDefinition
from .types.conversation_group_by import ConversationGroupBy
from .types.conversation_table_response import ConversationTableResponse
from .types.feedback_column_definition import FeedbackColumnDefinition
from .types.feedback_group_by import FeedbackGroupBy
from .types.feedback_table_response import FeedbackTableResponse
from .types.time_interval import TimeInterval

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AnalyticsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAnalyticsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAnalyticsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAnalyticsClient
        """
        return self._raw_client

    def get_conversation_table(
        self,
        *,
        field_groupings: typing.Sequence[ConversationGroupBy],
        column_definitions: typing.Sequence[ConversationColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        conversation_filter: typing.Optional[ConversationFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationTableResponse:
        """
        Retrieves structured conversation data formatted as a table, allowing users to group, filter, and define specific metrics to display as columns.

        Parameters
        ----------
        field_groupings : typing.Sequence[ConversationGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row. |
            Note: The field `CreatedAt` should not be used here, all time-based grouping should be done using the `timeGrouping` field.

        column_definitions : typing.Sequence[ConversationColumnDefinition]
            Specifies the metrics to be displayed as columns. Column headers act as keys, with computed metric values as their mapped values. There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly  based on the time they were created. Example: If set to "DAY," data will be aggregated by day.

        conversation_filter : typing.Optional[ConversationFilter]
            Optional filter applied to refine the conversation data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationTableResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.analytics import (
            ConversationColumnDefinition,
            ConversationGroupBy,
            ConversationMetric_Average,
            ConversationMetric_Count,
            ConversationMetric_Percentile,
        )
        from mavenagi.conversation import ConversationFilter

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.analytics.get_conversation_table(
            conversation_filter=ConversationFilter(
                languages=["en", "es"],
            ),
            time_grouping="DAY",
            field_groupings=[
                ConversationGroupBy(
                    field="Category",
                )
            ],
            column_definitions=[
                ConversationColumnDefinition(
                    header="count",
                    metric=ConversationMetric_Count(),
                ),
                ConversationColumnDefinition(
                    header="avg_first_response_time",
                    metric=ConversationMetric_Average(
                        target_field="FirstResponseTime",
                    ),
                ),
                ConversationColumnDefinition(
                    header="percentile_handle_time",
                    metric=ConversationMetric_Percentile(
                        target_field="HandleTime",
                        percentile=25.0,
                    ),
                ),
            ],
        )
        """
        _response = self._raw_client.get_conversation_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            conversation_filter=conversation_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data

    def get_conversation_chart(
        self, *, request: ConversationChartRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ChartResponse:
        """
        Fetches conversation data visualized in a chart format. Supported chart types include pie chart, date histogram, and stacked bar charts.

        Parameters
        ----------
        request : ConversationChartRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChartResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.analytics import (
            ConversationChartRequest_PieChart,
            ConversationGroupBy,
            ConversationMetric_Count,
        )
        from mavenagi.conversation import ConversationFilter

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.analytics.get_conversation_chart(
            request=ConversationChartRequest_PieChart(
                conversation_filter=ConversationFilter(
                    languages=["en", "es"],
                ),
                group_by=ConversationGroupBy(
                    field="Category",
                ),
                metric=ConversationMetric_Count(),
            ),
        )
        """
        _response = self._raw_client.get_conversation_chart(request=request, request_options=request_options)
        return _response.data

    def get_feedback_table(
        self,
        *,
        field_groupings: typing.Sequence[FeedbackGroupBy],
        column_definitions: typing.Sequence[FeedbackColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        feedback_filter: typing.Optional[FeedbackFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeedbackTableResponse:
        """
        Retrieves structured feedback data formatted as a table, allowing users to group, filter,  and define specific metrics to display as columns.

        Parameters
        ----------
        field_groupings : typing.Sequence[FeedbackGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row.
            Note: The field CreatedAt should not be used here, all the time-based grouping should be done using the timeGrouping field.

        column_definitions : typing.Sequence[FeedbackColumnDefinition]
            Specifies the metrics to be displayed as columns.
            Column headers act as keys, with computed metric values as their mapped values.
            There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly based on the time they were created.
             Example: If set to "DAY," data will be aggregated by day.

        feedback_filter : typing.Optional[FeedbackFilter]
            Optional filter applied to refine the feedback data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackTableResponse

        Examples
        --------
        from mavenagi import MavenAGI
        from mavenagi.analytics import (
            FeedbackColumnDefinition,
            FeedbackGroupBy,
            FeedbackMetric_Count,
        )
        from mavenagi.conversation import FeedbackFilter

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.analytics.get_feedback_table(
            feedback_filter=FeedbackFilter(
                types=["THUMBS_UP", "INSERT"],
            ),
            field_groupings=[
                FeedbackGroupBy(
                    field="CreatedBy",
                )
            ],
            column_definitions=[
                FeedbackColumnDefinition(
                    header="feedback_count",
                    metric=FeedbackMetric_Count(),
                )
            ],
        )
        """
        _response = self._raw_client.get_feedback_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            feedback_filter=feedback_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data


class AsyncAnalyticsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAnalyticsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAnalyticsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAnalyticsClient
        """
        return self._raw_client

    async def get_conversation_table(
        self,
        *,
        field_groupings: typing.Sequence[ConversationGroupBy],
        column_definitions: typing.Sequence[ConversationColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        conversation_filter: typing.Optional[ConversationFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationTableResponse:
        """
        Retrieves structured conversation data formatted as a table, allowing users to group, filter, and define specific metrics to display as columns.

        Parameters
        ----------
        field_groupings : typing.Sequence[ConversationGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row. |
            Note: The field `CreatedAt` should not be used here, all time-based grouping should be done using the `timeGrouping` field.

        column_definitions : typing.Sequence[ConversationColumnDefinition]
            Specifies the metrics to be displayed as columns. Column headers act as keys, with computed metric values as their mapped values. There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly  based on the time they were created. Example: If set to "DAY," data will be aggregated by day.

        conversation_filter : typing.Optional[ConversationFilter]
            Optional filter applied to refine the conversation data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationTableResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.analytics import (
            ConversationColumnDefinition,
            ConversationGroupBy,
            ConversationMetric_Average,
            ConversationMetric_Count,
            ConversationMetric_Percentile,
        )
        from mavenagi.conversation import ConversationFilter

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.analytics.get_conversation_table(
                conversation_filter=ConversationFilter(
                    languages=["en", "es"],
                ),
                time_grouping="DAY",
                field_groupings=[
                    ConversationGroupBy(
                        field="Category",
                    )
                ],
                column_definitions=[
                    ConversationColumnDefinition(
                        header="count",
                        metric=ConversationMetric_Count(),
                    ),
                    ConversationColumnDefinition(
                        header="avg_first_response_time",
                        metric=ConversationMetric_Average(
                            target_field="FirstResponseTime",
                        ),
                    ),
                    ConversationColumnDefinition(
                        header="percentile_handle_time",
                        metric=ConversationMetric_Percentile(
                            target_field="HandleTime",
                            percentile=25.0,
                        ),
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_conversation_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            conversation_filter=conversation_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data

    async def get_conversation_chart(
        self, *, request: ConversationChartRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ChartResponse:
        """
        Fetches conversation data visualized in a chart format. Supported chart types include pie chart, date histogram, and stacked bar charts.

        Parameters
        ----------
        request : ConversationChartRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChartResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.analytics import (
            ConversationChartRequest_PieChart,
            ConversationGroupBy,
            ConversationMetric_Count,
        )
        from mavenagi.conversation import ConversationFilter

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.analytics.get_conversation_chart(
                request=ConversationChartRequest_PieChart(
                    conversation_filter=ConversationFilter(
                        languages=["en", "es"],
                    ),
                    group_by=ConversationGroupBy(
                        field="Category",
                    ),
                    metric=ConversationMetric_Count(),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_conversation_chart(request=request, request_options=request_options)
        return _response.data

    async def get_feedback_table(
        self,
        *,
        field_groupings: typing.Sequence[FeedbackGroupBy],
        column_definitions: typing.Sequence[FeedbackColumnDefinition],
        time_grouping: typing.Optional[TimeInterval] = OMIT,
        feedback_filter: typing.Optional[FeedbackFilter] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeedbackTableResponse:
        """
        Retrieves structured feedback data formatted as a table, allowing users to group, filter,  and define specific metrics to display as columns.

        Parameters
        ----------
        field_groupings : typing.Sequence[FeedbackGroupBy]
            Specifies the fields by which data should be grouped. Each unique combination forms a row.
            If multiple fields are provided, the result is grouped by their unique value combinations.
            If empty, all data is aggregated into a single row.
            Note: The field CreatedAt should not be used here, all the time-based grouping should be done using the timeGrouping field.

        column_definitions : typing.Sequence[FeedbackColumnDefinition]
            Specifies the metrics to be displayed as columns.
            Column headers act as keys, with computed metric values as their mapped values.
            There needs to be at least one column definition in the table request.

        time_grouping : typing.Optional[TimeInterval]
            Defines the time interval for grouping data. If specified, data is grouped accordingly based on the time they were created.
             Example: If set to "DAY," data will be aggregated by day.

        feedback_filter : typing.Optional[FeedbackFilter]
            Optional filter applied to refine the feedback data before processing.

        timezone : typing.Optional[str]
            IANA timezone identifier (e.g., "America/Los_Angeles").
            When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
            otherwise UTC is used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackTableResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI
        from mavenagi.analytics import (
            FeedbackColumnDefinition,
            FeedbackGroupBy,
            FeedbackMetric_Count,
        )
        from mavenagi.conversation import FeedbackFilter

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.analytics.get_feedback_table(
                feedback_filter=FeedbackFilter(
                    types=["THUMBS_UP", "INSERT"],
                ),
                field_groupings=[
                    FeedbackGroupBy(
                        field="CreatedBy",
                    )
                ],
                column_definitions=[
                    FeedbackColumnDefinition(
                        header="feedback_count",
                        metric=FeedbackMetric_Count(),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_feedback_table(
            field_groupings=field_groupings,
            column_definitions=column_definitions,
            time_grouping=time_grouping,
            feedback_filter=feedback_filter,
            timezone=timezone,
            request_options=request_options,
        )
        return _response.data
