# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .series import Series
from .time_series import TimeSeries


class ChartResponse_PieChart(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.analytics import ChartResponse_PieChart, LabeledPoint, Series

    ChartResponse_PieChart(
        series=Series(
            name="Series",
            data=[
                LabeledPoint(
                    label="Sales",
                    y=5.0,
                ),
                LabeledPoint(
                    label="Support",
                    y=10.0,
                ),
            ],
        ),
    )
    """

    type: typing.Literal["pieChart"] = "pieChart"
    series: Series

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ChartResponse_DateHistogram(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.analytics import ChartResponse_PieChart, LabeledPoint, Series

    ChartResponse_PieChart(
        series=Series(
            name="Series",
            data=[
                LabeledPoint(
                    label="Sales",
                    y=5.0,
                ),
                LabeledPoint(
                    label="Support",
                    y=10.0,
                ),
            ],
        ),
    )
    """

    type: typing.Literal["dateHistogram"] = "dateHistogram"
    time_series: typing_extensions.Annotated[typing.List[TimeSeries], FieldMetadata(alias="timeSeries")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ChartResponse_BarChart(UniversalBaseModel):
    """
    Examples
    --------
    from mavenagi.analytics import ChartResponse_PieChart, LabeledPoint, Series

    ChartResponse_PieChart(
        series=Series(
            name="Series",
            data=[
                LabeledPoint(
                    label="Sales",
                    y=5.0,
                ),
                LabeledPoint(
                    label="Support",
                    y=10.0,
                ),
            ],
        ),
    )
    """

    type: typing.Literal["barChart"] = "barChart"
    series: typing.List[Series]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


"""
from mavenagi.analytics import ChartResponse_PieChart, LabeledPoint, Series

ChartResponse_PieChart(
    series=Series(
        name="Series",
        data=[
            LabeledPoint(
                label="Sales",
                y=5.0,
            ),
            LabeledPoint(
                label="Support",
                y=10.0,
            ),
        ],
    ),
)
"""
ChartResponse = typing.Union[ChartResponse_PieChart, ChartResponse_DateHistogram, ChartResponse_BarChart]
