# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...conversation.types.conversation_filter import ConversationFilter
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class ConversationAnalyticsRequest(UniversalBaseModel):
    conversation_filter: typing_extensions.Annotated[
        typing.Optional[ConversationFilter], FieldMetadata(alias="conversationFilter")
    ] = pydantic.Field(default=None)
    """
    Optional filter applied to refine the conversation data before processing.
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    IANA timezone identifier (e.g., "America/Los_Angeles").
    When provided, time-based groupings (e.g., DAY) and date filters are evaluated in this timezone;
    otherwise UTC is used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
