# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .conversation_analytics_request import ConversationAnalyticsRequest
from .conversation_group_by import ConversationGroupBy
from .conversation_metric import ConversationMetric


class ConversationBarChartRequest(ConversationAnalyticsRequest):
    bar_definition: typing_extensions.Annotated[ConversationGroupBy, FieldMetadata(alias="barDefinition")] = (
        pydantic.Field()
    )
    """
    Determines how data is grouped along the x-axis. Each unique value forms a separate bar.
    The name of the bar is derived from the grouping field's value or range.
    """

    metric: ConversationMetric = pydantic.Field()
    """
    Metric defining the y-axis values for the bar chart.
    """

    vertical_grouping: typing_extensions.Annotated[
        typing.Optional[ConversationGroupBy], FieldMetadata(alias="verticalGrouping")
    ] = pydantic.Field(default=None)
    """
    Optionally defines vertical grouping within each bar, producing multiple series.
    If omitted, a single series is generated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
