# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .conversation_analytics_request import ConversationAnalyticsRequest
from .conversation_group_by import ConversationGroupBy
from .conversation_metric import ConversationMetric
from .time_interval import TimeInterval


class ConversationDateHistogramRequest(ConversationAnalyticsRequest):
    time_interval: typing_extensions.Annotated[TimeInterval, FieldMetadata(alias="timeInterval")] = pydantic.Field()
    """
    Time-based grouping interval (e.g., HOUR, DAY, WEEK) for the date histogram.
    """

    group_by: typing_extensions.Annotated[typing.Optional[ConversationGroupBy], FieldMetadata(alias="groupBy")] = (
        pydantic.Field(default=None)
    )
    """
    Groups data before applying calculations, forming a separate time series for each group.
    """

    metric: ConversationMetric = pydantic.Field()
    """
    Defines the y-axis values for the date histogram.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
