# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .conversation_analytics_request import ConversationAnalyticsRequest
from .conversation_group_by import ConversationGroupBy
from .conversation_metric import ConversationMetric


class ConversationPieChartRequest(ConversationAnalyticsRequest):
    group_by: typing_extensions.Annotated[ConversationGroupBy, FieldMetadata(alias="groupBy")] = pydantic.Field()
    """
    Field used to group data into slices for the pie chart.
    """

    metric: ConversationMetric = pydantic.Field()
    """
    Metric defining the value for each pie slice, stored in the y-axis value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
