# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .conversation_analytics_request import ConversationAnalyticsRequest
from .conversation_column_definition import ConversationColumnDefinition
from .conversation_group_by import ConversationGroupBy
from .time_interval import TimeInterval


class ConversationTableRequest(ConversationAnalyticsRequest):
    """
    Examples
    --------
    from mavenagi.analytics import (
        ConversationColumnDefinition,
        ConversationGroupBy,
        ConversationMetric_Average,
        ConversationMetric_Count,
        ConversationMetric_Percentile,
        ConversationTableRequest,
    )
    from mavenagi.conversation import ConversationFilter

    ConversationTableRequest(
        conversation_filter=ConversationFilter(
            languages=["en", "es"],
        ),
        time_grouping="DAY",
        field_groupings=[
            ConversationGroupBy(
                field="Category",
            )
        ],
        column_definitions=[
            ConversationColumnDefinition(
                header="count",
                metric=ConversationMetric_Count(),
            ),
            ConversationColumnDefinition(
                header="avg_first_response_time",
                metric=ConversationMetric_Average(
                    target_field="FirstResponseTime",
                ),
            ),
            ConversationColumnDefinition(
                header="percentile_handle_time",
                metric=ConversationMetric_Percentile(
                    target_field="HandleTime",
                    percentile=25.0,
                ),
            ),
        ],
    )
    """

    time_grouping: typing_extensions.Annotated[typing.Optional[TimeInterval], FieldMetadata(alias="timeGrouping")] = (
        pydantic.Field(default=None)
    )
    """
    Defines the time interval for grouping data. If specified, data is grouped accordingly  based on the time they were created. Example: If set to "DAY," data will be aggregated by day.
    """

    field_groupings: typing_extensions.Annotated[
        typing.List[ConversationGroupBy], FieldMetadata(alias="fieldGroupings")
    ] = pydantic.Field()
    """
    Specifies the fields by which data should be grouped. Each unique combination forms a row.
    If multiple fields are provided, the result is grouped by their unique value combinations.
    If empty, all data is aggregated into a single row. |
    Note: The field `CreatedAt` should not be used here, all time-based grouping should be done using the `timeGrouping` field.
    """

    column_definitions: typing_extensions.Annotated[
        typing.List[ConversationColumnDefinition], FieldMetadata(alias="columnDefinitions")
    ] = pydantic.Field()
    """
    Specifies the metrics to be displayed as columns. Column headers act as keys, with computed metric values as their mapped values. There needs to be at least one column definition in the table request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
