# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .conversation_row import ConversationRow
from .table_response_base import TableResponseBase


class ConversationTableResponse(TableResponseBase):
    """
    Examples
    --------
    import datetime

    from mavenagi.analytics import (
        CellData_Double,
        CellData_Millisecond,
        ConversationRow,
        ConversationTableResponse,
        FieldValue_DateTime,
        FieldValue_String,
    )

    ConversationTableResponse(
        headers=[
            "count",
            "avg_first_response_time",
            "percentile_first_response_time",
        ],
        rows=[
            ConversationRow(
                identifier={
                    "Category": FieldValue_String(value="Sales"),
                    "CreatedAt": FieldValue_DateTime(
                        value=datetime.datetime.fromisoformat(
                            "2023-10-01 00:00:00+00:00",
                        )
                    ),
                },
                data={
                    "count": CellData_Double(value=5.0),
                    "avg_first_response_time": CellData_Millisecond(value=150.0),
                    "percentile_handle_time": CellData_Millisecond(value=110.0),
                },
            ),
            ConversationRow(
                identifier={
                    "Category": FieldValue_String(value="Support"),
                    "CreatedAt": FieldValue_DateTime(
                        value=datetime.datetime.fromisoformat(
                            "2023-10-01 00:00:00+00:00",
                        )
                    ),
                },
                data={
                    "count": CellData_Double(value=10.0),
                    "avg_first_response_time": CellData_Millisecond(value=300.0),
                    "percentile_handle_time": CellData_Millisecond(value=250.0),
                },
            ),
            ConversationRow(
                identifier={"Category": FieldValue_String(value="Sales")},
                data={
                    "count": CellData_Double(value=7.0),
                    "avg_first_response_time": CellData_Millisecond(value=180.0),
                    "percentile_handle_time": CellData_Millisecond(value=180.0),
                },
            ),
            ConversationRow(
                identifier={
                    "Category": FieldValue_String(value="Support"),
                    "CreatedAt": FieldValue_DateTime(
                        value=datetime.datetime.fromisoformat(
                            "2023-10-02 00:00:00+00:00",
                        )
                    ),
                },
                data={
                    "count": CellData_Double(value=8.0),
                    "avg_first_response_time": CellData_Millisecond(value=320.0),
                    "percentile_handle_time": CellData_Millisecond(value=220.0),
                },
            ),
        ],
    )
    """

    rows: typing.List[ConversationRow] = pydantic.Field()
    """
    The dataset rows, where each row represents a unique combination of grouping field values. 
    The identifier map contains grouping field names mapped to their respective values.
    The data map contains column headers mapped to their respective metric values.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
