# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .feedback_analytics_request import FeedbackAnalyticsRequest
from .feedback_column_definition import FeedbackColumnDefinition
from .feedback_group_by import FeedbackGroupBy
from .time_interval import TimeInterval


class FeedbackTableRequest(FeedbackAnalyticsRequest):
    """
    Examples
    --------
    from mavenagi.analytics import (
        FeedbackColumnDefinition,
        FeedbackGroupBy,
        FeedbackMetric_Count,
        FeedbackTableRequest,
    )
    from mavenagi.conversation import FeedbackFilter

    FeedbackTableRequest(
        feedback_filter=FeedbackFilter(
            types=["THUMBS_UP", "INSERT"],
        ),
        field_groupings=[
            FeedbackGroupBy(
                field="CreatedBy",
            )
        ],
        column_definitions=[
            FeedbackColumnDefinition(
                header="feedback_count",
                metric=FeedbackMetric_Count(),
            )
        ],
    )
    """

    time_grouping: typing_extensions.Annotated[typing.Optional[TimeInterval], FieldMetadata(alias="timeGrouping")] = (
        pydantic.Field(default=None)
    )
    """
    Defines the time interval for grouping data. If specified, data is grouped accordingly based on the time they were created.
     Example: If set to "DAY," data will be aggregated by day.
    """

    field_groupings: typing_extensions.Annotated[
        typing.List[FeedbackGroupBy], FieldMetadata(alias="fieldGroupings")
    ] = pydantic.Field()
    """
    Specifies the fields by which data should be grouped. Each unique combination forms a row. 
    If multiple fields are provided, the result is grouped by their unique value combinations. 
    If empty, all data is aggregated into a single row. 
    Note: The field CreatedAt should not be used here, all the time-based grouping should be done using the timeGrouping field.
    """

    column_definitions: typing_extensions.Annotated[
        typing.List[FeedbackColumnDefinition], FieldMetadata(alias="columnDefinitions")
    ] = pydantic.Field()
    """
    Specifies the metrics to be displayed as columns.
    Column headers act as keys, with computed metric values as their mapped values.
    There needs to be at least one column definition in the table request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
