# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .feedback_row import FeedbackRow
from .table_response_base import TableResponseBase


class FeedbackTableResponse(TableResponseBase):
    """
    Examples
    --------
    from mavenagi.analytics import (
        CellData_Double,
        FeedbackRow,
        FeedbackTableResponse,
        FieldValue_String,
    )

    FeedbackTableResponse(
        headers=["feedback_count", "unique_users"],
        rows=[
            FeedbackRow(
                identifier={"CreatedBy": FieldValue_String(value="John Doe")},
                data={"feedback_count": CellData_Double(value=5.0)},
            ),
            FeedbackRow(
                identifier={"CreatedBy": FieldValue_String(value="Jane Smith")},
                data={"feedback_count": CellData_Double(value=3.0)},
            ),
        ],
    )
    """

    rows: typing.List[FeedbackRow] = pydantic.Field()
    """
    The dataset rows, where each row represents a unique combination of grouping field values. 
    The identifier map contains grouping field names mapped to their respective values.
    The data map contains column headers mapped to their respective metric values.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
