# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class FieldValue_DateTime(UniversalBaseModel):
    value: dt.datetime
    type: typing.Literal["dateTime"] = "dateTime"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class FieldValue_String(UniversalBaseModel):
    value: str
    type: typing.Literal["string"] = "string"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class FieldValue_Double(UniversalBaseModel):
    value: float
    type: typing.Literal["double"] = "double"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class FieldValue_Long(UniversalBaseModel):
    value: int
    type: typing.Literal["long"] = "long"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class FieldValue_Range(UniversalBaseModel):
    type: typing.Literal["range"] = "range"
    from_: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="from")] = None
    to: typing.Optional[float] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class FieldValue_Boolean(UniversalBaseModel):
    value: bool
    type: typing.Literal["boolean"] = "boolean"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True


class FieldValue_EntityId(UniversalBaseModel):
    type: typing.Literal["entityId"] = "entityId"
    name: typing.Optional[str] = None
    reference_id: typing_extensions.Annotated[str, FieldMetadata(alias="referenceId")]
    app_id: typing_extensions.Annotated[str, FieldMetadata(alias="appId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


FieldValue = typing.Union[
    FieldValue_DateTime,
    FieldValue_String,
    FieldValue_Double,
    FieldValue_Long,
    FieldValue_Range,
    FieldValue_Boolean,
    FieldValue_EntityId,
]
