# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAppSettingsClient, RawAppSettingsClient
from .types.search_app_settings_response import SearchAppSettingsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AppSettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAppSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAppSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAppSettingsClient
        """
        return self._raw_client

    def search(
        self, *, index: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SearchAppSettingsResponse:
        """
        Search for app settings which have the `$index` key set to the provided value.

        You can set the `$index` key using the Update app settings API.

        <Warning>This API currently requires an organization ID and agent ID for any agent which is installed on the app. This requirement will be removed in a future update.</Warning>

        Parameters
        ----------
        index : str
            Will return all settings which have the `$index` key set to the provided value.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchAppSettingsResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.app_settings.search(
            index="index",
        )
        """
        _response = self._raw_client.search(index=index, request_options=request_options)
        return _response.data

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Get app settings set during installation

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.app_settings.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Update app settings. Performs a merge of the provided settings with the existing app settings.

        - If a new key is provided, it will be added to the app settings.
        - If an existing key is provided, it will be updated.
        - No keys will be removed.

        Note that if an array value is provided it will fully replace an existing value as arrays cannot be merged.

        Parameters
        ----------
        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.app_settings.update(
            request={"string": {"key": "value"}},
        )
        """
        _response = self._raw_client.update(request=request, request_options=request_options)
        return _response.data


class AsyncAppSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAppSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAppSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAppSettingsClient
        """
        return self._raw_client

    async def search(
        self, *, index: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SearchAppSettingsResponse:
        """
        Search for app settings which have the `$index` key set to the provided value.

        You can set the `$index` key using the Update app settings API.

        <Warning>This API currently requires an organization ID and agent ID for any agent which is installed on the app. This requirement will be removed in a future update.</Warning>

        Parameters
        ----------
        index : str
            Will return all settings which have the `$index` key set to the provided value.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchAppSettingsResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.app_settings.search(
                index="index",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(index=index, request_options=request_options)
        return _response.data

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Get app settings set during installation

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.app_settings.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Update app settings. Performs a merge of the provided settings with the existing app settings.

        - If a new key is provided, it will be added to the app settings.
        - If an existing key is provided, it will be updated.
        - No keys will be removed.

        Note that if an array value is provided it will fully replace an existing value as arrays cannot be merged.

        Parameters
        ----------
        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.app_settings.update(
                request={"string": {"key": "value"}},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(request=request, request_options=request_options)
        return _response.data
