# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class AppSettings(UniversalBaseModel):
    organization_id: typing_extensions.Annotated[str, FieldMetadata(alias="organizationId")] = pydantic.Field()
    """
    The ID of an organization.
    """

    agent_id: typing_extensions.Annotated[str, FieldMetadata(alias="agentId")] = pydantic.Field()
    """
    The ID of an agent.
    """

    settings: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The settings that were set during installation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
