# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAssetsClient, RawAssetsClient
from .types.initiate_asset_upload_response import InitiateAssetUploadResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AssetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAssetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAssetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAssetsClient
        """
        return self._raw_client

    def initiate_upload(
        self, *, type: str, name: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> InitiateAssetUploadResponse:
        """
        Initiate an upload.
        Returns a pre-signed URL for direct file upload and an asset ID for subsequent operations.

        Parameters
        ----------
        type : str
            The mime-type of the attachment. Supported types are:
            - image/jpeg
            - image/jpg
            - image/png
            - image/gif
            - image/webp
            - application/pdf
            - text/plain
            - text/csv
            - application/vnd.openxmlformats-officedocument.wordprocessingml.document
            - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
            - application/vnd.openxmlformats-officedocument.presentationml.presentation
            - application/msword
            - application/vnd.ms-excel
            - application/vnd.ms-powerpoint
            - audio/aac
            - audio/mpeg
            - audio/mp4
            - audio/wav
            - audio/ogg
            - video/mp4
            - video/webm

        name : typing.Optional[str]
            An optional name for the attachment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitiateAssetUploadResponse

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.assets.initiate_upload(
            type="type",
        )
        """
        _response = self._raw_client.initiate_upload(type=type, name=name, request_options=request_options)
        return _response.data

    def commit_upload(
        self,
        asset_reference_id: str,
        *,
        checksum: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Commit an upload after successful file transfer.
        Updates the asset status and makes it available for use.

        Parameters
        ----------
        asset_reference_id : str
            The reference ID of the asset to commit (provided by the initiate call). All other entity ID fields are inferred from the API request.

        checksum : typing.Optional[str]
            Checksum of the uploaded file (optional verification)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mavenagi import MavenAGI

        client = MavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )
        client.assets.commit_upload(
            asset_reference_id="assetReferenceId",
        )
        """
        _response = self._raw_client.commit_upload(
            asset_reference_id, checksum=checksum, request_options=request_options
        )
        return _response.data


class AsyncAssetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAssetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAssetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAssetsClient
        """
        return self._raw_client

    async def initiate_upload(
        self, *, type: str, name: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> InitiateAssetUploadResponse:
        """
        Initiate an upload.
        Returns a pre-signed URL for direct file upload and an asset ID for subsequent operations.

        Parameters
        ----------
        type : str
            The mime-type of the attachment. Supported types are:
            - image/jpeg
            - image/jpg
            - image/png
            - image/gif
            - image/webp
            - application/pdf
            - text/plain
            - text/csv
            - application/vnd.openxmlformats-officedocument.wordprocessingml.document
            - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
            - application/vnd.openxmlformats-officedocument.presentationml.presentation
            - application/msword
            - application/vnd.ms-excel
            - application/vnd.ms-powerpoint
            - audio/aac
            - audio/mpeg
            - audio/mp4
            - audio/wav
            - audio/ogg
            - video/mp4
            - video/webm

        name : typing.Optional[str]
            An optional name for the attachment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitiateAssetUploadResponse

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.assets.initiate_upload(
                type="type",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.initiate_upload(type=type, name=name, request_options=request_options)
        return _response.data

    async def commit_upload(
        self,
        asset_reference_id: str,
        *,
        checksum: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Commit an upload after successful file transfer.
        Updates the asset status and makes it available for use.

        Parameters
        ----------
        asset_reference_id : str
            The reference ID of the asset to commit (provided by the initiate call). All other entity ID fields are inferred from the API request.

        checksum : typing.Optional[str]
            Checksum of the uploaded file (optional verification)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mavenagi import AsyncMavenAGI

        client = AsyncMavenAGI(
            organization_id="YOUR_ORGANIZATION_ID",
            agent_id="YOUR_AGENT_ID",
            app_id="YOUR_APP_ID",
            app_secret="YOUR_APP_SECRET",
        )


        async def main() -> None:
            await client.assets.commit_upload(
                asset_reference_id="assetReferenceId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.commit_upload(
            asset_reference_id, checksum=checksum, request_options=request_options
        )
        return _response.data
