# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..commons.errors.bad_request_error import BadRequestError
from ..commons.errors.not_found_error import NotFoundError
from ..commons.errors.server_error import ServerError
from ..commons.types.error_message import ErrorMessage
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from .types.initiate_asset_upload_response import InitiateAssetUploadResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAssetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def initiate_upload(
        self, *, type: str, name: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[InitiateAssetUploadResponse]:
        """
        Initiate an upload.
        Returns a pre-signed URL for direct file upload and an asset ID for subsequent operations.

        Parameters
        ----------
        type : str
            The mime-type of the attachment. Supported types are:
            - image/jpeg
            - image/jpg
            - image/png
            - image/gif
            - image/webp
            - application/pdf
            - text/plain
            - text/csv
            - application/vnd.openxmlformats-officedocument.wordprocessingml.document
            - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
            - application/vnd.openxmlformats-officedocument.presentationml.presentation
            - application/msword
            - application/vnd.ms-excel
            - application/vnd.ms-powerpoint
            - audio/aac
            - audio/mpeg
            - audio/mp4
            - audio/wav
            - audio/ogg
            - video/mp4
            - video/webm

        name : typing.Optional[str]
            An optional name for the attachment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InitiateAssetUploadResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/assets",
            method="POST",
            json={
                "type": type,
                "name": name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitiateAssetUploadResponse,
                    parse_obj_as(
                        type_=InitiateAssetUploadResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def commit_upload(
        self,
        asset_reference_id: str,
        *,
        checksum: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Commit an upload after successful file transfer.
        Updates the asset status and makes it available for use.

        Parameters
        ----------
        asset_reference_id : str
            The reference ID of the asset to commit (provided by the initiate call). All other entity ID fields are inferred from the API request.

        checksum : typing.Optional[str]
            Checksum of the uploaded file (optional verification)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/assets/{jsonable_encoder(asset_reference_id)}/commit",
            method="POST",
            json={
                "checksum": checksum,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAssetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def initiate_upload(
        self, *, type: str, name: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[InitiateAssetUploadResponse]:
        """
        Initiate an upload.
        Returns a pre-signed URL for direct file upload and an asset ID for subsequent operations.

        Parameters
        ----------
        type : str
            The mime-type of the attachment. Supported types are:
            - image/jpeg
            - image/jpg
            - image/png
            - image/gif
            - image/webp
            - application/pdf
            - text/plain
            - text/csv
            - application/vnd.openxmlformats-officedocument.wordprocessingml.document
            - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
            - application/vnd.openxmlformats-officedocument.presentationml.presentation
            - application/msword
            - application/vnd.ms-excel
            - application/vnd.ms-powerpoint
            - audio/aac
            - audio/mpeg
            - audio/mp4
            - audio/wav
            - audio/ogg
            - video/mp4
            - video/webm

        name : typing.Optional[str]
            An optional name for the attachment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InitiateAssetUploadResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/assets",
            method="POST",
            json={
                "type": type,
                "name": name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitiateAssetUploadResponse,
                    parse_obj_as(
                        type_=InitiateAssetUploadResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def commit_upload(
        self,
        asset_reference_id: str,
        *,
        checksum: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Commit an upload after successful file transfer.
        Updates the asset status and makes it available for use.

        Parameters
        ----------
        asset_reference_id : str
            The reference ID of the asset to commit (provided by the initiate call). All other entity ID fields are inferred from the API request.

        checksum : typing.Optional[str]
            Checksum of the uploaded file (optional verification)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/assets/{jsonable_encoder(asset_reference_id)}/commit",
            method="POST",
            json={
                "checksum": checksum,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise ServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorMessage,
                        parse_obj_as(
                            type_=ErrorMessage,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
