# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...commons.types.entity_id_base import EntityIdBase
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class InitiateAssetUploadResponse(UniversalBaseModel):
    asset_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="assetId")] = pydantic.Field()
    """
    The ID of the asset. Use this ID to commit the asset after upload.
    """

    upload_url: typing_extensions.Annotated[str, FieldMetadata(alias="uploadUrl")] = pydantic.Field()
    """
    Pre-signed URL for file upload. Use this URL to upload the file directly to storage.
    """

    expires_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="expiresAt")] = pydantic.Field()
    """
    The expiration time for the upload URL
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
