# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .action_enum_option import ActionEnumOption
from .action_parameter_type import ActionParameterType


class ActionFormField(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID field should be used as the key in the `submitActionForm` API.
    """

    label: str = pydantic.Field()
    """
    The title of the field to show on the form. Provided in the user's language.
    """

    description: str = pydantic.Field()
    """
    A longer description of the field which should be shown in smaller text near the label. Provided in the user's language.
    """

    required: bool = pydantic.Field()
    """
    Whether the field is required for the action. Client side validation is recommended for an improved user experience.
    """

    suggestion: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    A value for the field provided by the LLM. All form fields should default to this value if present.
    """

    type: ActionParameterType = pydantic.Field()
    """
    Describes how the action field should be validated. Client side validation is recommended but not required. | If `enumOptions` are provided, using a dropdown or radio field is preferred. Otherwise, if the `type` is `BOOLEAN` a checkbox is preferred. | Fallback to a text input.
    """

    enum_options: typing_extensions.Annotated[
        typing.Optional[typing.List[ActionEnumOption]], FieldMetadata(alias="enumOptions")
    ] = pydantic.Field(default=None)
    """
    The options that should be shown to the user as a dropdown or radio.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
