# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .action_enum_option import ActionEnumOption
from .action_o_auth_configuration import ActionOAuthConfiguration
from .action_parameter_type import ActionParameterType


class ActionParameter(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID field will be used when parameters are supplied to `executeAction`.
    """

    label: str = pydantic.Field()
    """
    The title of the field that will be shown on action forms.
    """

    description: str = pydantic.Field()
    """
    A longer description of the field which will be shown in smaller text near the label on action forms.
    """

    required: bool = pydantic.Field()
    """
    Whether the field is required for action execution.
    """

    hidden: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When user interaction is required, whether this parameter should be excluded from forms. Hidden parameters are not displayed to users but their values are still populated by the LLM and sent to actions. Defaults to false.
    """

    type: typing.Optional[ActionParameterType] = pydantic.Field(default=None)
    """
    The parameter type. Values provided to `executeAction` will conform to this type. Defaults to `STRING`.
    """

    enum_options: typing_extensions.Annotated[
        typing.Optional[typing.List[ActionEnumOption]], FieldMetadata(alias="enumOptions")
    ] = pydantic.Field(default=None)
    """
    Restricts the action parameter to only the options in this list. Valid for type `STRING`, `BOOLEAN`, and `NUMBER`. Should not be used when type is `SCHEMA`.
    """

    schema_: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="schema")] = pydantic.Field(
        default=None
    )
    """
    JSON schema for validating the parameter value. Only valid when type is `SCHEMA`.
    
    **Schema Requirements:**
    - Root type must be "object" - The top-level schema must define an object type
    - Supported types: string, number, boolean, integer, object, array, enum, anyOf
    - Unsupported features: oneOf, allOf, const, not, if/then/else, pattern, maxLength, minLength
    - Required fields: All fields must be required (no optional properties)
    - Additional properties: Must be set to false
    
    **Limits:**
    - Maximum nesting depth: 5 levels
    - Maximum total properties: 100
    - Maximum total string length: 15,000 characters
    - Maximum total enum values: 500
    """

    oauth_configuration: typing_extensions.Annotated[
        typing.Optional[ActionOAuthConfiguration], FieldMetadata(alias="oauthConfiguration")
    ] = pydantic.Field(default=None)
    """
    OAuth configuration required to start an OAuth authorization flow when this parameter's type is `OAUTH`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
