# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from .app_user import AppUser
from .entity_id_base import EntityIdBase


class AppUserRequest(AppUser):
    """
    Examples
    --------
    from mavenagi.commons import (
        AppUserIdentifier,
        AppUserRequest,
        EntityIdBase,
        UserData,
    )

    AppUserRequest(
        user_id=EntityIdBase(
            reference_id="user-0",
        ),
        identifiers=[
            AppUserIdentifier(
                value="joe@myapp.com",
                type="EMAIL",
            )
        ],
        data={
            "name": UserData(
                value="Joe",
                visibility="VISIBLE",
            )
        },
    )
    """

    user_id: typing_extensions.Annotated[EntityIdBase, FieldMetadata(alias="userId")] = pydantic.Field()
    """
    ID that uniquely identifies this app user
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
